----------------------------------------------------------------------------------
-- Company:  Redaktion c't
-- Engineer: C. Meyer cm@ctmagazin.de
-- 
-- Create Date:    11:05:53 06/21/2011 
-- Design Name: 
-- Module Name:    PORT_DDR - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description:   Ausgangsport mit Data Direction Register
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity PORT_DDR is
    Port ( DQ : in  STD_LOGIC_VECTOR (15 downto 0);
           DDR : in  STD_LOGIC_VECTOR (15 downto 0);
           OUTPORT : out  STD_LOGIC_VECTOR (15 downto 0);
           SYSCLK : in  STD_LOGIC);
end PORT_DDR;

architecture Behavioral of PORT_DDR is

begin

process(SYSCLK)  
	variable index: Integer range 0 to 15;
begin
	if rising_edge(SYSCLK) then
		for index in 0 to 15 loop 	-- Update aller Tristate-Bits
			if DDR(index) = '1' then
				OUTPORT(index) <= DQ(index);
			else
				OUTPORT(index) <= 'Z';
			end if; 
		end loop;
	end if;
end process;

end Behavioral;

