/* ct_puzzle.c
 * by Arnold Wendl, Frth, anno Domini 2003
 bcc32 -6 -O2
 */
/* eventuell bei UNIX-Compiler noetig:
 * #define __int64  long long
 */
#include <stdio.h>
#include <mem.h>
#include <malloc.h>
#include <windows.h> /* Zeiterfassung - wohl nichts fuer UNIX - und auch die Codepageumschaltung */

#define ERGEBNIS  "ct_puzzle_erg.bin"
#define VERBOSE
#define NO_ZAEHLE_LEGUNGEN
#define NO_VERBOSE_1
#define NO_RESULT_CHAIN
// #define SLP_WUERFELGROESSE 10.0
// #define SLP_ERGOUT
// #define MELDUNGSHAEUFIGKEIT 0x1fff
#define MELDUNGSHAEUFIGKEIT 0x03ff
// #define MELDUNGSHAEUFIGKEIT 0x03f
#define DONOT_DEBUGING
#define DONOT_UNTERSCHEIDE_TEXT
#define DONOT_DUMP_TABLE_1
#define DONOT_DUMP_TABLE_2

// #define PRESHIFT
// #define MULTISHIFT

#ifdef SLP_WUERFELGROESSE
#include <dir.h>
#endif

#define SZ1 3
#define SZ2 4
#define SZ3 5

#define MAX_TEILWUERFEL    6
#define BAUSTEINZAHL      12
#define BESCHRAENKT_ROTIERTER_BAUSTEIN  6 /* 0 .. BAUSTEINZAHL - 1 (2, 3, 4, 6, 9, 11 */
 /* Gut: 2 mit A4, C2, D4, D2 oder 6 mit A4, B3, C1 bzw. C4, D2, E4, F1 */
#define EINSETZTABELLE   183
#define EINSETZPUNKTE    (SZ1*SZ2*SZ3)
#define KLASSEN          (EINSETZPUNKTE * BAUSTEINZAHL)
#define MAGAZINGROESSE  3132 /* 2964 */


#define KASTEN_1         {SZ3,SZ2,SZ1}
#define KASTEN_2         {SZ3,SZ1,SZ2}
#define KASTEN_3         {SZ2,SZ3,SZ1}
#define KASTEN_4         {SZ2,SZ1,SZ3}
#define KASTEN_5         {SZ1,SZ3,SZ2}
#define KASTEN_6         {SZ1,SZ2,SZ3}
#define KASTEN_GR        KASTEN_1
#define FUELLKOORDINATE_1 2
#define FUELLKOORDINATE_2 1
#define FUELLKOORDINATE_3 0
int FUELL_BM_FAKTOR_2, FUELL_BM_FAKTOR_3;

unsigned long Zeiterfassung_Init = 0,
              Zeiterfassung_Suchen = 0,
	      Zeiterfassung_Ausgabe =0,
	      Zeiterfassung_Start;
int           Zeiterfassung_Art = 0;
#define ZEITERFASSUNG_INIT    1
#define ZEITERFASSUNG_SUCHEN  2
#define ZEITERFASSUNG_AUSGABE 3
#define ZEITERFASSUNG_ENDE    0

unsigned long Resultate = 0;
#ifdef ZAEHLE_LEGUNGEN
#pragma option push -a8
unsigned __int64 Legungen = 0, Ands = 0,
                 LegungenA[BAUSTEINZAHL][25] = {
		   { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
		   { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
		   { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
		   { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
		   { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
		   { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
		   { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
		   { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
		   { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
		   { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
		   { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
		   { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
                 AndsA[BAUSTEINZAHL][25]     = {
		   { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
		   { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
		   { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
		   { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
		   { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
		   { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
		   { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
		   { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
		   { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
		   { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
		   { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
		   { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } };
#pragma option pop
#endif

void Geschwindigkeitserfassung(void)
{ unsigned long Jetztzeit;
  long double Zeitdauer, Ausgabezeitdauer;
#ifdef ZAEHLE_LEGUNGEN
  void PrintLegungen(void);
#endif
  Zeitdauer = ((long double) (GetTickCount() - Zeiterfassung_Start + Zeiterfassung_Suchen)) / 1000.0;
  Ausgabezeitdauer = (long double) Zeiterfassung_Ausgabe;
  if (Zeitdauer < 0.0001) Zeitdauer = 0.0001;
  if (Ausgabezeitdauer >= 1000.0)
    fprintf(stderr, " %6lu Lsungen in %5.3Lf s = %4.1Lf Lsungen / s\n"
                    "      zuzglich %5.3Lf %% fr die Ergebnisausgabe\n",
      Resultate, Zeitdauer, ((long double) Resultate) / Zeitdauer, Ausgabezeitdauer / Zeitdauer * 0.1);
   else
    fprintf(stderr, " %6lu Lsungen in %5.3Lf s = %4.1Lf Lsungen / s\n",
      Resultate, Zeitdauer, ((long double) Resultate) / Zeitdauer);
#ifdef ZAEHLE_LEGUNGEN
    fprintf(stderr, " %I64u Legungen und %I64u Ands bis jetzt\n", Legungen, Ands);
    PrintLegungen();
#endif
}

void Zeiterfassung(int NeueArt)
{ unsigned long Jetztzeit;

  Jetztzeit = GetTickCount(); /* definiert in windows.h */
  switch (Zeiterfassung_Art) {
    case ZEITERFASSUNG_INIT:
      Zeiterfassung_Init += Jetztzeit - Zeiterfassung_Start;
    break;
    case ZEITERFASSUNG_SUCHEN:
      Zeiterfassung_Suchen += Jetztzeit - Zeiterfassung_Start;
    break;
    case ZEITERFASSUNG_AUSGABE:
      Zeiterfassung_Ausgabe += Jetztzeit - Zeiterfassung_Start;
    break;
  }
  Zeiterfassung_Start = Jetztzeit;
  Zeiterfassung_Art = NeueArt;
  if (!NeueArt) fprintf(stdout, "\n"
		                "Initialisierung: %9.3Lf s\n"
                                "Suchen:          %9.3Lf s\n"
				"Ergebnisausgabe: %9.3Lf s\n",
     ((long double) Zeiterfassung_Init)    / ((long double) 1000.0),
     ((long double) Zeiterfassung_Suchen)  / ((long double) 1000.0),
     ((long double) Zeiterfassung_Ausgabe) / ((long double) 1000.0));
}

// typedef int GrInt;
   typedef char GrInt;
// typedef short GrInt;

typedef struct TP_KOORD {
  GrInt KOORD[3];
} KOORD;
static KOORD KOORD_NULLPUNKT = { 0,0,0 };

typedef struct TP_MATRIX {
  GrInt MATRIX[12];
} MATRIX;

typedef struct TP_BAUSTEIN {
  GrInt Teilwuerfelzahl, Beschriftet;
  /*@ Alle Beschriftungen vom 1. Teilwrfel - immer auf (0,0,0) - aus in z-Richtung */
  KOORD Min, Max, Einzelelemente[MAX_TEILWUERFEL];
} BAUSTEIN;

MATRIX RotationsMoeglichkeiten[24];

const KOORD Kastengroesse = KASTEN_GR;

const BAUSTEIN Baustein[BAUSTEINZAHL] = {
/*  1 */ { 5, 1, { 0, 0, 0 }, { 1, 2, 0 }, { { 0, 0, 0}, { 1, 0, 0}, { 0, 1, 0}, { 0, 2, 0}, { 1, 2, 0}, { 0, 0, 0} } },
/*  2 */ { 5, 1, { 0,-1,-2 }, { 0, 1, 0 }, { { 0, 0, 0}, { 0, 1, 0}, { 0, 0,-1}, { 0, 0,-2}, { 0,-1,-2}, { 0, 0, 0} } },
/*  3 */ { 5, 0, { 0, 0, 0 }, { 1, 3, 0 }, { { 0, 0, 0}, { 1, 0, 0}, { 0, 1, 0}, { 0, 2, 0}, { 0, 3, 0}, { 0, 0, 0} } },
/*  4 */ { 5, 0, { 0, 0, 0 }, { 1, 3, 0 }, { { 0, 0, 0}, { 1, 2, 0}, { 0, 1, 0}, { 0, 2, 0}, { 0, 3, 0}, { 0, 0, 0} } },
/*  5 */ { 5, 1, { 0, 0,-1 }, { 1, 1, 0 }, { { 0, 0, 0}, { 1, 0,-1}, { 0, 1, 0}, { 0, 1,-1}, { 0, 0,-1}, { 0, 0, 0} } },
/*  6 */ { 5, 0, {-1, 0, 0 }, { 1, 2, 0 }, { { 0, 0, 0}, {-1, 2, 0}, { 1, 2, 0}, { 0, 1, 0}, { 0, 2, 0}, { 0, 0, 0} } },
/*  7 */ { 5, 0, { 0, 0, 0 }, { 1, 2, 0 }, { { 0, 0, 0}, { 0, 2, 0}, { 1, 1, 0}, { 0, 1, 0}, { 1, 0, 0}, { 0, 0, 0} } },
/*  8 */ { 5, 0, {-1, 0, 0 }, { 1, 2, 0 }, { { 0, 0, 0}, {-1, 2, 0}, {-1, 1, 0}, { 0, 1, 0}, { 1, 0, 0}, { 0, 0, 0} } },
/*  9 */ { 4, 1, { 0, 0,-1 }, { 1, 1, 0 }, { { 0, 0, 0}, { 1, 1,-1}, { 0, 1, 0}, { 0, 1,-1}, { 0, 0, 0}, { 0, 0, 0} } },
/* 10 */ { 5, 0, {-1, 0, 0 }, { 1, 2, 0 }, { { 0, 0, 0}, { 1, 2, 0}, {-1, 1, 0}, { 0, 1, 0}, { 0, 2, 0}, { 0, 0, 0} } },
/* 11 */ { 5, 0, {-1,-1, 0 }, { 1, 1, 0 }, { { 0, 0, 0}, {-1, 0, 0}, { 0,-1, 0}, { 1, 0, 0}, { 0, 1, 0}, { 0, 0, 0} } },
/* 12 */ { 6, 1, { 0, 0, 0 }, { 1, 3, 0 }, { { 0, 0, 0}, { 0, 3, 0}, { 1, 2, 0}, { 1, 0, 0}, { 0, 1, 0}, { 0, 2, 0} } }
};

int EinsetztabelleBelegt = 0;
BAUSTEIN BereitgelegterBaustein[EINSETZTABELLE];
MATRIX   BereitgelegteMatrix[EINSETZTABELLE];
int BausteinBereitgelegtAb[BAUSTEINZAHL + 1];
struct BITMASKEN {
  unsigned __int64 Maske;
  int Versatz[3];
} Bitmasken[EINSETZTABELLE];

struct POSITIONIERUNG {
  MATRIX Einsetzpunkt;
  int    eingesetzt;
} Positionierung[BAUSTEINZAHL];

#pragma option push -a8
int Klassen[KLASSEN + 1];
unsigned __int64 Magazin[MAGAZINGROESSE];
#ifdef ZAEHLE_LEGUNGEN
unsigned int BausteinMagazinRotId[MAGAZINGROESSE];
#endif
#ifdef ERGEBNIS
unsigned int BausteinMagazinId[MAGAZINGROESSE];
FILE *ergdat = NULL;
#endif
#pragma option pop

#ifdef VERBOSE
#ifdef ERGEBNIS
void DumpBausteinId(FILE *aus, unsigned int bsid)
{ fprintf(aus, "%2d=%d%c%d%c=%d,%d,%d",
          (bsid >> 12) & 15,
          (bsid >> 10) & 3, ((bsid >> 9) & 1) ? '-' : '+',
          (bsid >>  8) & 1, ((bsid >> 7) & 1) ? '-' : '+',
          (bsid >>  4) & 7,  (bsid >> 2) & 3,  bsid & 3);
}
#endif

void DumpBitmask(FILE *aus, unsigned __int64 bm)
{ int ct, x1, x2;
  for (ct = x1 = x2 = 0; ct < EINSETZPUNKTE; ct++) {
    fprintf(aus, "%c", (bm & (((unsigned __int64) 1) << ct)) ? '#' : '.');
    if (++x1 >= Kastengroesse.KOORD[FUELLKOORDINATE_1]) {
      fprintf(aus, " "); x1 = 0;
      if (++x2 >= Kastengroesse.KOORD[FUELLKOORDINATE_2]) {
        fprintf(aus, " "); x2 = 0;
      }
    }
  }
}

int BitMaskBitCount(unsigned __int64 bm)
{ int ct, erg;
  unsigned __int64 m;
  erg = 0; m = 1;
  for (ct = 0; ct < 64; ct++) {
    if (bm & m) erg++;
    m <<= 1;
  }
  return erg;
}

void DumpMat(FILE *a, MATRIX mat)
{ fprintf(a, "{ %2d,%2d,%2d, %2d,%2d,%2d, %2d,%2d,%2d, %2d,%2d,%2d } (%u)\n",
  mat.MATRIX[0], mat.MATRIX[1], mat.MATRIX[2], mat.MATRIX[3], mat.MATRIX[4], mat.MATRIX[5],
  mat.MATRIX[6], mat.MATRIX[7], mat.MATRIX[8], mat.MATRIX[9], mat.MATRIX[10], mat.MATRIX[11],
  stackavail());
}
#endif

#ifdef DEBUGING
#define DUMP_MAT(a) DumpMat(stderr, a);

int MatDet(MATRIX mat)
{ return (mat.MATRIX[0] * mat.MATRIX[4] * mat.MATRIX[8] - mat.MATRIX[2] * mat.MATRIX[4] * mat.MATRIX[6]
        + mat.MATRIX[3] * mat.MATRIX[7] * mat.MATRIX[2] - mat.MATRIX[5] * mat.MATRIX[7] * mat.MATRIX[0]
	+ mat.MATRIX[6] * mat.MATRIX[1] * mat.MATRIX[5] - mat.MATRIX[8] * mat.MATRIX[1] * mat.MATRIX[3]);
}
#endif

#ifdef VERBOSE
void DumpBS(FILE *a, BAUSTEIN bs)
{ int ct;
  fprintf(a, "{%d,%d, {%2d,%2d,%2d}, {%2d,%2d,%2d}", bs.Teilwuerfelzahl, bs.Beschriftet,
  bs.Min.KOORD[0], bs.Min.KOORD[1], bs.Min.KOORD[2],
  bs.Max.KOORD[0], bs.Max.KOORD[1], bs.Max.KOORD[2]);
  for (ct = 0; ct < bs.Teilwuerfelzahl; ct++)
    fprintf(a, "%s{%2d,%2d,%2d}", ct ? ", " : ", {",
    bs.Einzelelemente[ct].KOORD[0], bs.Einzelelemente[ct].KOORD[1], bs.Einzelelemente[ct].KOORD[2]);
  fprintf(a, "}}\n");
}
#endif

#ifdef DEBUGING
void Pause(void)
{ char Zeile[200];
  fprintf(stderr, "DEBUG>"); fgets(Zeile, 200, stdin);
}

#else
#define DUMP_MAT(a)
#endif

#ifdef ERGEBNIS
void PauseWait(void)
{ char Zeile[200];
  fprintf(stderr, "Bitte RETURN eingeben>"); fgets(Zeile, 200, stdin);
}
#endif

unsigned __int64 ErzeugeBitmaske(BAUSTEIN bs)
/*@ Die entstehende Bitmaske muss so aufgebaut sein, da die Fllreihenfolge aus einem Einzelbitschieben besteht!
 *@ Natrlich auch bei den verschiedenen Fllrichtungen!
 */
{ int versatz[3], ct;
  unsigned __int64 erg;
  erg = 0;
  versatz[0] = - bs.Min.KOORD[0];
  versatz[1] = - bs.Min.KOORD[1];
  versatz[2] = - bs.Min.KOORD[2];
  for (ct = 0; ct < bs.Teilwuerfelzahl; ct++) {
    erg |= ((unsigned __int64) 1) << (                      (bs.Einzelelemente[ct].KOORD[FUELLKOORDINATE_1]
                                                                      + versatz[FUELLKOORDINATE_1])
                             + FUELL_BM_FAKTOR_2 * (bs.Einzelelemente[ct].KOORD[FUELLKOORDINATE_2]
			                                              + versatz[FUELLKOORDINATE_2])
                             + FUELL_BM_FAKTOR_3 * (bs.Einzelelemente[ct].KOORD[FUELLKOORDINATE_3]
			                                              + versatz[FUELLKOORDINATE_3]));
  }
  return erg;
}

void GetBausteinExtends(BAUSTEIN *bs)
{ int ct, xmin, ymin, zmin, xmax, ymax, zmax, w;
  // printf("GetBausteinExtends() ...\n");
  // DumpBS(stdout, *bs);
  xmin = xmax = bs->Einzelelemente[0].KOORD[0];
  ymin = ymax = bs->Einzelelemente[0].KOORD[1];
  zmin = zmax = bs->Einzelelemente[0].KOORD[2];
  for (ct = 1; ct < bs->Teilwuerfelzahl; ct++) {
    if ((w = bs->Einzelelemente[ct].KOORD[0]) > xmax) xmax = w;
    else if (w < xmin) xmin = w;
    if ((w = bs->Einzelelemente[ct].KOORD[1]) > ymax) ymax = w;
    else if (w < ymin) ymin = w;
    if ((w = bs->Einzelelemente[ct].KOORD[2]) > zmax) zmax = w;
    else if (w < zmin) zmin = w;
  }
  bs->Min.KOORD[0] = xmin; bs->Min.KOORD[1] = ymin; bs->Min.KOORD[2] = zmin;
  bs->Max.KOORD[0] = xmax; bs->Max.KOORD[1] = ymax; bs->Max.KOORD[2] = zmax;
  // DumpBS(stdout, *bs);
}

void VerschiebeBausteinNullpunktElement(BAUSTEIN *bs)
{ int ct;
  if (!(bs->Einzelelemente[0].KOORD[0])
   && !(bs->Einzelelemente[0].KOORD[1])
   && !(bs->Einzelelemente[0].KOORD[2])) return; /* es stimmt schon */
  for (ct = 1; ct < bs->Teilwuerfelzahl; ct++) {
    if (!(bs->Einzelelemente[ct].KOORD[0])
     && !(bs->Einzelelemente[ct].KOORD[1])
     && !(bs->Einzelelemente[ct].KOORD[2])) {
      bs->Einzelelemente[ct] = bs->Einzelelemente[0];
      bs->Einzelelemente[0] = KOORD_NULLPUNKT;
      return;
    }
  }
}

int PasstBausteinInKasten(BAUSTEIN bs)
{ if (bs.Max.KOORD[0] - bs.Min.KOORD[0] >= Kastengroesse.KOORD[0]) return 0;
  if (bs.Max.KOORD[1] - bs.Min.KOORD[1] >= Kastengroesse.KOORD[1]) return 0;
  if (bs.Max.KOORD[2] - bs.Min.KOORD[2] >= Kastengroesse.KOORD[2]) return 0;
  return 1;
}

int PasstBausteinInEinsetzsequenz(BAUSTEIN bs)
/*@ Da dieses Programm eine festgelegte Fllrichtung benutzt, knnen bestimmte Ausformungen
 *@ nie bentigt werden, da diese in einen sicher schon belegten Bereich hineinragen wrden
 */
{ int u;
  if (bs.Min.KOORD[FUELLKOORDINATE_3] < 0) return 0;
  for (u = 1; u < bs.Teilwuerfelzahl; u++) {
    if (bs.Einzelelemente[u].KOORD[FUELLKOORDINATE_3] == 0) {
      if (bs.Einzelelemente[u].KOORD[FUELLKOORDINATE_2] < 0) return 0;
      if (bs.Einzelelemente[u].KOORD[FUELLKOORDINATE_2] == 0) {
        if (bs.Einzelelemente[u].KOORD[FUELLKOORDINATE_1] < 0) return 0;
      }
    }
  }
  return 1;
}

int TeilSymmetriegleichNeu(BAUSTEIN bs, int suche_ab, unsigned __int64 *bitmaske)
{ int ct;
  unsigned __int64 bm;
  *bitmaske = bm = ErzeugeBitmaske(bs);
#ifdef UNTERSCHEIDE_TEXT
  return 1;
#else
  for (ct = suche_ab; (ct < EinsetztabelleBelegt) && (ct < EINSETZTABELLE); ct++)
    if ((bm == Bitmasken[ct].Maske)
     && (Bitmasken[ct].Versatz[0] == - bs.Min.KOORD[0])
     && (Bitmasken[ct].Versatz[1] == - bs.Min.KOORD[1])
     && (Bitmasken[ct].Versatz[2] == - bs.Min.KOORD[2])) return 0;
  return 1;
#endif
}

MATRIX Mat1(void)
{ MATRIX erg;
	memset(&erg, 0, sizeof(MATRIX));
	erg.MATRIX[0] = erg.MATRIX[4] = erg.MATRIX[8] = 1;
	/* DUMP_MAT(erg) */ return erg;
}

MATRIX MatOrthoRot(int Achse, int Winkel)
{ MATRIX erg;
	memset(&erg, 0, sizeof(MATRIX));
	switch (Winkel & 3) {
		case 1:
			switch (Achse) {
				case 0: /* 90 um X-Achse */
					erg.MATRIX[0] = erg.MATRIX[5] = 1; erg.MATRIX[7] = -1;
					break;
				case 1: /* 90 um Y-Achse */
					erg.MATRIX[4] = erg.MATRIX[6] = 1; erg.MATRIX[2] = -1;
					break;
				default: /* 90 um Z-Achse */
					erg.MATRIX[1] = erg.MATRIX[8] = 1; erg.MATRIX[3] = -1;
			}
			break;
		case 2:
			switch (Achse) {
				case 0: /* 180 um X-Achse */
					erg.MATRIX[0] = 1; erg.MATRIX[4] = erg.MATRIX[8] = -1;
					break;
				case 1: /* 180 um Y-Achse */
					erg.MATRIX[4] = 1; erg.MATRIX[0] = erg.MATRIX[8] = -1;
					break;
				default: /* 180 um Z-Achse */
					erg.MATRIX[8] = 1; erg.MATRIX[0] = erg.MATRIX[4] = -1;
			}
			break;
		case 3:
			switch (Achse) {
				case 0: /* -90 um X-Achse */
					erg.MATRIX[0] = erg.MATRIX[7] = 1; erg.MATRIX[5] = -1;
					break;
				case 1: /* -90 um Y-Achse */
					erg.MATRIX[4] = erg.MATRIX[2] = 1; erg.MATRIX[6] = -1;
					break;
				default: /* -90 um Z-Achse */
					erg.MATRIX[3] = erg.MATRIX[8] = 1; erg.MATRIX[1] = -1;
			}
			break;
		default: /* 0 um welche Achse auch immer */
			erg.MATRIX[0] = erg.MATRIX[4] = erg.MATRIX[8] = 1;
			break;
	}
	/* DUMP_MAT(erg) */ return erg;
}

MATRIX MatVersch3i(int x, int y, int z)
{ MATRIX erg;
	memset(&erg, 0, sizeof(MATRIX));
	erg.MATRIX[0] = erg.MATRIX[4] = erg.MATRIX[8] = 1;
	erg.MATRIX[9] = x; erg.MATRIX[10] = y; erg.MATRIX[11] = z;
	/* DUMP_MAT(erg) */ return erg;
}

MATRIX MatVerschKoord(KOORD v)
{ MATRIX erg;
  memset(&erg, 0, sizeof(MATRIX));
  erg.MATRIX[0] = erg.MATRIX[4] = erg.MATRIX[8] = 1;
  memcpy(((KOORD *) &(erg.MATRIX[9])), &v, 3 * sizeof(GrInt));
  /* DUMP_MAT(erg) */ return erg;
}

MATRIX MatMul(MATRIX m1, MATRIX m2)
{ MATRIX erg;
  memset(&erg, 0, sizeof(MATRIX));
  erg.MATRIX[0] = m1.MATRIX[0] * m2.MATRIX[0] + m1.MATRIX[3] * m2.MATRIX[1] + m1.MATRIX[6] * m2.MATRIX[2];
  erg.MATRIX[1] = m1.MATRIX[1] * m2.MATRIX[0] + m1.MATRIX[4] * m2.MATRIX[1] + m1.MATRIX[7] * m2.MATRIX[2];
  erg.MATRIX[2] = m1.MATRIX[2] * m2.MATRIX[0] + m1.MATRIX[5] * m2.MATRIX[1] + m1.MATRIX[8] * m2.MATRIX[2];
  erg.MATRIX[3] = m1.MATRIX[0] * m2.MATRIX[3] + m1.MATRIX[3] * m2.MATRIX[4] + m1.MATRIX[6] * m2.MATRIX[5];
  erg.MATRIX[4] = m1.MATRIX[1] * m2.MATRIX[3] + m1.MATRIX[4] * m2.MATRIX[4] + m1.MATRIX[7] * m2.MATRIX[5];
  erg.MATRIX[5] = m1.MATRIX[2] * m2.MATRIX[3] + m1.MATRIX[5] * m2.MATRIX[4] + m1.MATRIX[8] * m2.MATRIX[5];
  erg.MATRIX[6] = m1.MATRIX[0] * m2.MATRIX[6] + m1.MATRIX[3] * m2.MATRIX[7] + m1.MATRIX[6] * m2.MATRIX[8];
  erg.MATRIX[7] = m1.MATRIX[1] * m2.MATRIX[6] + m1.MATRIX[4] * m2.MATRIX[7] + m1.MATRIX[7] * m2.MATRIX[8];
  erg.MATRIX[8] = m1.MATRIX[2] * m2.MATRIX[6] + m1.MATRIX[5] * m2.MATRIX[7] + m1.MATRIX[8] * m2.MATRIX[8];
  erg.MATRIX[ 9] = m1.MATRIX[0] * m2.MATRIX[9] + m1.MATRIX[3] * m2.MATRIX[10] + m1.MATRIX[6] * m2.MATRIX[11] + m1.MATRIX[ 9];
  erg.MATRIX[10] = m1.MATRIX[1] * m2.MATRIX[9] + m1.MATRIX[4] * m2.MATRIX[10] + m1.MATRIX[7] * m2.MATRIX[11] + m1.MATRIX[10];
  erg.MATRIX[11] = m1.MATRIX[2] * m2.MATRIX[9] + m1.MATRIX[5] * m2.MATRIX[10] + m1.MATRIX[8] * m2.MATRIX[11] + m1.MATRIX[11];
  /* DUMP_MAT(erg) */ return erg;
}

KOORD PosTrans3i(MATRIX m, int x, int y, int z)
{ KOORD erg;
  erg.KOORD[0] = m.MATRIX[0] * x + m.MATRIX[3] * y + m.MATRIX[6] * z + m.MATRIX[ 9];
  erg.KOORD[1] = m.MATRIX[1] * x + m.MATRIX[4] * y + m.MATRIX[7] * y + m.MATRIX[10];
  erg.KOORD[2] = m.MATRIX[2] * x + m.MATRIX[5] * y + m.MATRIX[8] * z + m.MATRIX[11];
  return erg;
}

KOORD PosTransKoord(MATRIX m, KOORD v)
{ KOORD erg;
  erg.KOORD[0] = m.MATRIX[0] * v.KOORD[0] + m.MATRIX[3] * v.KOORD[1] + m.MATRIX[6] * v.KOORD[2] + m.MATRIX[ 9];
  erg.KOORD[1] = m.MATRIX[1] * v.KOORD[0] + m.MATRIX[4] * v.KOORD[1] + m.MATRIX[7] * v.KOORD[2] + m.MATRIX[10];
  erg.KOORD[2] = m.MATRIX[2] * v.KOORD[0] + m.MATRIX[5] * v.KOORD[1] + m.MATRIX[8] * v.KOORD[2] + m.MATRIX[11];
  return erg;
}

int RotIdOfMatrix(MATRIX m)
{ int erg, t;
  if (m.MATRIX[0]) { erg =  0; t = 5; }
  else
  if (m.MATRIX[1]) { erg =  8; t = 3; }
  else             { erg = 16; t = 4; }
  if (m.MATRIX[0] + m.MATRIX[1] + m.MATRIX[2] < 0) erg += 4;
  if (m.MATRIX[t]) erg += 2;
  if (m.MATRIX[3] + m.MATRIX[4] + m.MATRIX[5] < 0) erg++;
  return erg;
}

BAUSTEIN BewegterBaustein(BAUSTEIN bs, MATRIX m)
{ BAUSTEIN erg;
  int ct;
  memset(&erg, 0, sizeof(BAUSTEIN));
  erg.Teilwuerfelzahl = bs.Teilwuerfelzahl;
  erg.Beschriftet = bs.Beschriftet;
  for (ct = 0; ct < bs.Teilwuerfelzahl; ct++) {
    erg.Einzelelemente[ct] = PosTransKoord(m, bs.Einzelelemente[ct]);
  }
  GetBausteinExtends(&erg);
  return erg;
}

#ifdef SLP_WUERFELGROESSE
void SchreibeBausteinSLP(FILE *aus, int No, MATRIX m)
{ char Zeile[100], von[80];
  FILE *ein;
  float fx, fy, fz;
  sprintf(von, "%u.slp", No);
  if ((ein = fopen(von, "rb")) == NULL) {
    fprintf(stderr, "Kann Datei '%s' nicht lesen!\n", von);
    return;
  }
  while (fgets(Zeile, 100, ein) != NULL) {
    if (!strncmp(Zeile, "      normal ", 13)) {
      sscanf(&(Zeile[13]), "%e%e%e", &fx, &fy, &fz);
      fprintf(aus, "      normal %.6e %.6e %.6e\r\n",
        m.MATRIX[0] * fx + m.MATRIX[3] * fy + m.MATRIX[6] * fz,
        m.MATRIX[1] * fx + m.MATRIX[4] * fy + m.MATRIX[7] * fz,
        m.MATRIX[2] * fx + m.MATRIX[5] * fy + m.MATRIX[8] * fz);
    } else
    if (!strncmp(Zeile, "      vertex ", 13)) {
      sscanf(&(Zeile[13]), "%e%e%e", &fx, &fy, &fz);
      fprintf(aus, "      vertex %.6e %.6e %.6e\r\n",
        m.MATRIX[0] * fx + m.MATRIX[3] * fy + m.MATRIX[6] * fz + SLP_WUERFELGROESSE * m.MATRIX[ 9],
        m.MATRIX[1] * fx + m.MATRIX[4] * fy + m.MATRIX[7] * fz + SLP_WUERFELGROESSE * m.MATRIX[10],
        m.MATRIX[2] * fx + m.MATRIX[5] * fy + m.MATRIX[8] * fz + SLP_WUERFELGROESSE * m.MATRIX[11]);
    } else
      fprintf(aus, "%s", Zeile);
  }
  fclose(ein);
}

void SchreibeAktuellePositionierung(void)
{ char Dateiname[100];
  int ct;
  FILE *aus;
  sprintf(Dateiname, "ct_puzzle_%.6u.slp", Resultate);
  if ((aus = fopen(Dateiname, "wb")) == NULL) {
    fprintf(stderr, "Datei '%s' kann nicht angelegt werden!\n", Dateiname);
    return;
  }
  for (ct = 0; ct < BAUSTEINZAHL; ct++) {
    // fprintf(stderr, "%s ", Positionierung[ct].eingesetzt ? "+" : "-");
    // DUMP_MAT(Positionierung[ct].Einsetzpunkt)
    if (Positionierung[ct].eingesetzt)
      SchreibeBausteinSLP(aus, ct + 1, Positionierung[ct].Einsetzpunkt);
     else fprintf(stderr, "%d. Bauteil ist nicht eingesetzt!\n", ct + 1);
  }
  fclose(aus);
}

void SchreibeOrientierungsuebersicht(void)
{ int bs, p, h;
  FILE *aus;
  MATRIX m;
  if ((aus = fopen("bausteinrotationsuebersicht.slp", "wb")) == NULL) return;
  for (bs = 0; bs < BAUSTEINZAHL; bs++) {
    h = 0;
    for (p = BausteinBereitgelegtAb[bs]; p < BausteinBereitgelegtAb[bs + 1]; p++) {
      m = MatMul(MatVersch3i( 5 * h  - BereitgelegterBaustein[p].Min.KOORD[0],
                             -5 * bs - BereitgelegterBaustein[p].Min.KOORD[1],
                                     - BereitgelegterBaustein[p].Min.KOORD[2]),
			      BereitgelegteMatrix[p]);
      SchreibeBausteinSLP(aus, bs + 1, m);
      h++;
    }
  }
  fclose(aus);
}

void SchreibeTeileuebersicht(void)
{ int ct;
  for (ct = 0; ct < BAUSTEINZAHL; ct++) {
    Positionierung[ct].eingesetzt = 1;
    Positionierung[ct].Einsetzpunkt = MatVersch3i(4 * ct, 0, 0);
  }
  SchreibeAktuellePositionierung();
  for (ct = 0; ct < BAUSTEINZAHL; ct++) Positionierung[ct].eingesetzt = 0;
}

#endif

void Init_RotationsMoeglichkeiten(void)
{ int ct;
  ct = 0;
  /*@ die 6 Richtungen, mit welcher die Symmetrieen (bei X-max != Y-max != Z-max != X-max)
   *@ augeschlossen werden knnen
   */
  /* A4 */ RotationsMoeglichkeiten[ct++] =    MatMul(   MatOrthoRot(1, 2)   ,   MatOrthoRot(0, 2)   )  ;
  /* B3 */ RotationsMoeglichkeiten[ct++] =    MatMul(   MatOrthoRot(1, 2)   ,   MatOrthoRot(0, 1)   )  ;
  /* C1 */ RotationsMoeglichkeiten[ct++] = /* MatMul(*/ MatOrthoRot(1, 1) /*,   MatOrthoRot(0, 0)   )*/;
  /* D2 */ RotationsMoeglichkeiten[ct++] =    MatMul(   MatOrthoRot(1, 1)   ,   MatOrthoRot(0, 3)   )  ;
  /* E4 */ RotationsMoeglichkeiten[ct++] =    MatMul(   MatOrthoRot(2, 3)   ,   MatOrthoRot(0, 2)   )  ;
  /* F1 */ RotationsMoeglichkeiten[ct++] =    MatMul(   MatOrthoRot(2, 1)   ,   MatOrthoRot(0, 1)   )  ;
  /*@ die restlichen 18 - 24 gesamt */
  /* A1 */ RotationsMoeglichkeiten[ct++] = /* MatMul(   MatOrthoRot(0, 0)   ,   MatOrthoRot(0, 0)   )*/ Mat1();
  /* A2 */ RotationsMoeglichkeiten[ct++] = /* MatMul(   MatOrthoRot(0, 0)   ,*/ MatOrthoRot(0, 2) /*)*/;
  /* A3 */ RotationsMoeglichkeiten[ct++] = /* MatMul(*/ MatOrthoRot(1, 2) /*,   MatOrthoRot(0, 0)   )*/;

  /* B1 */ RotationsMoeglichkeiten[ct++] = /* MatMul(   MatOrthoRot(0, 0)   ,*/ MatOrthoRot(0, 1) /*)*/;
  /* B2 */ RotationsMoeglichkeiten[ct++] = /* MatMul(   MatOrthoRot(0, 0)   ,*/ MatOrthoRot(0, 3) /*)*/;
  /* B4 */ RotationsMoeglichkeiten[ct++] =    MatMul(   MatOrthoRot(1, 2)   ,   MatOrthoRot(0, 3)   )  ;

  /* C2 */ RotationsMoeglichkeiten[ct++] =    MatMul(   MatOrthoRot(1, 1)   ,   MatOrthoRot(0, 2)   )  ;
  /* C3 */ RotationsMoeglichkeiten[ct++] = /* MatMul(*/ MatOrthoRot(1, 3) /*,   MatOrthoRot(0, 0)   )*/;
  /* C4 */ RotationsMoeglichkeiten[ct++] =    MatMul(   MatOrthoRot(1, 3)   ,   MatOrthoRot(0, 2)   )  ;

  /* D1 */ RotationsMoeglichkeiten[ct++] =    MatMul(   MatOrthoRot(1, 1)   ,   MatOrthoRot(0, 1)   )  ;
  /* D3 */ RotationsMoeglichkeiten[ct++] =    MatMul(   MatOrthoRot(1, 3)   ,   MatOrthoRot(0, 1)   )  ;
  /* D4 */ RotationsMoeglichkeiten[ct++] =    MatMul(   MatOrthoRot(1, 3)   ,   MatOrthoRot(0, 3)   )  ;

  /* E1 */ RotationsMoeglichkeiten[ct++] = /* MatMul(*/ MatOrthoRot(2, 1) /*,   MatOrthoRot(0, 0)   )*/;
  /* E2 */ RotationsMoeglichkeiten[ct++] =    MatMul(   MatOrthoRot(2, 1)   ,   MatOrthoRot(0, 2)   )  ;
  /* E3 */ RotationsMoeglichkeiten[ct++] = /* MatMul(*/ MatOrthoRot(2, 3) /*,   MatOrthoRot(0, 0)   )*/;

  /* F2 */ RotationsMoeglichkeiten[ct++] =    MatMul(   MatOrthoRot(2, 1)   ,   MatOrthoRot(0, 3)   )  ;
  /* F3 */ RotationsMoeglichkeiten[ct++] =    MatMul(   MatOrthoRot(2, 3)   ,   MatOrthoRot(0, 1)   )  ;
  /* F4 */ RotationsMoeglichkeiten[ct  ] =    MatMul(   MatOrthoRot(2, 3)   ,   MatOrthoRot(0, 3)   )  ;
}

void Init_Einsetztabelle(void)
{ int b, r, u;
  unsigned __int64 bitmaske;
  BAUSTEIN rot_bs, versch_bs;
  MATRIX versch_m;
#ifdef DUMP_TABLE_1
  FILE *aus;
  aus = fopen("table1.txt", "w");
#endif
  for (b = 0; b < BAUSTEINZAHL; b++) {
    BausteinBereitgelegtAb[b] = BausteinBereitgelegtAb[b + 1] = EinsetztabelleBelegt;
    for (r = 0; r < ((b == BESCHRAENKT_ROTIERTER_BAUSTEIN) ? 6 : 24); r++) {
    /* Bei einem (dem letzten) Baustein nmlich nur noch 6 Orientierungen */
      rot_bs = BewegterBaustein(Baustein[b], RotationsMoeglichkeiten[r]);
#ifdef DEBUGING
      if (aus != NULL) {
        fprintf(aus, "\nRotationsMoeglichkeiten[%d] = ", r);
	DumpMat(aus, RotationsMoeglichkeiten[r]);
        fprintf(aus, "rot_bs = ");
	DumpBS(aus, rot_bs);
      }
#endif
      if (PasstBausteinInKasten(rot_bs)) {
#ifdef DEBUGING
        if (aus != NULL) fprintf(aus, "passt hinein\n");
#endif
        for (u = 0; u < rot_bs.Teilwuerfelzahl; u++) {
#ifdef DEBUGING
          if (aus != NULL) fprintf(aus, "%d. Teilwuerfel\n", u);
#endif
          if (u) {
	    versch_m = RotationsMoeglichkeiten[r];
	    versch_m.MATRIX[ 9] -= rot_bs.Einzelelemente[u].KOORD[0];
	    versch_m.MATRIX[10] -= rot_bs.Einzelelemente[u].KOORD[1];
	    versch_m.MATRIX[11] -= rot_bs.Einzelelemente[u].KOORD[2];
            versch_bs = BewegterBaustein(Baustein[b], versch_m);
	  } else {
	    versch_bs = rot_bs; versch_m = RotationsMoeglichkeiten[r];
	  }
#ifdef DEBUGING
          if (aus != NULL) {
	    fprintf(aus, "versch_m = "); DumpMat(aus, versch_m);
	    fprintf(aus, "versch_bs = "); DumpBS(aus, versch_bs);
          }
#endif
	  VerschiebeBausteinNullpunktElement(&versch_bs);
#ifdef DEBUGING
          if (aus != NULL) {
	    fprintf(aus, "versch_bs = "); DumpBS(aus, versch_bs);
          }
#endif
	  if (PasstBausteinInEinsetzsequenz(versch_bs)
	   /* und jetzt knnte es noch ein symmetrisch in sich selbst abgebildetes Teil sein! */
	   && TeilSymmetriegleichNeu(versch_bs, BausteinBereitgelegtAb[b], &bitmaske)) {
	    if (EinsetztabelleBelegt >= EINSETZTABELLE)
	     fprintf(stderr, "ACHTUNG! EINSETZTABELLE zu klein - bitte mit neuem Wert (%d) neu kompilieren!\n",
	             EinsetztabelleBelegt);
            else {
	      BereitgelegterBaustein[EinsetztabelleBelegt] = versch_bs;
	      BereitgelegteMatrix[EinsetztabelleBelegt] = versch_m;
	      Bitmasken[EinsetztabelleBelegt].Maske = bitmaske;
	      Bitmasken[EinsetztabelleBelegt].Versatz[0] = - versch_bs.Min.KOORD[0];
	      Bitmasken[EinsetztabelleBelegt].Versatz[1] = - versch_bs.Min.KOORD[1];
	      Bitmasken[EinsetztabelleBelegt].Versatz[2] = - versch_bs.Min.KOORD[2];
#ifdef DEBUGING
              if (aus != NULL) {
	        fprintf(aus, "BereitgelegteMatrix[%d] = ", EinsetztabelleBelegt);
	        DumpMat(aus, BereitgelegteMatrix[EinsetztabelleBelegt]);
		fprintf(aus, "Versatz = { %d , %d , %d }\n",
	          Bitmasken[EinsetztabelleBelegt].Versatz[0],
	          Bitmasken[EinsetztabelleBelegt].Versatz[1],
	          Bitmasken[EinsetztabelleBelegt].Versatz[2]);
	        fprintf(aus, "BereitgelegterBaustein[%d] = ", EinsetztabelleBelegt);
		DumpBS(aus, BereitgelegterBaustein[EinsetztabelleBelegt]);
              }
#endif
	    }
	    EinsetztabelleBelegt++;
	  } /* else: kann nie und nimmer so gebraucht werden */
        }
      } /* else: Passt doch garniemalsnienicht bei dieser Drehstellung in die Gesamtabmessungen hinein! */
    }
    // Pause();
  }
  if (EinsetztabelleBelegt > EINSETZTABELLE) {
    EinsetztabelleBelegt = EINSETZTABELLE;
    fprintf(stderr, "\n\nA C H T U N G :   Ergebnis wahrscheinlich unvollstndig!\n\n");
  }
  for (b = 0; b < BAUSTEINZAHL; b++)
    if (BausteinBereitgelegtAb[b] > EINSETZTABELLE)
      BausteinBereitgelegtAb[b] = EINSETZTABELLE;
  BausteinBereitgelegtAb[BAUSTEINZAHL] = EinsetztabelleBelegt;
#ifdef VERBOSE
  Zeiterfassung(ZEITERFASSUNG_AUSGABE);
  printf("%d Einsetzvarianten sind belegt.\n", EinsetztabelleBelegt);
#endif
#ifdef DUMP_TABLE_1
  Zeiterfassung(ZEITERFASSUNG_AUSGABE);
  for (b = 0; b < BAUSTEINZAHL; b++)
    for (r = BausteinBereitgelegtAb[b]; (r < BausteinBereitgelegtAb[b + 1]) /* && (r < 70) */; r++) {
    if (aus != NULL) {
      fprintf(aus, "          Rot-ID = %2d ", RotIdOfMatrix(BereitgelegteMatrix[r]) + 1);
      DumpMat(aus, BereitgelegteMatrix[r]);
      fprintf(aus, "%2d: [%4d] ", b, r); DumpMat(aus, BereitgelegteMatrix[r]);
      fprintf(aus, "  ");
      DumpBS(aus, BereitgelegterBaustein[r]);
      fprintf(aus, "   Bitmask: [%d] %d,%d,%d ", BitMaskBitCount(Bitmasken[r].Maske),
      Bitmasken[r].Versatz[0], Bitmasken[r].Versatz[1], Bitmasken[r].Versatz[2]);
      DumpBitmask(aus, Bitmasken[r].Maske);
      fprintf(aus, "\n\n");
    }
  }
  fprintf(aus, "{");
  for (b = 0; b < BAUSTEINZAHL; b++)
    fprintf(aus, " %2d (%2d)", BausteinBereitgelegtAb[b], BausteinBereitgelegtAb[b + 1] - BausteinBereitgelegtAb[b]);
  fprintf(aus, " %2d }\n", BausteinBereitgelegtAb[BAUSTEINZAHL]);
#endif
#ifdef VERBOSE_1
  printf("{");
  for (b = 0; b < BAUSTEINZAHL; b++)
    printf(" %2d (%2d)", BausteinBereitgelegtAb[b], BausteinBereitgelegtAb[b + 1] - BausteinBereitgelegtAb[b]);
  printf(" %2d }\n", BausteinBereitgelegtAb[BAUSTEINZAHL]);
  Zeiterfassung(ZEITERFASSUNG_INIT);
#endif
#ifdef SLP_WUERFELGROESSE
  SchreibeOrientierungsuebersicht();
#endif
#ifdef DUMP_TABLE_1
  if (aus != NULL) fclose(aus);
  Zeiterfassung(ZEITERFASSUNG_INIT);
#endif
}

void Init_KlassenMagazin(void)
{ int Position, p[3], Baustein, ep, kp, ct, verloren;
#ifdef DUMP_TABLE_2
  FILE *aus;
  aus = fopen("table2.txt", "w");
#endif
  p[0] = p[1] = p[2] = ep = Klassen[0] = verloren = 0;
  kp = 1;
  for (Position = 0; Position < EINSETZPUNKTE; Position++) {
    for (Baustein = 0; Baustein < BAUSTEINZAHL; Baustein++) {
      for (ct = BausteinBereitgelegtAb[Baustein]; ct < BausteinBereitgelegtAb[Baustein + 1]; ct++) {
        if ((Bitmasken[ct].Versatz[0] <= p[0])
         && (Bitmasken[ct].Versatz[1] <= p[1])
         && (Bitmasken[ct].Versatz[2] <= p[2])
	 && (BereitgelegterBaustein[ct].Max.KOORD[0] + p[0] < Kastengroesse.KOORD[0])
	 && (BereitgelegterBaustein[ct].Max.KOORD[1] + p[1] < Kastengroesse.KOORD[1])
	 && (BereitgelegterBaustein[ct].Max.KOORD[2] + p[2] < Kastengroesse.KOORD[2])) {
	   if (ep < MAGAZINGROESSE) {
	     Magazin[ep] = Bitmasken[ct].Maske >> (  Position
#ifdef PRESHIFT
			                                      + 1
#endif
				                   - (p[FUELLKOORDINATE_1] - Bitmasken[ct].Versatz[FUELLKOORDINATE_1])
	                      - FUELL_BM_FAKTOR_2 *  (p[FUELLKOORDINATE_2] - Bitmasken[ct].Versatz[FUELLKOORDINATE_2])
	                      - FUELL_BM_FAKTOR_3 *  (p[FUELLKOORDINATE_3] - Bitmasken[ct].Versatz[FUELLKOORDINATE_3])
	                                           );
#ifdef ZAEHLE_LEGUNGEN
             BausteinMagazinRotId[ep] = RotIdOfMatrix(BereitgelegteMatrix[ct]) + 1;
#endif
#ifdef ERGEBNIS
             BausteinMagazinId[ep] = ((Baustein + 1) << 12)
	                           | (RotIdOfMatrix(BereitgelegteMatrix[ct]) << 7)
	                           | (((BereitgelegteMatrix[ct].MATRIX[ 9] + p[0]) & 7) << 4)
	                           | (((BereitgelegteMatrix[ct].MATRIX[10] + p[1]) & 3) << 2)
	                           |  ((BereitgelegteMatrix[ct].MATRIX[11] + p[2]) & 3);
#endif
#ifdef DUMP_TABLE_2
             if (aus != NULL) {
               fprintf(aus, "Quelle[%3d]  %1d %1d %1d : ", ct, 
	         Bitmasken[ct].Versatz[FUELLKOORDINATE_1],
	         Bitmasken[ct].Versatz[FUELLKOORDINATE_2],
	         Bitmasken[ct].Versatz[FUELLKOORDINATE_3]);
	       DumpBitmask(aus, Bitmasken[ct].Maske);
               fprintf(aus, "\nBS %2d Pos %2d Var %2d: ", Baustein, Position, ep - Klassen[kp - 1]);
	       DumpBitmask(aus, Magazin[ep]);
#ifdef ERGEBNIS
	       fprintf(aus, "\nBaustein-ID: "); DumpBausteinId(aus, BausteinMagazinId[ep]);
#endif
	       fprintf(aus, "\n\n");
             }
#endif
	     ep++;
	   } else verloren++;
	 } /* else: Passt an dieser Position nicht mehr in den 'Kasten'. */
      }
      Klassen[kp] = ep;
      kp++;
    }
    if (++p[FUELLKOORDINATE_1] >= Kastengroesse.KOORD[FUELLKOORDINATE_1]) {
      p[FUELLKOORDINATE_1] = 0;
      if (++p[FUELLKOORDINATE_2] >= Kastengroesse.KOORD[FUELLKOORDINATE_2]) {
        p[FUELLKOORDINATE_2] = 0;
        ++p[FUELLKOORDINATE_3];
      }
    }
  }
#ifdef DUMP_TABLE_2
  Zeiterfassung(ZEITERFASSUNG_AUSGABE);
  if (aus != NULL) {
    fprintf(aus, "\n");
    for (Position = ep = 0; Position < EINSETZPUNKTE; Position++) {
      fprintf(aus, "M%.2d:", Position);
      for (Baustein = 0; Baustein < BAUSTEINZAHL; Baustein++) {
        fprintf(aus, " %4d (%2d)", Klassen[ep], Klassen[ep + 1] - Klassen[ep]);
        ep++;
      }
      fprintf(aus, " %2d\n", Klassen[ep]);
    }
    fprintf(aus, "SUM:");
    // kp = 1;
    for (Baustein = 0; Baustein < BAUSTEINZAHL; Baustein++) {
      ep = 0;
      for (Position = 0; Position < EINSETZPUNKTE; Position++)
        ep += Klassen[12 * Position + Baustein + 1] - Klassen[12 * Position + Baustein];
      fprintf(aus, "%10d", ep);
      // kp *= ep;
    }
    fprintf(aus, "\n"); // printf("\nPROD:%9d\n", kp);
    fprintf(aus, "MAX:");
    for (Baustein = 0; Baustein < BAUSTEINZAHL; Baustein++) {
      ep = 0;
      for (Position = 0; Position < EINSETZPUNKTE; Position++)
        if (ep < Klassen[12 * Position + Baustein + 1] - Klassen[12 * Position + Baustein])
          ep = Klassen[12 * Position + Baustein + 1] - Klassen[12 * Position + Baustein];
      fprintf(aus, "%10d", ep);
    }
    fprintf(aus, "\n%d Bitmasken im Magazin\n", Klassen[KLASSEN]);
  }
  Zeiterfassung(ZEITERFASSUNG_INIT);
#endif
  if (verloren) {
    fprintf(stderr, "ACHTUNG: MAGAZINGROESSE ist zu klein! %d Bitmasken wurden verloren!\n"
                    "Bitte Parameter vergrern und neu kompilieren.\n", verloren);
#ifdef DUMP_TABLE_2
    if (aus != NULL) fprintf(aus, "ACHTUNG: MAGAZINGROESSE ist zu klein! %d Bitmasken wurden verloren!\n");
#endif
  }
#ifdef DUMP_TABLE_2
  if (aus != NULL) fclose(aus);
#endif
#ifdef VERBOSE
  fprintf(stderr, "%d Bitmasken im Magazin.\n\n", Klassen[KLASSEN]);
#endif
}

#ifdef ERGEBNIS
unsigned short Ergebnis[BAUSTEINZAHL];

#ifdef SLP_ERGOUT
void SchreibeEinzelergebnisAlsSLP(void)
{ char Dateiname[100];
  int ct, BS, xdir, ydir;
  FILE *aus;
  MATRIX Mat;
  sprintf(Dateiname, "loesungen\\ct_puzzle_%.6u.slp", Resultate);
  if ((aus = fopen(Dateiname, "wb")) == NULL) {
    fprintf(stderr, "Datei '%s' kann nicht angelegt werden!\n", Dateiname);
    return;
  }
  for (ct = 0; ct < BAUSTEINZAHL; ct++) {
    BS = (Ergebnis[ct] >> 12) & 15;
    memset(&Mat, 0, sizeof(MATRIX));
    /* Richtung X-Achse des Bausteinkoordinatensystems */
    xdir = (Ergebnis[ct] >> 10) & 3;
    Mat.MATRIX[xdir] = ((Ergebnis[ct] >> 9) & 1) ? -1 : 1;
    /* Richtung Y-Achse des Bausteinkoordinatensystems */
    ydir = (xdir + 1 + ((Ergebnis[ct] >> 8) & 1)) % 3 + 3;
    Mat.MATRIX[ydir] = ((Ergebnis[ct] >> 7) & 1) ? -1 : 1;
    /* Kreuzprodukt fr Z-Achse */
    Mat.MATRIX[8] = Mat.MATRIX[0] * Mat.MATRIX[4] - Mat.MATRIX[1] * Mat.MATRIX[3];
    Mat.MATRIX[6] = Mat.MATRIX[1] * Mat.MATRIX[5] - Mat.MATRIX[2] * Mat.MATRIX[4];
    Mat.MATRIX[7] = Mat.MATRIX[2] * Mat.MATRIX[3] - Mat.MATRIX[0] * Mat.MATRIX[5];
    /* Ursprung - skaliert wird erst in der folgenden Ausgaberoutine */
    Mat.MATRIX[ 9] = (Ergebnis[ct] >>  4) & 7;
    Mat.MATRIX[10] = (Ergebnis[ct] >> 2) & 3;
    Mat.MATRIX[11] = Ergebnis[ct] & 3;
    // fprintf(stderr, "Baustein %2d: ", ct); DumpMat(stderr, Mat); fprintf(stderr, "\n");
    /* Ausgabe incl. Skalierung der Translation */
    SchreibeBausteinSLP(aus, BS, Mat);
  }
  fclose(aus);
}
#endif

void GebeLoesungAus(void)
{
  Zeiterfassung(ZEITERFASSUNG_AUSGABE);
  if (ergdat != NULL) fwrite(Ergebnis, BAUSTEINZAHL * sizeof(unsigned short), 1, ergdat);
#ifdef SLP_ERGOUT
  SchreibeEinzelergebnisAlsSLP();
#endif
  Zeiterfassung(ZEITERFASSUNG_SUCHEN);
}
#endif


#ifdef ZAEHLE_LEGUNGEN
int BausteinLiegtInRichtung[BAUSTEINZAHL] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

void IncAnds(void)
{ int bs;
  Ands++;
  for (bs = 0; bs < BAUSTEINZAHL; bs++) AndsA[bs][BausteinLiegtInRichtung[bs]]++;
}

void IncLegungen(void)
{ int bs;
  Legungen++;
  for (bs = 0; bs < BAUSTEINZAHL; bs++) LegungenA[bs][BausteinLiegtInRichtung[bs]]++;
}

void PrintLegungen(void)
{ int bs, dir;
  FILE *erg;
  if ((erg = fopen("richtungen.csv", "w")) == NULL) {
    fprintf(stderr, "Richtungsauswertung kann nicht geschrieben werden!\n");
    return;
  }
  fprintf(erg, "LEGUNGEN:\nRichtung:");
  for (dir = 0; dir < 25; dir++) fprintf(erg, ",%d", dir);
  for (bs = 0; bs < 12; bs++) {
    fprintf(erg, "\nBaustein %d:", bs);
    for (dir = 0; dir < 25; dir++) {
      fprintf(erg, ",%8.6lf", ((double) LegungenA[bs][dir]) / 1000000.0);
    }
  }
  fprintf(erg, "\n");
  fprintf(erg, "AND-VERKNUEPFUNGEN:\nRichtung:");
  for (dir = 0; dir < 25; dir++) fprintf(erg, ",%d", dir);
  for (bs = 0; bs < 12; bs++) {
    fprintf(erg, "\nBaustein %d:", bs);
    for (dir = 0; dir < 25; dir++) {
      fprintf(erg, ",%8.6lf", ((double) AndsA[bs][dir]) / 1000000.0);
    }
  }
  fprintf(erg, "\n");
  fclose(erg);
}
#endif

int Zaehle_USED[BAUSTEINZAHL] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
#ifdef RESULT_CHAIN
int Zaehle_PLACED[BAUSTEINZAHL + 1] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
int Zaehle_BEREICH[BAUSTEINZAHL + 1] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
int Zaehle_IMBEREICH[BAUSTEINZAHL + 1] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
#endif
int Zaehle_EBENE = 0;

void Zaehle_Funktion(int ab_pos12, unsigned __int64 bisherige_maske)
{ unsigned __int64 belegt;
  int pos12, poslim, ct, BS;
#ifdef RESULT_CHAIN
  int bereich, bp;
  if (Zaehle_EBENE == 3) {
    fprintf(stderr, "\r  %2d(%2d/%2d) - %2d(%2d/%2d) - %2d(%2d/%2d)",
    Zaehle_PLACED[1] + 1, Zaehle_IMBEREICH[1], Zaehle_BEREICH[1],
    Zaehle_PLACED[2] + 1, Zaehle_IMBEREICH[2], Zaehle_BEREICH[2],
    Zaehle_PLACED[3] + 1, Zaehle_IMBEREICH[3], Zaehle_BEREICH[3]);
  }
#endif
#ifdef ZAEHLE_LEGUNGEN
  IncLegungen();
#endif
  Zaehle_EBENE++;
  belegt = bisherige_maske; pos12 = ab_pos12;
  /* Wo liegt der nchste Einsetzpunkt? */
#ifdef PRESHIFT
  while (((unsigned int) belegt) & 1) { belegt >>= 1; pos12 += 12; }
  belegt >>= 1; pos12 += 12;
#else
#ifndef MULTISHIFT
  do {
    belegt >>= 1; pos12 += 12;
  } while (((unsigned int) belegt) & 1);
#else
  while (!((~((unsigned int) belegt)) & 7)) {
    belegt >>= 3; pos12 += 36;
  }
  while (((unsigned int) belegt) & 1) {
    belegt >>= 1; pos12 += 12;
  }
#endif
#endif
  /* je noch unbenutzter Baustein */
  for (BS = 0; BS < BAUSTEINZAHL; BS++) if (!Zaehle_USED[BS]) {
    /* je grundstzliche Einsetzmglichkeit dieses Bausteins an dieser Position */
    poslim = Klassen[pos12 + BS + 1];
#ifdef RESULT_CHAIN
    bereich = poslim - Klassen[pos12 + BS]; bp = 0;
    Zaehle_BEREICH[Zaehle_EBENE] = bereich;
#endif
    for (ct = Klassen[pos12 + BS]; ct < poslim; ct++) {
#ifdef RESULT_CHAIN
      bp++;
#endif
#ifdef DEBUGING
      { int i;
        for (i = 0; i < EINSETZPUNKTE; i++) fprintf(stderr, "%c",
	  ((belegt & Magazin[ct]) & (((unsigned __int64) 1) << i)) ? (i == pos12 / 12) ? 'X' : '#' : (i == pos12 / 12) ? 'o' : '.');
	// for (i = 1; i <= Zaehle_EBENE; i++) fprintf(stderr, " %2d", Zaehle_PLACED[i]);
	fprintf(stderr, "\n");
      }
#endif
#ifdef ZAEHLE_LEGUNGEN
      IncAnds();
#endif
      if (!(belegt & Magazin[ct])) { /* Treffer ins Loch: Freier Platz */
        Zaehle_USED[BS] = 1;
#ifdef ERGEBNIS
        Ergebnis[Zaehle_EBENE - 1] = BausteinMagazinId[ct];
#endif
#ifdef ZAEHLE_LEGUNGEN
        BausteinLiegtInRichtung[BS] = BausteinMagazinRotId[ct];
#endif
#ifdef RESULT_CHAIN
        Zaehle_PLACED[Zaehle_EBENE] = BS;
        Zaehle_IMBEREICH[Zaehle_EBENE] = bp;
#endif
        if (Zaehle_EBENE == BAUSTEINZAHL) {
          Resultate++;
#ifdef ERGEBNIS
          GebeLoesungAus();
#endif
	  if (!(Resultate & MELDUNGSHAEUFIGKEIT )) {
            Geschwindigkeitserfassung();
	    /*
	    fprintf(stderr,
	    // "%-35s %lu Resultate bis jetzt gefunden.\r", " ", Resultate);
	    " %lu Resultate bis jetzt gefunden.\n", Resultate);
            DumpBitmask(stderr, belegt | Magazin[ct]);
	    fprintf(stderr, "\n%2d - %2d - %2d - %2d - %2d - %2d - %2d - %2d - %2d - %2d - %2d - %2d\n",
              Zaehle_PLACED[1] + 1, Zaehle_PLACED[2] + 1, Zaehle_PLACED[3] + 1, Zaehle_PLACED[4] + 1,
              Zaehle_PLACED[5] + 1, Zaehle_PLACED[6] + 1, Zaehle_PLACED[7] + 1, Zaehle_PLACED[8] + 1,
              Zaehle_PLACED[9] + 1, Zaehle_PLACED[10] + 1, Zaehle_PLACED[11] + 1, Zaehle_PLACED[12] + 1);
	    */
	  }
	} else {
#ifdef DEBUGING
          { int i;
            DumpBitmask(stderr, belegt | Magazin[ct]);
	    for (i = 1; i <= Zaehle_EBENE; i++) fprintf(stderr, " %2d", Zaehle_PLACED[i]);
	    fprintf(stderr, "\n");
	  }
#endif
          Zaehle_Funktion(pos12, belegt | Magazin[ct]);
        }
#ifdef ZAEHLE_LEGUNGEN
        BausteinLiegtInRichtung[BS] = 0;
#endif
      }
    }
    Zaehle_USED[BS] = 0;
  }
  Zaehle_EBENE--;
}


void Zaehle_Moeglichkeiten(void)
{ Resultate = 0;
#ifdef ERGEBNIS
  ergdat = fopen(ERGEBNIS, "wb");
#endif
#ifdef MULTISHIFT
  Zaehle_Funktion(  0, (unsigned __int64) 0);
#else
  Zaehle_Funktion(-12, (unsigned __int64) 0);
#endif
                  
#ifdef ERGEBNIS
  fclose(ergdat);
#endif
  printf("\n\nc't-Puzzle: %lu Zusammenbaulsungen gefunden.\n", Resultate);
}

void Init_Bitmaskparameter(void)
{ FUELL_BM_FAKTOR_2 = Kastengroesse.KOORD[FUELLKOORDINATE_1];
  FUELL_BM_FAKTOR_3 = Kastengroesse.KOORD[FUELLKOORDINATE_1] * Kastengroesse.KOORD[FUELLKOORDINATE_2];
}

void InitParametercheck(void)
{ if (EINSETZPUNKTE > 8 * sizeof(__int64)) {
    fprintf(stderr, "Bitmasken-Bearbeitung nicht fr Volumen ber %d Einheiten ausgelegt!\n",
            8 * sizeof(__int64));
    exit(9);
  }
}

int main()
{
  UINT CodePage;
  CodePage = GetConsoleOutputCP();
  SetConsoleOutputCP(1252);
#ifdef ERGEBNIS
#ifdef SLP_ERGOUT
  mkdir("loesungen");
#endif
#endif

  Zeiterfassung(ZEITERFASSUNG_INIT);
  InitParametercheck();
  Init_Bitmaskparameter();
  Init_RotationsMoeglichkeiten();
#ifdef DEBUGING
  Zeiterfassung(ZEITERFASSUNG_AUSGABE);
  { int ct;
    printf("RotationsMoeglichkeiten[]:\n");
    for (ct = 0; ct < 24; ct++) {
      printf("[%2d] (Det = %d) = ", ct, MatDet(RotationsMoeglichkeiten[ct]));
      DumpMat(stdout, RotationsMoeglichkeiten[ct]);
    }
  }
  Zeiterfassung(ZEITERFASSUNG_INIT);
#endif
  Init_Einsetztabelle();
  Init_KlassenMagazin();
  /*
   * Zeiterfassung(ZEITERFASSUNG_AUSGABE);
   * SchreibeTeileuebersicht();
   */
  Zeiterfassung(ZEITERFASSUNG_SUCHEN);
  Zaehle_Moeglichkeiten();
  Zeiterfassung(ZEITERFASSUNG_ENDE);
#ifdef ERGEBNIS
  PauseWait();
#endif
#ifdef ZAEHLE_LEGUNGEN
  printf("%I64u Legungen und %I64u Ands ausgefhrt.\n", Legungen, Ands);
  PrintLegungen();
#endif
  SetConsoleOutputCP(CodePage);
  return 0;
}
