/* dlg_untils.c */
/* Utilities for Dialogs */

// #include <string.h>
#include <memory.h>
#include <wchar.h>

#define DlgButton    0x0080
#define DlgEdit      0x0081
#define DlgStatic    0x0082
#define DlgListbox   0x0083
#define DlgScrollbar 0x0084
#define DlgCombobox  0x0085

typedef struct DynamicDialogTemplate {
  int bytes_accessable;
  int bytes_filled;
  int bytes_base;
  unsigned char *data;
  DLGTEMPLATE *dlg;
} DynDlgTemplate;

#define DynDlgTemplateNULL { 0 , 0, 0, NULL, NULL }

DynDlgTemplate DynDlgTemplateZero(void)
{ DynDlgTemplate erg;
  erg.bytes_accessable = erg.bytes_filled = erg.bytes_base = 0;
  erg.data = NULL; erg.dlg = NULL;
  return erg;
}

void DynDlgTemplateFree(DynDlgTemplate *dt)
{ if ((dt->bytes_accessable == 0) || (dt->data == NULL)) return;
  free(dt->data);
  *dt = DynDlgTemplateZero();
}

int DynDlgTemplateAlloc(DynDlgTemplate *dt, int dwords)
{ int byte_count;
  unsigned long addr;
  byte_count = 4 * dwords + 3;
  if ((dt->data = malloc(byte_count)) == NULL) {
    *dt = DynDlgTemplateZero();
    return -1;
  }
  dt->bytes_base = 0; addr = (unsigned long) dt->data;
  while (addr & 3) { addr++; byte_count--; dt->bytes_base++; }
  dt->dlg = (void *) &(dt->data[dt->bytes_base]);
  dt->bytes_accessable = byte_count;
  dt->bytes_filled = 0;
  return 0;
}

int DynDlgTemplateExpand(DynDlgTemplate *dt, int dwords)
{ int byte_count, neu_base;
  unsigned long addr;
  unsigned char *neu;
  if (dt->bytes_accessable >= 4 * dwords) return 0;
  byte_count = 4 * dwords + 3;
  if ((neu = malloc(byte_count)) == NULL) return -1;
  neu_base = 0; addr = (unsigned long) neu;
  while (addr & 3) { addr++; byte_count--; neu_base++; }
  if (dt->data != NULL) {
    if (dt->bytes_filled)
      memcpy(&(neu[neu_base]), &(dt->data[dt->bytes_base]), dt->bytes_filled);
    free(dt->data);
  }
  dt->data = neu;
  dt->bytes_base = neu_base;
  dt->dlg = (void *) &(dt->data[neu_base]);
  dt->bytes_accessable = byte_count;
  return 0;
}

int DynDlgSetHead(DynDlgTemplate *dt,
                  DWORD Style, DWORD ExtStyle, int x_0, int y_0, int x_w, int y_w,
                  wchar_t *MenuName, int Menu_ID,   /* -1 if none */
                  wchar_t *ClassName, int Class_ID, /* -1 if none */
                  wchar_t *Title,
                  wchar_t *Font, int FontPointsize, int FontWeight, int FontItalic)
/*  0 = ok
 * -1 = any error
 */
{ int required_bytes, ct;
  DWORD style;
  struct DT {
    DWORD style;
    DWORD dwExtendedStyle;
    WORD  cDlgItms;
    short x;
    short y;
    short cx;
    short cy;
    wchar_t varies[3];
  } *neu;
  style = Style;
  required_bytes = sizeof(DLGTEMPLATE); if (required_bytes & 1) required_bytes++;
  if (MenuName != NULL) required_bytes += 2 * (wcslen(MenuName) + 1);
  else required_bytes += (Menu_ID == -1) ? 2 : 4;
  if (ClassName != NULL) required_bytes += 2 * (wcslen(ClassName) + 1);
  else required_bytes += (Class_ID == -1) ? 2 : 4;
  if (Title != NULL) required_bytes += 2 * (wcslen(Title) + 1);
  else required_bytes += 2;
  if (Font != NULL) {
    required_bytes += 2 * (wcslen(Font) + 4);
    style |= DS_SETFONT;
  }
  while (required_bytes & 3) required_bytes++;
  if (DynDlgTemplateExpand(dt, required_bytes >> 2)) return -1;
  neu = (struct DT *) dt->dlg;
  neu->style = style;
  neu->dwExtendedStyle = ExtStyle;
  neu->cDlgItms = 0;
  neu->x = x_0; neu->y = y_0; neu->cx = x_w; neu->cy = y_w;
  if (MenuName != NULL) { wcscpy(neu->varies, MenuName); ct = wcslen(MenuName) + 1;
  } else if (Menu_ID == -1) { neu->varies[0] = 0; ct = 1;
  } else { neu->varies[0] = 0xffff; neu->varies[1] = Menu_ID; ct = 2;
  }
  if (ClassName != NULL) { wcscpy(&(neu->varies[ct]), ClassName); ct += wcslen(ClassName) + 1;
  } else if (Class_ID == -1) { neu->varies[ct] = 0; ct++;
  } else { neu->varies[ct] = 0xffff; neu->varies[ct + 1] = Class_ID; ct += 2;
  }
  if (Title != NULL) { wcscpy(&(neu->varies[ct]), Title); ct += wcslen(Title) + 1;
  } else { neu->varies[ct] = 0; ct++;
  }
  if (Font != NULL) {
    neu->varies[ct] = FontPointsize; neu->varies[ct + 1] = FontWeight; neu->varies[ct + 2] = FontItalic;
    wcscpy(&(neu->varies[ct + 3]), Font);
    // ct += wcslen(Font) + 4;
  }
  // if (ct & 1) ct++;
  dt->bytes_filled = required_bytes;
  return 0;
}

int DynDlgAddItem(DynDlgTemplate *dt,
                  DWORD Style, DWORD ExtStyle, int x_0, int y_0, int x_w, int y_w, int ID,
                  wchar_t *ClassName, int Class_ID,
                  wchar_t *Title, int Title_ID,
                  int CreaDataType, void *CreaData, int CreaDataSize)
/*  0 = ok
 * -1 = any error
 */
{ int required_bytes, ct;
  struct DI {
    DWORD style;
    DWORD dwExtendedStyle;
    short x;
    short y;
    short cx;
    short cy;
    WORD  id;
    wchar_t varies[3];
  } *neu;
  required_bytes = sizeof(DLGITEMTEMPLATE); if (required_bytes & 1) required_bytes++;
  required_bytes += (ClassName != NULL) ? 2 * (wcslen(ClassName) + 1) : 4;
  required_bytes += (Title != NULL) ? 2 * (wcslen(Title) + 1) : 4;
  required_bytes += 2; /* size */
  if (required_bytes & 1) required_bytes++;
  // while (required_bytes & 3) required_bytes++;
  switch (CreaDataType) {
    case 1: /* full array in pointer */
      required_bytes += *((unsigned char *)CreaData);
      while (required_bytes & 3) required_bytes++;
      break;
    case 2: /* Additional Data word aligned */
      required_bytes += CreaDataSize + 2;
      while (required_bytes & 3) required_bytes++;
      break;
    case 4: /* Additional Data dword aligned */
      required_bytes += CreaDataSize + 4;
      while (required_bytes & 3) required_bytes++;
      break;
    case 3: /* One short in CreaDataSize only, align by word */
      required_bytes += 4;
      break;
    case 5: /* One dword in CreaDataSize only, align by dword */
    case 6: /* Pass the pointer, align by dword */
      required_bytes += 8;
      break;
    default: /* 0, no Data */
    /* required_bytes += 4; */
      break;
  }
  while (required_bytes & 3) required_bytes++;
  if (DynDlgTemplateExpand(dt, (dt->bytes_filled + required_bytes) >> 2)) return -1;
  neu = (struct DI *) &(dt->data[dt->bytes_filled + dt->bytes_base]);
  neu->style = Style;
  neu->dwExtendedStyle = ExtStyle;
  neu->x = x_0; neu->y = y_0; neu->cx = x_w; neu->cy = y_w; neu->id = ID;
  if (ClassName != NULL) { wcscpy(&(neu->varies[0]), ClassName); ct = wcslen(ClassName) + 1;
  } else { neu->varies[0] = 0xffff; neu->varies[1] = Class_ID; ct = 2;
  }
  if (Title != NULL) { wcscpy(&(neu->varies[ct]), Title); ct += wcslen(Title) + 1;
  } else { neu->varies[ct] = 0; neu->varies[ct + 1] = Title_ID; ct += 2;
  }
  switch (CreaDataType) {
    case 1:
      neu->varies[ct] = *((unsigned char *)CreaData);
      break;
    case 2:
      neu->varies[ct] = CreaDataSize + 2;
      break;
    case 4:
      neu->varies[ct] = CreaDataSize + 4;
      break;
    case 3:
      neu->varies[ct] = 4;
      break;
    case 5: case 6:
      neu->varies[ct] = 8;
      break;
    default:
      neu->varies[ct] = 0;
  }
  ct++;
  // if ((ct + sizeof(DLGITEMTEMPLATE)/2) & 1) ct++;
  switch (CreaDataType) {
    case 1:
      memcpy(&(neu->varies[ct]), CreaData, *((unsigned char *)CreaData));
      break;
    case 2:
      neu->varies[ct] = CreaDataSize + 2;
      memcpy(&(neu->varies[ct + 1]), CreaData, CreaDataSize);
      break;
    case 4:
      neu->varies[ct] = CreaDataSize + 4;
      memcpy(&(neu->varies[ct + 2]), CreaData, CreaDataSize);
      break;
    case 3:
      neu->varies[ct] = 4;
      neu->varies[ct + 1] = CreaDataSize;
      break;
    case 5:
      neu->varies[ct] = 8;
      neu->varies[ct + 1] = 0;
      *((DWORD *) &(neu->varies[ct + 2])) = CreaDataSize;
      break;
    case 6:
      neu->varies[ct] = 8;
      neu->varies[ct + 1] = 0;
      *((void **) &(neu->varies[ct + 2])) = CreaData;
      break;
    default:
      /* neu->varies[ct] = 4;
      neu->varies[ct + 1] = 0; */
      break;
  }
  dt->dlg->cdit++;
  dt->bytes_filled += required_bytes;
  return 0;
}
  
    
