/* ct_puzzle_common.c
 * by Arnold Wendl, Frth, anno Domini 2003
 */
/* eventuell bei UNIX-Compiler noetig:
 * #define __int64  long long
 */

#define BAUSTEINZAHL      12
#define MAX_TEILWUERFEL    6

typedef struct TP_KOORD {
  GrInt KOORD[3];
} KOORD;
static KOORD KOORD_NULLPUNKT = { 0,0,0 };

typedef struct TP_MATRIX {
  GrInt MATRIX[12];
} MATRIX;

typedef struct TP_BAUSTEIN {
  GrInt Teilwuerfelzahl, Beschriftet;
  /*@ Alle Beschriftungen vom 1. Teilwrfel - immer auf (0,0,0) - aus in z-Richtung */
  KOORD Min, Max, Einzelelemente[MAX_TEILWUERFEL];
} BAUSTEIN;

const BAUSTEIN Baustein[BAUSTEINZAHL] = {
/*  1 */ { 5, 1, { 0, 0, 0 }, { 1, 2, 0 }, { { 0, 0, 0}, { 1, 0, 0}, { 0, 1, 0}, { 0, 2, 0}, { 1, 2, 0}, { 0, 0, 0} } },
/*  2 */ { 5, 1, { 0,-1,-2 }, { 0, 1, 0 }, { { 0, 0, 0}, { 0, 1, 0}, { 0, 0,-1}, { 0, 0,-2}, { 0,-1,-2}, { 0, 0, 0} } },
/*  3 */ { 5, 0, { 0, 0, 0 }, { 1, 3, 0 }, { { 0, 0, 0}, { 1, 0, 0}, { 0, 1, 0}, { 0, 2, 0}, { 0, 3, 0}, { 0, 0, 0} } },
/*  4 */ { 5, 0, { 0, 0, 0 }, { 1, 3, 0 }, { { 0, 0, 0}, { 1, 2, 0}, { 0, 1, 0}, { 0, 2, 0}, { 0, 3, 0}, { 0, 0, 0} } },
/*  5 */ { 5, 1, { 0, 0,-1 }, { 1, 1, 0 }, { { 0, 0, 0}, { 1, 0,-1}, { 0, 1, 0}, { 0, 1,-1}, { 0, 0,-1}, { 0, 0, 0} } },
/*  6 */ { 5, 0, {-1, 0, 0 }, { 1, 2, 0 }, { { 0, 0, 0}, {-1, 2, 0}, { 1, 2, 0}, { 0, 1, 0}, { 0, 2, 0}, { 0, 0, 0} } },
/*  7 */ { 5, 0, { 0, 0, 0 }, { 1, 2, 0 }, { { 0, 0, 0}, { 0, 2, 0}, { 1, 1, 0}, { 0, 1, 0}, { 1, 0, 0}, { 0, 0, 0} } },
/*  8 */ { 5, 0, {-1, 0, 0 }, { 1, 2, 0 }, { { 0, 0, 0}, {-1, 2, 0}, {-1, 1, 0}, { 0, 1, 0}, { 1, 0, 0}, { 0, 0, 0} } },
/*  9 */ { 4, 1, { 0, 0,-1 }, { 1, 1, 0 }, { { 0, 0, 0}, { 1, 1,-1}, { 0, 1, 0}, { 0, 1,-1}, { 0, 0, 0}, { 0, 0, 0} } },
/* 10 */ { 5, 0, {-1, 0, 0 }, { 1, 2, 0 }, { { 0, 0, 0}, { 1, 2, 0}, {-1, 1, 0}, { 0, 1, 0}, { 0, 2, 0}, { 0, 0, 0} } },
/* 11 */ { 5, 0, {-1,-1, 0 }, { 1, 1, 0 }, { { 0, 0, 0}, {-1, 0, 0}, { 0,-1, 0}, { 1, 0, 0}, { 0, 1, 0}, { 0, 0, 0} } },
/* 12 */ { 6, 1, { 0, 0, 0 }, { 1, 3, 0 }, { { 0, 0, 0}, { 0, 3, 0}, { 1, 2, 0}, { 1, 0, 0}, { 0, 1, 0}, { 0, 2, 0} } }
};

MATRIX MatMul(MATRIX m1, MATRIX m2)
{ MATRIX erg;
  memset(&erg, 0, sizeof(MATRIX));
  erg.MATRIX[0] = m1.MATRIX[0] * m2.MATRIX[0] + m1.MATRIX[3] * m2.MATRIX[1] + m1.MATRIX[6] * m2.MATRIX[2];
  erg.MATRIX[1] = m1.MATRIX[1] * m2.MATRIX[0] + m1.MATRIX[4] * m2.MATRIX[1] + m1.MATRIX[7] * m2.MATRIX[2];
  erg.MATRIX[2] = m1.MATRIX[2] * m2.MATRIX[0] + m1.MATRIX[5] * m2.MATRIX[1] + m1.MATRIX[8] * m2.MATRIX[2];
  erg.MATRIX[3] = m1.MATRIX[0] * m2.MATRIX[3] + m1.MATRIX[3] * m2.MATRIX[4] + m1.MATRIX[6] * m2.MATRIX[5];
  erg.MATRIX[4] = m1.MATRIX[1] * m2.MATRIX[3] + m1.MATRIX[4] * m2.MATRIX[4] + m1.MATRIX[7] * m2.MATRIX[5];
  erg.MATRIX[5] = m1.MATRIX[2] * m2.MATRIX[3] + m1.MATRIX[5] * m2.MATRIX[4] + m1.MATRIX[8] * m2.MATRIX[5];
  erg.MATRIX[6] = m1.MATRIX[0] * m2.MATRIX[6] + m1.MATRIX[3] * m2.MATRIX[7] + m1.MATRIX[6] * m2.MATRIX[8];
  erg.MATRIX[7] = m1.MATRIX[1] * m2.MATRIX[6] + m1.MATRIX[4] * m2.MATRIX[7] + m1.MATRIX[7] * m2.MATRIX[8];
  erg.MATRIX[8] = m1.MATRIX[2] * m2.MATRIX[6] + m1.MATRIX[5] * m2.MATRIX[7] + m1.MATRIX[8] * m2.MATRIX[8];
  erg.MATRIX[ 9] = m1.MATRIX[0] * m2.MATRIX[9] + m1.MATRIX[3] * m2.MATRIX[10] + m1.MATRIX[6] * m2.MATRIX[11] + m1.MATRIX[ 9];
  erg.MATRIX[10] = m1.MATRIX[1] * m2.MATRIX[9] + m1.MATRIX[4] * m2.MATRIX[10] + m1.MATRIX[7] * m2.MATRIX[11] + m1.MATRIX[10];
  erg.MATRIX[11] = m1.MATRIX[2] * m2.MATRIX[9] + m1.MATRIX[5] * m2.MATRIX[10] + m1.MATRIX[8] * m2.MATRIX[11] + m1.MATRIX[11];
  /* DUMP_MAT(erg) */ return erg;
}

KOORD PosTransKoord(MATRIX m, KOORD v)
{ KOORD erg;
  erg.KOORD[0] = m.MATRIX[0] * v.KOORD[0] + m.MATRIX[3] * v.KOORD[1] + m.MATRIX[6] * v.KOORD[2] + m.MATRIX[ 9];
  erg.KOORD[1] = m.MATRIX[1] * v.KOORD[0] + m.MATRIX[4] * v.KOORD[1] + m.MATRIX[7] * v.KOORD[2] + m.MATRIX[10];
  erg.KOORD[2] = m.MATRIX[2] * v.KOORD[0] + m.MATRIX[5] * v.KOORD[1] + m.MATRIX[8] * v.KOORD[2] + m.MATRIX[11];
  return erg;
}

KOORD PosTrans3i(MATRIX m, int x, int y, int z)
{ KOORD erg;
  erg.KOORD[0] = m.MATRIX[0] * x + m.MATRIX[3] * y + m.MATRIX[6] * z + m.MATRIX[ 9];
  erg.KOORD[1] = m.MATRIX[1] * x + m.MATRIX[4] * y + m.MATRIX[7] * z + m.MATRIX[10];
  erg.KOORD[2] = m.MATRIX[2] * x + m.MATRIX[5] * y + m.MATRIX[8] * z + m.MATRIX[11];
  return erg;
}

void GetBausteinExtends(BAUSTEIN *bs)
{ int ct, xmin, ymin, zmin, xmax, ymax, zmax, w;
  // printf("GetBausteinExtends() ...\n");
  // DumpBS(stdout, *bs);
  xmin = xmax = bs->Einzelelemente[0].KOORD[0];
  ymin = ymax = bs->Einzelelemente[0].KOORD[1];
  zmin = zmax = bs->Einzelelemente[0].KOORD[2];
  for (ct = 1; ct < bs->Teilwuerfelzahl; ct++) {
    if ((w = bs->Einzelelemente[ct].KOORD[0]) > xmax) xmax = w;
    else if (w < xmin) xmin = w;
    if ((w = bs->Einzelelemente[ct].KOORD[1]) > ymax) ymax = w;
    else if (w < ymin) ymin = w;
    if ((w = bs->Einzelelemente[ct].KOORD[2]) > zmax) zmax = w;
    else if (w < zmin) zmin = w;
  }
  bs->Min.KOORD[0] = xmin; bs->Min.KOORD[1] = ymin; bs->Min.KOORD[2] = zmin;
  bs->Max.KOORD[0] = xmax; bs->Max.KOORD[1] = ymax; bs->Max.KOORD[2] = zmax;
  // DumpBS(stdout, *bs);
}

BAUSTEIN BewegterBaustein(BAUSTEIN bs, MATRIX m)
{ BAUSTEIN erg;
  int ct;
  memset(&erg, 0, sizeof(BAUSTEIN));
  erg.Teilwuerfelzahl = bs.Teilwuerfelzahl;
  erg.Beschriftet = bs.Beschriftet;
  for (ct = 0; ct < bs.Teilwuerfelzahl; ct++) {
    erg.Einzelelemente[ct] = PosTransKoord(m, bs.Einzelelemente[ct]);
  }
  GetBausteinExtends(&erg);
  return erg;
}

