/* ******************************************************************* */
/* Christoph Peter-Orth, Diplom-Mathematiker & Software-Engineer       */
/* Jungborn 16                                                         */
/* 22926 Ahrensburg                                        Ostern 2003 */
/* 0 41 02 - 47 22 69                                                  */
/* Anfragen sowie Auftrge richten Sie bitte an  cpo.qm@t-online.de    */
/* ------------------------------------------------------------------- */
/* Mein Beitrag zum "Programmierwettbewerb" in c't 2003, Heft 7. 234.  */
/* aus: Harald Bgeholz. "Zusammengewrfelt. Puzzles mit dem Computer  */
/*      lsen". in: c't 2003, Heft 7. 230-234.                         */
/* In der auf Seite 234 oben abgebildeten Reihenfolge bezeichne ich    */
/* die Puzzle-Teile von links nach rechts: U Z L Y ' T P W s F X t     */
/* Siehe: Pieter van Delft, Jack Botermans. "Denkspiele der Welt".     */
/*        Mnchen 1977 / 1979. Deutsche Bearbeitung von Eugen Oker.    */
/* sowie: Jack Botermans, Jerry Slocum. "Geduldsspiele der Welt".      */
/*        Mnchen 1987. bersetzt von Claus Voigt, Anke Burmeister.    */
/* Von den gngigen Pentominos fehlen I N V, statt dessen haben wir    */
/* das aus den 4 Wrfeln bestehende Puzzle-Teil s aus dem Soma-Wrfel  */
/* und die c't-Kreationen ' aus 5 Wrfeln und t aus 6 Wrfeln.         */
/* Zu Ehren der c't sei das U in c umbenannt: c Z L Y ' T P W s F X t  */
/* Zur Bestimmung aller wesentlich unterschiedlichen Zusammensetzungen */
/* des 3 x 4 x 5 - Quaders werden in diesem Programm fr Puzzle-Teil t */
/* lediglich vier Grundausrichtungen zugelassen, um gedrehte gleiche   */
/* Lsungen zu vermeiden.Gespiegelte Lsungen sind nicht mglich, weil */
/* das Spiegelbild des Puzzle-Teils s fehlt.                           */
/*             Anzahl    Anzahl der verbleibenden noch mglichen       */
/* Grundausrichtungen:   Positionen im Quader:                         */
/* Puzzle-Teil t:   4        56                                        */
/* Puzzle-Teil Z:  12       160                                        */
/* Puzzle-Teil X:   3        40                                        */
/* Puzzle-Teil W:  12       160                                        */
/* Puzzle-Teil T:  12       160                                        */
/* Puzzle-Teil Y:  16       224                                        */
/* Puzzle-Teil L:  16       224                                        */
/* Puzzle-Teil c:  12       252                                        */
/* Puzzle-Teil F:  24       320                                        */
/* Puzzle-Teil P:  24       504                                        */
/* Puzzle-Teil ':  24       576                                        */
/* Puzzle-Teil s:  12       288                                        */
/* ******************************************************************* */
#include <stdio.h>                /* Standard I/O                      */
#include <stdlib.h>               /* Standard-Funktionen               */
#include <time.h>                 /* fr die Zeitmessung               */

/* ----- lokale Funktionen                                             */
static void tstart(void);         /* start puzzle                      */
static void puzzle(int, int);     /* ermittelt Anzahl aller Lsungen   */
static void s000(void);           /* Initialisierung                   */
static void s111(int*, int);      /* Wrfel plan oder diagonal drehen  */
static void s123(int);            /* alle Lagen im 3 x 4 x 5 Quader    */
static void s200(void);           /* Text zum Programm-Start           */
static void s222(int);            /* Text zum Programm-Ende            */
//static void s333(int);            /* puzzeln mit output                */

/* ----- globale Variablen                                             */
static unsigned long bit[32];     /* indizierter Zugriff auf Bits      */
static unsigned long ii[24];      /* ii unterer Teil - jj oberer Teil  */
static unsigned long jj[24];      /* 24 turns of the 4 x 4 x 4 - cube  */
static unsigned long qb[9216];    /* quader bottom                     */
static unsigned long qt[9216];    /* quader top                        */
static unsigned long pb[12];      /* assembled quader bottom           */
static unsigned long pt[12];      /* assembled quader top              */
static unsigned long number;      /* Anzahl aller Puzzle-Lsungen      */
static int           pp[12];      /* gewhltes Puzzle-Teil Position    */
static int           ht[12];      /* Pointer auf head und tail         */
static int           head[67];    /* Pointer: Start Puzzle-Teil-Matrix */
static int           tail[67];    /* Pointer: Ende Puzzle-Teil-Matrix  */
static int           pnlty[67];   /* Strafe fr Puzzle-Teil s          */
//static char          name[12];    /* Namen der Puzzle-Teile            */
//static char          row[4][78];  /* 4 Zeilen fr den Druck            */

static FILE *fp;

/* ******************************************************************* */

void main()
{
  clock_t start_time, end_time;   /* fr die Zeitmessung mit clock():  */

  s000();                         /* Initialisierungen                 */
  s200();                         /* erste Bildschirm-Meldungen        */

  start_time = clock();           /* ----- Zeitnahme Anfang ---------- */
  /* ----- c't-Puzzle Anfang ----------------------------------------- */
  tstart();                       /* Suchbaum ber alle Mglichkeiten  */
  /* ----- c't-Puzzle Ende ------------------------------------------- */
  end_time = clock();             /* ----- Zeitnahme Ende ------------ */


  s222((end_time - start_time)    /* letzte Bildschirm-Meldungen       */
              / CLOCKS_PER_SEC);
  exit(0);
}

/* ------------------------------------------------------------------- */
/* tstart()                             Start Puzzle mit Puzzle-Teil t */
/* ------------------------------------------------------------------- */
static void tstart(void)
{
  /* ----- erstes Puzzle-Teil:                                         */
  for (pp[0]=head[0]; pp[0]<=tail[0]; pp[0]++)   /* 0-1-matrix part 0  */
  { pb[0]=qb[pp[0]];              /* assembled quader bottom           */
    pt[0]=qt[pp[0]];              /* assembled quader top              */
    /* ----- zweites Puzzle-Teil                                       */
    for (pp[1]=head[1]; pp[1]<=tail[1]; pp[1]++) /* 0-1-matrix part 1  */
    { if ((pb[0]&qb[pp[1]]) == 0  &&  /* bottom not occupied           */
          (pt[0]&qt[pp[1]]) == 0)     /* top not occupied              */
      { pb[1]=pb[0];              /* assembled quader bottom           */
        pb[1]|=qb[pp[1]];         /* plus new piece                    */
        pt[1]=pt[0];              /* assembled quader top              */
        pt[1]|=qt[pp[1]];         /* plus new piece                    */
        puzzle(1,1);              /* recursion                         */
      }
    }
  }
}

/* ------------------------------------------------------------------- */
/* puzzle(level,omit)                  ermittelt Anzahl aller Lsungen */
/*                                                                     */
/* INPUT: int level   = Ebene im Suchbaum                              */
/*        int omit    = bereits eingefgtes Puzzle-Teil                */
/* ------------------------------------------------------------------- */
static void puzzle(int level, int omit)
{
  int           i, j, n;
  int           k, kk, select;    /* Suche nach krzester Teilmatrix   */
  unsigned long rakeb;            /* Test ob Quader unten fllbar      */
  unsigned long raket;            /* Test ob Quader oben fllbar       */

  k=1024;
  rakeb=pb[level];                /* new assembled quader bottom       */
  raket=pt[level];                /* new assembled quader top          */
  n=ht[level];                    /* index: start smaller matrix       */
  /* ----- Die zu bearbeitende Matrix wird konsequent verkleinert.     */
  /*       Kleinere Matrix mit bisher nicht eingebauten Puzzle-Teilen: */
  for (j=ht[level-1]; j<ht[level]; j++) /* verbliebene Teilmatrizen    */
  { if (j!=omit)                  /* eingefgtes Puzzle-Teil auslassen */
    { tail[n]=tail[n-1];          /* Ende der aktuellen Matrix         */
      head[n]=tail[n]+1;          /* Start fr zu kopierenden Teil     */
      for (i=head[j]; i<=tail[j]; i++)  /* Teilmatrix                  */
      { if ((pb[level]&qb[i]) == 0  &&  /* unten frei                  */
            (pt[level]&qt[i]) == 0)     /* oben frei                   */
        { tail[n]++;              /* Puzzle-Teil pat noch             */
          qb[tail[n]]=qb[i];      /* unteren Teil kopieren             */
          rakeb|=qb[i];           /* Harke unten                       */
          qt[tail[n]]=qt[i];      /* oberen Teil kopieren              */
          raket|=qt[i];           /* Harke oben                        */
        }
      } /* >>>>>>>>>>>>>>>>>>>>>>>>> 1. Abbruch-Kriterium: >>>>>>>>>>> */
      if (tail[n] < head[n])      /* Puzzle-Teil pat nicht in Quader  */
        return;                   /* 1. Abbruch-Kriterium erfllt      */
      kk=pnlty[n]=pnlty[j];       /* Straffaktor kopieren              */
      kk*=tail[n]-head[n]+1;      /* Straffaktor * Lnge Teilmatrix    */
      if (kk < k)                 /* neue Teilmatrix krzer:           */
      { k=kk;                     /* Lnge merken                      */
        select=n;                 /* bisher krzeste Teilmatrix        */
      }
      n++;                        /* index: next smaller matrix        */
    }
  } /* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> letztes Abbruchkriterium: >>>>>>> */
  if (level == 10)                /* Lsung gefunden:                  */
  { number++;                     /* Anzahl gefundener Lsungen        */
  } /* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> 2. Abbruch-Kriterium: >>>>>>>>>>> */
  else if ((rakeb^0xffffffff) == 0 /* Quader ist von den restlichen    */
       && (raket^0x0fffffff) == 0) /* Puzzle-Teilen potentiell fllbar */
  { level++;                      /* Abbruch-Kriterium nicht erfllt   */
    for (pp[level]=head[select]; pp[level]<=tail[select]; pp[level]++)
    { pb[level]=pb[level-1];      /* assembled quader bottom           */
      pb[level]|=qb[pp[level]];   /* plus new piece                    */
      pt[level]=pt[level-1];      /* assembled quader top              */
      pt[level]|=qt[pp[level]];   /* plus new piece                    */
      puzzle(level,select);       /* recursion                         */
    }
  }
}

/* ******************************************************************* */
/* ------------------------------------------------------------------- */
/* Auer dem 1. Puzzle-Teil t werden alle Teile in alle mglichen      */
/* 24 rumlichen Positionen gedreht. Doppelungen werden entfernt.      */
/* Danach wird jedes Puzzle-Teil in smtliche mglichen Positionen des */
/* 3 x 4 x 5 - Quaders geschoben und als Bit-Vekter abgespeichert.     */
/* ------------------------------------------------------------------- */
static void s000(void)
{
  int  i, j, k;

  /* ----- neue Position plan drehen                                   */
  static int tp[] =
  {  3,  7, 11, 15,  2,  6, 10, 14,  1,  5,  9, 13,  0,  4,  8, 12,
    19, 23, 27, 31, 18, 22, 26, 30, 17, 21, 25, 29, 16, 20, 24, 28,
    35, 39, 43, 47, 34, 38, 42, 46, 33, 37, 41, 45, 32, 36, 40, 44,
    51, 55, 59, 63, 50, 54, 58, 62, 49, 53, 57, 61, 48, 52, 56, 60 };
  /* ----- neue Position diagonal drehen                               */
  static int  td[] =
  {  0, 16, 32, 48,  1, 17, 33, 49,  2, 18, 34, 50,  3, 19, 35, 51,
     4, 20, 36, 52,  5, 21, 37, 53,  6, 22, 38, 54,  7, 23, 19, 55,
     8, 24, 40, 56,  9, 25, 41, 57, 10, 26, 42, 58, 11, 27, 23, 59,
    12, 28, 44, 60, 13, 29, 45, 61, 14, 30, 46, 62, 15, 31, 27, 63 };

  /*       000 1001 0101 1000 1001 0101  0=plan und 1=diagonal drehen  */
  long steer = 0x00095895;        /* Steuerung plan - diagonal drehen  */

  /* Analog zum "Rntgenbild" in c't 2003, Heft 7 Seite 232 Definition */
  /* der Puzzle-Teile als Bit-Vektoren in einem 4 x 4 x 4 - Wrfel     */
  static unsigned long iteil[] =  /* Definition der c't Puzzle-Teile   */
  { 0x11110101,                   /* Puzzle-Teil t                     */
    0x00000471,                   /* Puzzle-Teil Z                     */
    0x00000272,                   /* Puzzle-Teil X                     */
    0x00000136,                   /* Puzzle-Teil W                     */
    0x00000227,                   /* Puzzle-Teil T                     */
    0x0000002f,                   /* Puzzle-Teil Y                     */
    0x0000001f,                   /* Puzzle-Teil L                     */
    0x00000075,                   /* Puzzle-Teil c                     */
    0x00000271,                   /* Puzzle-Teil F                     */
    0x00000037,                   /* Puzzle-Teil P                     */
    0x00010033,                   /* Puzzle-Teil '                     */
    0x00010023 };                 /* Puzzle-Teil s                     */

//  name[0]='t';                    /* Puzzle-Teil t                     */
//  name[1]='Z';                    /* Puzzle-Teil Z                     */
//  name[2]='X';                    /* Puzzle-Teil X                     */
//  name[3]='W';                    /* Puzzle-Teil W                     */
//  name[4]='T';                    /* Puzzle-Teil T                     */
//  name[5]='Y';                    /* Puzzle-Teil Y                     */
//  name[6]='L';                    /* Puzzle-Teil L                     */
//  name[7]='c';                    /* Puzzle-Teil c                     */
//  name[8]='F';                    /* Puzzle-Teil F                     */
//  name[9]='P';                    /* Puzzle-Teil P                     */
//  name[10]=39;                    /* Puzzle-Teil '                     */
//  name[11]='s';                   /* Puzzle-Teil s                     */

  ht[0]=1;                        /* level  0: Pointer auf head        */
  ht[1]=12;                       /* level  1: Pointer auf head        */
  ht[2]=22;                       /* level  2: Pointer auf head        */
  ht[3]=31;                       /* level  3: Pointer auf head        */
  ht[4]=39;                       /* level  4: Pointer auf head        */
  ht[5]=46;                       /* level  5: Pointer auf head        */
  ht[6]=52;                       /* level  6: Pointer auf head        */
  ht[7]=57;                       /* level  7: Pointer auf head        */
  ht[8]=61;                       /* level  8: Pointer auf head        */
  ht[9]=64;                       /* level  9: Pointer auf head        */
  ht[10]=66;                      /* level 10: Pointer auf head        */

  for (i=0; i<12; i++)
    pnlty[i]=3;                   /* Straffaktor: 3                    */
  pnlty[11]=5;                    /* Straffaktor 5 fr Puzzle-Teil s   */

  /* ----- fr indizierten Zugriff bit[] initialisieren                */
  bit[0]=0x00000001;
  for (i=1, j=0; i<32; i++, j++)
    bit[i]=bit[j]<<1;

  for (k=0; k<12; k++)            /* fr Puzzle-Teil 1 bis 12          */
  { for (i=0; i<24; i++)          /* Wrfel mit 0 vorbesetzen          */
    { ii[i]=0;
      jj[i]=0;
    }
    ii[0]=iteil[k];               /* kopiert Definition in den Wrfel  */
    /* --- Spezialbehandlung fr das 1. Puzzle-Teil t: nur 4 rumliche */
    if (k == 0)                   /* Ausrichtungen werden zugelassen,  */
    { s111(td,0);                 /* um wesentlich gleiche, rumlich   */
      ii[2]=ii[1];                /* gedrehte Lsungen auszuschlieen. */
      jj[2]=jj[1];                /* Gespiegelte Lsungen gibt es      */
      s111(tp,0);                 /* nicht, da fr Puzzle-Teil s kein  */
      s111(tp,2);                 /* Spiegelbild existiert.            */
    }                             /* alle Lagen im 3 x 4 x 5 Quader    */
    /* ----- 24 Ausrichtungen im Raum aufbereiten                      */
    else /* --- restliche Puzzle-Teile in allen Stellungen             */
    {
      for (i=0; i<23; i++)        /* plus 23 rumliche Ausrichtungen:  */
      { if (steer&bit[i])         /* Steuerung plan - diagonal drehen  */
        { s111(td,i);             /* diagonal drehen                   */
        }
        else
        { s111(tp,i);             /* plan drehen                       */
        }
      }
      /* ----- doppelte und unmgliche Ausrichtungen entfernen         */
      for (j=1; j<24; j++)        /* fr jede Ausrichtung:             */
      { for (i=0; i<j; i++)       /* falls ein Vorgnger:              */
        { if ((ii[i] == ii[j]  && /* doppelt unten und                 */
               jj[i] == jj[j]) || /* doppelt oben       oder           */
               jj[j]&0xffff0000)  /* ber 3 x 4 x 5 Quader hinausragt: */
          { ii[j]=0;              /* Ausrichtung entfernen             */
            jj[j]=0;              /* Ausrichtung entfernen             */
           break;
          }
        }
      }
    }
    /* ----- Puzzle-Teil im 3 x 4 x 5 Quader in alle Lagen bringen     */
    s123(k);                      /* alle Lagen im 3 x 4 x 5 Quader    */
  }
  number=0;                       /* Anzahl gefundener Lsungen        */
}

/* ------------------------------------------------------------------- */
/* s111(tp,i)                           4 x 4 x 4 - Wrfel plan drehen */
/* s111(td,i)                       4 x 4 x 4 - Wrfel diagonal drehen */
/*                        und Puzzle-Teil in die Grundposition bringen */
/* ------------------------------------------------------------------- */
static void s111(int turn[], int lage)
{
  int  i, next;
  next=lage+1;

  ii[next]=0;                     /* unterer Teil des Wrfels          */
  jj[next]=0;                     /* oberer Teil des Wrfels           */

  for (i=0; i<32; i++)            /* Prfung aller Bits Wrfel[lage]   */
  { if (ii[lage]&bit[i])          /* Bit gesetzt im unteren Teil:      */
    { if (turn[i]&0xffe0)         /* Ziel im oberen Teil Wrfel[next]: */
      { jj[next]|=bit[turn[i]&0x001f]; /* Bit setzen                   */
      }
      else                        /* Ziel unten im Wrfel[next]:       */
      { ii[next]|=bit[turn[i]&0x001f]; /* Bit setzen                   */
      }
    }
    if (jj[lage]&bit[i])          /* Bit gesetzt im oberen Teil:       */
    { if (turn[i+32]&0xffe0)      /* Ziel im oberen Teil Wrfel[next]: */
      { jj[next]|=bit[turn[i+32]&0x001f]; /* Bit setzen                */
      }
      else                        /* Ziel unten im Wrfel[next]:       */
      { ii[next]|=bit[turn[i+32]&0x001f]; /* Bit setzen                */
      }
    }
  }

  /* ----- in die Grundposition unten + rechts + vorne schieben:       */
  while ((ii[next]&0xffffffff) == 0) /* unterste Schicht ist frei:     */
  { ii[next]>>=16;                /* Bits nach unten schieben          */
    ii[next]|=jj[next]<<16;       /* unteren Teil vom oberen Wrfel    */
    jj[next]>>=16;                /* Bits nach unten schieben          */
  }
  while ((ii[next]&0x000f000f) == 0  /* unten: rechte Schicht ist frei */
       && (jj[next]&0x000f000f) == 0) /* oben: rechte Schicht ist frei */
  { ii[next]>>=4;                 /* Puzzle-Teil nach rechts schieben  */
    jj[next]>>=4;                 /* Puzzle-Teil nach rechts schieben  */
  }
  while ((ii[next]&0x11111111) == 0  /* unten: Schicht vorne ist frei  */
       && (jj[next]&0x11111111) == 0) /* oben: Schicht vorne ist frei  */
  { ii[next]>>=1;                 /* Puzzle-Teil nach vorne schieben   */
    jj[next]>>=1;                 /* Puzzle-Teil nach vorne schieben   */
  }
}

/* ------------------------------------------------------------------- */
/* s123(pteil)                       alle Lagen im 3 x 4 x 5 Quader    */
/* ------------------------------------------------------------------- */
static void s123(int pteil)
{ int i, j, k, last, mark, nn;

  if (pteil)                      /* fr Puzzle-Teil 1 bis 11          */
  { tail[pteil]=tail[pteil-1];    /* Ende auf Ende(Vorgnger) setzen   */
    head[pteil]=tail[pteil]+1;    /* Anfang direkt dahinter            */
  }
  else                            /* fr Puzzle-Teil 0                 */
  { tail[pteil]=-1;               /* Ende steht vor dem Anfang         */
    head[pteil]=0;                /* Anfang gleich 0                   */
  }
  last=tail[pteil];

  for (k=0; k<24; k++)            /* fr alle 24 Ausrichtungen:        */
  { if (ii[k])                    /* Ausrichtung ist nicht aussortiert */
    { last++;                     /* Ende weiterstellen                */
      mark=last;                  /* Anfang dieser Ausrichtung merken  */
      /* ----- Puzzle-Teil aus dem Wrfel in den Quader kopieren       */
      qt[last]=ii[k];             /* quader top - mittlere Schicht     */
      qt[last]>>=28;              /* bit 28-31 kommen nach bit 0-3     */
      qt[last]|=jj[k]<<8;         /* quader top - obere Schicht        */
      qb[last]=0;                 /* quader bottom mit 0 vorbesetzen   */
      qb[last]|=ii[k]&0x0000ffff; /* unterste Schicht aus dem Wrfel   */
      ii[k]<<=4;                  /* bit 28-31 links rausschieben      */
      qb[last]|=ii[k]&0xfff00000; /* mittlere Schicht aus dem Wrfel   */
      /* ----- Puzzle-Teil im Quader schieben                          */
      while ((qt[last]&0x0f0000f0) == 0  &&  /* top + center +         */
             (qb[last]&0x000f0000) == 0)     /* bottom ist links frei: */
      { last++;                   /* Ende weiterstellen                */
        qt[last]=qb[last-1];      /* quader bottom zunchst kopieren   */
        qt[last]>>=28;            /* Grenzschicht nach ganz rechts     */
        qt[last]|=qt[last-1]<<4;  /* um eine Wrfelschicht nach links  */
        qb[last]=0;               /* quader bottom mit 0 vorbesetzen   */
        qb[last]|=qb[last-1]<<4;  /* um eine Wrfelschicht nach links  */
      }
      nn=last;                    /* bisher letzte Position            */
      for (j=mark; j<=nn; j++)    /* Puzzle-Teile: obige Ausrichtung   */
      { i=j;
        while ((qt[i]&0x08888888) == 0  &&  /* top + center +          */
               (qb[i]&0x88888888) == 0)     /* bottom ist hinten frei: */
        { last++;                 /* Ende weiterstellen                */
          qt[last]=0;             /* quader top mit 0 vorbesetzen      */
          qt[last]|=qt[i]<<1;     /* um eine Wrfelschicht nach hinten */
          qb[last]=0;             /* quader bottom mit 0 vorbesetzen   */
          qb[last]|=qb[i]<<1;     /* um eine Wrfelschicht nach hinten */
          i=last;
        }
      }
      nn=last;                    /* bisher letzte Position            */
      for (j=mark; j<=nn; j++)    /* Puzzle-Teile: obige Ausrichtung   */
      { i=j;
        while ((qt[i]&0x0fffff00) == 0) /* top: obere Schicht ist frei */
        { last++;                 /* Ende weiterstellen                */
          qt[last]=0;             /* quader top mit 0 vorbesetzen      */
          qt[last]|=qt[i]<<20;    /* um eine Wrfelschicht nach oben   */
          qb[last]=qb[i];         /* quader bottom zunchst kopieren   */
          qb[last]>>=12;          /* Schicht auf gleiche Hhe bringen  */
          qt[last]|=qb[last];     /* top + center Schicht reinkopieren */
          qb[last]=0;             /* quader bottom mit 0 vorbesetzen   */
          qb[last]|=qb[i]<<20;    /* um eine Wrfelschicht nach oben   */
          i=last;
        }
      }
    }
  }

  tail[pteil]=last;
}

/* ******************************************************************* */
/* ------------------------------------------------------------------- */
/* s200()                                      Text bei Programm-Start */
/* ------------------------------------------------------------------- */
static void s200(void)
{
  char ch;

  fp=fopen("ctpuzzle.txt","wb");
  if (fp==0)
  { printf("\n\n Error opening file 'ctPUZZLE.txt' !\n");
    printf(" Copy 'ct.exe' to your hard disk and start it from there.");
    scanf("%c",&ch);
    exit(1);
  }
  printf("\n The c't-puzzle\n\n");
  printf(" This program examines all essential different solutions\n");
  printf(" of the c't-puzzle. After about half an hour you will get\n");
  printf(" a message with the exact number.\n\n");
  printf(" Please wait!\n\n");
  return;
}


/* ------------------------------------------------------------------- */
/* s222(seconds)                                Text bei Programm-Ende */
/* ------------------------------------------------------------------- */
static void s222(int seconds)
{
//  char ch;
//  int  i, n;

  printf("\n Number of solutions: %lu\n",number);
  printf("\n Execution time was %lu seconds.\n\n",seconds);
  printf("\n That are on an average %f solutions per second.\n\n\n",
        (double)number/seconds);

  fprintf(fp,"\nNumber of solutions: %lu\n",number);
  fprintf(fp,"\nExecution time was %lu seconds.\n\n",seconds);
  fprintf(fp,"\nThat are on an average %f solutions per second.\n",
         (double)number/seconds);

  fclose(fp);
  /* ***************************************************************** */
  /* **** Teilproblem mit c t in der obersten Schicht des Quaders **** */
//  fp=fopen("ct_top.txt","wb");
//  if (fp==0)
//  { printf("\n\n Error opening file 'ct_TOP.txt' !\n");
//    scanf("%c",&ch);
//    exit(1);
//  }
//  for (i=0; i<3; i++)             /* Kopfzeile in 'ct_TOP.txt'         */
//    fprintf(fp," top  centr bottm   ");
//  fprintf(fp," top  centr bottm\n\n");
//
//  for (i=0; i<77; i++)            /* Quader-Output vorbereiten         */
//    row[0][i]=row[1][i]=row[2][i]=row[3][i]=' ';
//  row[0][77]=row[1][77]=row[2][77]=row[3][77]=0;
//
//  /* ----- Puzzle-Teil c fixiert in Position 0x07500000 0x00000000 --- */
//  n=head[7];
//  while (qt[n]^0x07500000)
//    n++;
//  tail[7]=head[7]=n;
//  /* ----- Puzzle-Teil t fixiert in Position 0x0000f500 0x00000000 --- */
//  n=head[0];
//  while (qt[n]^0x0000f500)
//    n++;
//  tail[0]=head[0]=n;
//  /* ----- erstes Puzzle-Teil:                                         */
//  number=0;                       /* Anzahl gefundener Lsungen        */
//  for (pp[0]=head[0]; pp[0]<=tail[0]; pp[0]++) /* 0-1-matrix           */
//  { pb[0]=qb[pp[0]];              /* assembled quader bottom           */
//    pt[0]=qt[pp[0]];              /* assembled quader top              */
//    /* ----- zweites Puzzle-Teil                                       */
//    for (pp[1]=head[1]; pp[1]<=tail[1]; pp[1]++)
//    { if ((pb[0]&qb[pp[1]]) == 0  &&  /* unten frei                    */
//          (pt[0]&qt[pp[1]]) == 0)     /* oben frei                     */
//      { pb[1]=pb[0];              /* assembled quader bottom           */
//        pb[1]|=qb[pp[1]];         /* plus new piece                    */
//        pt[1]=pt[0];              /* assembled quader top              */
//        pt[1]|=qt[pp[1]];         /* plus new piece                    */
//        s333(1);                  /* recursion                         */
//      }
//    }
//  }
//  /* ----- Druck der restlichen Lsungen und Anzahl                    */
//  if (number%4)
//  { for (i=3; i>=0; i--)
//      fprintf(fp,"%s\n",row[i]);
//  }
//  fprintf(fp,"\nNumber of solutions: %lu",number);
//  fclose(fp);
//
//  printf(" You are interested in all solutions having c t\n");
//  printf(" within the top layer of the 3 x 4 x 5 block?\n");
//  printf(" Print the file 'ct_TOP.txt' with a monospaced\n");
//  printf(" typeface in size 9pt.\n\n");
//  printf(" c t within the top layer - number of solutions: %lu\n",number);

  return;
}

/* ------------------------------------------------------------------- */
/* s333(level)                                                 puzzeln */
/* input: int level   = Ebene im Suchbaum                              */
/* ------------------------------------------------------------------- */
//static void s333(int level)
//{
//  int           i, j, n;
//  unsigned long rakeb;            /* Test ob Quader unten fllbar      */
//  unsigned long raket;            /* Test ob Quader oben fllbar       */
//
//  rakeb=pb[level];                /* new assembled quader bottom       */
//  raket=pt[level];                /* new assembled quader top          */
//  n=ht[level];                    /* index: start smaller matrix       */
//  /* ----- Die zu bearbeitende Matrix wird konsequent verkleinert.     */
//  /* ----- Kleinere Matrix mit bisher nicht eingebauten Puzzle-Teilen: */
//  for (j=ht[level-1]+1; j<ht[level]; j++)
//  { tail[n]=tail[n-1];            /* Ende der aktuellen Matrix         */
//    head[n]=tail[n]+1;            /* Start fr zu kopierenden Teil     */
//    for (i=head[j]; i<=tail[j]; i++)
//    { if ((pb[level]&qb[i]) == 0  &&  /* unten frei                    */
//          (pt[level]&qt[i]) == 0)     /* oben frei                     */
//      { tail[n]++;                /* Puzzle-Teil pat noch             */
//        qb[tail[n]]=qb[i];        /* unteren Teil kopieren             */
//        rakeb|=qb[i];             /* Harke unten                       */
//        qt[tail[n]]=qt[i];        /* oberen Teil kopieren              */
//        raket|=qt[i];             /* Harke oben                        */
//      }
//    }
//    if (tail[n] < head[n])        /* Puzzle-Teil pat nicht in Quader  */
//      return;                     /* 1. Abbruch-Kriterium              */
//    n++;                          /* index: next smaller matrix        */
//  }
//  if (level == 10)                /* Lsung gefunden:                  */
//  { j=number%4;
//    j*=20;
//    number++;                     /* Anzahl gefundener Lsungen        */
//    pp[11]=head[n-1];
//    for (n=0; n<12; n++)
//    { for (i=0; i<20; i++)
//      { if (qb[pp[n]]&bit[i])
//          row[i%4][j+16-(i>>2)]=name[n];
//      }
//      for (i=20; i<32; i++)
//      { if (qb[pp[n]]&bit[i])
//          row[i%4][j+15-(i>>2)]=name[n];
//      }
//      for (i=0; i<8; i++)
//      { if (qt[pp[n]]&bit[i])
//          row[i%4][j+7-(i>>2)]=name[n];
//      }
//      for (i=8; i<28; i++)
//      { if (qt[pp[n]]&bit[i])
//          row[i%4][j+6-(i>>2)]=name[n];
//      }
//    }
//    if (number%4 == 0)
//    { for (i=3; i>=0; i--)
//        fprintf(fp,"%s\n",row[i]);
//      fprintf(fp,"\n");
//      for (i=0; i<77; i++)
//        row[0][i]=row[1][i]=row[2][i]=row[3][i]=' ';
//    }
//  }                               /* 2. Abbruch-Kriterium:             */
//  else if ((rakeb^0xffffffff) == 0 /* Quader ist von den restlichen    */
//       && (raket^0x0fffffff) == 0) /* Puzzle-Teilen potentiell fllbar */
//  { level++;
//    for (pp[level]=head[ht[level-1]]; pp[level]<=tail[ht[level-1]]; pp[level]++)
//    { pb[level]=pb[level-1];      /* assembled quader bottom           */
//      pb[level]|=qb[pp[level]];   /* plus new piece                    */
//      pt[level]=pt[level-1];      /* assembled quader top              */
//      pt[level]|=qt[pp[level]];   /* plus new piece                    */
//      s333(level);                /* recursion                         */
//    }
//  }
//}
/* *** Ende Teilproblem mit ct in der obersten Schicht des Quaders *** */
/* ******************************************************************* */
