/***************************************************************************
                          prepare.cpp  -  description
                             -------------------
    begin                : Fri Mar 28 2003
    copyright            : (C) 2003 by Dominik Raddatz
    email                : dom@wtal.de
 ***************************************************************************/

#include "prepare.h"
#include <stdio.h>

unsigned long long turnedPieceArray[24];
int boundingBox[24][3];
int numberOfTurns;

void prepare()
{
  int i;
  initializePC();
  for(i=0; i<12; ++i)
  {
    int bb[3]={BoundingBox[i][0], BoundingBox[i][1], BoundingBox[i][2]};
    createTurns(pieceArray[i], bb);
    registerPositions(i);
  }
  for(i=0; i<60; ++i)
  {
    registerMasks(i);
  }
}

void registerMasks(const int index)
{
  int x, y, z;
  const long long indexMask=1ull<<index;
  long long andMask=indexMask;
  long long equalsMask=0;
  x=index%3;
  y=(index/3)%4;
  z=(index/12)%5;
  if(x>0)equalsMask|=indexMask>>1;
  if(x<2)equalsMask|=indexMask<<1;
  if(y>0)equalsMask|=indexMask>>3;
  if(y<3)equalsMask|=indexMask<<3;
  if(z>0)equalsMask|=indexMask>>12;
  if(z<4)equalsMask|=indexMask<<12;
  andMask|=equalsMask;
  insert(indexMask, andMask, equalsMask);
}

void registerPositions(int index)
{
  bool box[3][4][5], temp[4][4][4];
  int posCount=0;
  if(index!=10)       // hack for piece 11 will be done here, peace 10 later
  {
    for(int i=0; i<numberOfTurns; ++i)
    {
      convert(&turnedPieceArray[i], temp);
      for(int x=0; x<=3-boundingBox[i][0]; ++x)
      {
        for(int y=0; y<=4-boundingBox[i][1]; ++y)
        {
          for(int z=0; z<=(index!=11? 5: 3)-boundingBox[i][2]; ++z)  // Hack: do not use all z Positions
          {
            for(int a=0; a<3; ++a)
            {
              for(int b=0; b<4; ++b)
              {
                for(int c=0; c<5; ++c)
                {
                  box[a][b][c]=0;
                }
              }
            }
            for(int a=0; a<boundingBox[i][0]; ++a)
            {
              for(int b=0; b<boundingBox[i][1]; ++b)
              {
                for(int c=0; c<boundingBox[i][2]; ++c)
                {
                  box[x+a][y+b][z+c]=temp[a][b][c];
                }
              }
            }
            ++posCount;
            insert(box, index);
          }
        }
      }
    }
  }
  else   // hack for asymmetric 3x1x2 piece
  {
    for(int i=0; i<numberOfTurns; ++i)
    {
      if(boundingBox[i][1]!=2)
      {
        convert(&turnedPieceArray[i], temp);
        for(int x=0; x<=3-boundingBox[i][0]; ++x)
        {
          for(int y=0; y<=(boundingBox[i][1]==1? 1: 0); ++y)  // Depth==1=>2 layers
          {
            for(int z=0; z<=5-boundingBox[i][2]; ++z)
            {
              for(int a=0; a<3; ++a)
              {
                for(int b=0; b<4; ++b)
                {
                  for(int c=0; c<5; ++c)
                  {
                    box[a][b][c]=0;
                  }
                }
              }
              for(int a=0; a<boundingBox[i][0]; ++a)
              {
                for(int b=0; b<boundingBox[i][1]; ++b)
                {
                  for(int c=0; c<boundingBox[i][2]; ++c)
                  {
                    box[x+a][y+b][z+c]=temp[a][b][c];
                  }
                }
              }
              ++posCount;
              insert(box, index);
            }
          }
        }
      }
      else  // Problematic cases where boundingBox[i][1]==2
      {
        convert(&turnedPieceArray[i], temp);
        int y=0;
        for(int x=0; x<=3-boundingBox[i][0]; ++x)
        {
          for(int z=0; z<=5-boundingBox[i][2]; ++z)
          {
            for(int a=0; a<3; ++a)
            {
              for(int b=0; b<4; ++b)
              {
                for(int c=0; c<5; ++c)
                {
                  box[a][b][c]=0;
                }
              }
            }
            for(int a=0; a<boundingBox[i][0]; ++a)
            {
              for(int b=0; b<boundingBox[i][1]; ++b)
              {
                for(int c=0; c<boundingBox[i][2]; ++c)
                {
                  box[x+a][y+b][z+c]=temp[a][b][c];
                }
              }
            }
            ++posCount;
            insert(box, index);
          }
        }
        if(boundingBox[i][0]==1)  // First half of problematic cases
        {
          if(temp[0][1][0]==0        // Now the real hacks: the pieces in the middle must not have all orientations
           ||temp[0][1][2]==0)
          {
            y=1;
            for(int x=0; x<=2; ++x)
            {
              for(int z=0; z<=2; ++z)
              {
                for(int a=0; a<3; ++a)
                {
                  for(int b=0; b<4; ++b)
                  {
                    for(int c=0; c<5; ++c)
                    {
                      box[a][b][c]=0;
                    }
                  }
                }
                for(int a=0; a<boundingBox[i][0]; ++a)
                {
                  for(int b=0; b<boundingBox[i][1]; ++b)
                  {
                    for(int c=0; c<boundingBox[i][2]; ++c)
                    {
                      box[x+a][y+b][z+c]=temp[a][b][c];
                    }
                  }
                }
                ++posCount;
                insert(box, index);
              }
            }
          }
        }
        else //boundingBox[i][0]==3 means second half of problematic cases
        {
          if(temp[0][1][0]==0        // Now the 2nd real hack: the pieces in the middle must not have all orientations
           ||temp[2][1][0]==0)
          {
            int x=0;
            y=1;
            for(int z=0; z<5; ++z)
            {
              for(int a=0; a<3; ++a)
              {
                for(int b=0; b<4; ++b)
                {
                  for(int c=0; c<5; ++c)
                  {
                    box[a][b][c]=0;
                  }
                }
              }
              for(int a=0; a<boundingBox[i][0]; ++a)
              {
                for(int b=0; b<boundingBox[i][1]; ++b)
                {
                  for(int c=0; c<boundingBox[i][2]; ++c)
                  {
                    box[x+a][y+b][z+c]=temp[a][b][c];
                  }
                }
              }
              ++posCount;
              insert(box, index);
            }
          }
        }
      }
    }
  }
  printf("Positions: %d\n", posCount);
}

void createTurns(const bool piece[4][4][4], int bb[3])
{
  numberOfTurns=0;
  bool dub;
  unsigned long long currentTurn;
  convert(piece, &currentTurn);
  for(int i=0; i<3; ++i)
  {
    for(int j=0; j<4; ++j)
    {
      turnX(&currentTurn, bb);
      dub=false;
      int k=0;
      while((dub==false)&&(k<numberOfTurns))
      {
        dub=turnedPieceArray[k]==currentTurn;
        ++k;
      }
      if(dub==false)fillNextPlace(&currentTurn, bb);
    }
    turnY(&currentTurn, bb);
    for(int j=0; j<4; ++j)
    {
      turnX(&currentTurn, bb);
      dub=false;
      int k=0;
      while((dub==false)&&(k<numberOfTurns))
      {
        dub=turnedPieceArray[k]==currentTurn;
        ++k;
      }
      if(dub==false)fillNextPlace(&currentTurn, bb);
    }
    turnZ(&currentTurn, bb);  
  }  
  printf("Number of Turns:%d\n", numberOfTurns);
}

void fillNextPlace(unsigned long long *currentTurn, int bb[3])
{
  turnedPieceArray[numberOfTurns]=(*currentTurn);
  boundingBox[numberOfTurns][0]=bb[0];
  boundingBox[numberOfTurns][1]=bb[1];
  boundingBox[numberOfTurns][2]=bb[2];
  ++numberOfTurns;
}

void turnX(unsigned long long *currentTurn, int bb[3])
{
  bool temp1[4][4][4], temp2[4][4][4];
  convert(currentTurn, temp1);
  turnX(temp1, temp2, bb);
  convert(temp2, currentTurn);
  normalize(currentTurn);
}

void turnY(unsigned long long *currentTurn, int bb[3])
{
  bool temp1[4][4][4], temp2[4][4][4];
  convert(currentTurn, temp1);
  turnY(temp1, temp2, bb);
  convert(temp2, currentTurn);
  normalize(currentTurn);
}

void turnZ(unsigned long long *currentTurn, int bb[3])
{
  bool temp1[4][4][4], temp2[4][4][4];
  convert(currentTurn, temp1);
  turnZ(temp1, temp2, bb);
  convert(temp2, currentTurn);
  normalize(currentTurn);
}

void convert(unsigned long long *source, bool target[4][4][4])
{
  for(int i=0; i<64; ++i)
  {
    target[i>>4][(i>>2)%4][i%4]=(*source)&(1ull<<i);
  }
}

void convert(const bool source[4][4][4], unsigned long long *target)
{
  unsigned long long bitPos=1;
  *target=0ull;
  for(int x=0; x<4; ++x)
  {
    for(int y=0; y<4; ++y)
    {
      for(int z=0; z<4; ++z)
      {
        if(source[x][y][z]==1)
        {
          (*target)|=bitPos;
        }
        bitPos<<=1;
      }
    }
  }
}

void turnX(const bool source[4][4][4], bool target[4][4][4], int bb[3])
{
  for(int x=0; x<4; ++x)
  {
    for(int y=0; y<4; ++y)
    {
      for(int z=0; z<4; ++z)
      {
        target[x][3-z][y] = source[x][y][z];
      }
    }
  }
  int temp=bb[1];
  bb[1]=bb[2];
  bb[2]=temp;
}

void turnY(const bool source[4][4][4], bool target[4][4][4], int bb[3])
{
  for(int x=0; x<4; ++x)
  {
    for(int y=0; y<4; ++y)
    {
      for(int z=0; z<4; ++z)
      {
        target[3-z][y][x] = source[x][y][z];
      }
    }
  }
  int temp=bb[0];
  bb[0]=bb[2];
  bb[2]=temp;
}

void turnZ(const bool source[4][4][4], bool target[4][4][4], int bb[3])
{
  for(int x=0; x<4; ++x)
  {
    for(int y=0; y<4; ++y)
    {
      for(int z=0; z<4; ++z)
      {
        target[y][3-x][z] = source[x][y][z];
      }
    }
  }
  int temp=bb[0];
  bb[0]=bb[1];
  bb[1]=temp;
}

void normalize(unsigned long long *rawTurn)
{
  while((0x000000000000ffffull&(*rawTurn))==0)(*rawTurn)>>=16;
  while((0x1111111111111111ull&(*rawTurn))==0)(*rawTurn)>>=1;
  while((0x000f000f000f000full&(*rawTurn))==0)(*rawTurn)>>=4;
}
