/***************************************************************************
                          solve.cpp  -  description
                             -------------------
    begin                : Fri Mar 28 2003
    copyright            : (C) 2003 by Dominik Raddatz
    email                : dom@wtal.de
 ***************************************************************************/

#include "solve.h"
#include <stdio.h>

long long allPieces[56*16*16];        // Array with all pieces sorted
int pieceCount[57*16];
int remainingPiecesList[12]={0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12};  // 11 and 13 are additional space for 10 and 12

int numberOfSolutions=0;

long long andMasks[60];
long long equalsMasks[60];

int solve()
{
  solve12();
  return numberOfSolutions;
}

void permute(const long long *source, long long *target)
{
  *target=0ull;
  for(int i=0; i<60; ++i)
  {
    *target|=(((*source)>>permutation13[i])&1)<<i;
  }
}

void insert(bool box[3][4][5], int pieceIndex)
{
  long long temp, temp2;
  convert(box, &temp2);
  permute(&temp2, &temp);
  int firstBit=findLowestBit(temp);
  if(pieceIndex==11)++pieceIndex;   // Hack for 16-Positions-Alignment; piece10 and piece 11 need mor space than allocated
  allPieces[(firstBit<<8)+(pieceIndex<<4)+pieceCount[(firstBit<<4)+pieceIndex]]=temp;
  ++(*(pieceCount+((firstBit<<4)+pieceIndex)));
}

void insert(const long long &indexMask, const long long &andMask, const long long &equalsMask)
{
  long long temp;
  permute(&indexMask, &temp);
  int index=findLowestBit(temp);
  permute(&andMask, &temp);
  *(andMasks+index)=temp;
  permute(&equalsMask, &temp);
  *(equalsMasks+index)=temp;
}

int findLowestBit(long long piece)
{
  int i=0;
  while(testBit(&piece, i)==false) ++i;
  return i;
}

inline bool testBit(const long long *piece, const int position)
{
  return(((*piece)&(1ull<<position))!=0);
}

void convert(bool source[3][4][5], long long *target)
{
  (*target)=0ull;
  for(int z=0; z<5; ++z)
  {
    for(int y=0; y<4; ++y)
    {
      for(int x=0; x<3; ++x)
      {
        (*target)<<=1;
        (*target)|=(long long)(source[x][y][z]);
      }
    }
  }
}

void initializePC()
{
  for(int i=0; i<57; ++i)
  {
    for(int j=0; j<16; ++j)
    {
      *(pieceCount+((i<<4)+j))=0;
    }
  }
}

void solve12()
{
  int i, j;
  const int *pC=pieceCount;                 // [0][0]
  int pieceNumber=*remainingPiecesList;
  const int last=*(remainingPiecesList+11);
  const long long *aP=allPieces;   // [0][0][0]
  const long long *cP=aP;
  int *rpl=remainingPiecesList;
  *rpl=last;
  for(j=0; j<*pC; ++j)
  {
    solve11(*cP, 0);    // Does only work in first round
    printf("Solutions: %d, ", numberOfSolutions);
    ++cP;
  }
  *rpl++=pieceNumber;
  for(i=1; i<12; ++i)             // Leave out piece 0
  {
    aP+=16;
    cP=aP;
    ++pC;
    pieceNumber=*rpl;
    *rpl=last;
    for(j=0; j<*pC; ++j)
    {
      solve11(*cP, 0);
      printf("Solutions: %d, ", numberOfSolutions);
      ++cP;
    }
    *(rpl++)=pieceNumber;
  }
}

void solve11(const long long puzzle, int fillPosition)
{
  while(((1ull<<(++fillPosition))&puzzle)!=0); // look for first 0 entry
  int i, j;
  int pieceNumber=*remainingPiecesList;
  int lastPiece=*(remainingPiecesList+10);
  int *rpl=remainingPiecesList;
  const int offsetPart=fillPosition<<4;
  const int * const pCfP=pieceCount+offsetPart;       // Compute offset for pieceCount
  const int *pC=pCfP+(*rpl);                   // get number of elements there
  const long long * const aPfP=(allPieces+(offsetPart<<4));   // Compute offset for to be selected pieces
  const long long *currentPiece=aPfP+((*rpl)<<4);
  *rpl=lastPiece;
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve10(puzzle|(*currentPiece), fillPosition);
    }
    ++currentPiece;
  }
  *(rpl++)=pieceNumber;
  for(i=1; i<10; ++i)
  {
    pieceNumber=*rpl;               // Save to be tested pieceNumber
    *rpl=lastPiece;                 // Copy last (important) element to saved position
    pC=pCfP+pieceNumber;            // set pieceCount to next Piece
    currentPiece=aPfP+(pieceNumber<<4);
    for(j=0; j<*pC; ++j)
    {
      if((puzzle&(*currentPiece))==0ull)
      {
        solve10(puzzle|(*currentPiece), fillPosition);
      }
      ++currentPiece;
    }
    *(rpl++)=pieceNumber;
  }
  pC=pCfP+(*rpl);
  currentPiece=aPfP+((*rpl)<<4);
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve10(puzzle|(*currentPiece), fillPosition);
    }
    ++currentPiece;
  }
}

void solve10(const long long puzzle, int fillPosition)
{
  while(((1ull<<(++fillPosition))&puzzle)!=0); // look for first 0 entry
  int i, j;
  const long long *currentPiece=andMasks+fillPosition;
  const long long *em=equalsMasks+fillPosition;
  for(j=fillPosition; j<60; ++j)
  {
    if((puzzle&(*(currentPiece++)))==(*(em++)))    // Check if puzzle contains pattern
    {
      return;
    }
  }
  int pieceNumber=*remainingPiecesList;
  const int lastPiece=*(remainingPiecesList+9);
  int *rpl=remainingPiecesList;
  const int offsetPart=fillPosition<<4;
  const int * const pCfP=pieceCount+offsetPart;       // Compute offset for pieceCount
  const int *pC=pCfP+(*rpl);                   // get number of elements there
  const long long * const aPfP=(allPieces+(offsetPart<<4));   // Compute offset for to be selected pieces
  currentPiece=aPfP+((*rpl)<<4);
  *rpl=lastPiece;
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve9(puzzle|(*currentPiece), fillPosition);
    }
    ++currentPiece;
  }
  *(rpl++)=pieceNumber;
  for(i=1; i<9; ++i)
  {
    pieceNumber=*rpl;               // Save to be tested pieceNumber
    *rpl=lastPiece;                 // Copy last (important) element to saved position
    pC=pCfP+pieceNumber;            // set pieceCount to next Piece
    currentPiece=aPfP+(pieceNumber<<4);
    for(j=0; j<*pC; ++j)
    {
      if((puzzle&(*currentPiece))==0ull)
      {
        solve9(puzzle|(*currentPiece), fillPosition);
      }
      ++currentPiece;
    }
    *(rpl++)=pieceNumber;
  }
  pC=pCfP+(*rpl);
  currentPiece=aPfP+((*rpl)<<4);
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve9(puzzle|(*currentPiece), fillPosition);
    }
    ++currentPiece;
  }
}

void solve9(const long long puzzle, int fillPosition)
{
  while(((1ull<<(++fillPosition))&puzzle)!=0); // look for first 0 entry
  int i, j;
  const long long *currentPiece=andMasks+fillPosition;
  const long long *em=equalsMasks+fillPosition;
  for(j=fillPosition; j<60; ++j)
  {
    if((puzzle&(*(currentPiece++)))==(*(em++)))    // Check if puzzle contains pattern
    {
      return;
    }
  }
  int pieceNumber=*remainingPiecesList;
  const int lastPiece=*(remainingPiecesList+8);
  int *rpl=remainingPiecesList;
  const int offsetPart=fillPosition<<4;
  const int * const pCfP=pieceCount+offsetPart;       // Compute offset for pieceCount
  const int *pC=pCfP+(*rpl);                   // get number of elements there
  const long long * const aPfP=allPieces+(offsetPart<<4);   // Compute offset for to be selected pieces
  currentPiece=aPfP+((*rpl)<<4);
  *rpl=lastPiece;
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve8(puzzle|(*currentPiece), fillPosition);
    }
    ++currentPiece;
  }
  *(rpl++)=pieceNumber;
  for(i=1; i<8; ++i)
  {
    pieceNumber=*rpl;               // Save to be tested pieceNumber
    *rpl=lastPiece;                 // Copy last (important) element to saved position
    pC=pCfP+pieceNumber;            // set pieceCount to next Piece
    currentPiece=aPfP+(pieceNumber<<4);
    for(j=0; j<*pC; ++j)
    {
      if((puzzle&(*currentPiece))==0ull)
      {
        solve8(puzzle|(*currentPiece), fillPosition);
      }
      ++currentPiece;
    }
    *(rpl++)=pieceNumber;
  }
  pC=pCfP+(*rpl);
  currentPiece=aPfP+((*rpl)<<4);
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve8(puzzle|(*currentPiece), fillPosition);
    }
    ++currentPiece;
  }
}

void solve8(const long long puzzle, int fillPosition)
{
  while(((1ull<<(++fillPosition))&puzzle)!=0); // look for first 0 entry
  int i, j;
  const long long *currentPiece=andMasks+fillPosition;
  const long long *em=equalsMasks+fillPosition;
  for(j=fillPosition; j<60; ++j)
  {
    if((puzzle&(*(currentPiece++)))==(*(em++)))    // Check if puzzle contains pattern
    {
      return;
    }
  }
  int pieceNumber=*remainingPiecesList;
  const int lastPiece=*(remainingPiecesList+7);
  int *rpl=remainingPiecesList;
  const int offsetPart=fillPosition<<4;
  const int * const pCfP=pieceCount+offsetPart;       // Compute offset for pieceCount
  const int *pC=pCfP+(*rpl);                   // get number of elements there
  const long long * const aPfP=allPieces+(offsetPart<<4);   // Compute offset for to be selected pieces
  currentPiece=aPfP+((*rpl)<<4);
  *rpl=lastPiece;
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve7(puzzle|(*currentPiece), fillPosition);
    }
    ++currentPiece;
  }
  *(rpl++)=pieceNumber;
  for(i=1; i<7; ++i)
  {
    pieceNumber=*rpl;               // Save to be tested pieceNumber
    *rpl=lastPiece;                 // Copy last (important) element to saved position
    pC=pCfP+pieceNumber;            // set pieceCount to next Piece
    currentPiece=aPfP+(pieceNumber<<4);
    for(j=0; j<*pC; ++j)
    {
      if((puzzle&(*currentPiece))==0ull)
      {
        solve7(puzzle|(*currentPiece), fillPosition);
      }
      ++currentPiece;
    }
    *(rpl++)=pieceNumber;
  }
  pC=pCfP+(*rpl);
  currentPiece=aPfP+((*rpl)<<4);
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve7(puzzle|(*currentPiece), fillPosition);
    }
    ++currentPiece;
  }
}

void solve7(const long long puzzle, int fillPosition)
{
  while(((1ull<<(++fillPosition))&puzzle)!=0); // look for first 0 entry
  int i, j;
  const long long *currentPiece=andMasks+fillPosition;  //currentPiece reused
  const long long *em=equalsMasks+fillPosition;
  for(j=fillPosition; j<60; ++j)
  {
    if((puzzle&(*(currentPiece++)))==(*(em++)))    // Check if puzzle contains pattern
    {
      return;
    }
  }
  int pieceNumber=*remainingPiecesList;
  const int lastPiece=*(remainingPiecesList+6);
  int *rpl=remainingPiecesList;
  const int offsetPart=fillPosition<<4;
  const int * const pCfP=pieceCount+offsetPart;       // Compute offset for pieceCount
  const int *pC=pCfP+(*rpl);                   // get number of elements there
  const long long * const aPfP=allPieces+(offsetPart<<4);   // Compute offset for to be selected pieces
  currentPiece=aPfP+((*rpl)<<4);
  *rpl=lastPiece;
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve6(puzzle|(*currentPiece), fillPosition);
    }
    ++currentPiece;
  }
  *(rpl++)=pieceNumber;
  for(i=1; i<6; ++i)
  {
    pieceNumber=*rpl;               // Save to be tested pieceNumber
    *rpl=lastPiece;                 // Copy last (important) element to saved position
    pC=pCfP+pieceNumber;            // set pieceCount to next Piece
    currentPiece=aPfP+(pieceNumber<<4);
    for(j=0; j<*pC; ++j)
    {
      if((puzzle&(*currentPiece))==0ull)
      {
        solve6(puzzle|(*currentPiece), fillPosition);
      }
      ++currentPiece;
    }
    *(rpl++)=pieceNumber;
  }
  pC=pCfP+(*rpl);
  currentPiece=aPfP+((*rpl)<<4);
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve6(puzzle|(*currentPiece), fillPosition);
    }
    ++currentPiece;
  }
}

void solve6(const long long puzzle, int fillPosition)
{
  while(((1ull<<(++fillPosition))&puzzle)!=0); // look for first 0 entry
  int j;
  const long long *currentPiece=andMasks+fillPosition;
  const long long *em=equalsMasks+fillPosition;
  for(j=fillPosition; j<60; ++j)
  {
    if((puzzle&(*(currentPiece++)))==(*(em++)))    // Check if puzzle contains pattern
    {
      return;
    }
  }
  int *p234=remainingPiecesList;
  int pieceNumber=*(p234++);
  const int last=*(p234+4);
  const int offsetPart=fillPosition<<4;
  const int * const pCfP=pieceCount+offsetPart;       // Compute offset for pieceCount
  const int *pC=pCfP+pieceNumber;                   // get number of elements there
  const long long * const aPfP=(allPieces+(offsetPart<<4));   // Compute offset for to be selected pieces
  currentPiece=aPfP+(pieceNumber<<4);
  *remainingPiecesList=last;    // Replace 1st element
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve5(puzzle|(*currentPiece), fillPosition);
    }
    ++currentPiece;
  }
  *remainingPiecesList=pieceNumber;
  pieceNumber=*p234;
  *p234=last;        // Replace 2nd element
  pC=pCfP+pieceNumber;            // set pieceCount to next Piece
  currentPiece=aPfP+(pieceNumber<<4);
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve5(puzzle|(*currentPiece), fillPosition);
    }
    ++currentPiece;
  }
  *p234=pieceNumber;
  pieceNumber=*(++p234);
  *p234=last;              // Replace 3rd element
  pC=pCfP+pieceNumber;            // set pieceCount to next Piece
  currentPiece=aPfP+(pieceNumber<<4);
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve5(puzzle|(*currentPiece), fillPosition);
    }
    ++currentPiece;
  }
  *p234=pieceNumber;
  pieceNumber=*(++p234);
  *p234=last;
  pC=pCfP+pieceNumber;            // set pieceCount to next Piece
  currentPiece=aPfP+(pieceNumber<<4);
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve5(puzzle|(*currentPiece), fillPosition);
    }
    ++currentPiece;
  }
  *p234=pieceNumber;
  pieceNumber=*(++p234);
  *p234=last;
  pC=pCfP+pieceNumber;            // set pieceCount to next Piece
  currentPiece=aPfP+(pieceNumber<<4);
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve5(puzzle|(*currentPiece), fillPosition);
    }
    ++currentPiece;
  }
  *p234=pieceNumber;
  pC=pCfP+last;            // set pieceCount to next Piece
  currentPiece=aPfP+(last<<4);         // evtl tunable here
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve5(puzzle|(*currentPiece), fillPosition);
    }
    ++currentPiece;
  }
}

void solve5(const long long puzzle, int fillPosition)
{
  while(((1ull<<(++fillPosition))&puzzle)!=0); // look for first 0 entry
  int j;
  int *p234=remainingPiecesList;
  int pieceNumber=*(p234++);
  const int last=*(p234+3);
  const int offsetPart=(fillPosition<<4);
  const int * const pCfP=pieceCount+offsetPart;       // Compute offset for pieceCount
  const int *pC=pCfP+pieceNumber;                   // get number of elements there
  const long long * const aPfP=(allPieces+(offsetPart<<4));   // Compute offset for to be selected pieces
  const long long *currentPiece=aPfP+(pieceNumber<<4);
  *remainingPiecesList=last;    // Replace 1st element
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve4(puzzle|(*currentPiece), fillPosition);
    }
    ++currentPiece;
  }
  *remainingPiecesList=pieceNumber;
  pieceNumber=*p234;
  *p234=last;        // Replace 2nd element
  pC=pCfP+pieceNumber;            // set pieceCount to next Piece
  currentPiece=aPfP+(pieceNumber<<4);
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve4(puzzle|(*currentPiece), fillPosition);
    }
    ++currentPiece;
  }
  *p234=pieceNumber;
  pieceNumber=*(++p234);
  *p234=last;              // Replace 3rd element
  pC=pCfP+pieceNumber;            // set pieceCount to next Piece
  currentPiece=aPfP+(pieceNumber<<4);
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve4(puzzle|(*currentPiece), fillPosition);
    }
    ++currentPiece;
  }
  *p234=pieceNumber;
  pieceNumber=*(++p234);
  *p234=last;
  pC=pCfP+pieceNumber;            // set pieceCount to next Piece
  currentPiece=aPfP+(pieceNumber<<4);
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve4(puzzle|(*currentPiece), fillPosition);
    }
    ++currentPiece;
  }
  *p234=pieceNumber;
  pC=pCfP+last;            // set pieceCount to next Piece
  currentPiece=aPfP+(last<<4);         // evtl tunable here
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve4(puzzle|(*currentPiece), fillPosition);
    }
    ++currentPiece;
  }
}

void solve4(const long long puzzle, int fillPosition)
{
  while(((1ull<<(++fillPosition))&puzzle)!=0); // look for first 0 entry
  int j_4;
  int *p23_4=remainingPiecesList;
  int pieceNumber_4=*(p23_4++);
  const int last_4=*(p23_4+2);
  const int offsetPart_4=fillPosition<<4;
  const int * const pCfP_4=pieceCount+offsetPart_4;       // Compute offset for pieceCount
  const int *pC_4=pCfP_4+pieceNumber_4;                   // get number of elements there
  const long long * const aPfP_4=(allPieces+(offsetPart_4<<4));   // Compute offset for to be selected pieces
  const long long *currentPiece_4=aPfP_4+(pieceNumber_4<<4);
  *remainingPiecesList=last_4;    // Replace 1st element
  for(j_4=0; j_4<*pC_4; ++j_4)
  {
    if((puzzle&(*currentPiece_4))==0ull)    // Use first Piece, call solve3 with pieces 2 and 3
    {
      solve3(puzzle|(*currentPiece_4), fillPosition);
    }
    ++currentPiece_4;
  }
  *remainingPiecesList=pieceNumber_4;
  pieceNumber_4=*p23_4;
  *p23_4=last_4;        // Replace 2nd element
  pC_4=pCfP_4+pieceNumber_4;            // set pieceCount to next Piece
  currentPiece_4=aPfP_4+(pieceNumber_4<<4);
  for(j_4=0; j_4<*pC_4; ++j_4)
  {
    if((puzzle&(*currentPiece_4))==0ull)
    {
      solve3(puzzle|(*currentPiece_4), fillPosition);
    }
    ++currentPiece_4;
  }
  *p23_4=pieceNumber_4;
  pieceNumber_4=*(++p23_4);
  *p23_4=last_4;              // Replace 3rd element
  pC_4=pCfP_4+pieceNumber_4;            // set pieceCount to next Piece
  currentPiece_4=aPfP_4+(pieceNumber_4<<4);
  for(j_4=0; j_4<*pC_4; ++j_4)
  {
    if((puzzle&(*currentPiece_4))==0ull)    // Use first Piece, call solve2 with pieces 2 and 3
    {
      solve3(puzzle|(*currentPiece_4), fillPosition);
    }
    ++currentPiece_4;
  }
  *p23_4=pieceNumber_4;
  pC_4=pCfP_4+last_4;            // set pieceCount to next Piece
  currentPiece_4=aPfP_4+(last_4<<4);         // evtl tunable here
  for(j_4=0; j_4<*pC_4; ++j_4)
  {
    if((puzzle&(*currentPiece_4))==0ull)
    {
      solve3(puzzle|(*currentPiece_4), fillPosition);
    }
    ++currentPiece_4;
  }
}

void solve3(const long long puzzle, int fillPosition)
{
  while(((1ull<<(++fillPosition))&puzzle)!=0); // look for first 0 entry
  int *p2=remainingPiecesList;
  int pieceNumber=*(p2++);
  const int last=*(p2+1);
  const int offsetPart=fillPosition<<4;
  const int * const pCfP=pieceCount+offsetPart;       // Compute offset for pieceCount
  const int *pC=pCfP+pieceNumber;                   // get number of elements there
  const long long * const aPfP=(allPieces+(offsetPart<<4));   // Compute offset for to be selected pieces
  const long long *currentPiece=aPfP+(pieceNumber<<4);
  int j;
  *remainingPiecesList=last;
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)    // Use first Piece, call solve2 with pieces 2 and 3
    {
      solve2(puzzle|(*currentPiece), fillPosition);
    }
    ++currentPiece;
  }
  *remainingPiecesList=pieceNumber;
  pieceNumber=*p2;
  *p2=last;
  pC=pCfP+pieceNumber;            // set pieceCount to next Piece
  currentPiece=aPfP+(pieceNumber<<4);
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve2(puzzle|(*currentPiece), fillPosition);
    }
    ++currentPiece;
  }
  *p2=pieceNumber;
  pC=pCfP+last;            // set pieceCount to next Piece
  currentPiece=aPfP+(last<<4);
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      solve2(puzzle|(*currentPiece), fillPosition);
    }
    ++currentPiece;
  }
}

void solve2(const long long puzzle, int fillPosition)
{
  while(((1ull<<(++fillPosition))&puzzle)!=0); // look for first 0 entry
  int j;
  const int pieceNumber=*remainingPiecesList;
  const int last=*(remainingPiecesList+1);
  const int offsetPart=fillPosition<<4;
  const int * const pCfP=pieceCount+offsetPart;       // Compute offset for pieceCount
  const int *pC=pCfP+pieceNumber;                   // get number of elements there
  const long long * const aPfP=(allPieces+(offsetPart<<4));   // Compute offset for to be selected pieces
  const long long *currentPiece=aPfP+((pieceNumber)<<4);
  *remainingPiecesList=last;
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)    // Use first Piece, call solve2 with pieces 2 and 3
    {
      solve1(puzzle|(*currentPiece), fillPosition);
    }
    ++currentPiece;
  }
  *remainingPiecesList=pieceNumber;
  pC=pCfP+last;
  currentPiece=aPfP+(last<<4);
  for(j=0; j<*pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)    // Use first Piece, call solve2 with pieces 2 and 3
    {
      solve1(puzzle|(*currentPiece), fillPosition);
    }
    ++currentPiece;
  }
}

void solve1(const long long puzzle, int fillPosition)
{
  while(((1ull<<(++fillPosition))&puzzle)!=0);
  const int offsetPart=(fillPosition<<4)+(*remainingPiecesList);
  const int pC=*(pieceCount+offsetPart);       // Compute offset for pieceCount
  const long long *currentPiece=allPieces+(offsetPart<<4);
  for(int j=0; j<pC; ++j)
  {
    if((puzzle&(*currentPiece))==0ull)
    {
      ++numberOfSolutions;
      return;
    }
    ++currentPiece;
  }
}
