/* ctpz.cc -- C't journal 2003/3/24 puzzle, multithreading.
**
** Copyright (C) 2003 Eric Laroche.  All rights reserved.
**
** @author Eric Laroche <laroche@lrdev.com>
** @version @(#)$Id: ctpzmt.cc,v 1.1 2003/04/30 21:34:12 laroche Exp $
** @url http://www.lrdev.com/lr/c/ctpz.html
**
** This program is free software;
** you can redistribute it and/or modify it.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
*/


// implemented interface
#include "ctpzmt.hh"


#ifdef WIN32
#include <process.h>
#include <windows.h>
#endif


#ifdef WIN32

// the single semaphore
static HANDLE semaphore = 0;

// the single lock
static CRITICAL_SECTION lock;

#endif


static void init()
{
	// init() is called the first time while being single-threaded,
	// so we do not need to synchronize this
	static bool initialized = false;
	if (initialized) {
		return;
	}

	initialized = true;

#ifdef WIN32

	InitializeCriticalSection(&lock);

#endif

}


int Thread::startThread(int (*what)(void* data), void* data)
{
	init();

#ifdef WIN32

	static int const stackSize = 1 << 16;
	int threadId = -1;

	return (int)_beginthreadex(
		0, // security, use default/inherited
		(unsigned int)stackSize,
		(unsigned int (__stdcall*)(void*))what,
		data,
		0, // init flags
		(unsigned int*)&threadId);

#else

	return 0;

#endif

}


void Thread::waitForThread(int threadId)
{
	init();

#ifdef WIN32

	WaitForSingleObject((HANDLE)threadId, INFINITE);

#endif

}


void Semaphore::setCount(int count)
{
	init();

#ifdef WIN32

	//assert(semaphore == 0);

	semaphore = CreateSemaphore(0, count, count, "ctpzthreads");

#endif

}


Semaphore::Semaphore()
{
	init();

#ifdef WIN32

	//assert(semaphore != 0);

	WaitForSingleObject(semaphore, INFINITE);

#endif

}


Semaphore::~Semaphore()
{

#ifdef WIN32

	//assert(semaphore != 0);

	long int old;
	ReleaseSemaphore(semaphore, 1, &old);

#endif

}


Lock::Lock()
{
	init();

#ifdef WIN32

	EnterCriticalSection(&lock);

#endif

}


Lock::~Lock()
{

#ifdef WIN32

	LeaveCriticalSection(&lock);

#endif

}

