/* ctpz.hh -- C't journal 2003/3/24 puzzle, multithreading.
**
** Copyright (C) 2003 Eric Laroche.  All rights reserved.
**
** @author Eric Laroche <laroche@lrdev.com>
** @version @(#)$Id: ctpzmt.hh,v 1.1 2003/04/30 21:35:04 laroche Exp $
** @url http://www.lrdev.com/lr/c/ctpz.html
**
** This program is free software;
** you can redistribute it and/or modify it.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
*/


#ifndef CTPZMT_HH
#define CTPZMT_HH


/** Thread functions.  [stateless]
*/
class Thread
{

public :

	static int startThread(int (*what)(void* data), void* data);

	static void waitForThread(int threadId);

};


/** Threading synchronizing semaphore.  This is a singleton, i.e. there
* is one semaphore available only, which is sufficient for our problem
* domain.  The interface is similar to that of a typical mutex lock
* interface.
*/
class Semaphore
{

public :

	static void setCount(int count);

	Semaphore();

	~Semaphore();

};


/** Threading synchronizing lock.  This is a singleton, i.e. there is
* one lock available only, which is sufficient for our problem domain.
*/
class Lock
{

public :

	/** Acquire a lock that releases upon destruction.
	*/
	Lock();

	~Lock();

};


#endif

