/* ctpz.hh -- C't journal 2003/3/24 puzzle, tiling (packing).
**
** Copyright (C) 2003 Eric Laroche.  All rights reserved.
**
** @author Eric Laroche <laroche@lrdev.com>
** @version @(#)$Id: ctpzt.hh,v 1.1 2003/04/30 21:35:04 laroche Exp $
** @url http://www.lrdev.com/lr/c/ctpz.html
**
** @reference c't 7/2003, p. 234 [c't puzzle]
** @reference http://www.lrdev.com/lr/c/sqfig.html [pentomino tilings]
**
** This program is free software;
** you can redistribute it and/or modify it.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
*/


#ifndef CTPZT_HH
#define CTPZT_HH


// type declarations
class Figure;
class ostream;


/** Figure tiling.  This tiling engine is implemented quite specifically
* for the 12 figures / 3*4*5 packing problem.  [stateless]
*/
class Tile
{

public :

	/** Count the puzzle solutions.
	*/
	static int count(Figure const* const* const* figures, ostream* status = 0);

	/** Count the puzzle solutions, multithreading version.
	*/
	static int countMt(
		Figure const* const* const* figures,
		int threads = -1,
		ostream* status = 0);

	/** Generate the puzzle solutions and call a call-back function for
	* each solution.
	*/
	static void generateSolutions(
		Figure const* const* const* figures,
		void (*callback)(Figure** figures, void* data),
		void* data);

};

#endif

