/* ctpzut.hh -- C't journal 2003/3/24 puzzle, utilities.
**
** Copyright (C) 2003 Eric Laroche.  All rights reserved.
**
** @author Eric Laroche <laroche@lrdev.com>
** @version @(#)$Id: ctpzut.hh,v 1.1 2003/04/30 21:35:04 laroche Exp $
** @url http://www.lrdev.com/lr/c/ctpz.html
**
** This program is free software;
** you can redistribute it and/or modify it.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
*/


#ifndef CTPZUT_HH
#define CTPZUT_HH


/** Range on a C string.  Owner must make sure string doesn't run out of
* scope while referenced / in use here.  Data members are public to
* allow direct operations (to make the API leaner; diminuishes
* encapsulation).
*/
class StringRange
{

public :

	/** A range including 'begin' and excluding 'end'.
	*/
	StringRange(char const* s, int begin, int end);

	/** The whole C string range.
	*/
	StringRange(char const* s);

	StringRange(StringRange const& that);

	StringRange& operator=(StringRange const& that);

	/** Note: owner makes sure this string doesn't run out of scope
	* while referenced / in use here.
	*/
	char const* m_s;

	/** Inclusive begin.
	*/
	int m_begin;

	/** Exclusive end.
	*/
	int m_end;

private :

	// common initializer
	void init(char const* s, int begin, int end);
};


/** Utility to parse sets in the form "{a, b, c}".
*/
class SetParser
{

public :

	SetParser(StringRange const& sr);

	/** [decorator method]
	*/
	SetParser(char const* s);

	/** Get set size.
	*/
	int count() const;

	/** Enumerate the set.
	*/
	void enumerate(
		void (*callback)(StringRange const& sr, void* userData),
		void* userData
	) const;

private :

	// common initializer
	void init(StringRange const& sr);

	// range is excluding leading and trailing blanks and opening and
	// closing braces;  m_sr(0, 0, 0) means unset/invalid
	StringRange m_sr;
};


#endif

