/* ctpzvr.hh -- C't journal 2003/3/24 puzzle, virtual reality modeling.
**
** Copyright (C) 1998,2003 Eric Laroche.  All rights reserved.
**
** @author Eric Laroche <laroche@lrdev.com>
** @version @(#)$Id: ctpzvr.hh,v 1.1 2003/04/30 21:35:04 laroche Exp $
** @url http://www.lrdev.com/lr/c/ctpz.html
**
** @reference http://www.lrdev.com/lr/math/glass.html [vrml glass]
**
** This program is free software;
** you can redistribute it and/or modify it.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
*/


#ifndef CTPZVR_HH
#define CTPZVR_HH


// type declarations
class Figure;
class ostream;


/** VRML 1.0 representation of Figure lists.  [stateless]
*/
class VrmlPrinter
{

public :

	/** Output a VRML representation of a list of figures.
	*/
	static void print(ostream& out, Figure const* const* figures);

	/** Output a VRML representation of a list of figures, figures
	* separated.  E.g. used to display input set of figures.
	*/
	static void printSeparated(ostream& out, Figure const* const* figures);
};


#endif

