from constants import *
from pprint import pprint
import partreader


class TurnC:
   def __init__(self):
      self.tripelSet=self.gen_turns(self.basis_turn)
      self.sym_stuff(self.tripelSet)

   def basis_turn(self,tripel,axis):
      new_tripel=list(tripel)
      if axis == 0:
         new_tripel[1], new_tripel[2] = tripel[2], -tripel[1]
      elif axis == 1:
         new_tripel[0], new_tripel[2] = tripel[2], -tripel[0]
      elif axis == 2:
         new_tripel[0], new_tripel[1] = tripel[1], -tripel[0]
      return (new_tripel[0],new_tripel[1],new_tripel[2])


   def turn180(self,tripel,axis):
      new_tripel = self.basis_turn(tripel,axis)
      new_tripel = self.basis_turn(new_tripel,axis)
      return new_tripel

   def gen_turns(self, func=basis_turn):   
      tripel=(1,2,3)
      tripelD={tripel:""}

      while 1:
         anz = len(tripelD.keys())
         for tripel in tripelD.keys():
            for axis in range(len(tripel)):
               for i in range(3):
                  #new_tripel = self.basis_turn(tripel,axis)
                  new_tripel = func(tripel,axis)
                  tripelD[new_tripel]=""
         tripelSet=tripelD.keys()
         if anz == len(tripelSet):
            break
      return tripelSet
      #print "tripelSet" ,tripelSet


   def f(self, tripel, posL):
      ret = [7,7,7]
      for i in range(3):
         v=tripel[i]
         #print tripel,v
         if v > 0:
            ret[i] = posL[v-1]
         else:
            ret[i] = -posL[-v-1]
      return ret       
   
   def apply_turns(self,tripelSet,posLL):
      turnLLL=[]
      #print "tripelSet", tripelSet
      for tripel in tripelSet:
         turnLL = [self.f(tripel,posL) for posL in posLL]
         #print "turnLL",turnLL
         turnLLL.append(turnLL)
      return turnLLL

   def sym_stuff(self,tripelSet):
      idL=[[1,2,3]]
      LL = self.apply_turns(tripelSet,idL)
      #i=LL.index(idL)
      #LL.pop(i)
      #LL=[idL] + LL #identitt an den Anfang
      #print len(LL),LL

      table_range = range(len(LL))
      for i in table_range:
         g=LL[i][0]
         for j in table_range:
            h=LL[j][0]
            gh=self.f(g,h)
            ij = LL.index([gh])
      
      tripelSet180 = self.gen_turns(self.turn180)
      LL180 = self.apply_turns(tripelSet180, [(1,2,3)])
      coset={}
      for g in LL:
          gLL180=[tuple(self.f(g[0],u[0])) for u in LL180]
          gLL180.sort()
          coset[tuple(gLL180)]=""
      self.rep_sys180=[list(k[0]) for k in coset]

      #for k in coset:
      #   print k                
      #print self.rep_sys180
class MoveC:
   def __init__(self):            
      self.turn = TurnC()

   def max(self,axis,posL):
      return max([L[axis] for L in posL])
   
   def min(self,axis,posL):
      return min([L[axis] for L in posL])
                         
   def moveToWall(self,axis,value,side,posL):
      if side == '<':
         delta = value - self.max(axis, posL)
      elif side == '>':
         delta = value - self.min(axis, posL)
      for i in range(len(posL)):
         posL[i][axis] = posL[i][axis] + delta
   
   def normalize(self, posL):
      for axis in range(3):
         min_axis = self.min(axis, posL)
         for j in range(len(posL)):
            posL[j][axis] -= min_axis
      posL.sort()
   
   def genNormSet(self, bWithTurns):
      if bWithTurns:
         self.posLL = self.turn.apply_turns(self.turn.tripelSet,self.posL)                
      else:
         self.posLL = self.turn.apply_turns(self.turn.rep_sys180,self.posL) 

      normposLL = []
      for posL in self.posLL:
          #print 'v', posL
          self.normalize(posL)
          #print 'n', posL
          if posL not in normposLL: 
             normposLL.append(posL)
      return normposLL 
      

   def genpos(self, posL, boxranges, bWithTurns):
      self.posL = posL
      self.genposLL=[]  
      normposLL = self.genNormSet(bWithTurns)
      for normposL in normposLL:       
         deltaT = [boxranges[axis] - self.max(axis,normposL) for axis in range(3)]                            
         #print deltaT,"normposL",normposL 
         for x in range(deltaT[0]):
            for y in range(deltaT[1]):
                for z in range(deltaT[2]):
                   genposL=[[pos[0]+x, pos[1]+y, pos[2]+z] for pos in normposL]
                   if genposL not in self.genposLL:
                      self.genposLL.append(genposL)
                      #print '+%d,+%d,+%d' % (x,y,z),genposL
      return self.genposLL
      
#unittest
if __name__ == "__main__":
   if 0:
      turn=TurnC()
   elif 1:
      turn=TurnC()
      tripelSet = turn.gen_turns(turn.basis_turn)
      idL=[[1,2,3]]
      
      #idL nach vorne verschieben, wird 0 in  Gruppentafel 
      LL = turn.apply_turns(tripelSet, idL)
      i=LL.index(idL)
      LL.pop(i)
      LL=[idL] + LL
      
      print "Zuordnung hier etwas anders als im Programm interpretiert als Drehungen eines Spielwrfes"
      table_size  = len(LL)
      table_range = range(len(LL))
      for i in table_range:
         print "%2d : %s -> %s"%(i, tuple(idL[0]), tuple([(k+7)%7 for k in LL[i][0]]) )

      print "\nGruppentafel"
      table=[]
      for i in table_range:
         table.append([])
         g=LL[i][0]
         for j in table_range:
            h=LL[j][0]
            gh=turn.f(g,h)
            ij = LL.index([gh])
            table[i].append(ij)
     
      for i in table_range:
         for j in table_range:
            print "%3d" % table[i][j],
         print
      
      
      
      tripelSet180 = turn.gen_turns(turn.turn180)
      LL180 = turn.apply_turns(tripelSet180, idL)
      
      t180=[LL.index(g) for g in LL180]
      t180.sort()
      #print t180

      coset={}
      for i in table_range:
         i_t180=[table[i][j] for j in t180]
         i_t180.sort()
         coset[tuple(i_t180)]=""

      for k in coset:
         print k,
         if 0 in k:
            print "Symmetrie-Untergruppe"
         else:
            print "Nebenklasse"
            
      r=[k[0] for k in coset]
      print "\n Reprsentanten"
      print r

   else:
      r = partreader.PartReaderC(partlist)   
      allpartL= r.partlist()  
      boxranges = r.getSize()

      print "%d parts found:" % r.getPartCount()
      print 'boxranges', boxranges
      print 'parts',
      pprint(allpartL)
      allpartCL =[]
      move=MoveC()
      for i in range(len(allpartL)):
         LL = move.genpos(allpartL[i], boxranges,true)
         print "ergo"
         for L in LL:
            print L

