from constants import *
import copy

bitvector= [1L << i for i in range(60)]

class BitVectorC:
   def __init__(self, dim):
      assert dim  <= len(bitvector)
      self.dim=dim      
      self.b=0

   def append(self,el):
      assert el in range(self.dim) , "%d-%d"%(el, self.dim)
      self.b |= bitvector[el]   
      
   def subtract(self,el):
      assert el in range(self.dim) , "%d-%d"%(el, self.dim)
      self.b &= ~bitvector[el]

   def extend(self,L):
      assert 0<=min(L)
      assert max(L)<=self.dim
      for el in L:
         self.b |= bitvector[el]

   def intersect(self,other):
      self.b &= other.b

   def is_element(self,el):
      assert el in range(self.dim)
      return (self.b & bitvector[el]) >0
         
   def is_subset(self,L):
      assert 0<=min(L)
      assert max(L) <= self.dim
      for el in L:
         if self.b & bitvector[el] ==0:
            return false
      return true

   
   def make_complement(self):
      self.b = ~self.b

   def complement(self):
      return ~self.b


   def first(self):
      b = self.b
      for el in range(self.dim):
         if b & bitvector[el]:
            return el
      return -1
                              
   def to_list(self):
      L=[]
      b = self.b
      
      for i in range(self.dim):
         if b==0:
           break
         if b & 1:
            L.append(i)
         b = b >> 1 
      return L

   def clone(self):
      return copy.copy(self)

def to_list(b,dim=100):
   L=[]
   i = 0
   for i in range(dim):
     if b == 0:
        break;     
     if b & 1:
        L.append(i)
     b = b >> 1
     i += 1
     if i==1000:
        break
   return L

def disjoint(bv1,bv2):
   return bv1.b & bv2.b == 0

if __name__ == '__main__':
   set0 = BitVectorC(dim=10)
   print to_list(~0,dim=10)
   
   set1 = BitVectorC(dim=10)
   set1.extend((7,8))
   set1.append(9)
   print set1.to_list()
   set1.subtract(5)
   set1.subtract(9)
   print set1.to_list()
   set1.append(9)
   
   set2 = BitVectorC(dim=10)
   set2.extend((1,))
   print "disjoint(789,1)", disjoint(set1,set2)
   set2.extend((8,))
   print "disjoint(789,18)", disjoint(set1,set2)

   test = (5,6)      
   print "subset:  ", test,"->", set1.is_subset(test)

   test = (6,7)
   print "subset:  ", test,"->", set1.is_subset(test)

   test = (8,9)
   print "subset:  ", test,"->", set1.is_subset(test)
   
   for el in (6,7):
      print "element:",el,set1.is_element(el)
   

   clone=set1.clone()
   print "clone complement"
   clone.make_complement()
   print clone.to_list()
   print "original"
   print set1.to_list()

   print "intersect 2,4,6,8"
   other = BitVectorC(dim=20)
   other.extend((2,4,6,8,10,12,14,16,18))
   set1.intersect(other)
   print set1.to_list()
   print "x",to_list(set1.b)
   print set1.first()
   set1.make_complement()
   print set1.to_list()
   print set1.b
   #print "x",to_list(set1.b)


