//
//  BruteForceSolver.java
//  Cube
//
//  Created by Gunter Blache on Sat Apr 12 2003.
//  Copyright (c) 2003 __MyCompanyName__. All rights reserved.
//

import java.util.Vector;

import java.io.*;

public class BruteForceSolver implements CubeSolver {
    private Part p[][];
    private int t[][][];
    private int partlength,partlength1;

    private class SortPart implements Comparable {
        private int index,size,transformations;
        public SortPart(int i,int s,int t) {
            index=i;
            size=s;
            transformations=t;
        }
        
        public int getIndex() {return index;}
        public void setIndex(int i) {index=i;}
        
        public int getSize() {return size;}
        
        public int compareTo(Object o) {
            SortPart p = (SortPart)o;
            int c=transformations-p.transformations;
            if (c!=0) return c;
            return p.size-size;
        }
    }
    
    static private final boolean GLOBAL_MIN_RR = true;
    
    private void print(Part p[],String filename) {
        try {
            FileWriter f = new FileWriter(filename);
            PrintWriter pw = new PrintWriter(f);
            pw.print((new Cube(p)).povRay());
            pw.flush();
            f.close();
        } catch (IOException e) {
            System.out.println(e);
        }
    }
    
    private Part[] remove(Part p[],Part unmoveable[]) {
        Vector v = new Vector(p.length);
        for (int i=0;i<p.length;i++) {
            boolean collision=false;
            int pp[]=p[i].getPacked();
            for (int j=0;j<unmoveable.length;j++) {
                int up[]=unmoveable[j].getPacked();
                for (int k=0;k<up.length;k++) collision|=(pp[k] & up[k]) !=0;
            }
            if (!collision) v.add(p[i]);
        }
        Part r[] = new Part[v.size()];
        v.copyInto(r);
        return r;
    }
    
    public BruteForceSolver(Part parts[]) {
        this(parts,new Part[0]);
    }
    
    public BruteForceSolver(Part parts[],Part unmoveable[]) {
        if (parts.length<2) throw new IllegalArgumentException("At least two parts needed");
        long start = System.currentTimeMillis();
        p=new Part[parts.length][];
        Part r[][]=new Part[parts.length][];
        t=new int[parts.length][][];
        int partsizeX=parts[0].getSizeX();
        int partsizeY=parts[0].getSizeY();
        int partsizeZ=parts[0].getSizeZ();
        for (int i=0;i<unmoveable.length;i++) {
            if ((partsizeX!=unmoveable[i].getSizeX()) || (partsizeY!=unmoveable[i].getSizeY()) ||
                (partsizeZ!=unmoveable[i].getSizeZ()))
                throw new IllegalArgumentException("All parts must have the same size");
        }
        int minr=0,minp=0,minri=0,mins=0;
        for (int i=0;i<p.length;i++) {
            if ((partsizeX!=parts[i].getSizeX()) || (partsizeY!=parts[i].getSizeY()) || (partsizeZ!=parts[i].getSizeZ()))
                throw new IllegalArgumentException("All parts must have the same size");
            p[i]=remove(parts[i].transformedParts(),unmoveable);
            r[i]=parts[i].transformedUnrotatedParts(p[i]);
            System.out.println("Part "+i+" has "+p[i].length+"/"+r[i].length+" transformations\n");
            print(p[i],"Part"+i+".txt");
            int s=parts[i].size();
            if (i==0) {
                minp=p[i].length;minr=r[i].length;minri=i;mins=s;
            } else if ((r[i].length*minp<minr*p[i].length) || ((r[i].length*minp==minr*p[i].length) && (s>mins))) {
                minp=p[i].length;minr=r[i].length;minri=i;mins=s;
            }
        }
        p[minri]=r[minri];
        sortParts();
        for (int i=0;i<p.length;i++) {
            t[i]=new int[p[i].length][];
            for (int j=0;j<p[i].length;j++) t[i][j]=p[i][j].getPacked();
        }
        partlength=t[0][0].length;
        partlength1=partlength-1;

        System.out.println("Final results:");
        for (int i=0;i<p.length;i++)
            System.out.println("Part "+i+" has "+p[i].length+" transformations\n");
        System.out.println("Duration of initialisation : "+(System.currentTimeMillis()-start)+" ms \n");
    }
    
    private void sortParts() {
        SortPart sp[] = new SortPart[p.length];
        for (int i=0;i<p.length;i++) {
            int s=p[i][0].size();
            sp[i]=new SortPart(i,s,p[i].length);
        }
        java.util.Arrays.sort(sp);
        Part p2[][] = new Part[p.length][];
        for (int i=0;i<p.length;i++) {
            p2[i]=p[sp[i].getIndex()];
        }
        p=p2;
    }

    private Part config[];
    private Vector solutions;
    private int total_solutions;
    private int cube[][];
    private long startTime;
    private long steps;
    
    private void solve(int i) {
        steps++;
        if (i>=t.length) {
//            System.out.println("Solved");
            solutions.add(new Cube(config));
            total_solutions++;
            return;
        }
        int cubei[] = cube[i];
        int cubei1[] = cube[i+1];
        int ti[][] = t[i];
        Part pi[] = p[i];
        int part[];
        int k;
        for (int j=ti.length-1;j>=0;j--) {
            part=ti[j];
            for (k=partlength1;((k>=0) && ((cubei[k] & part[k])==0));k--);
            if (k<0) {
                config[i]=pi[j];
                for (k=partlength1;k>=0;k--) cubei1[k] = cubei[k] | part[k];
                solve(i+1);
            }
        }
    }

    private void solve1(int i) {
        int cubei[] = cube[i];
        int cubei1[] = cube[i+1];
        int ti[][] = t[i];
        Part pi[] = p[i];
        int part[];
        int k;
        for (int j=ti.length-1;j>=0;j--) {
            System.out.print("Part 1 transformation "+(ti.length-j)+" / "+t[i].length+"\n");
            part=ti[j];
            for (k=partlength1;((k>=0) && ((cubei[k] & part[k])==0));k--);
            if (k<0) {
                config[i]=pi[j];
                for (k=partlength1;k>=0;k--) cubei1[k] = cubei[k] | part[k];
                solve(i+1);
            }
            System.out.println("Estimation for remaining duration : "+
                ((System.currentTimeMillis()-startTime)*j/((ti.length-j)*1000))+" seconds");
        }
    }

    public synchronized Cube[] solve() {
        startTime = System.currentTimeMillis();
        solutions=new Vector();
        config=new Part[t.length];
        total_solutions=0;
        cube = new int[t.length+1][partlength];
        steps=0;
        solve1(0);
        Cube s[] = new Cube[solutions.size()];
        solutions.copyInto(s);
        solutions=null;
        config=null;
        System.out.println("Steps : "+steps);
        System.out.println("Solution :"+total_solutions);
        System.out.println("Duration for solving : "+(System.currentTimeMillis()-startTime)+" ms \n");
        return s;
    }
    
    public void generateSolverClass(java.io.PrintWriter p) {
        p.println("final public class SolveCube {");
        p.println();
        for (int i=0;i<t.length;i++) {
            p.println("\tprivate static final int t_"+i+"[][] = {// Part "+i);
            for (int j=0;j<t[i].length;j++) {
                p.print("\t\t{");
                for (int k=0;k<t[i][j].length;k++) {
                    p.print(t[i][j][k]+(k<t[i][j].length-1?",":""));
                }
                p.println("\t\t\t}"+(j<t[i].length-1?",":"")+" // Transformation "+j);
            }
            p.println("\t\t}; // Part "+i);
        }
        p.println();
        for (int i=0;i<t.length;i++) {
            for (int j=0;j<partlength;j++)
                p.println("\tstatic private int cube_"+i+"_"+j+";");
        }
        p.println();
        p.println("\tstatic private int total_solutions;");
        p.println();
        for (int i=0;i<t.length;i++) {
            p.println("\tstatic private void solve_"+i+"() {");
            p.println("\t\tint part[];");
            if (i>0) p.println("\t\tboolean a;");
            p.println("\t\tfor (int j="+(t[i].length-1)+";j>=0;j--) {");
            p.println("\t\t\tpart=t_"+i+"[j];");
            if (i>0) {
                for (int k=0;k<partlength;k++) {
                    p.println("\t\t\t"+(k==0?"a=":"a&=")+"(cube_"+i+"_"+k+" & part["+k+"])==0;");
                }
                p.println("\t\t\tif (a) {");
                if (i<t.length-1) {
                    for (int k=0;k<partlength;k++) {
                        p.println("\t\t\t\tcube_"+(i+1)+"_"+k+"=cube_"+i+"_"+k+" | part["+k+"];");
                    }
                }
                p.println("\t\t\t\tsolve_"+(i+1)+"();");
                p.println("\t\t\t}");
            } else {
                if (i<t.length-1) {
                    for (int k=0;k<partlength;k++) {
                        p.println("\t\t\tcube_"+(i+1)+"_"+k+"=part["+k+"];");
                    }
                }
                p.println("\t\t\tsolve_"+(i+1)+"();");
            }
            p.println("\t\t}");
            p.println("\t}");
            p.println();
        }
        p.println("\tstatic final private void solve_"+t.length+"() {");
        p.println("\t\ttotal_solutions++;");
        p.println("\t}");
        p.println();

        p.println("\tfinal public static void main(String arg[]) {");
        p.println("\t\tlong startTime = System.currentTimeMillis();\n");
        p.println("\t\tsolve_0();");
        p.println("\t\tSystem.out.println(\"Solutions :\"+total_solutions);");
        p.println("\t\tSystem.out.println(\"Duration : \"+(System.currentTimeMillis()-startTime));");
        p.println("\t}");
        p.println("}");
    }

}
