//
//  FirstBitSolver.java
//  Cube
//
//  Created by Gunter Blache on Sat Apr 12 2003.
//  Copyright (c) 2003 __MyCompanyName__. All rights reserved.
//

import java.util.Vector;

import java.io.*;

public final class FirstBitSolver implements CubeSolver {

    private Part p[][][];
    private int t[][][][];
    private int nextPos[][][];
    private int partlength,partlength1,partsize;

    private int firstBit(int x[]) {
        for (int i=0;i<x.length;i++) {
            for (int k=0;k<32;k++)
                if ((x[i] & (1<<k))!=0) return i*32+k;
        }
        return x.length*32;
    }

    private int secondClear(int x[]) {
        boolean first=false;
        for (int i=0;i<x.length;i++) {
            for (int k=0;k<32;k++) {
                boolean bit =(x[i] & (1<<k))!=0;
                if (!first && bit) first=true;
                if (first && !bit) return i*32+k;
            }
        }
        return x.length*32;
    }

    public FirstBitSolver(Part parts[]) {
        if (parts.length<2) throw new IllegalArgumentException("At least two parts needed");
        long start = System.currentTimeMillis();
        // Find all transformations and the part with the minimum number
        // of positions with rotated ones discarded
        Part tp[][]=new Part[parts.length][];
        int tt[][][]=new int[parts.length][][];
        Part tr[][]=new Part[parts.length][];
        int partsizeX=parts[0].getSizeX();
        int partsizeY=parts[0].getSizeY();
        int partsizeZ=parts[0].getSizeZ();
        int mintr=0,mintp=0,mintri=0,mins=0;
        for (int i=0;i<tp.length;i++) {
            if ((partsizeX!=parts[i].getSizeX()) || (partsizeY!=parts[i].getSizeY()) || (partsizeZ!=parts[i].getSizeZ()))
                throw new IllegalArgumentException("All parts must have the same size");
            tp[i] = parts[i].transformedParts();
            tr[i]= parts[i].transformedUnrotatedParts(tp[i]);
            System.out.println("Ratio "+tr[i].length+" / "+tp[i].length);
            int s=parts[i].size();
            if (i==0) {
                mintp=tp[i].length;mintr=tr[i].length;mintri=i;mins=s;
            } else if ((tr[i].length*mintp<mintr*tp[i].length) || ((tr[i].length*mintp==mintr*tp[i].length) && (s>mins))) {
                mintp=tp[i].length;mintr=tr[i].length;mintri=i;mins=s;
            }
        }
        tp[mintri]=tr[mintri]; // Replace the transformation with the unrotated transformations

//        for (int i=0;i<tp.length;i++) {
//            System.out.println("Part "+i+" has "+tp[i].length+"/"+tr[i].length+" transformations");
//            print(tp[i],"Part"+i+".txt");
//        }
        
        partsize=partsizeX*partsizeY*partsizeZ;
        int mapping[]=new int[partsize];

        // Create the bit arrays
        tt=new int[tp.length][][];
        for (int i=0;i<tp.length;i++) {
            tt[i]=new int[tp[i].length][];
            for (int k=0;k<tp[i].length;k++) tt[i][k]=tp[i][k].getPacked();
        }

        boolean bit_used[] = new boolean[partsize]; // Store if this bis has already been used
        float bit_prob[] = new float[partsize]; // Probability that this bit is set
        float part_used[] = new float[tt.length]; // Probability that this part is used
        // Find mapping
        int empty[] = new int[tt[0][0].length];
        float part_exp[] = new float[tt.length],part_exp_temp[] = new float[tt.length];
        float trans_prob[][] = new float[tt.length][],trans_prob_temp[][] = new float[tt.length][];
        for (int i=0;i<tt.length;i++) {
            trans_prob[i]=new float[tt[i].length];
            trans_prob_temp[i]=new float[tt[i].length];
        }
        for (int i=0;i<partsize;i++) {
            float min_exp=Float.MAX_VALUE;int minj=-1,mincount=1;
            if (i==53) {
                System.out.println("53");
            }
            for (int j=0;j<partsize;j++) if (!bit_used[j]) { // For each unused bit
                float exp_count = 0.0f; // Expected number of parts that can be placed
                int count=0;
                java.util.Arrays.fill(part_exp_temp,0.0f);
                for (int k=0;k<tt.length;k++) // for all parts
                    for (int l=0;l<tt[k].length;l++) // For all transformations
                        if ((tt[k][l][j/32] & (1<<(j & 31)))!=0) { // If the jth bit is set
                            float p=1.0f-part_used[k]; // Probability that this transformation can be placed
                            for (int m=0;m<partsize;m++)
                                if ((tt[k][l][m/32] & (1<<(m & 31)))!=0) p*=1.0f-bit_prob[m];
                            exp_count+=p;count++;
                            trans_prob_temp[k][l]=p;
                            part_exp_temp[k]+=p;
                        }
/*                if (((count>0) && (mincount>0) && (exp_count/count<min_exp/mincount)) || 
                    ((count>0) && (mincount>0) && (exp_count/count==min_exp/mincount) && (exp_count<min_exp)) || 
                    ((count==0) && (minj==-1)) ) {*/
                if (exp_count<min_exp) {
                    min_exp=exp_count;mincount=count;minj=j;
                    System.arraycopy(part_exp_temp,0,part_exp,0,tt.length);
                    for (int k=0;k<tt.length;k++)
                        System.arraycopy(trans_prob_temp[k],0,trans_prob[k],0,trans_prob[k].length);
                }
            }
            System.out.println(i+" min exp "+min_exp+" at "+minj);
            mapping[minj]=i;
            bit_used[minj]=true;
            if (min_exp!=0.0f) {
                for (int l=0;l<tt.length;l++)
                    for (int j=0;j<tt[l].length;j++) {
                        int p[] = tt[l][j];
                        if ((p[minj/32] & (1<<(minj & 31)))!=0) {
                            for (int k=0;k<partsize;k++)
                                if ((p[k/32] & (1<<(k & 31)))!=0) 
                                    bit_prob[k]+=(1.0f-bit_prob[k])*trans_prob[l][j]*part_exp[l]/min_exp;
                            tt[l][j]=empty;
                        }
                    }
                for (int j=0;j<tt.length;j++)
                    part_used[j]+=(1.0f-part_used[j])*part_exp[j]/min_exp;
            } else {
                for (int l=0;l<tt.length;l++)
                    for (int j=0;j<tt[l].length;j++) 
                        if ((tt[l][j][minj/32] & (1<<(minj & 31)))!=0)
                            tt[l][j]=empty;
            }
        }

        // Sort the transformed parts according to the first bit that is set
        Vector vp[][]=new Vector[tp.length][partsize];
        for (int i=0;i<tp.length;i++)
            for (int j=0;j<partsize;j++)
                vp[i][j]=new Vector();
        for (int i=0;i<tp.length;i++) {
            for (int j=0;j<tp[i].length;j++) {
                int r = firstBit(tp[i][j].getPacked(mapping));
                vp[i][r].add(tp[i][j]);
            }
        }
        
        // Copy the contents of the Vectors into arrays
        p=new Part[tp.length][partsize][];
        for (int i=0;i<p.length;i++) {
            for (int j=0;j<partsize;j++) {
                p[i][j]=new Part[vp[i][j].size()];
                vp[i][j].copyInto(p[i][j]);
            }
        }
        
        for (int j=0;j<partsize;j++)
            System.out.println("Mapping "+j+" -> "+mapping[j]);
        for (int j=0;j<partsize;j++) {
            int sum=0;
            for (int i=0;i<p.length;i++) sum+=p[i][j].length;
            System.out.println("Bit "+j+" has "+sum+" parts");
        }

        // Create the bit arrays
        t=new int[p.length][partsize][][];
        for (int i=0;i<p.length;i++) {
            for (int j=0;j<partsize;j++) {
                t[i][j]=new int[p[i][j].length][];
                for (int k=0;k<p[i][j].length;k++) t[i][j][k]=p[i][j][k].getPacked(mapping);
            }
        }
        
        // Build the information where to proceed after placing a part
        nextPos=new int[p.length][partsize][];
        for (int i=0;i<p.length;i++) {
            for (int j=0;j<partsize;j++) {
                nextPos[i][j]=new int[p[i][j].length];
                for (int k=0;k<p[i][j].length;k++) {
                    partlength=t[i][j][k].length;
                    nextPos[i][j][k]=secondClear(t[i][j][k]);
                }
            }
        }
        
        // Print warnings
        /*
        for (int i=0;i<p.length;i++) {
            for (int j=0;j<partsize;j++) {
                if (p[i][j].length==0) System.out.println("Part "+i+" has no tranformations for positon "+j);
            }
        }
        
        boolean reachable[] = new boolean[partlength*32];
        for (int i=0;i<p.length;i++) {
            for (int j=0;j<partsize-1;j++) {
                for (int k=0;k<p[i][j].length;k++) {
                    int r=nextPos[i][j][k];
                    if (r!=partlength*32) reachable[r]=true;
                }
            }
        }
        
        for (int i=0;i<partlength*32;i++)
            if (!reachable[i]) System.out.println("Position "+i+" is not reachable");
        */
        partlength1=partlength-1;
        
        System.out.println("Duration of initialisation : "+(System.currentTimeMillis()-start)+" ms \n");
    }
    
    private Vector solutions;
    private int partCount;
    private boolean partUsed[];
    private Part config[];
    private int cube[][];
    private long steps;
    private long max_steps;
    private long startTime;
    private boolean called[];
    private long hit[];
    
    private final void solve(int i,int pos) {
        if (steps>=max_steps) return;
        steps++;
        if (i>=partCount) {
            solutions.add(new Cube(config));
            for (int j=0;j<partsize;j++)
                if (called[j]) hit[j]++;
            if ((solutions.size() % 100)==0) System.out.println(solutions.size()+" Solutions with "+steps+" steps ( Ratio "+(steps/solutions.size())+" Steps/solution");
            return;
        }
        int l;
        int cubei[]=cube[i];
        int cubei1[]=cube[i+1];
        pos=-1;
        for (int j=0;(j<cubei.length) && (pos==-1);j++) {
            for (int k=0;(k<32) && (pos==-1);k++) {
                if ((cubei[j] & (1<<k))==0) pos=j*32+k;
            }
        }
        called[pos]=true;
        for (int j=0;j<t.length;j++) {
            if (!partUsed[j]) {
                partUsed[j]=true;
                int tj[][]=t[j][pos];
                Part pj[] =p[j][pos];
                for (int k=0;k<tj.length;k++) {
                    int part[]=tj[k];
                    for (l=partlength1;((l>=0) && ((cubei[l] & part[l])==0));l--);
                    if (l<0) {
                        config[i]=pj[k];
                        for (l=partlength1;l>=0;l--) cubei1[l] = cubei[l] | part[l];
                        solve(i+1,nextPos[j][pos][k]);
                    }                    
                }
                partUsed[j]=false;
            }
        }
        called[pos]=false;
    }


    public final Cube[] solve(long max_steps) {
        this.max_steps=max_steps;
        startTime=System.currentTimeMillis();
        solutions=new Vector();
        partCount=p.length;
        partUsed=new boolean[p.length];
        config=new Part[p.length];
        cube = new int[p.length+1][partlength];
        called=new boolean[partsize];
        hit=new long[partsize];
        steps=0;
        solve(0,0);
        Cube s[] = new Cube[solutions.size()];
        solutions.copyInto(s);
        solutions=null;
        partUsed=null;
        config=null;
        for (int i=0;i<partsize;i++)
            System.out.println("Hit "+i+" : "+hit[i]);
        System.out.println("Steps : "+steps);
        System.out.println("Solution :"+s.length);
        System.out.println("Duration for solving : "+(System.currentTimeMillis()-startTime)+" ms \n");
        return s;        
    }
    
    public final Cube[] solve() {
        return solve(Long.MAX_VALUE);
    }
    
    public void generateSolverClass(java.io.PrintWriter p) {
        generateSolverClass(p,1);
    }
    
    public void generateSolverClass(java.io.PrintWriter p,int threads) {
        String bitArrayType = "int[] ";
        if (partlength==1) bitArrayType="int ";
        if (partlength==2) bitArrayType="long ";
        p.println("final class SolverThread implements Runnable {");
        p.println();
        p.println("\tObject lock;");
        p.println("\t"+bitArrayType+"t[][][];");
        p.println();
        p.println("\tSolverThread(Object lock,"+bitArrayType+" t[][][]) {");
        p.println("\t\tthis.lock=lock;");
        p.println("\t\tthis.t=t;");
        p.println("\t}");
        p.println();
        for (int i=0;i<t.length;i++) {
            if (partlength==1) p.println("\tprivate int cube_"+i+";");
            else if (partlength==2) p.println("\tprivate long cube_"+i+";");
            else {
                p.print("\tprivate int cube_"+i+"[]={");
                for (int j=0;j<partlength;j++)
                    p.print("0"+(j<partlength-1?",":""));
                p.println("};");
            }
        }
        p.println();
        p.println("\tprivate int total_solutions;");
        p.println("\tprivate boolean part_used[]=new boolean["+t.length+"];");
        p.println();
        for (int i=0;i<t.length;i++) {
            p.println("\tprivate final void solve_"+i+"("+(i==0?"":"int pos0")+") {");
            if (i>0) {
                p.println("\t\tint pos=-1;");
                if (partlength<=2) {
                    p.println("\t\tfor (int i=pos0;(i<"+partsize+") && (pos==-1);i++)");
                    p.println("\t\t\tif ((cube_"+i+" & (1"+(partlength==2?"L":"")+"<<i)) ==0) pos=i;");
                } else {
                    p.println("\t\tfor (int i=(pos0/32),j=(pos0 & 31);(i<"+(partlength/32)+") && (pos==-1);i++) {");
                    p.println("\t\t\tfor (;(j<32) && (pos==-1);j++)");
                    p.println("\t\t\t\tif ((cube_"+i+"[i] & (1<<j)) ==0) pos=i*32+j;");
                    p.println("\t\t\tj=0;");
                    p.println("\t\t}");
                }
            } else p.println("\t\tint pos=0;");
            if (partlength>2) p.println("\t\tboolean a;");
            p.println("\t\t"+bitArrayType+"ti[][] = t[pos];");
            p.println("\t\tfor (int i=0;i<"+t.length+";i++) if (!part_used[i]) {");
            p.println("\t\t\tpart_used[i]=true;");
            p.println("\t\t\t"+bitArrayType+" tj[]=ti[i];");
            p.println("\t\t\tfor (int j=0;j<tj.length;j++) {");
            if (partlength<=2) {
                p.println("\t\t\t\tif ((cube_"+i+" & tj[j])==0) {");
                if (i<t.length-1)
                    p.println("\t\t\t\t\tcube_"+(i+1)+" = cube_"+i+" | tj[j];");
            } else {
                for (int j=0;j<partlength;j++)
                    p.println("\t\t\t\t"+(j==0?"a=":"a&=")+"(cube_"+i+"["+j+"] & tj[j]["+j+"])==0;");
                p.println("\t\t\t\tif (a) {");
                if (i<t.length-1)
                    for (int j=0;j<partlength;j++)
                        p.println("\t\t\t\t\tcube_"+(i+1)+"["+j+"] = cube_"+i+"["+j+"] | tj[j]["+j+"];");
            }
            if (i<t.length-1) p.println("\t\t\t\t\tsolve_"+(i+1)+"(pos+1);");
            else p.println("\t\t\t\t\ttotal_solutions++;");
            p.println("\t\t\t\t}");
            p.println("\t\t\t}");
            p.println("\t\t\tpart_used[i]=false;");
            p.println("\t\t}");
            p.println("\t}");
            p.println();
        }
        p.println("\tpublic void run() {");
        p.println("\t\tsolve_0();");
        p.println("\t\tsynchronized(lock) {SolveCube.finished++;SolveCube.total_solutions+=total_solutions;lock.notify();}");
        p.println("\t}");
        p.println("}");
        p.println();

        p.println("final public class SolveCube {");
        int bit0count=0;
        for (int i=0;i<t.length;i++) bit0count+=t[i][0].length;
        int threadno=0;
        p.println("\tprivate static final "+bitArrayType+" bit0[][][] = {");
        int itemcount=0;
        p.println("\t\t{//Thread "+threadno);
        for (int i=0;i<t.length;i++) {
            p.print("\t\t{");// Open part
            for (int k=0;k<t[i][0].length;k++) {
                if (partlength==1) p.print(t[i][0][k][0]);
                else if (partlength==2) p.print(((((long)t[i][0][k][1])<<32)+(((long)t[i][0][k][0]) & 0xFFFFFFFFL))+"L");
                else {
                    p.print("{");
                    for (int l=0;l<t[i][0][k].length;l++) p.print(t[i][0][k][l]+(l<t[i][0][k].length-1?",":""));
                    p.print("}");
                }
                itemcount++;
                if ((itemcount<bit0count*(threadno+1)/threads) && (itemcount<bit0count)) {
                    p.print((k<t[i][0].length-1?",":""));
                } else {
                    p.println("}"+(i<t.length-1?",":"")+" // Part "+i);// Close part
                    for (int l=i+1;l<t.length;l++) p.println("\t\t{}"+(l<t.length-1?",":"")+" // Part "+l);
                    p.println("\t\t},");// Close thread
                    threadno++;
                    p.println("\t\t{//Thread "+threadno);
                    for (int l=0;l<i;l++) p.println("\t\t{}"+(l<t.length-1?",":"")+" // Part "+l);
                    p.print("\t\t{"); // Open part
                }
            }
            p.println("}"+(i<t.length-1?",":"")+" // Part "+i);
        }
        p.println("\t\t}");// Close thread
        p.println("\t};");
        for (int j=1;j<partsize;j++) {
            p.println("\tprivate static final "+bitArrayType+" bit"+j+"[][] = {");
            for (int i=0;i<t.length;i++) {
                p.print("\t\t{");
                for (int k=0;k<t[i][j].length;k++) {
                    if (partlength==1) p.print(t[i][j][k][0]);
                    else if (partlength==2) p.print(((((long)t[i][j][k][1])<<32)+(((long)t[i][j][k][0]) & 0xFFFFFFFFL))+"L");
                    else {
                        p.print("{");
                        for (int l=0;l<t[i][j][k].length;l++) p.print(t[i][j][k][l]+(l<t[i][j][k].length-1?",":""));
                        p.print("}");
                    }
                    p.print((k<t[i][j].length-1?",":""));
                }
                p.println("}"+(i<t.length-1?",":"")+" // Part "+i);
            }
            p.println("\t};");
        }
        p.println();
        p.println("\tpublic static int finished=0;");
        p.println("\tpublic static int total_solutions=0;");
        p.println("\tfinal public static void main(String arg[]) {");
        p.println("\t\tlong startTime = System.currentTimeMillis();\n");
        p.println("\t\tObject lock = new Object();");
        p.println("\t\tfor (int i=0;i<"+threads+";i++)");
        p.print("\t\t\t(new Thread(new SolverThread(lock,new "+bitArrayType+"[][][] {");
        p.print("bit0[i],");
        for (int i=1;i<partsize;i++) p.print("bit"+i+(i<partsize-1?",":""));
        p.println("}))).start();");
//        p.println("\t\tsolve_0();");
        p.println("\t\twhile (finished<"+threads+") {");
        p.println("\t\t\tsynchronized(lock) {try{lock.wait();} catch (InterruptedException e){}}");
        p.println("\t\t}");
        p.println("\t\tSystem.out.println(\"Solutions :\"+total_solutions);");
        p.println("\t\tSystem.out.println(\"Duration : \"+(System.currentTimeMillis()-startTime));");
        p.println("\t}");
        p.println("}");
    }
    
}
