//
//  PaintedPart.java
//  Cube
//
//  Created by Gunter Blache on Mon Apr 14 2003.
//  Copyright (c) 2003 __MyCompanyName__. All rights reserved.
//

import java.util.Vector;

public class PaintedPart extends Part {

    private char coord; // 'x', 'y' or 'z'
    private int constant; // The painted side is the one with coord==constant

    private void check(char c,int t) {
        if ((c!='x') && (c!='y') && (c!='z')) throw new IllegalArgumentException("coord must be x,y or z");
        if (c<0) throw new IllegalArgumentException("constant must be >=0");
        switch (c) {
            case 'x' : if (t>sizeX) throw new IllegalArgumentException("constant must be <=sizeX");
            case 'y' : if (t>sizeY) throw new IllegalArgumentException("constant must be <=sizeY");
            case 'z' : if (t>sizeZ) throw new IllegalArgumentException("constant must be <=sizeZ");
        }
    }

    public PaintedPart(boolean c[][][], int s,char co,int t) {
        super(c,s);
        check(co,t);
        coord=co;
        constant=t;
    }

    public PaintedPart(boolean c[][][], char co, int t) {
        super(c);
        check(co,t);
        coord=co;
        constant=t;
    }
    
    public PaintedPart(int c[][],int sizeX,int sizeY,int sizeZ,char co,int t) {
        super(c,sizeX,sizeY,sizeZ);
        check(co,t);
        coord=co;
        constant=t;        
    }
    
    private int coordToInt(char c) {
        int i=0;
        switch (c) {
            case 'x' : c=0;
            case 'y' : c=1;
            case 'z' : c=2;
        }
        return i;
    }
    
    private char intToChar(int i) {
        return (new char[] {'x','y','z'})[i];
    }
    
    private char transform(char c,int t[][]) {
        int i=coordToInt(c);
        int j=0;
        for (int k=0;k<3;k++)
            if (t[k][i]!=0) j=k;
        return intToChar(j);
    }
    
    private int transform(char c,int s,int t[][]) {
        int i=coordToInt(c);
        int j=0;
        for (int k=0;k<3;k++)
            if (t[k][i]!=0) j=k;
        if (t[j][i]==1) return s+t[j][3];
        if (t[j][i]==-1) return t[j][3]-s;
        return 0;
    }
    
    protected Part transform(int t[][]) throws Exception {
        PaintedPart p = new PaintedPart(transform(cubelets,t),sizeX,sizeY,sizeZ,transform(coord,t),transform(coord,constant,t));
        return p;
    }
    
    private char rotateNormalised(char c,int r[][]) {
        return transform(c,r);
    }
    
    private int rotateNormalised(char c,int t,int r[][],int xmin,int ymin,int zmin) {
        int i=coordToInt(c);
        return transform(c,t,r)+(new int[] {xmin,ymin,zmin})[i];
    }

    protected Part rotateNormalised(int r[][],int xmin,int ymin,int zmin) throws Exception {
        PaintedPart p = new PaintedPart(rotateNormalised(cubelets,r,xmin,ymin,zmin),
            sizeX,sizeY,sizeZ, 
            rotateNormalised(coord,r),
            rotateNormalised(coord,constant,r,xmin,ymin,zmin));
        return p;
    }
    
    private int move(char c,int t,int mx,int my,int mz) {
        int i=coordToInt(c);
        return t+(new int[] {mx,my,mz})[i];
    }

    protected Part move(int mx,int my,int mz) throws Exception {
        PaintedPart p = new PaintedPart(move(cubelets,mx,my,mz),sizeX,sizeY,sizeZ,coord,move(coord,constant,mx,my,mz));
        return p;
    }
    
    private boolean isPrintingInside() {
        switch (coord) {
            case 'x' : return (constant!=0) && (constant!=sizeX);
            case 'y' : return (constant!=0) && (constant!=sizeY);
            case 'z' : return (constant!=0) && (constant!=sizeZ);
        }
        return true;
    }

    public Part[] transformedParts() {
        Part p[]=super.transformedParts();
        Vector v=new Vector(p.length);
        for (int i=0;i<p.length;i++)
            if (((PaintedPart)p[i]).isPrintingInside()) v.add(p[i]);
        Part[] r = new Part[v.size()];
        v.copyInto(r);
        return r;
        
    }
    
    public String povRay() {
        StringBuffer b= new StringBuffer();
        String white = "texture{pigment { color red 1 green 1 blue 1 }}";
        String black = "texture{pigment { color red 0.3 green 0.3 blue 0.3 }}";
        for (int i=0;i<cubelets.length;i++) {
            int x=cubelets[i][0],y=cubelets[i][1],z=cubelets[i][2];
            float x1ofs=((coord=='x') && (constant==x))?0.1f:0.0f;
            float x2ofs=((coord=='x') && (constant==x+1))?-0.1f:0.0f;
            float y1ofs=((coord=='y') && (constant==y))?0.1f:0.0f;
            float y2ofs=((coord=='y') && (constant==y+1))?-0.1f:0.0f;
            float z1ofs=((coord=='z') && (constant==z))?0.1f:0.0f;
            float z2ofs=((coord=='z') && (constant==z+1))?-0.1f:0.0f;
            box(b,x+x1ofs,y+y1ofs,z+z1ofs,x+1+x2ofs,y+1+y2ofs,z+1+z2ofs,white);
            if (x1ofs!=0.0f) box(b,x,y,z,x+x1ofs,y,z,black);
            if (x2ofs!=0.0f) box(b,x+1+x2ofs,y,z,x+1,y,z,black);
            if (y1ofs!=0.0f) box(b,x,y,z,x,y+y1ofs,z,black);
            if (y2ofs!=0.0f) box(b,x,y+1+y2ofs,z,x,y+1,z,black);
            if (z1ofs!=0.0f) box(b,x,y,z,x,y,z+z1ofs,black);
            if (z2ofs!=0.0f) box(b,x,y,z+1+z2ofs,x,y,z+1,black);
        }
        return b.toString();
    }
    
}
