//
//  TwoColourPart.java
//  Cube
//
//  Created by Gunter Blache on Sat Feb 08 2003.
//  Copyright (c) 2003 __MyCompanyName__. All rights reserved.
//

import java.util.Vector;

public class TwoColourPart extends Part {

    private boolean colour[];

    private TwoColourPart(int c[][], int sizeX,int sizeY,int sizeZ,int t,boolean col[]) {
        super(c,sizeX,sizeY,sizeZ,t);
        colour=new boolean[col.length];
        System.arraycopy(col,0,colour,0,col.length);
    }

    public TwoColourPart(boolean c[][][], int t) {
        super(c,t);
        colour=fillColour(cubelets);
    }

    public TwoColourPart(boolean c[][][]) {
        this(c,1);
    }
    
    private boolean colour(int x,int y,int z) {
        return ((x ^ y ^ z) & 2)==0;
    }
    
    private boolean[] fillColour(int cubelets[][]) {
        boolean colour[]=new boolean[cubelets.length];
        for (int i=0;i<cubelets.length;i++)
            colour[i]=colour(cubelets[i][0],cubelets[i][1],cubelets[i][2]);
        return colour;
    }
    
    private boolean isCorrectColour() {
        for (int i=0;i<cubelets.length;i++) {
            int x=cubelets[i][0],y=cubelets[i][1],z=cubelets[i][2];
            if ((x==0) || (x==sizeX-1) || (y==0) || (y==sizeY-1) || (z==0) || (z==sizeZ-1)) {
                if (colour[i]!=colour(x,y,z)) return false;
            }
        }
        return true;
    }
    
    protected Part transform(int t[][]) throws Exception {
        TwoColourPart p = new TwoColourPart(transform(cubelets,t),sizeX,sizeY,sizeZ,translationStep,colour);
        return p;
    }

    protected Part rotateNormalised(int r[][],int xmin,int ymin,int zmin) throws Exception {
        TwoColourPart p = new TwoColourPart(rotateNormalised(cubelets,r,xmin,ymin,zmin),sizeX,sizeY,sizeZ,translationStep,colour);
        return p;
    }

    protected Part move(int mx,int my,int mz) throws Exception {
        TwoColourPart p = new TwoColourPart(move(cubelets,mx,my,mz),sizeX,sizeY,sizeZ,translationStep,colour);
        return p;
    }

    public Part[] transformedParts() {
        Part p[]=super.transformedParts();
        Vector v=new Vector(p.length);
        for (int i=0;i<p.length;i++)
            if (((TwoColourPart)p[i]).isCorrectColour()) v.add(p[i]);
        Part[] r = new Part[v.size()];
        v.copyInto(r);
        return r;
        
    }

    public String povRay() {
        StringBuffer b= new StringBuffer();
        String white = "texture{pigment { color red 1 green 1 blue 1 }}";
        String black = "texture{pigment { color red 0.3 green 0.3 blue 0.3 }}";
        for (int i=0;i<cubelets.length;i++) {
            int x=cubelets[i][0],y=cubelets[i][1],z=cubelets[i][2];
            box(b,x,y,z,x+1,y+1,z+1,colour[i]?black:white);
        }
        return b.toString();
    }
    
}
