#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <time.h>

// Compilieren mit:
// gcc ctpuzzle_final.c -o ctpuzzle.exe -Wall -O2 -fomit-frame-pointer

#define ANZAHL_TEILE	12
#define WIDTH		3
#define HEIGHT		4
#define LENGTH		5

typedef struct {
	unsigned int b[2];
} Bitfield;

typedef struct {
	int a[3];
} Wuerfel;

typedef struct {
	Wuerfel *w;
	int anzahl;
	int min[3], max[3];
} Holzteil;

struct LinkedList {
	Bitfield bf;
	Holzteil ht;
	struct LinkedList *prev, *next;
};

typedef struct {
	struct LinkedList *l;
	int anzahl;
} ListContainer;

typedef struct {
	int dir[6];
} Map;

int teil4[4][3] =
{
	{0, 0, 0},
	{1, 0, 0},
	{0, 1, 0},
	{0, 1, 1}
};

int teil5[10][5][3] =
{
	{
		{0, 0, 0},
		{1, 0, 0},
		{2, 0, 0},
		{0, 0, 1},
		{2, 0, 1}
	},
	{
		{1, 0, 0},
		{0, 0, 1},
		{1, 0, 1},
		{2, 0, 1},
		{2, 0, 2}
	},
	{
		{1, 0, 0},
		{1, 0, 1},
		{0, 0, 2},
		{1, 0, 2},
		{2, 0, 2}
	},
	{
		{0, 0, 0},
		{0, 0, 1},
		{0, 1, 1},
		{0, 2, 1},
		{0, 2, 2}
	},
	{
		{0, 0, 0},
		{1, 0, 0},
		{2, 0, 0},
		{1, 0, 1},
		{2, 0, 1}
	},
	{
		{0, 0, 0},
		{1, 0, 0},
		{0, 1, 0},
		{1, 1, 0},
		{0, 0, 1}
	},
	{
		{1, 0, 0},
		{0, 0, 1},
		{1, 0, 1},
		{2, 0, 1},
		{1, 0, 2}
	},
	{
		{0, 0, 0},
		{0, 1, 0},
		{0, 2, 0},
		{0, 3, 0},
		{1, 0, 0}
	},
	{
		{0, 0, 0},
		{1, 0, 0},
		{1, 0, 1},
		{2, 0, 1},
		{2, 0, 2}
	},
	{
		{0, 0, 0},
		{0, 0, 1},
		{0, 0, 2},
		{0, 0, 3},
		{1, 0, 1}
	}
};

int teil6[6][3] =
{
	{0, 0, 0},
	{0, 1, 0},
	{0, 2, 0},
	{0, 3, 0},
	{0, 0, 1},
	{0, 2, 1}
};

time_t zeit;
int counter;
int solutions;
int anzahl[ANZAHL_TEILE];
Bitfield *bf[ANZAHL_TEILE];
Bitfield quader[ANZAHL_TEILE + 1];
Map *karte;
int schon[60];
int blocksize;
int fs;

void ctCreateHolzteil(Holzteil *ht, int anzahl, ...);
void ctFreeHolzteil(Holzteil *ht);
void ctFreeLinkedList(struct LinkedList *l);
struct LinkedList *ctRotateHolzteil(Holzteil *ht);
void ctFindBounds(Holzteil *ht);
void ctArrangeHolzteil(Holzteil *ht);
void ctMoveHolzteil(Holzteil *ht, int x, int y, int z);
void ctAddHolzteilToList(Holzteil *ht, struct LinkedList *l);
int ctIsValidRotation(Holzteil *ht);
void ctRotateX(Holzteil *ht, int d);
void ctRotateY(Holzteil *ht, int d);
void ctRotateZ(Holzteil *ht, int d);
void ctRotateXYZ(Holzteil *ht, Holzteil *tempht, int x, int y, int z);
void ctTranslateHolzteil(struct LinkedList *l, int anzahl);
void ctTranslateX(Holzteil *ht, int d);
void ctTranslateY(Holzteil *ht, int d);
void ctTranslateZ(Holzteil *ht, int d);
void ctTranslateXYZ(Holzteil *ht, Holzteil *tempht, int x, int y, int z);
int ctIsValidPosition(Holzteil *ht);
void ctFindSolutions(int teil);
Map *ctGenerateMap(void);
void ctNextStep(int i);
int ctFindSmallestGroup(int teil);

int main(int argc, char *argv[])
{
	int i, j;
	Holzteil *ht[ANZAHL_TEILE];
	ListContainer lc[ANZAHL_TEILE];
	struct LinkedList *t;

	karte = ctGenerateMap();

	for(i = 0; i < ANZAHL_TEILE; i++)
		ht[i] = (Holzteil *)malloc(sizeof(Holzteil));

	for(i = 0; i < 10; i++)
		ctCreateHolzteil(ht[i], 5, teil5[i][0], teil5[i][1], teil5[i][2], teil5[i][3], teil5[i][4]);
	ctCreateHolzteil(ht[10], 4, teil4[0], teil4[1], teil4[2], teil4[3]);
	ctCreateHolzteil(ht[11], 6, teil6[0], teil6[1], teil6[2], teil6[3], teil6[4], teil6[5]);

	// Alle Rotationen berechnen
	for(i = 0; i < ANZAHL_TEILE; i++) {
		lc[i].l = ctRotateHolzteil(ht[i]);

		// Anzahl Elemente pro Liste zaehlen
		j = 0;
		for(t = lc[i].l; t->next != NULL; t = t->next)
			j++;

		lc[i].anzahl = j;
	}

	// Alle Translationen berechnen
	for(i = 0; i < ANZAHL_TEILE; i++) {
		ctTranslateHolzteil(lc[i].l, lc[i].anzahl);

		// Anzahl Elemente pro Liste zaehlen
		j = 0;
		for(t = lc[i].l; t->next != NULL; t = t->next)
			j++;

		lc[i].anzahl = j;
	}

	for(i = 0; i < ANZAHL_TEILE; i++) {
		bf[i] = (Bitfield *)malloc(lc[i].anzahl * sizeof(Bitfield));

		t = lc[i].l;

		for(j = 0; j < lc[i].anzahl; j++) {
			bf[i][j].b[0] = t->bf.b[0];
			bf[i][j].b[1] = t->bf.b[1];

			if(bf[i][j].b[0] == 0 && bf[i][j].b[1] == 0)
				printf("das sollte nicht vorkommen\n");

			t = t->next;
		}

		anzahl[i] = lc[i].anzahl;

		ctFreeLinkedList(lc[i].l);
	}

	// So, jetzt hammer alle Infos, die wir brauchen. Nun kann es losgehen.
	quader[0].b[0] = 0;
	quader[0].b[1] = 0;
	solutions = 0;

	counter = 0;
	zeit = time(NULL);

	printf("Start: %s", ctime(&zeit));

	ctFindSolutions(0);

	zeit = time(NULL) - zeit;

	printf("\nAnzahl Loesungen: %d\nDauer: %d Sekunden", solutions, zeit);

	return 0;
}

int ctFindSmallestGroup(int teil)
{
	int i;

	for(i = 0; i < 60; i++) {
		if(i < 32) {
			if(((quader[teil].b[0] >> i) & 1) == 1)
				schon[i] = 1;
			else
				schon[i] = 0;
		}
		else {
			if(((quader[teil].b[1] >> (i - 32)) & 1) == 1)
				schon[i] = 1;
			else
				schon[i] = 0;
		}
	}

	for(i = 0; i < 60; i++) {
		blocksize = 1;
		if(schon[i] == 1)
			continue;
		schon[i] = 1;
		ctNextStep(i);

		if(blocksize < 4)
			return 0;
	}

	return 1;
}

void ctNextStep(int i)
{
	int j;

	for(j = 0; j < 6; j++) {
		if(schon[karte[i].dir[j]] == 1)
			continue;
		if(karte[i].dir[j] == -1)
			continue;
		schon[karte[i].dir[j]] = 1;
		blocksize++;

		ctNextStep(karte[i].dir[j]);
	}

	return;
}

Map *ctGenerateMap(void)
{
	int i;
	Map *t;
	t = (Map *)malloc(60 * sizeof(Map));

	for(i = 0; i < 60; i++) {
		// in positiver x-Richtung schauen
		if(i % WIDTH < (WIDTH - 1))
			t[i].dir[0] = i + 1;
		else
			t[i].dir[0] = -1;
		// in negativer x-Richtung schauen
		if(i % WIDTH > 0)
			t[i].dir[1] = i - 1;
		else
			t[i].dir[1] = -1;

		// in positiver y-Richtung schauen
		if(i % (WIDTH * HEIGHT) < (WIDTH * HEIGHT - WIDTH))
			t[i].dir[2] = i + WIDTH;
		else
			t[i].dir[2] = -1;
		// in negativer y-Richtung schauen
		if((i % (WIDTH * HEIGHT)) - (WIDTH - 1) > 0)
			t[i].dir[3] = i - WIDTH;
		else
			t[i].dir[3] = -1;

		// in positiver z-Richtung schauen
		if(i % (WIDTH * HEIGHT * LENGTH) < (WIDTH * HEIGHT * LENGTH - WIDTH * HEIGHT))
			t[i].dir[4] = i + WIDTH * HEIGHT;
		else
			t[i].dir[4] = -1;
		// in negativer z-Richtung schauen
		if((i % (WIDTH * HEIGHT * LENGTH)) - (WIDTH * HEIGHT - 1) > 0)
			t[i].dir[5] = i - WIDTH * HEIGHT;
		else
			t[i].dir[5] = -1;
	}

	return t;
}

void ctFindSolutions(int teil)
{
	int i;

	for(i = 0; i < anzahl[teil]; i++) {
		if((quader[teil].b[0] & bf[teil][i].b[0]) == 0 && (quader[teil].b[1] & bf[teil][i].b[1]) == 0) {
			quader[teil + 1].b[0] = (quader[teil].b[0] | bf[teil][i].b[0]);
			quader[teil + 1].b[1] = (quader[teil].b[1] | bf[teil][i].b[1]);
			if(teil == ANZAHL_TEILE - 1) {
				solutions++;
				printf("Loesung gefunden (%d) %.3f L/s\r", solutions, (float)solutions / (float)(time(NULL) - zeit));
				return;
			}
			if(ctFindSmallestGroup(teil + 1))
				ctFindSolutions(teil + 1);
		}
	}

	return;
}

void ctTranslateHolzteil(struct LinkedList *l, int anzahl)
{
	int index;
	int i, j, k;
	struct LinkedList *t;
	Holzteil *tempht;

	tempht = (Holzteil *)malloc(sizeof(Holzteil));

	// Maximal 6 Wuerfel pro Holzteil
	tempht->anzahl = 6;
	tempht->w = (Wuerfel *)malloc(tempht->anzahl * sizeof(Wuerfel));

	t = l;
	for(index = 0; index < anzahl; index++) {
		for(k = 0; k < LENGTH; k++) {
			for(j = 0; j < HEIGHT; j++) {
				for(i = 0; i < WIDTH; i++) {
					ctTranslateXYZ(&t->ht, tempht, i, j, k);
					if(ctIsValidPosition(tempht))
						ctAddHolzteilToList(tempht, l);
				}
			}
		}
		t = t->next;
	}

	ctFreeHolzteil(tempht);
	free(tempht);

	return;
}

int ctIsValidPosition(Holzteil *ht)
{
	ctFindBounds(ht);

	if(ht->min[0] < 0 || ht->max[0] >= WIDTH)
		return 0;

	if(ht->min[1] < 0 || ht->max[1] >= HEIGHT)
		return 0;

	if(ht->min[2] < 0 || ht->max[2] >= LENGTH)
		return 0;

	return 1;
}

void ctTranslateXYZ(Holzteil *ht, Holzteil *tempht, int x, int y, int z)
{
	int i;

	tempht->anzahl = ht->anzahl;
	for(i = 0; i < ht->anzahl; i++) {
		tempht->w[i].a[0] = ht->w[i].a[0];
		tempht->w[i].a[1] = ht->w[i].a[1];
		tempht->w[i].a[2] = ht->w[i].a[2];
	}

	ctTranslateX(tempht, x);
	ctTranslateY(tempht, y);
	ctTranslateZ(tempht, z);

	return;
}

void ctTranslateX(Holzteil *ht, int d)
{
	int i;

	for(i = 0; i < ht->anzahl; i++)
		ht->w[i].a[0] += d;

	return;
}

void ctTranslateY(Holzteil *ht, int d)
{
	int i;

	for(i = 0; i < ht->anzahl; i++)
		ht->w[i].a[1] += d;

	return;
}

void ctTranslateZ(Holzteil *ht, int d)
{
	int i;

	for(i = 0; i < ht->anzahl; i++)
		ht->w[i].a[2] += d;

	return;
}

struct LinkedList *ctRotateHolzteil(Holzteil *ht)
{
	int i, j, k;
	struct LinkedList *l;
	Holzteil *tempht;

	l = (struct LinkedList *)malloc(sizeof(struct LinkedList));
	l->prev = l->next = NULL;
	l->bf.b[0] = l->bf.b[1] = 0;
	l->ht.w = (Wuerfel *)malloc(ht->anzahl * sizeof(Wuerfel));

	tempht = (Holzteil *)malloc(sizeof(Holzteil));

	// Maximal 6 Wuerfel pro Holzteil
	tempht->anzahl = 6;
	tempht->w = (Wuerfel *)malloc(tempht->anzahl * sizeof(Wuerfel));

	// In den Ursprung (oder moeglichst nah dran) verschieben
	ctArrangeHolzteil(ht);

	// pruefen, ob das Teil zulaessig ist
	// d.h. ob es nicht irgendwo aus dem Quader rausragt
	if(ctIsValidRotation(ht))
		ctAddHolzteilToList(ht, l);	// Das Holzteil der Liste hinzufuegen

	for(k = 0; k < 4; k++) {
		for(j = 0; j < 4; j++) {
			for(i = 0; i < 4; i++) {
				ctRotateXYZ(ht, tempht, i, j, k);
				ctArrangeHolzteil(tempht);
				if(ctIsValidRotation(tempht))
					ctAddHolzteilToList(tempht, l);
			}
		}
	}

	ctFreeHolzteil(tempht);
	free(tempht);

	return l;
}

void ctFreeLinkedList(struct LinkedList *l)
{
	struct LinkedList *t;

	t = l;
	while(t->next != NULL) {
		ctFreeHolzteil(&t->ht);
		t = t->next;
	}

	while(t->prev != NULL) {
		free(t->next);
		t = t->prev;
	}

	free(l);

	return;
}

void ctFreeHolzteil(Holzteil *ht)
{
	free(ht->w);

	return;
}

void ctRotateXYZ(Holzteil *ht, Holzteil *tempht, int x, int y, int z)
{
	int i;

	tempht->anzahl = ht->anzahl;
	for(i = 0; i < ht->anzahl; i++) {
		tempht->w[i].a[0] = ht->w[i].a[0];
		tempht->w[i].a[1] = ht->w[i].a[1];
		tempht->w[i].a[2] = ht->w[i].a[2];
	}

	ctRotateX(tempht, x);
	ctRotateY(tempht, y);
	ctRotateZ(tempht, z);

	return;
}

void ctRotateX(Holzteil *ht, int d)
{
	int i, indizes[3], sign[3], temp[3];

	switch(d) {
		case 0:
			indizes[0] = 0; sign[0] = 1;
			indizes[1] = 2; sign[1] = -1;
			indizes[2] = 1; sign[2] = 1;
			break;
		case 1:
			indizes[0] = 0; sign[0] = 1;
			indizes[1] = 1; sign[1] = -1;
			indizes[2] = 2; sign[2] = -1;
			break;
		case 2:
			indizes[0] = 0; sign[0] = 1;
			indizes[1] = 2; sign[1] = 1;
			indizes[2] = 1; sign[2] = -1;
			break;
		case 3:
			indizes[0] = 0; sign[0] = 1;
			indizes[1] = 1; sign[1] = 1;
			indizes[2] = 2; sign[2] = 1;
			break;
	}

	for(i = 0; i < ht->anzahl; i++) {
		temp[0] = sign[0] * ht->w[i].a[indizes[0]];
		temp[1] = sign[1] * ht->w[i].a[indizes[1]];
		temp[2] = sign[2] * ht->w[i].a[indizes[2]];

		ht->w[i].a[0] = temp[0];
		ht->w[i].a[1] = temp[1];
		ht->w[i].a[2] = temp[2];
	}

	return;
}

void ctRotateY(Holzteil *ht, int d)
{
	int i, indizes[3], sign[3], temp[3];

	switch(d) {
		case 0:
			indizes[0] = 2; sign[0] = 1;
			indizes[1] = 1; sign[1] = 1;
			indizes[2] = 0; sign[2] = -1;
			break;
		case 1:
			indizes[0] = 0; sign[0] = -1;
			indizes[1] = 1; sign[1] = 1;
			indizes[2] = 2; sign[2] = -1;
			break;
		case 2:
			indizes[0] = 2; sign[0] = -1;
			indizes[1] = 1; sign[1] = 1;
			indizes[2] = 0; sign[2] = 1;
			break;
		case 3:
			indizes[0] = 0; sign[0] = 1;
			indizes[1] = 1; sign[1] = 1;
			indizes[2] = 2; sign[2] = 1;
			break;
	}

	for(i = 0; i < ht->anzahl; i++) {
		temp[0] = sign[0] * ht->w[i].a[indizes[0]];
		temp[1] = sign[1] * ht->w[i].a[indizes[1]];
		temp[2] = sign[2] * ht->w[i].a[indizes[2]];

		ht->w[i].a[0] = temp[0];
		ht->w[i].a[1] = temp[1];
		ht->w[i].a[2] = temp[2];
	}

	return;
}

void ctRotateZ(Holzteil *ht, int d)
{
	int i, indizes[3], sign[3], temp[3];

	switch(d) {
		case 0:
			indizes[0] = 1; sign[0] = -1;
			indizes[1] = 0; sign[1] = 1;
			indizes[2] = 2; sign[2] = 1;
			break;
		case 1:
			indizes[0] = 0; sign[0] = -1;
			indizes[1] = 1; sign[1] = -1;
			indizes[2] = 2; sign[2] = 1;
			break;
		case 2:
			indizes[0] = 1; sign[0] = 1;
			indizes[1] = 0; sign[1] = -1;
			indizes[2] = 2; sign[2] = 1;
			break;
		case 3:
			indizes[0] = 0; sign[0] = 1;
			indizes[1] = 1; sign[1] = 1;
			indizes[2] = 2; sign[2] = 1;
			break;
	}

	for(i = 0; i < ht->anzahl; i++) {
		temp[0] = sign[0] * ht->w[i].a[indizes[0]];
		temp[1] = sign[1] * ht->w[i].a[indizes[1]];
		temp[2] = sign[2] * ht->w[i].a[indizes[2]];

		ht->w[i].a[0] = temp[0];
		ht->w[i].a[1] = temp[1];
		ht->w[i].a[2] = temp[2];
	}

	return;
}

int ctIsValidRotation(Holzteil *ht)
{
	if((ht->max[0] - ht->min[0]) >= WIDTH)
		return 0;

	if((ht->max[1] - ht->min[1]) >= HEIGHT)
		return 0;

	if((ht->max[2] - ht->min[2]) >= LENGTH)
		return 0;

	return 1;
}

void ctAddHolzteilToList(Holzteil *ht, struct LinkedList *l)
{
	int i, pos;
	struct LinkedList *t;
	Bitfield bf;

	bf.b[0] = bf.b[1] = 0;

	for(i = 0; i < ht->anzahl; i++) {
		pos = ht->w[i].a[0] + WIDTH * ht->w[i].a[1] + (WIDTH * HEIGHT) * ht->w[i].a[2];
		if(pos < 32)
			bf.b[0] |= (1 << pos);
		else
			bf.b[1] |= (1 << (pos - 32));
	}

	t = l;
	while(t->bf.b[0] != 0 || t->bf.b[1] != 0) {
		// pruefen, ob das Teil schon in der Liste ist (Symmetrieen herausfiltern)
		if(t->bf.b[0] == bf.b[0] && t->bf.b[1] == bf.b[1])
			return;

		t = t->next;
	}

	t->bf.b[0] = bf.b[0];
	t->bf.b[1] = bf.b[1];
	for(i = 0; i < ht->anzahl; i++) {
		t->ht.w[i].a[0] = ht->w[i].a[0];
		t->ht.w[i].a[1] = ht->w[i].a[1];
		t->ht.w[i].a[2] = ht->w[i].a[2];
	}
	t->ht.anzahl = ht->anzahl;

	t->next = (struct LinkedList *)malloc(sizeof(struct LinkedList));
	if(t->next == NULL) {
		printf("nicht genug speicher\n");
		exit(1);
	}
	t->next->prev = t;
	t->next->next = NULL;
	t->next->bf.b[0] = t->next->bf.b[1] = 0;
	t->next->ht.w = (Wuerfel *)malloc(ht->anzahl * sizeof(Wuerfel));

	return;
}

void ctArrangeHolzteil(Holzteil *ht)
{
	// BoundingBox bestimmen
	ctFindBounds(ht);

	if(ht->min[0] != 0)
		ctMoveHolzteil(ht, -ht->min[0], 0, 0);
	if(ht->min[1] != 0)
		ctMoveHolzteil(ht, 0, -ht->min[1], 0);
	if(ht->min[2] != 0)
		ctMoveHolzteil(ht, 0, 0, -ht->min[2]);

	return;
}

void ctMoveHolzteil(Holzteil *ht, int x, int y, int z)
{
	int i;

	ht->min[0] += x;
	ht->max[0] += x;
	ht->min[1] += y;
	ht->max[1] += y;
	ht->min[2] += z;
	ht->max[2] += z;

	for(i = 0; i < ht->anzahl; i++) {
		ht->w[i].a[0] += x;
		ht->w[i].a[1] += y;
		ht->w[i].a[2] += z;
	}

	return;
}

void ctFindBounds(Holzteil *ht)
{
	int i;

	ht->min[0] = ht->max[0] = ht->w[0].a[0];
	ht->min[1] = ht->max[1] = ht->w[0].a[1];
	ht->min[2] = ht->max[2] = ht->w[0].a[2];

	for(i = 1; i < ht->anzahl; i++) {
		if(ht->w[i].a[0] < ht->min[0])
			ht->min[0] = ht->w[i].a[0];
		else if(ht->w[i].a[0] > ht->max[0])
			ht->max[0] = ht->w[i].a[0];

		if(ht->w[i].a[1] < ht->min[1])
			ht->min[1] = ht->w[i].a[1];
		else if(ht->w[i].a[1] > ht->max[1])
			ht->max[1] = ht->w[i].a[1];

		if(ht->w[i].a[2] < ht->min[2])
			ht->min[2] = ht->w[i].a[2];
		else if(ht->w[i].a[2] > ht->max[2])
			ht->max[2] = ht->w[i].a[2];
	}

	return;
}

void ctCreateHolzteil(Holzteil *ht, int anzahl, ...)
{
	va_list ap;
	int *teil, i;

	ht->w = (Wuerfel *)malloc(anzahl * sizeof(Wuerfel));
	ht->anzahl = anzahl;
	ht->min[0] = ht->min[1] = ht->min[2] = 0;
	ht->max[0] = ht->max[1] = ht->max[2] = 0;

	va_start(ap, anzahl);

	for(i = 0; i < anzahl; i++) {
		teil = va_arg(ap, int *);
		ht->w[i].a[0] = teil[0];
		ht->w[i].a[1] = teil[1];
		ht->w[i].a[2] = teil[2];
	}

	va_end(ap);

	return;
}
