#include "StdAfx.h"
#include "Instance.h"
#include "BitVector.h"
#include "Puzzle.h"
#include "Part.h"

Instance::Instance(BitVector turn, Puzzle* puzzle, int x, int y, int z, Part* part)
{
	this->part = part;

	int ox, oy, oz;
	hash = 0;
	for(int bit = 0; bit < xD * yD * zD; bit++)
		if(turn.getBit(bit))
		{
			puzzle->projection.getCoordinates(bit, ox, oy, oz);
			hash.setBit(puzzle->projection.getIndex(ox + x, oy + y, oz + z));
		}
}

Instance::~Instance(void)
{
}

void Instance::map(Puzzle* puzzle, bool erase)
{
	int ox, oy, oz;
	for(int bit = 0; bit < xD * yD * zD; bit++)
		if(hash.getBit(bit))
		{
			puzzle->projection.getCoordinates(bit, ox, oy, oz);
			puzzle->space[ox][oy][oz] = (erase ? -1 : part->partNo);
		}
}
