#pragma once

#include "Part.h"
#include "Projection.h"
#include "Instance.h"

class Puzzle
{
public:
	Puzzle(int dx, int dy, int dz);
	~Puzzle(void);
	void addPart(Part* part);
	int solve(void);
	void insertInstance(Instance instance);

	Projection projection;
	Instance instances[2700], instancesByBits[xD * yD * zD][numParts][100];
	int instanceCounter, instancesByBitsCounter[xD * yD * zD][numParts];
	int space[xD][yD][zD];

private:
	void recursiveSolve(int depth, int nextBit, BitVector allocation);

	bool* usedParts;
	int foundPossibilities;
public:
	void debugOutput(void);
};
