// Copyright (C) 2003 by Michael Pichler. See copympi.txt for further information.
//
// created: mpichler, 20030411
// changed: mpichler, 20030411


#include "point.h"


/*
 * Apply linear transformation.
 * Parameters: Image of unit vectors, i. e.  f (ex) = nx;  f (ey) = ny;  f (ez) = nz;
 * Special case: rotation when (nx, ny, nz) are ortonormal, e. g. for nz = nx x ny;
 * Writes the transformed point into to (this instance unchanged).
 * Point3i to must be distinct from this, nx, ny, and nz.
 */
void Point3i::xform (const Point3i& nx, const Point3i& ny, const Point3i& nz, Point3i* to) const
{
  int x = x_, y = y_, z = z_;
  to->x_ = x*nx.x_ + y*ny.x_ + z*nz.x_;
  to->y_ = x*nx.y_ + y*ny.y_ + z*nz.y_;
  to->z_ = x*nx.z_ + y*ny.z_ + z*nz.z_;
}


/*
 * Update the bounding box (min, max).
 */
void Point3i::updateBoundings (Point3i& min, Point3i& max) const
{
  if (x_ < min.x_)  min.x_ = x_;
  if (y_ < min.y_)  min.y_ = y_;
  if (z_ < min.z_)  min.z_ = z_;
  if (x_ > max.x_)  max.x_ = x_;
  if (y_ > max.y_)  max.y_ = y_;
  if (z_ > max.z_)  max.z_ = z_;
}


/*
 * Compute the cross product u x v.
 */
Point3i Point3i::cross (const Point3i& u, const Point3i& v)
{
  return Point3i (
    u.y_*v.z_ - u.z_*v.y_,
    u.z_*v.x_ - u.x_*v.z_,
    u.x_*v.y_ - u.y_*v.x_
  );
}
