// Copyright (C) 2003 by Michael Pichler. See copympi.txt for further information.
//
// created: mpichler, 20030411
// changed: mpichler, 20030413


/*
 * 3D point (int precision).
 */
class Point3i
{
  public:
    Point3i ()  { x_ = y_ = z_ = 0; }
    Point3i (int x, int y, int z)  { x_ = x;  y_ = y;  z_ = z; }

    // get coordinates
    int x () const  { return x_; }
    int y () const  { return y_; }
    int z () const  { return z_; }
    // update boundig box
    void updateBoundings (Point3i& min, Point3i& max) const;
    // cross product: u x v
    static Point3i cross (const Point3i& u, const Point3i& v);
    // apply linear transformation to this, write result into to (no alias address!)
    void xform (const Point3i& nx, const Point3i& ny, const Point3i& nz, Point3i* to) const;
    // apply translation to this, write result into to
    void translate (int dx, int dy, int dz, Point3i& to) const
    { to.x_ = x_+dx;  to.y_ = y_+dy;  to.z_ = z_+dz; }

  private:
    int x_, y_, z_;
};
