#include "puzzle.h"
#include "global.h"

/* Aufbauen der einzelnen Teile
 *
 */
static struct teil *tt;
static int tc;
static ull bitpos[5][4][3];

struct teil teil[12];

/* Hilfsfunktion um zu jeder Quader-Koordinate die Bitmaske
 * zu erstellen
 */
static void setup_bitpos(void)
{
	int i,j,k;
	for ( k = 0 ; k < 3 ; k++ )
		for ( j = 0 ; j < 4 ; j++ )
			for ( i = 0 ; i < 5 ; i++ )
				bitpos[i][j][k] = ((ull)1) << ( i + 5 * j + 20 * k );
}

/* Ein teil in genau einer Orientierung wird an alle mglichen
 * Positionen im Quader verschoben.
 */
static void verschieben(ull bm,intd d)
{
	int i,j,k,o;
	for ( k = 0 ; k <= 3 - d[2] ; k++ )
		for ( j = 0 ; j <= 4 - d[1] ; j++ )
			for ( i = 0 ; i <= 5 - d[0] ; i++ )
			{
				o = 20 * k + 5 * j + i;
				tt->platzWert[tt->anzahlPlatzWert++] = bm << o;
			}
}
/* Ermitteln der Basis-Bitmasken, wenn das teil in der 0-Ecke liegt.
 * Dabei Doubletten durch Symetrien aussortieren
 */
static void basiswert (chrf t,intd d)
{
	ull bm = 0;
	int i,j,k;
	/* Bitmaske bestimmen */
	for ( k = 0 ; k < d[2] ; k++ )
		for ( j = 0 ; j < d[1] ; j++ )
			for ( i = 0 ; i < d[0] ; i++ )
				if ( t[i][j][k] == '#' )
					bm |= bitpos[i][j][k];
	/* Nach doubletten suchen */
	for ( i = 0 ; i < tt->anzahlBasisWert ; i++ )
		if ( bm == tt->basisWert[i] )
			return;
	/* Eintragen */
	tt->basisWert[i] = bm;
	tt->anzahlBasisWert++;
	/* alle verschiebungen durchfhren */
	verschieben(bm,d);
}
/* Rotieren eines gedrehten Teils um die z-Achse */
static void rotieren(chrf t0,intd d0,int halb)
{
	int i,j,k;
	chrf t1;
	chrf t2;
	chrf t3;
	intd d1;
	intd d2;
	intd d3;

	basiswert(t0,d0);

	d1[0] = d0[1];
	d1[1] = d0[0];
	d1[2] = d0[2];
	memset(t1,0,sizeof t1);
	for ( k = 0 ; k < d0[2] ; k++ )
		for ( j = 0 ; j < d0[1] ; j++ )
			for ( i = 0 ; i < d0[0] ; i++ )
				t1[d0[1]-1-j][i][k] = t0[i][j][k];
	basiswert(t1,d1);

	if ( halb )
		return;

	d2[0] = d1[1];
	d2[1] = d1[0];
	d2[2] = d1[2];
	memset(t2,0,sizeof t2);
	for ( k = 0 ; k < d1[2] ; k++ )
		for ( j = 0 ; j < d1[1] ; j++ )
			for ( i = 0 ; i < d1[0] ; i++ )
				t2[d1[1]-1-j][i][k] = t1[i][j][k];
	basiswert(t2,d2);

	d3[0] = d2[1];
	d3[1] = d2[0];
	d3[2] = d2[2];
	memset(t3,0,sizeof t3);
	for ( k = 0 ; k < d2[2] ; k++ )
		for ( j = 0 ; j < d2[1] ; j++ )
			for ( i = 0 ; i < d2[0] ; i++ )
				t3[d2[1]-1-j][i][k] = t2[i][j][k];
	basiswert(t3,d3);
}
#define d0 t->boundingBox
#define t0 t->beschreibung

/* Funktion um ein Teil in alle 6 Basisrichtungen zu drehen,
 * berlange Teile werden nicht aufgerichtet
 */
static int dreher(struct teil *t)
{
	chrf t1;
	intd d1;
	int l;
	int i,j,k;

	tt = t;
	tc = 0;

	rotieren(t0,d0,0);

	for ( l = 0 ; l < 3 ; l++ )
	{
		for ( k = 0 ; k < d0[2] ; k++ )
			for ( j = 0 ; j < d0[1] ; j++ )
				for ( i = 0 ; i < d0[0] ; i++ )
					t1[i][d0[2]-1-k][j] = t0[i][j][k];
		d1[0] = d0[0];
		d1[1] = d0[2];
		d1[2] = d0[1];
		memcpy(d0,d1,sizeof d0);
		memcpy(t0,t1,sizeof t0);
		rotieren(t0,d0,0);
	}
	if ( t->boundingBox[0] < 4 ) 
		for ( l = 0 ; l < 3 ; l++ )
		{
			for ( k = 0 ; k < d0[2] ; k++ )
				for ( j = 0 ; j < d0[1] ; j++ )
					for ( i = 0 ; i < d0[0] ; i++ )
						t1[k][j][d0[0]-1-i] = t0[i][j][k];
			d1[0] = d0[2];
			d1[1] = d0[1];
			d1[2] = d0[0];
			memcpy(d0,d1,sizeof d0);
			memcpy(t0,t1,sizeof t0);
			//if ( l != 1 )
				rotieren(t0,d0,0);
		}
}
/* Spezialversion von dreher fr Teil 1 in der Variante mit c't Logo
 */
static int dreher_1(struct teil *t)
{
	chrf t1;
	intd d1;
	int l;
	int i,j,k;

	tt = t;
	tc = 0;

	rotieren(t0,d0,0);

	for ( l = 0 ; l < 3 ; l++ )
	{
		for ( k = 0 ; k < d0[2] ; k++ )
			for ( j = 0 ; j < d0[1] ; j++ )
				for ( i = 0 ; i < d0[0] ; i++ )
					t1[k][j][d0[0]-1-i] = t0[i][j][k];
		d1[0] = d0[2];
		d1[1] = d0[1];
		d1[2] = d0[0];
		memcpy(d0,d1,sizeof d0);
		memcpy(t0,t1,sizeof t0);
		rotieren(t0,d0,0);
	}
}
/* Spezialversion von dreher fr die nicht-Logo-Variante.
 * Es werden nur drei von sechs Ausrichtungen erzeugt
 */
static int dreher_6(struct teil *t)
{
	chrf t1;
	intd d1;
	int l;
	int i,j,k;

	tt = t;
	tc = 0;

	rotieren(t0,d0,1);

	for ( k = 0 ; k < d0[2] ; k++ )
		for ( j = 0 ; j < d0[1] ; j++ )
			for ( i = 0 ; i < d0[0] ; i++ )
				t1[i][d0[2]-1-k][j] = t0[i][j][k];
	d1[0] = d0[0];
	d1[1] = d0[2];
	d1[2] = d0[1];
	rotieren(t1,d1,1);

	if ( t->boundingBox[0] < 4 ) 
	{
		for ( k = 0 ; k < d0[2] ; k++ )
			for ( j = 0 ; j < d0[1] ; j++ )
				for ( i = 0 ; i < d0[0] ; i++ )
					t1[k][j][d0[0]-1-i] = t0[i][j][k];
		d1[0] = d0[2];
		d1[1] = d0[1];
		d1[2] = d0[0];
		rotieren(t1,d1,1);
	}
}

/* Definition der einzelnen Teile
 */
void setup_teile(int logo,int nur1)
{
	setup_bitpos();

	/* Teil  a = ###
	 * flach     #.#     Mit c
	 */
	teil[ 0].code = 'a';
	teil[ 0].beschreibung[0][0][0] = '#';
	teil[ 0].beschreibung[1][0][0] = '#';
	teil[ 0].beschreibung[2][0][0] = '#';
	teil[ 0].beschreibung[0][1][0] = '#';
	teil[ 0].beschreibung[1][1][0] = '.';
	teil[ 0].beschreibung[2][1][0] = '#';
	teil[ 0].boundingBox[0] = 3;
	teil[ 0].boundingBox[1] = 2;
	teil[ 0].boundingBox[2] = 1;
	teil[ 0].logoWert = 1LL<<56|1LL<<55|1LL<<50|1LL<<46|1LL<<45;
	dreher(teil+ 0);

	/* Teil  b = ##.
	 * flach     .#.
	 *           .##      Mit '
	 */
	teil[ 1].code = 'b';
	teil[ 1].beschreibung[0][0][0] = '#';
	teil[ 1].beschreibung[1][0][0] = '#';
	teil[ 1].beschreibung[2][0][0] = '.';
	teil[ 1].beschreibung[0][1][0] = '.';
	teil[ 1].beschreibung[1][1][0] = '#';
	teil[ 1].beschreibung[2][1][0] = '.';
	teil[ 1].beschreibung[0][2][0] = '.';
	teil[ 1].beschreibung[1][2][0] = '#';
	teil[ 1].beschreibung[2][2][0] = '#';
	teil[ 1].boundingBox[0] = 3;
	teil[ 1].boundingBox[1] = 3;
	teil[ 1].boundingBox[2] = 1;
	teil[ 1].logoWert = 1LL<<47|1LL<<42|1LL<<27|1LL<<7|1LL<<12;
	if ( logo )
		dreher_1(teil+ 1);
	else
		dreher(teil+ 1);

	/* Teil  c = ####
	 * flach     #...
	 */
	teil[ 2].code = 'c';
	teil[ 2].beschreibung[0][0][0] = '#';
	teil[ 2].beschreibung[1][0][0] = '#';
	teil[ 2].beschreibung[2][0][0] = '#';
	teil[ 2].beschreibung[3][0][0] = '#';
	teil[ 2].beschreibung[0][1][0] = '#';
	teil[ 2].beschreibung[1][1][0] = '.';
	teil[ 2].beschreibung[2][1][0] = '.';
	teil[ 2].beschreibung[3][1][0] = '.';
	teil[ 2].boundingBox[0] = 4;
	teil[ 2].boundingBox[1] = 2;
	teil[ 2].boundingBox[2] = 1;
	teil[ 2].logoWert = 0;
	dreher(teil+ 2);

	/* Teil  d = ####
	 * flach     .#..
	 */
	teil[ 3].code = 'd';
	teil[ 3].beschreibung[0][0][0] = '#';
	teil[ 3].beschreibung[1][0][0] = '#';
	teil[ 3].beschreibung[2][0][0] = '#';
	teil[ 3].beschreibung[3][0][0] = '#';
	teil[ 3].beschreibung[0][1][0] = '.';
	teil[ 3].beschreibung[1][1][0] = '#';
	teil[ 3].beschreibung[2][1][0] = '.';
	teil[ 3].beschreibung[3][1][0] = '.';
	teil[ 3].boundingBox[0] = 4;
	teil[ 3].boundingBox[1] = 2;
	teil[ 3].boundingBox[2] = 1;
	teil[ 3].logoWert = 0;
	dreher(teil+ 3);

	/* Teil  e = ##  #.  Keinerlei Symetrieachsen !!
	 * 3d      = #.  #.  Mit '
	 */
	teil[ 4].code = 'e';
	teil[ 4].beschreibung[0][0][0] = '#';
	teil[ 4].beschreibung[0][1][0] = '#';
	teil[ 4].beschreibung[1][0][0] = '#';
	teil[ 4].beschreibung[1][1][0] = '.';
	teil[ 4].beschreibung[0][0][1] = '#';
	teil[ 4].beschreibung[0][1][1] = '#';
	teil[ 4].beschreibung[1][0][1] = '.';
	teil[ 4].beschreibung[1][1][1] = '.';
	teil[ 4].boundingBox[0] = 2;
	teil[ 4].boundingBox[1] = 2;
	if ( logo )
		teil[ 4].boundingBox[2] = 3;
	else
		teil[ 4].boundingBox[2] = 2;
	teil[ 4].logoWert = 1LL<<47|1LL<<42|1LL<<27|1LL<<22|1LL<<28;
	dreher(teil+ 4);

    /* Teil  f = ###
	 * flach   = .#.
	 *         = .#.
	 */
	teil[ 5].code = 'f';
	teil[ 5].beschreibung[0][0][0] = '#';
	teil[ 5].beschreibung[1][0][0] = '#';
	teil[ 5].beschreibung[2][0][0] = '#';
	teil[ 5].beschreibung[0][1][0] = '.';
	teil[ 5].beschreibung[1][1][0] = '#';
	teil[ 5].beschreibung[2][1][0] = '.';
	teil[ 5].beschreibung[0][2][0] = '.';
	teil[ 5].beschreibung[1][2][0] = '#';
	teil[ 5].beschreibung[2][2][0] = '.';
	teil[ 5].boundingBox[0] = 3;
	teil[ 5].boundingBox[1] = 3;
	teil[ 5].boundingBox[2] = 1;
	teil[ 5].logoWert = 0;
	dreher(teil+ 5);

	/* Teil  g = ###
	 * flach     ##.
	 */
	teil[ 6].code = 'g';
	teil[ 6].beschreibung[0][0][0] = '#';
	teil[ 6].beschreibung[1][0][0] = '#';
	teil[ 6].beschreibung[2][0][0] = '#';
	teil[ 6].beschreibung[0][1][0] = '#';
	teil[ 6].beschreibung[1][1][0] = '#';
	teil[ 6].beschreibung[2][1][0] = '.';
	teil[ 6].boundingBox[0] = 3;
	teil[ 6].boundingBox[1] = 2;
	teil[ 6].boundingBox[2] = 1;
	teil[ 6].logoWert = 0;
	if ( logo )
		dreher(teil+ 6);
	else
		dreher_6(teil+ 6);

	/* Teil  h = ##.
	 * flach     .##
	 *           ..#
	 */
	teil[ 7].code = 'h';
	teil[ 7].beschreibung[0][0][0] = '#';
	teil[ 7].beschreibung[1][0][0] = '#';
	teil[ 7].beschreibung[2][0][0] = '.';
	teil[ 7].beschreibung[0][1][0] = '.';
	teil[ 7].beschreibung[1][1][0] = '#';
	teil[ 7].beschreibung[2][1][0] = '#';
	teil[ 7].beschreibung[0][2][0] = '.';
	teil[ 7].beschreibung[1][2][0] = '.';
	teil[ 7].beschreibung[2][2][0] = '#';
	teil[ 7].boundingBox[0] = 3;
	teil[ 7].boundingBox[1] = 3;
	teil[ 7].boundingBox[2] = 1;
	teil[ 7].logoWert = 0;
	dreher(teil+ 7);

	/* Teil  i = ## #.
	 * 3d        .. #.  Mit '
	 */
	teil[ 8].code = 'i';
	teil[ 8].beschreibung[0][0][0] = '#';
	teil[ 8].beschreibung[1][0][0] = '#';
	teil[ 8].beschreibung[0][1][0] = '.';
	teil[ 8].beschreibung[1][1][0] = '.';
	teil[ 8].beschreibung[0][0][1] = '#';
	teil[ 8].beschreibung[1][0][1] = '.';
	teil[ 8].beschreibung[0][1][1] = '#';
	teil[ 8].beschreibung[1][1][1] = '.';
	teil[ 8].boundingBox[0] = 2;
	teil[ 8].boundingBox[1] = 2;
	teil[ 8].boundingBox[2] = 2;
	teil[ 8].logoWert = 1LL<<47|1LL<<42|1LL<<22|1LL<<23;
	dreher(teil+ 8);

	/* Teil  j = ##.
	 * flach     .##
	 *           .#.
	 */
	teil[ 9].code = 'j';
	teil[ 9].beschreibung[0][0][0] = '#';
	teil[ 9].beschreibung[1][0][0] = '#';
	teil[ 9].beschreibung[2][0][0] = '.';
	teil[ 9].beschreibung[0][1][0] = '.';
	teil[ 9].beschreibung[1][1][0] = '#';
	teil[ 9].beschreibung[2][1][0] = '#';
	teil[ 9].beschreibung[0][2][0] = '.';
	teil[ 9].beschreibung[1][2][0] = '#';
	teil[ 9].beschreibung[2][2][0] = '.';
	teil[ 9].boundingBox[0] = 3;
	teil[ 9].boundingBox[1] = 3;
	teil[ 9].boundingBox[2] = 1;
	teil[ 9].logoWert = 0;
	dreher(teil+ 9);

	/* Teil  k = .#.
	 * flach     ###
	 *           .#.
	 */
	teil[10].code = 'k';
	teil[10].beschreibung[0][0][0] = '.';
	teil[10].beschreibung[1][0][0] = '#';
	teil[10].beschreibung[2][0][0] = '.';
	teil[10].beschreibung[0][1][0] = '#';
	teil[10].beschreibung[1][1][0] = '#';
	teil[10].beschreibung[2][1][0] = '#';
	teil[10].beschreibung[0][2][0] = '.';
	teil[10].beschreibung[1][2][0] = '#';
	teil[10].beschreibung[2][2][0] = '.';
	teil[10].boundingBox[0] = 3;
	teil[10].boundingBox[1] = 3;
	teil[10].boundingBox[2] = 1;
	teil[10].logoWert = 0;
	dreher(teil+10);

	/* Teil  l = ####
	 * flach     .#.#   Mit t
	 */
	teil[11].code = 'l';
	teil[11].beschreibung[0][0][0] = '#';
	teil[11].beschreibung[1][0][0] = '#';
	teil[11].beschreibung[2][0][0] = '#';
	teil[11].beschreibung[3][0][0] = '#';
	teil[11].beschreibung[0][1][0] = '.';
	teil[11].beschreibung[1][1][0] = '#';
	teil[11].beschreibung[2][1][0] = '.';
	teil[11].beschreibung[3][1][0] = '#';
	teil[11].boundingBox[0] = 4;
	teil[11].boundingBox[1] = 2;
	teil[11].boundingBox[2] = 1;
	teil[11].logoWert = 1LL<<59|1LL<<58|1LL<<53|1LL<<49|1LL<<48|1LL<<43;
	dreher(teil+11);
}
