//**noelte*28.04.2003*************************************************************************//
// Programm zur Bestimmung smtlicher Lsungen fr das CT-Puzzle (Ausgabe 7/03 Seite 230)     //
// unter Ausschlu der Lsungen, die durch die Rotation des gesamten Quaders entstehen        //
//                                                                                            //
// Zielplattform: P4 512MB Hyperthreading  - Windows XP                                       //
//                                                                                            //
// Ideen:                                                                                     //
//        1) Wahl des Puzzleteiles, dessen Positionen, die durch Rotation des Quaders ent-    //
//           stehen, ignoriert werden.                                                        //
//           Von den Teilen, die durch Rotation entstanden sind, wird das Teil gewhlt, da   //
//           im Quader am weitesten 'hinten' liegt und somit in der Rekursion nur selten      //
//           getestet werden mu.                                                             //
//                                                                                            //
//        2) X-Trick                                                                          //
//           Im Gegensatz zu dem Ansatz, in dem von einem leeren Quader ausgegangen wird,     //
//           startet man hier mit einem vorgefllten Quader. Hierzu wird zu Beginn das        //
//           Puzzleteil ermittelt, da in dem Quader die wenigsten Positionierungs-           //
//           mglichkeiten besitzt. In diesem Fall ist es das X-Teil mit 40 Positionen.       //
//                                                                                            //
//        2.1) Vorwrts/Rckwrts                                                             //
//             Wenn ein vorgefllter Quader verwendet wird, sollte die Fllrichtung gewhlt   //
//             werden, die am schnellsten auf das Puzzleteil trifft, das initial im Quader    //
//             gesetzt wurde. Da jedoch durch 1) mehr Puzzleteile im hinteren Teil des        //
//             Quaders liegen, sollte also auch nicht bei Bit 30, sondern erst etwas spter   //
//             (30+(30/4)) = 37.5 umgeschaltet werden. Ich flle den Quader also von hinten,  //
//             wenn das Zentrum MinBit+(MaxBit-MinBit)/2 > 37 ist.                            //
//                                                                                            //
//        3) Fllen des Quaders                                                               //
//           Grundstzlich flle ich den Quader immer am nchsten freien Bit. Dazu werden     //
//           fr jedes Teil die Positionen bestimmt, die ein bestimmtes freies Bit fllen.    //
//           Da alle vorherigen Bits schon gefllt sind, werden nur die Positionen gelistet,  //
//           die kein kleiners Bit fllen.                                                    //
//                                                                                            //
//        4) 32/64 Bit                                                                        //
//           Da wir leider keinen 64Bit Rechner als Zielplattform haben, sollte man nur       //
//           solange mit 64Bit Werten rechnen, wie es notwendig ist. D.h. wenn nur noch       //
//           die letzten 32Bit gefllt werden mssen, wird auf eine 32Bit-Version geschwenkt. //
//           Wenn von vorne gefllt wird ist das Bit4 das erste Bit (4-63) und rckwrts      //
//           geht's dann von 59-0. Das hat den Vorteil, das im Vorwrtsgang an der Grenze     //
//           nicht geshiftet werden mu.                                                      //
//                                                                                            //
//        5) Lcher                                                                           //
//           Wenn ich ein Teil anlege, suche ich nach Lchern, die durch das aktuelle Teil    //
//           erzeugt worden sein knnten. Lcher knnen durch kein Teil gefllt werden. Der   //
//           Zeitgewinn durch Vermeidung unntiger Rekursionen verschlechtert sich, je mehr   //
//           Teile bereits gelegt wurden. Daher bietet es sich an, das in der 32Bit-Rekursion //
//           nicht mehr auf Lcher getestet wird.                                             //
//                                                                                            //
//        6) Verwaltung freier Teile                                                          //
//           Eine Mglichkeit der Verwaltung freier Teile beteht darin, die bereits           //
//           verwendeten Teile in einem Bitfeld zu markieren. Allerdings mu dann immerwieder //
//           nach einer freien Stelle gesucht werden und fr die nchste Rekursion das        //
//           entsprechende Bit gesetzt werden. Meine Alternative speichert fr jedes Teil eine//
//           List der Teile, die, wenn das Teil verwendet wird, noch verfgbar sind. Dadurch  //
//           braucht kein freies Teil mehr gesucht werden und wenn die Liste leer ist, hat    //
//           man alle Teile verwendet.                                                        //
//                                                                                            //
// Kritikpunkte:                                                                              //
//        1) Idee 1 - Da die Wahl des Teils deutliche Auswirkungen hat.                       //
//           Allerdings mu man ja eines whlen. Alternativ wre Bewertung der einzelnen      //
//           Algorithmen mglich, wenn keine Symmetrien ausgeschlossen werden. Das war aber   //
//           nicht die Aufgabe.                                                               //
//                                                                                            //
//        2) Idee 2.1 - Da die Grenze unscharf ist sollte hier auch mglichst geschickt       //
//           gewhlt werden. Ist allerdings im Wesentlichen eine Folge von 1).                //
//           In meinen Augen ist jedoch die explizite Wahl der Fllrichtung pro Position      //
//           unfair. Es gibt z.B. zwei Positionen des X-Teils, die im vorderen Teil des       //
//           Quaders liegen, jedoch durch den reversen Algorithmus schneller durchlaufen      //
//           werden.                                                                          //
//                                                                                            //
// Ronald Nlte (noelte@web.de)                                                               //
//********************************************************************************************//

#define BUILD_FINAL_RELEASE  // nur noch minimale Ausgabe und Zhler
#define MULTI_THREAD         // Verwendung zweier Threads






#ifdef MULTI_THREAD
#include <windows.h>
#include <process.h>
#endif

#include <sys/types.h>
#include <sys/timeb.h>
#include <time.h>

#include <stdio.h>
#include <stdlib.h>
#include <memory.h>
#include <malloc.h>


#define BOOL int
#define TRUE 1
#define FALSE 0


#ifdef BUILD_FINAL_RELEASE
#define EXCL_AT_FR(a)
#else
#define EXCL_AT_FR(a) a
#endif

#ifdef MULTI_THREAD
CRITICAL_SECTION CriticalSection; 
#endif

void *g_arMallocs[50000];
int g_nMallocs=0;

inline void *Malloc(unsigned long nSize)
{
  return g_arMallocs[g_nMallocs++]=malloc(nSize);
  //return g_arMallocs[g_nMallocs++]=_aligned_malloc(nSize,16);
}

inline void CleanUp()
{
  for(int i=0;i<g_nMallocs;i++)
    free(g_arMallocs[i]);
    //_aligned_free(g_arMallocs[i]);
}

clock_t g_nStartTime;

char g_sSpace[81]="                                                                                ";

const int g_nNumParts =12;
const int g_nDimX=3;
const int g_nDimY=4;
const int g_nDimZ=5;
const int g_nMaxRot       = 4*4*4;
const int g_nMaxTrans     = 2000;
const int g_nMaxCheckHole = 200;

int g_nNumPartIgnoreSym=6;

int g_nNumPartPos[g_nNumParts];

struct DEFRot_
{
  char    nDimX,nDimY,nDimZ;
  __int64 nQuader444;
};

struct CHECK_HOLE 
{
  __int64 nSolid,nHole;
};

struct FILLS_HOLE
{
  __int64     nQuader;
  CHECK_HOLE  *parCheckHole;
  int nNextBit;
};

struct FILLS_HOLE32
{
  int nQuader;
  int nNextBit;
};

typedef struct DEFPart_
{
  FILLS_HOLE      *parFillsHole         [64];
  __int64         arUsedByAll           [64];

  FILLS_HOLE32    *parFillsHole28_59    [64];
  unsigned int    arUsedByAll28_59      [64];


  FILLS_HOLE      *parFillsHoleRev      [64];
  __int64         arUsedByAllRev        [64];

  FILLS_HOLE32    *parFillsHoleRev0_31  [64];
  unsigned int    arUsedByAllRev0_31    [64];


  unsigned int    nNumTrans;
  __int64         *parTrans;

} DEFPart;

union my__int64
{
  __int64 i64;
  struct {unsigned short ll,lh,hl,hh;}s;
  struct {unsigned int l,h;} i;
};

__int64 g_arQuader[64];
__int64 g_arNotIn [64];

__int64  g_arStar    [64];
__int64  g_arStarHole[64];

int g_arQuader0_31__32_63[64];


DEFPart g_arParts[g_nNumParts+1];

struct DEFPartNotUsed_
{
  DEFPart         *pPart;
  DEFPartNotUsed_ *pNotUsed;
} *g_pExtParts;

inline int compareInt(const void *arg1,const void *arg2)
{ 
  if  (*(int*)arg1<*(int*)arg2) return -1;
  else
    if(*(int*)arg1>*(int*)arg2) return  1;
    else                        return  0;
}

inline int compareI64(const void *arg1,const void *arg2 )
{
  if  ((*(__int64*)arg1) < (*(__int64*)arg2))  return -1;
  else
    if((*(__int64*)arg1) > (*(__int64*)arg2))  return  1;
    else                                       return  0;
}

inline void print_bits(__int64 nQ){for(int i=0;i<64;i++){printf(nQ&((__int64)1<<63)?"1":"0");nQ<<=1;}}
inline void print_bits(int     nQ){for(int i=0;i<32;i++){printf(nQ&((__int64)1<<31)?"1":"0");nQ<<=1;}}

inline int ClearBit(const int nBitField,int nNumBit)
{
  int nH=1;

  do
  {
    if(nBitField&nH)
      if(!nNumBit)
        return nBitField&~nH;
      else
        nNumBit--;

    nH<<=1;
  }
  while(nH);

  return 0;
}

inline __int64 ClearBit(const __int64 &i64,int nNumBit)
{
  __int64 nH=(__int64)1;

  do
  {
    if(i64&nH)
      if(!nNumBit)
        return i64&~nH;
      else
        nNumBit--;

    nH<<=1;
  }
  while(nH);

  return (__int64)0;
}

inline __int64 GetBit(__int64 i64,int nNumBit)
{
  int nC=0; 

  do
  {
    if(i64&1)
    {
      if(!nNumBit)
        return (__int64)1<<nC;
      nNumBit--;
    }
    nC++;i64>>=1;
  }while(i64);

  return 0;
}

inline int MinBit(__int64 nQ)
{
  int nI=0;
  while(nI<60)
  {
    if(nQ&((__int64)1<<nI))
      return nI;
    nI++;
  }
  return nI;
}

inline int MaxBit(__int64 nQ)
{
  int nI=60;
  while(nI>=0)
  {
    if(nQ&((__int64)1<<nI))
      return nI;
    nI--;
  }
  return nI;
}

inline int BitCentre(__int64 nQ) {return MinBit(nQ)+(MaxBit(nQ)-MinBit(nQ));}


inline int FirstNullBit(  int   nValue,int nF) {while(nF<32 && (nValue&(         1<<nF))) nF++;return nF;}
inline int FirstNullBit(__int64 nValue,int nF) {while(nF<64 && (nValue&((__int64)1<<nF))) nF++;return nF;}


inline int FirstNullBitRev(  int   nValue,int nF) {while(nF>=0 && (nValue&(         1<<nF))) nF--;return nF;}
inline int FirstNullBitRev(__int64 nValue,int nF) {while(nF>=0 && (nValue&((__int64)1<<nF))) nF--;return nF;}

DEFPartNotUsed_ *g_arPartNotUsed[1<<12];

DEFPartNotUsed_ *_InitExtParts(unsigned int nLvl,int nBitField)
{
  DEFPartNotUsed_ *pExtParts = (DEFPartNotUsed_*)Malloc((nLvl+1)*sizeof(DEFPartNotUsed_));
  int i,nB;
 
  memset(pExtParts,0,(nLvl+1)*sizeof(DEFPartNotUsed_));

  if(nLvl>0)
  {
    for(i=0,nB=0;i<nLvl;i++,nB++)
    {
      while(nB<12 && !(nBitField&(1<<nB)))
        nB++;

      pExtParts[i].pPart    = &g_arParts[nB];

      if(nLvl-1==0)
        pExtParts[i].pNotUsed=NULL;
      else
      {
        if(!g_arPartNotUsed[nBitField&~(1<<nB)])
          g_arPartNotUsed[nBitField&~(1<<nB)] = _InitExtParts(nLvl-1,nBitField&~(1<<nB));

        pExtParts[i].pNotUsed = g_arPartNotUsed[nBitField&~(1<<nB)];
      }
    }
  }
  return pExtParts;
}

#define XYZ444(x,y,z) ((x)+4*((y)+4*(z)))

#define XYZ(x,y,z) ((x)+g_nDimX*((y)+g_nDimY*(z)))
#define YZ(y,z) (g_nDimX*((y)+g_nDimY*(z)))

#define SetRot(a,q,x,y,z) a.nQuader444=q;a.nDimX=x;a.nDimY=y;a.nDimZ=z;

#define Set(a,bit) ((a)|=(__int64)1<<(bit))
#define Get(a,bit) (((a)>>bit)&1)

void Display(__int64 nQuader)
{
  int y,z;
  __int64 nRow;
  for(z=g_nDimZ-1;z>=0;z--)
    for(y=g_nDimY-1;y>=0;y--)
    {
      nRow = (nQuader>>YZ(y,z)) & 31;
      printf("%s%d%d%d\n",&g_sSpace[sizeof(g_sSpace)-z*5],(nRow&1)?1:0,(nRow&2)?1:0,(nRow&4)?1:0);
    }
}

inline void RotateX90 (const DEFRot_ &s,DEFRot_ &d)
{ int x,y,z;
  
  for(x=0;x<s.nDimX;x++) for(y=0;y<s.nDimY;y++) for(z=0;z<s.nDimZ;z++) 
    if(Get(s.nQuader444,XYZ444(x,y,z))) Set(d.nQuader444,XYZ444(x,s.nDimZ-1-z,          y));
  d.nDimX=s.nDimX;d.nDimY=s.nDimZ;d.nDimZ=s.nDimY;
}

inline void RotateY90 (const DEFRot_ &s,DEFRot_ &d)
{ int x,y,z;
  for(x=0;x<s.nDimX;x++) for(y=0;y<s.nDimY;y++) for(z=0;z<s.nDimZ;z++) 
    if(Get(s.nQuader444,XYZ444(x,y,z))) Set(d.nQuader444,XYZ444(          z,y,s.nDimX-1-x));

  d.nDimX=s.nDimZ;d.nDimY=s.nDimY;d.nDimZ=s.nDimX;
}

inline void RotateZ90 (const DEFRot_ &s,DEFRot_ &d)
{ int x,y,z;
  for(x=0;x<s.nDimX;x++) for(y=0;y<s.nDimY;y++) for(z=0;z<s.nDimZ;z++) 
    if(Get(s.nQuader444,XYZ444(x,y,z)))  Set(d.nQuader444,XYZ444(          y,s.nDimX-1-x,z));

  d.nDimX=s.nDimY;d.nDimY=s.nDimX;d.nDimZ=s.nDimZ;
}

inline void MoveX(__int64 &d,const __int64 &s,int w){int x,y,z; for(x=w;x<g_nDimX;x++) for(y=0;y<g_nDimY;y++) for(z=0;z<g_nDimZ;z++) if(Get(s,XYZ(x-w,y  ,z  ))) Set(d,XYZ(x,y,z));}
inline void MoveY(__int64 &d,const __int64 &s,int w){int x,y,z; for(x=0;x<g_nDimX;x++) for(y=w;y<g_nDimY;y++) for(z=0;z<g_nDimZ;z++) if(Get(s,XYZ(x  ,y-w,z  ))) Set(d,XYZ(x,y,z));}
inline void MoveZ(__int64 &d,const __int64 &s,int w){int x,y,z; for(x=0;x<g_nDimX;x++) for(y=0;y<g_nDimY;y++) for(z=w;z<g_nDimZ;z++) if(Get(s,XYZ(x  ,y  ,z-w))) Set(d,XYZ(x,y,z));}

inline void _444ToXYZ(__int64 &d,const __int64 &s){int x,y,z; for(x=0;x<g_nDimX;x++) for(y=0;y<g_nDimY;y++) for(z=0;z<g_nDimZ;z++) if(Get(s,XYZ444(x,y,z))) Set(d,XYZ(x,y,z));}

inline void MoveXYZ(__int64 &d,const __int64 &s,int dx,int dy,int dz){int x,y,z; for(x=dx;x<g_nDimX;x++) for(y=dy;y<g_nDimY;y++) for(z=dz;z<g_nDimZ;z++) if(Get(s,XYZ(x-dx,y-dy,z-dz))) Set(d,XYZ(x,y,z));}

#define SetB(a,x,y,z) {if(0<=x && x<g_nDimX && 0<=y && y<g_nDimY && 0<=z && z<g_nDimZ) Set(a,XYZ(x,y,z));}

void InitStar()
{
  memset(g_arStar,0,sizeof(g_arStar));
  
  int x,y,z,nH;
  for(z=0;z<g_nDimZ;z++)
    for(y=0;y<g_nDimY;y++)
      for(x=0;x<g_nDimX;x++)
      {
        nH=XYZ(x,y,z);
        SetB(g_arStarHole[nH],x-1,y  ,z  );
        SetB(g_arStarHole[nH],x+1,y  ,z  );

        SetB(g_arStarHole[nH],x  ,y-1,z  );
        SetB(g_arStarHole[nH],x  ,y+1,z  );

        SetB(g_arStarHole[nH],x  ,y  ,z-1);
        SetB(g_arStarHole[nH],x  ,y  ,z+1);

        g_arStar[nH] = g_arStarHole[nH];
        SetB(g_arStar[nH],x  ,y  ,z  );
      }
}

BOOL CompareByRot(const __int64 &l,const __int64 &r,int ax,int ay,int az)
{
  int x,y,z;

  for(x=0;x<g_nDimX;x++) for(y=0;y<g_nDimY;y++) for(z=0;z<g_nDimZ;z++) 
    if(Get(l,XYZ(x,y,z))^Get(r,XYZ(ax?g_nDimX-1-x:x,ay?g_nDimY-1-y:y,az?g_nDimZ-1-z:z)))
      return 0;
  return l<r;
}

inline __int64 BuildRot(const __int64 &org,int ax,int ay,int az)
{
  int x,y,z;__int64 nRot = (__int64)0;

  for(x=0;x<g_nDimX;x++) for(y=0;y<g_nDimY;y++) for(z=0;z<g_nDimZ;z++) 
    if(Get(org,XYZ(x,y,z)))
      Set(nRot,XYZ(ax?g_nDimX-1-x:x,ay?g_nDimY-1-y:y,az?g_nDimZ-1-z:z));
  
  return nRot;
}

inline BOOL LookFor(const __int64 &o,const __int64 *pT)
{
  while(*pT)
    if(*pT++ == o)
      return TRUE;
  return FALSE;
}

BOOL FindSym(const __int64 &o,const __int64 *pT)
{
  __int64 nRot;

  nRot=BuildRot(o,1,1,0); 
  if(   LookFor(nRot,pT) 
     && (    ((o&-o)< (nRot&-nRot))
         || (((o&-o)==(nRot&-nRot)) && o<nRot)))
     return FALSE;
  nRot=BuildRot(o,1,0,1); 
  if(   LookFor(nRot,pT) 
     && (    ((o&-o)< (nRot&-nRot))
         || (((o&-o)==(nRot&-nRot)) && o<nRot)))
     return FALSE;
  nRot=BuildRot(o,0,1,1); 
  if(   LookFor(nRot,pT) 
     && (    ((o&-o)< (nRot&-nRot))
         || (((o&-o)==(nRot&-nRot)) && o<nRot)))
     return FALSE;

  return TRUE;
}

void CalcFillsHole(DEFPart_ &nPart,const __int64 *pTranslation,BOOL bIgnoreSyms=FALSE)
{
  const __int64 *pT=pTranslation;

  __int64 arFillsHole[60][200];
  int nPartIndex,b,j,nCountFH[60];

  int arFillsHole28_59[60][200];
  int nCountFH28_59[60];

  __int64 arUsedByAll[60];

  memset(arFillsHole,0,sizeof(arFillsHole));
  memset(nCountFH,0,sizeof(nCountFH));
  memset(arUsedByAll,-1,sizeof(arUsedByAll));

  memset(arFillsHole28_59,0,sizeof(arFillsHole28_59));
  memset(nCountFH28_59,0,sizeof(nCountFH28_59));

  for(nPartIndex=0;nPartIndex<12;nPartIndex++)
    if(&nPart==&g_arParts[nPartIndex])
      break;

  while(*pT)
  {
    if(!bIgnoreSyms || FindSym(*pT,pTranslation))
    { 
      for(b=0;b<60;b++)
        if(g_arQuader[b] & (*pT))
          if(!(g_arNotIn[b] &(*pT)))
          {
            if(!nCountFH[b])  arUsedByAll[b]=(*pT);
            else              arUsedByAll[b]&=(*pT);

            arFillsHole[b][nCountFH[b]++]=(*pT);
            if(b>=28)
              arFillsHole28_59[b][nCountFH28_59[b]++]=((*pT)<<4)>>32; // obere 32bit
          }
    }
    pT++;
  }

  for(b=0;b<60;b++)
  {
    nPart.arUsedByAll     [b+4] = arUsedByAll[b]<<4;
    nPart.parFillsHole    [b+4] = (FILLS_HOLE*)Malloc((nCountFH[b]+1)*sizeof(FILLS_HOLE));
    memset(nPart.parFillsHole[b+4],0,(nCountFH[b]+1)*sizeof(FILLS_HOLE));

    for(j=0;j<nCountFH[b];j++)
    {
      nPart.parFillsHole[b+4][j].nQuader = arFillsHole[b][j]<<4;
      nPart.parFillsHole[b+4][j].nNextBit = FirstNullBit(nPart.parFillsHole[b+4][j].nQuader,b+4+1);
    }
    if(b>=28)
    {
      nPart.arUsedByAll28_59      [b+4] = arUsedByAll[b]>>28;
      nPart.parFillsHole28_59     [b+4] = (FILLS_HOLE32*)Malloc((nCountFH28_59[b]+1)*sizeof(FILLS_HOLE32));
      memset(nPart.parFillsHole28_59[b+4],0,nCountFH28_59[b]*sizeof(FILLS_HOLE32));
      nPart.parFillsHole28_59[b+4][nCountFH28_59[b]].nQuader = 0;

      for(j=0;j<nCountFH[b];j++)
      {
        nPart.parFillsHole28_59[b+4][j].nQuader  = arFillsHole28_59[b][j];
        nPart.parFillsHole28_59[b+4][j].nNextBit = 32+FirstNullBit(arFillsHole28_59[b][j],(b-28)+1);
      }
    }
  }
}

void CalcFillsHoleRev(DEFPart_ &nPart,const __int64 *pTranslation,BOOL bIgnoreSyms=FALSE)
{
  const __int64 *pT=pTranslation;

  __int64 arFillsHole[60][200];
  int nPartIndex,b,j,nCountFH[60];

  int arFillsHole0_31[60][200];
  int nCountFH0_31[60];

  __int64 arUsedByAll[60];

  memset(arFillsHole,0,sizeof(arFillsHole));
  memset(nCountFH,0,sizeof(nCountFH));
  memset(arUsedByAll,-1,sizeof(arUsedByAll));

  memset(arFillsHole0_31,0,sizeof(arFillsHole0_31));
  memset(nCountFH0_31,0,sizeof(nCountFH0_31));

  for(nPartIndex=0;nPartIndex<12;nPartIndex++)
    if(&nPart==&g_arParts[nPartIndex])
      break;

  while(*pT)
  {
    if(!bIgnoreSyms || FindSym(*pT,pTranslation))
    { 
      for(b=0;b<60;b++)
        if(g_arQuader[b] & (*pT))
          if(!(~(((__int64)1<<(b+1))-1) & (*pT)))
          {
            if(!nCountFH[b])  arUsedByAll[b]=(*pT);
            else              arUsedByAll[b]&=(*pT);

            arFillsHole[b][nCountFH[b]++]=(*pT);
            if(b<=31)
              arFillsHole0_31[b][nCountFH0_31[b]++]=((int*)(pT))[0];
          }
    }
    pT++;
  }

  for(b=0;b<60;b++)
  {
    nPart.arUsedByAllRev        [b] = arUsedByAll[b];
    nPart.parFillsHoleRev       [b] = (FILLS_HOLE*)Malloc((nCountFH[b]+1)*sizeof(FILLS_HOLE));
    memset(nPart.parFillsHoleRev[b],0,(nCountFH[b]+1)*sizeof(FILLS_HOLE));

    for(j=0;j<nCountFH[b];j++)
    {
      nPart.parFillsHoleRev[b][j].nQuader = arFillsHole[b][j];
      nPart.parFillsHoleRev[b][j].nNextBit= FirstNullBitRev(nPart.parFillsHoleRev[b][j].nQuader,b-1);
    }

    if(b<=31)
    {
      nPart.arUsedByAllRev0_31 [b] = ((int*)&arUsedByAll[b])[0];
      nPart.parFillsHoleRev0_31[b] = (FILLS_HOLE32*)Malloc((nCountFH0_31[b]+1)*sizeof(FILLS_HOLE32));
      memset(nPart.parFillsHoleRev0_31[b],0,(nCountFH0_31[b]+1)*sizeof(FILLS_HOLE32));
      for(j=0;j<nCountFH0_31[b];j++)
      {
        nPart.parFillsHoleRev0_31[b][j].nQuader  = arFillsHole0_31[b][j];
        nPart.parFillsHoleRev0_31[b][j].nNextBit = FirstNullBitRev(arFillsHole0_31[b][j],b-1);
      }
    }
  }
}

void CopyTrans(DEFPart_ &nPart,__int64 (&arTranslation)[g_nMaxTrans],BOOL bIgnoreSyms)
{
  __int64 *pT = arTranslation;

  if(!bIgnoreSyms)
  {
    int nC;
    while(*pT)
      pT++;

    nC=pT-arTranslation;

    nPart.nNumTrans = nC;
    nPart.parTrans = (__int64*)Malloc((nC+1)*sizeof(__int64));
    memcpy(nPart.parTrans,arTranslation,nC*sizeof(__int64));
    nPart.parTrans[nC]=0;
  }
  else
  {
    __int64 arT[g_nMaxTrans];

    int nC=0;
    while(*pT)
    {
      if(FindSym(*pT,pT))
        arT[nC++] = *pT;
      pT++;
    }

    nPart.nNumTrans = nC;
    nPart.parTrans = (__int64*)Malloc((nC+1)*sizeof(__int64));
    memcpy(nPart.parTrans,arT,nC*sizeof(__int64));
    nPart.parTrans[nC]=0;
  }
}

void CalcTrans(const DEFRot_ (&arRot)[g_nMaxRot],int nNumRot,__int64 (&arTranslation)[g_nMaxTrans])
{
  int r,x,y,z;
  __int64 *pT;const __int64 *pF;

  memset(arTranslation,0,sizeof(arTranslation));

  pF = pT = arTranslation;
  for(r=0;r<nNumRot;r++)
  {
    pF = pT;
    if(arRot[r].nDimX<=g_nDimX && arRot[r].nDimY<=g_nDimY && arRot[r].nDimZ<=g_nDimZ)
    {
      _444ToXYZ(*pT++,arRot[r].nQuader444);

      for(x=1;x<=g_nDimX-arRot[r].nDimX;x++)
        for(y=0;y<=g_nDimY-arRot[r].nDimY;y++)
          for(z=0;z<=g_nDimZ-arRot[r].nDimZ;z++)
            MoveXYZ(*pT++,*pF,x,y,z);

      for(y=1;y<=g_nDimY-arRot[r].nDimY;y++)
        for(z=0;z<=g_nDimZ-arRot[r].nDimZ;z++)
          MoveXYZ(*pT++,*pF,0,y,z);
   
      for(z=1;z<=g_nDimZ-arRot[r].nDimZ;z++)
        MoveXYZ(*pT++,*pF,0,0,z);
    }
  }
}

void CalcRot(DEFRot_ (&arRot)[g_nMaxRot],int &nNumRot)
{
  int nI,i,nF,nT,nNPH;

  nF=0,nT=0;

  RotateZ90(arRot[0],arRot[1]);
  if(arRot[0].nQuader444==arRot[1].nQuader444) arRot[1].nQuader444=(__int64)0;
  else
  {// nur weiter, falls nicht symetrisch bei Drehung um 90
    nNumRot++;
    RotateZ90(arRot[1],arRot[2]);
    if(arRot[0].nQuader444==arRot[2].nQuader444) arRot[2].nQuader444=(__int64)0;
    else
    {// nur weiter, falls nicht symetrisch bei Drehung um 180
      nNumRot++;
      RotateZ90(arRot[2],arRot[3]);
      nNumRot++;
    }
  }

  nT=nNumRot-1;
  for(nI=nF;nI<=nT;nI++)
  {
    RotateX90(arRot[nI],arRot[nNumRot]);
    if(arRot[nI].nQuader444==arRot[nNumRot].nQuader444) arRot[nNumRot].nQuader444=(__int64)0;
    else
    {// nur weiter, falls nicht symetrisch bei Drehung um 90
      nNumRot++;
      RotateX90(arRot[nNumRot-1],arRot[nNumRot]);
      if(arRot[nI].nQuader444==arRot[nNumRot].nQuader444) arRot[nNumRot].nQuader444=(__int64)0;
      else
      {// nur weiter, falls nicht symetrisch bei Drehung um 180
        nNumRot++;
        RotateX90(arRot[nNumRot-1],arRot[nNumRot]);
        nNumRot++;
      }
    }
  }
  for(nI=nT,nNPH=nT;nI<nNumRot;nI++,nNPH++)
  {
    for(i=nF;i<nI;i++)
      if(arRot[nI].nQuader444==arRot[i].nQuader444)
        {nNPH--;break;}

    if(i==nI && nNPH!=nI)
      arRot[nNPH]=arRot[nI];
  }
  nNumRot = nNPH;
  while(nNPH<nI)
  {
    arRot[nNPH].nQuader444=(__int64)0;
    nNPH++;
  }

  nT=nNumRot-1;
  for(nI=nF;nI<=nT;nI++)
  {
    RotateY90(arRot[nI],arRot[nNumRot]);
    if(arRot[nI].nQuader444==arRot[nNumRot].nQuader444) arRot[nNumRot].nQuader444=(__int64)0;
    else
    {// nur weiter, falls nicht symetrisch bei Drehung um 90
      nNumRot++;
      RotateY90(arRot[nNumRot-1],arRot[nNumRot]);
      if(arRot[nI].nQuader444==arRot[nNumRot].nQuader444) arRot[nNumRot].nQuader444=(__int64)0;
      else
      {// nur weiter, falls nicht symetrisch bei Drehung um 180
        nNumRot++;
        RotateY90(arRot[nNumRot-1],arRot[nNumRot]);
        nNumRot++;
      }
    }
  }

  for(nI=nT,nNPH=nT;nI<nNumRot;nI++,nNPH++)
  {
    for(i=nF;i<nI;i++)
      if(arRot[nI].nQuader444==arRot[i].nQuader444)
        {nNPH--;break;}

    if(i==nI && nNPH!=nI)
      arRot[nNPH]=arRot[nI];
  }
  nNumRot = nNPH;
  while(nNPH<nI)
  {
    arRot[nNPH].nQuader444=(__int64)0;
    nNPH++;
  }
}

BOOL InitFindHolesAddDistinct(CHECK_HOLE *pCheckHole,const __int64 nStar,const __int64 nStarHole)
{
  while((*pCheckHole).nSolid && ((*pCheckHole).nSolid!=nStar))
    pCheckHole++;
  
  if((*pCheckHole).nSolid)
    return FALSE;

  (*pCheckHole).nSolid  = nStar;
  (*pCheckHole).nHole   = nStarHole;
  return TRUE;
}

void InitFindHoles()
{
  int x,y,z,p,b,h,nC,nC28_59;
  
  FILLS_HOLE *pFillsHole;
  CHECK_HOLE arCheckHole[g_nMaxCheckHole];
   
  FILLS_HOLE32 *pFillsHole28_59;

  for(p=0;p<g_nNumParts;p++)
  {
    for(b=0;b<60;b++)
    {
      h=0;
      pFillsHole      = g_arParts[p].parFillsHole     [b+4];
      pFillsHole28_59 = g_arParts[p].parFillsHole28_59[b+4];;
      while(pFillsHole->nQuader)
      {
        nC=0;nC28_59=0;
        memset(arCheckHole,0,sizeof(arCheckHole));
      
        for(z=0;z<g_nDimZ;z++) for(y=0;y<g_nDimY;y++) for(x=0;x<g_nDimX;x++)
          if(b<XYZ(x,y,z))
          {
            if(  !(((pFillsHole->nQuader>>4)&~g_arStarHole[XYZ(x,y,z)])&g_arStar    [XYZ(x,y,z)])
               && ((pFillsHole->nQuader>>4)&g_arStar    [XYZ(x,y,z)]))
            {
              if(InitFindHolesAddDistinct(arCheckHole,g_arStar[XYZ(x,y,z)]<<4,g_arStarHole[XYZ(x,y,z)]<<4))
                nC++;
            }
          }

        pFillsHole->parCheckHole = (CHECK_HOLE*)Malloc((nC+1)*sizeof(CHECK_HOLE));
        memcpy( pFillsHole->parCheckHole    ,arCheckHole,nC*sizeof(CHECK_HOLE));
        memset(&pFillsHole->parCheckHole[nC],0          ,   sizeof(CHECK_HOLE));

        pFillsHole++;pFillsHole28_59++;h++;
      }
    }
  }
}

void InitFindHolesRev()
{
  int x,y,z,p,b,h,nC,nC0_31;
  
  FILLS_HOLE *pFillsHole;
  CHECK_HOLE arCheckHole[g_nMaxCheckHole];
  
  FILLS_HOLE32 *pFillsHole0_31;

  for(p=0;p<g_nNumParts;p++)
  {
    for(b=0;b<60;b++)
    {
      h=0;
      pFillsHole      = g_arParts[p].parFillsHoleRev     [b];
      pFillsHole0_31  = g_arParts[p].parFillsHoleRev0_31 [b];
      while(pFillsHole->nQuader)
      {
        nC=0;nC0_31=0;
        memset(arCheckHole,0,sizeof(arCheckHole));
      
        for(z=0;z<g_nDimZ;z++) for(y=0;y<g_nDimY;y++) for(x=0;x<g_nDimX;x++)
          if(XYZ(x,y,z)<b)
          {
            if(  !((pFillsHole->nQuader&~g_arStarHole[XYZ(x,y,z)])&g_arStar    [XYZ(x,y,z)])
               && (pFillsHole->nQuader&g_arStar    [XYZ(x,y,z)]))
            {
              if(InitFindHolesAddDistinct(arCheckHole,g_arStar[XYZ(x,y,z)],g_arStarHole[XYZ(x,y,z)]))
                nC++;
            }
          }

        pFillsHole->parCheckHole = (CHECK_HOLE*)Malloc((nC+1)*sizeof(CHECK_HOLE));
        memcpy( pFillsHole->parCheckHole    ,arCheckHole,nC*sizeof(CHECK_HOLE));
        memset(&pFillsHole->parCheckHole[nC],0          ,   sizeof(CHECK_HOLE));

        pFillsHole++;pFillsHole0_31++;h++;
      }
    }
  }
  printf("\n");
}

void Init()
{
  memset(g_nNumPartPos  ,0,sizeof(g_nNumPartPos   ));
  memset(g_arParts      ,0,sizeof(g_arParts       ));
  memset(g_arPartNotUsed,0,sizeof(g_arPartNotUsed ));
  

  g_arQuader[0]=(__int64)1;g_arNotIn [0]=(__int64)0;
  int b;
  for(b=1;b<64;b++)
  {
    g_arQuader[b]=(__int64)1<<b;
    g_arNotIn [b]=g_arNotIn [b-1]|g_arQuader[b-1];
  }

  for(b=0;b<64;b++)
    g_arQuader0_31__32_63[b]=1<<(b%32);

  InitStar();

  __int64 nQ; int nI=0,nNumRot; DEFRot_ arRot[g_nMaxRot];__int64 arT[g_nMaxTrans];

#define CALC(x,y,z,b) memset(arRot,0,sizeof(arRot));nNumRot=1;SetRot(arRot[0],nQ,x,y,z);CalcRot(arRot,nNumRot);CalcTrans(arRot,nNumRot,arT);CalcFillsHole(g_arParts[nI],arT,b);CalcFillsHoleRev(g_arParts[nI],arT,b);CopyTrans(g_arParts[nI],arT,b);

  //Part0 
  nQ=(__int64)0;Set(nQ,XYZ444(0,0,0));Set(nQ,XYZ444(0,0,1));Set(nQ,XYZ444(1,0,0));Set(nQ,XYZ444(2,0,0));Set(nQ,XYZ444(2,0,1)); 
  CALC(3,1,2,nI==g_nNumPartIgnoreSym);
  nI++;

  //Part1
  nQ=(__int64)0;Set(nQ,XYZ444(0,0,0));Set(nQ,XYZ444(0,0,1));Set(nQ,XYZ444(0,1,1));Set(nQ,XYZ444(0,2,1));Set(nQ,XYZ444(0,2,2));
  CALC(1,3,3,nI==g_nNumPartIgnoreSym);
  nI++;

  //Part2
  nQ=(__int64)0;Set(nQ,XYZ444(0,0,0));Set(nQ,XYZ444(0,0,1));Set(nQ,XYZ444(0,1,1));Set(nQ,XYZ444(0,2,1));Set(nQ,XYZ444(0,3,1));
  CALC(1,4,2,nI==g_nNumPartIgnoreSym);
  nI++;

  //Part3
  nQ=(__int64)0;Set(nQ,XYZ444(0,0,0));Set(nQ,XYZ444(0,1,0));Set(nQ,XYZ444(0,2,0));Set(nQ,XYZ444(0,2,1));Set(nQ,XYZ444(0,3,0));
  CALC(1,4,2,nI==g_nNumPartIgnoreSym);
  nI++;

  //Part4
  nQ=(__int64)0;Set(nQ,XYZ444(0,0,0));Set(nQ,XYZ444(0,0,1));Set(nQ,XYZ444(1,0,0));Set(nQ,XYZ444(0,1,0));Set(nQ,XYZ444(1,1,0));
  CALC(2,2,2,nI==g_nNumPartIgnoreSym);
  nI++;

  //Part5
  nQ=(__int64)0;Set(nQ,XYZ444(0,0,1));Set(nQ,XYZ444(0,1,1));Set(nQ,XYZ444(0,2,0));Set(nQ,XYZ444(0,2,1));Set(nQ,XYZ444(0,2,2));
  CALC(1,3,3,nI==g_nNumPartIgnoreSym);
  nI++;

  //Part6
  nQ=(__int64)0;Set(nQ,XYZ444(0,0,0));Set(nQ,XYZ444(0,0,1));Set(nQ,XYZ444(0,1,0));Set(nQ,XYZ444(0,1,1));Set(nQ,XYZ444(0,2,1));
  CALC(1,3,2,nI==g_nNumPartIgnoreSym);
  nI++;

  //Part7
  nQ=(__int64)0;Set(nQ,XYZ444(0,0,1));Set(nQ,XYZ444(0,0,2));Set(nQ,XYZ444(0,1,0));Set(nQ,XYZ444(0,1,1));Set(nQ,XYZ444(0,2,0));
  CALC(1,3,3,nI==g_nNumPartIgnoreSym);
  nI++;

  //Part8
  nQ=(__int64)0;Set(nQ,XYZ444(0,0,0));Set(nQ,XYZ444(0,0,1));Set(nQ,XYZ444(0,1,0));Set(nQ,XYZ444(1,1,0));
  CALC(2,2,2,nI==g_nNumPartIgnoreSym);
  nI++;

  //Part9
  nQ=(__int64)0;Set(nQ,XYZ444(0,0,1));Set(nQ,XYZ444(0,1,0));Set(nQ,XYZ444(0,1,1));Set(nQ,XYZ444(0,1,2));Set(nQ,XYZ444(0,2,0));
  CALC(1,3,3,nI==g_nNumPartIgnoreSym);
  nI++;

  //Part10
  nQ=(__int64)0;Set(nQ,XYZ444(0,0,1));Set(nQ,XYZ444(0,1,0));Set(nQ,XYZ444(0,1,1));Set(nQ,XYZ444(0,1,2));Set(nQ,XYZ444(0,2,1));
  CALC(1,3,3,nI==g_nNumPartIgnoreSym);
  nI++;

  //Part11
  nQ=(__int64)0;Set(nQ,XYZ444(0,0,0));Set(nQ,XYZ444(0,0,1));Set(nQ,XYZ444(0,1,0));Set(nQ,XYZ444(0,2,0));Set(nQ,XYZ444(0,2,1));Set(nQ,XYZ444(0,3,0));
  CALC(1,4,2,nI==g_nNumPartIgnoreSym);
  nI++;

  InitFindHoles();InitFindHolesRev();

  g_pExtParts = _InitExtParts(12,(1<<12)-1);
}

static unsigned long g_nSolutions =0;
static unsigned long g_nCalls     =0;

// secondary thread
static unsigned long g_nSolutions2=0; 
static unsigned long g_nCalls2    =0;

inline void PrintTimeIndex()
{
  __int64 nTime=clock()-g_nStartTime;

  printf("%02d:%02d:%02d.%03d (%14u)",(int)(nTime/3600000)%24,(int)(nTime/60000)%60,(int)(nTime/1000)%60,(int)nTime%1000,g_nCalls);
  //printf("%02d:%02d:%02d.%03d (%18I64u vs. %18I64u)",(int)(nTime/3600000)%24,(int)(nTime/60000)%60,(int)(nTime/1000)%60,(int)nTime%1000,g_nCalls,g_nCalls1);
  //printf("%02d:%02d:%02d.%03d",(int)(nTime/3600000)%24,(int)(nTime/60000)%60,(int)(nTime/1000)%60,(int)nTime%1000);fflush(stdout);
}

void Compute4_63_nochk32(DEFPartNotUsed_ *pP,int nQuader,int nBit)
{
  EXCL_AT_FR(g_nCalls++;)

  if(!pP)
  {
    if(nQuader==0xFFFFFFFF)
    {
      g_nSolutions++;

      EXCL_AT_FR
      (
        if(!(g_nSolutions%2000))
          {printf("Solution %6u found ",g_nSolutions);PrintTimeIndex();printf("\n");}
      )
    }
    return;
  }

  // Jedes Teil hat mindestens 4 Bit, aber selbst dann pat es nicht in die letzten 4Bit
  // Eigentlich knnte hier komplett auf den Test nBit<60 verzichtet werden.
  while(nBit<60 && (nQuader&g_arQuader0_31__32_63[nBit]))
    nBit++;
 
  FILLS_HOLE32 *pFH;

  while(pP->pPart)
  {
    if(!(nQuader&pP->pPart->arUsedByAll28_59[nBit]))
    {
      pFH=pP->pPart->parFillsHole28_59[nBit];
      while(pFH->nQuader)
      {
        if(!(nQuader&pFH->nQuader))
          Compute4_63_nochk32(pP->pNotUsed,nQuader|pFH->nQuader,pFH->nNextBit);
        pFH++;
      }
    }
    pP++;
  }
}

inline void Compute4_63_nochk32_(DEFPartNotUsed_ *pP,int nQuader,int nBit)
{
  EXCL_AT_FR(g_nCalls++);

  FILLS_HOLE32 *pFH;

  while(pP->pPart)
  {
    if(!(nQuader&pP->pPart->arUsedByAll28_59[nBit]))
    {
      pFH=pP->pPart->parFillsHole28_59[nBit];
      while(pFH->nQuader)
      {
        if(!(nQuader&pFH->nQuader))
          Compute4_63_nochk32(pP->pNotUsed,nQuader|pFH->nQuader,pFH->nNextBit);
        pFH++;
      }
    }
    pP++;
  }
}

void Compute4_63(DEFPartNotUsed_ *pP,__int64 nQuader,int nBit)
{
  EXCL_AT_FR(g_nCalls++;)

  if(!pP)
  {
    if(((int*)&nQuader)[1] == 0xFFFFFFFF)
    {
      g_nSolutions++;
      
      EXCL_AT_FR
      (
        if(!(g_nSolutions%2000))
          {printf("Solution %6u found ",g_nSolutions);PrintTimeIndex();printf("\n");}
      )
    }
    return;
  }

  while(nBit<60 && (nQuader&(g_arQuader[nBit])))
    nBit++;

  if(nBit>=32)
  {
    Compute4_63_nochk32_(pP,((int*)&nQuader)[1],nBit);
    return ;
  }

  FILLS_HOLE *pFH;

  while(pP->pPart)
  {
    if(!(nQuader&pP->pPart->arUsedByAll[nBit]))
    {
      pFH=pP->pPart->parFillsHole[nBit];
      while(pFH->nQuader)
      {
        if(!(nQuader&pFH->nQuader))
        {
          // Zugegeben, ich habe keine Ahnung warum die Nutzung von my__int64 schneller als die von __int64 ist!
          my__int64 nQH;

          nQH.i.l=((my__int64&)nQuader).i.l|((my__int64&)pFH->nQuader).i.l;
          nQH.i.h=((my__int64&)nQuader).i.h|((my__int64&)pFH->nQuader).i.h;

          CHECK_HOLE *pCheckHole = pFH->parCheckHole;

          while(!((nQH.i64 & (*pCheckHole).nSolid)==(*pCheckHole).nHole))
            pCheckHole++;
          if(!(*pCheckHole).nSolid)
            Compute4_63(pP->pNotUsed,nQH.i64,pFH->nNextBit);
        }
        pFH++;
      }
    }
    pP++;
  }
}

void Compute59_0_rev_nochk32(DEFPartNotUsed_ *pP,int nQuader,int nBit)
{
  EXCL_AT_FR(g_nCalls++);

  if(!pP)
  {
    if(nQuader==0xFFFFFFFF)
    {
      g_nSolutions++;
      
      EXCL_AT_FR
      (
        if(!(g_nSolutions%2000))
          {printf("Solution %6u found ",g_nSolutions);PrintTimeIndex();printf("\n");}
      )  
    }
    return;
  }

  while(nBit>=4 && (nQuader&g_arQuader0_31__32_63[nBit]))
    nBit--;
  
  FILLS_HOLE32 *pFH;

  while(pP->pPart)
  {
    if(!(nQuader&pP->pPart->arUsedByAllRev0_31[nBit]))
    {
      pFH=pP->pPart->parFillsHoleRev0_31[nBit];
      while(pFH->nQuader)
      {
        if(!(nQuader&pFH->nQuader))
          Compute59_0_rev_nochk32(pP->pNotUsed,nQuader|pFH->nQuader,pFH->nNextBit);
        pFH++;
      }
    }
    pP++;
  }
}

inline void Compute59_0_rev_nochk32_(DEFPartNotUsed_ *pP,int nQuader,int nBit)
{
  FILLS_HOLE32 *pFH;

  while(pP->pPart)
  {
    if(!(nQuader&pP->pPart->arUsedByAllRev0_31[nBit]))
    {
      pFH=pP->pPart->parFillsHoleRev0_31[nBit];
      while(pFH->nQuader)
      {
        if(!(nQuader&pFH->nQuader))
          Compute59_0_rev_nochk32(pP->pNotUsed,nQuader|pFH->nQuader,pFH->nNextBit);
        pFH++;
      }
    }
    pP++;
  }
}

void Compute59_0_rev(DEFPartNotUsed_ *pP,__int64 nQuader,int nBit)
{
  EXCL_AT_FR(g_nCalls++;)

  if(!pP)
  {
    if(((int*)&nQuader)[0]==0xFFFFFFFF)
    {
      g_nSolutions++;
      
      EXCL_AT_FR
      (
        if(!(g_nSolutions%2000))
          {printf("Solution %6u found ",g_nSolutions);PrintTimeIndex();printf("\n");}
      )
    }
    return;
  }

  while(nBit>=4 && (nQuader&(g_arQuader[nBit])))
    nBit--;
  
  if(nBit<32)
  {
    Compute59_0_rev_nochk32_(pP,((int*)&nQuader)[0],nBit);
    return;
  }

  FILLS_HOLE *pFH;

  while(pP->pPart)
  {
    if(!(nQuader&pP->pPart->arUsedByAllRev[nBit]))
    {
      pFH=pP->pPart->parFillsHoleRev[nBit];
        while(pFH->nQuader)
        {
          if(!(nQuader&pFH->nQuader))
          {
            my__int64 nQH;

            nQH.i.l=((my__int64&)nQuader).i.l|((my__int64&)pFH->nQuader).i.l;
            nQH.i.h=((my__int64&)nQuader).i.h|((my__int64&)pFH->nQuader).i.h;

            CHECK_HOLE *pCheckHole = pFH->parCheckHole;

            while(!((nQH.i64 & (*pCheckHole).nSolid)==(*pCheckHole).nHole))
              pCheckHole++;

            if(!(*pCheckHole).nSolid)
              Compute59_0_rev(pP->pNotUsed,nQH.i64,pFH->nNextBit);
          }
          pFH++;
        }
    }
    pP++;
  }
}

//**********************************************************************************************************************
void PrintTimeIndex2()
{
  __int64 nTime=clock()-g_nStartTime;

  printf("%02d:%02d:%02d.%03u (%14d)  (sec)",(int)(nTime/3600000)%24,(int)(nTime/60000)%60,(int)(nTime/1000)%60,(int)nTime%1000,g_nCalls2);
  //printf("%02d:%02d:%02d.%03d (%18I64u vs. %18I64u)",(int)(nTime/3600000)%24,(int)(nTime/60000)%60,(int)(nTime/1000)%60,(int)nTime%1000,g_nCalls,g_nCalls1);
  //printf("%02d:%02d:%02d.%03d",(int)(nTime/3600000)%24,(int)(nTime/60000)%60,(int)(nTime/1000)%60,(int)nTime%1000);fflush(stdout);
}

void Compute2_4_63_nochk32(DEFPartNotUsed_ *pP,int nQuader,int nBit)
{
  EXCL_AT_FR(g_nCalls2++;)

  if(!pP)
  {
    if(nQuader==0xFFFFFFFF)
    {
      g_nSolutions2++;

      EXCL_AT_FR
      (
        if(!(g_nSolutions2%2000))
          {printf("Solution %6u found ",g_nSolutions2);PrintTimeIndex2();printf("\n");}
      )
    }
    return;
  }

  while(nBit<60 && (nQuader&g_arQuader0_31__32_63[nBit]))
    nBit++;
 
  FILLS_HOLE32 *pFH;

  while(pP->pPart)
  {
    if(!(nQuader&pP->pPart->arUsedByAll28_59[nBit]))
    {
      pFH=pP->pPart->parFillsHole28_59[nBit];
      while(pFH->nQuader)
      {
        if(!(nQuader&pFH->nQuader))
          Compute2_4_63_nochk32(pP->pNotUsed,nQuader|pFH->nQuader,pFH->nNextBit);
        pFH++;
      }
    }
    pP++;
  }
}

inline void Compute2_4_63_nochk32_(DEFPartNotUsed_ *pP,int nQuader,int nBit)
{
  EXCL_AT_FR(g_nCalls2++);

  FILLS_HOLE32 *pFH;

  while(pP->pPart)
  {
    if(!(nQuader&pP->pPart->arUsedByAll28_59[nBit]))
    {
      pFH=pP->pPart->parFillsHole28_59[nBit];
      while(pFH->nQuader)
      {
        if(!(nQuader&pFH->nQuader))
          Compute2_4_63_nochk32(pP->pNotUsed,nQuader|pFH->nQuader,pFH->nNextBit);
        pFH++;
      }
    }
    pP++;
  }
}

void Compute2_4_63(DEFPartNotUsed_ *pP,__int64 nQuader,int nBit)
{
  EXCL_AT_FR(g_nCalls2++;)

  if(!pP)
  {
    if(((int*)&nQuader)[1] == 0xFFFFFFFF)
    {
      g_nSolutions2++;
      
      EXCL_AT_FR
      (
        if(!(g_nSolutions2%2000))
          {printf("Solution %6u found ",g_nSolutions2);PrintTimeIndex2();printf("\n");}
      )
    }
    return;
  }

  while(nBit<60 && (nQuader&(g_arQuader[nBit])))
    nBit++;

  if(nBit>=32)
  {
    Compute2_4_63_nochk32_(pP,((int*)&nQuader)[1],nBit);
    return ;
  }

  FILLS_HOLE *pFH;

  while(pP->pPart)
  {
    if(!(nQuader&pP->pPart->arUsedByAll[nBit]))
    {
      pFH=pP->pPart->parFillsHole[nBit];
      while(pFH->nQuader)
      {
        if(!(nQuader&pFH->nQuader))
        {
          my__int64 nQH;

          nQH.i.l=((my__int64&)nQuader).i.l|((my__int64&)pFH->nQuader).i.l;
          nQH.i.h=((my__int64&)nQuader).i.h|((my__int64&)pFH->nQuader).i.h;

          CHECK_HOLE *pCheckHole = pFH->parCheckHole;

          while(!((nQH.i64 & (*pCheckHole).nSolid)==(*pCheckHole).nHole))
            pCheckHole++;
          if(!(*pCheckHole).nSolid)
            Compute2_4_63(pP->pNotUsed,nQH.i64,pFH->nNextBit);
        }
        pFH++;
      }
    }
    pP++;
  }
}

void Compute2_59_0_rev_nochk32(DEFPartNotUsed_ *pP,int nQuader,int nBit)
{
  EXCL_AT_FR(g_nCalls2++);

  if(!pP)
  {
    if(nQuader==0xFFFFFFFF)
    {
      g_nSolutions2++;
      
      EXCL_AT_FR
      (
        if(!(g_nSolutions2%2000))
          {printf("Solution %6u found ",g_nSolutions2);PrintTimeIndex2();printf("\n");}
      )  
    }
    return;
  }

  while(nBit>=4 && (nQuader&g_arQuader0_31__32_63[nBit]))
    nBit--;
  
  FILLS_HOLE32 *pFH;

  while(pP->pPart)
  {
    if(!(nQuader&pP->pPart->arUsedByAllRev0_31[nBit]))
    {
      pFH=pP->pPart->parFillsHoleRev0_31[nBit];
      while(pFH->nQuader)
      {
        if(!(nQuader&pFH->nQuader))
          Compute2_59_0_rev_nochk32(pP->pNotUsed,nQuader|pFH->nQuader,pFH->nNextBit);
        pFH++;
      }
    }
    pP++;
  }
}

inline void Compute2_59_0_rev_nochk32_(DEFPartNotUsed_ *pP,int nQuader,int nBit)
{
  FILLS_HOLE32 *pFH;

  while(pP->pPart)
  {
    if(!(nQuader&pP->pPart->arUsedByAllRev0_31[nBit]))
    {
      pFH=pP->pPart->parFillsHoleRev0_31[nBit];
      while(pFH->nQuader)
      {
        if(!(nQuader&pFH->nQuader))
          Compute2_59_0_rev_nochk32(pP->pNotUsed,nQuader|pFH->nQuader,pFH->nNextBit);
        pFH++;
      }
    }
    pP++;
  }
}

void Compute2_59_0_rev(DEFPartNotUsed_ *pP,__int64 nQuader,int nBit)
{
  EXCL_AT_FR(g_nCalls2++;)

  if(!pP)
  {
    if(((int*)&nQuader)[0]==0xFFFFFFFF)
    {
      g_nSolutions2++;
      
      EXCL_AT_FR
      (
        if(!(g_nSolutions2%2000))
          {printf("Solution %6u found ",g_nSolutions2);PrintTimeIndex2();printf("\n");}
      )
    }
    return;
  }

  while(nBit>=4 && (nQuader&(g_arQuader[nBit])))
    nBit--;
  
  if(nBit<32)
  {
    Compute2_59_0_rev_nochk32_(pP,((int*)&nQuader)[0],nBit);
    return;
  }

  FILLS_HOLE *pFH;

  while(pP->pPart)
  {
    if(!(nQuader&pP->pPart->arUsedByAllRev[nBit]))
    {
      pFH=pP->pPart->parFillsHoleRev[nBit];
      while(pFH->nQuader)
      {
        if(!(nQuader&pFH->nQuader))
        {
          my__int64 nQH;

          nQH.i.l=((my__int64&)nQuader).i.l|((my__int64&)pFH->nQuader).i.l;
          nQH.i.h=((my__int64&)nQuader).i.h|((my__int64&)pFH->nQuader).i.h;

          CHECK_HOLE *pCheckHole = pFH->parCheckHole;

          while(!((nQH.i64 & (*pCheckHole).nSolid)==(*pCheckHole).nHole))
            pCheckHole++;

          if(!(*pCheckHole).nSolid)
            Compute2_59_0_rev(pP->pNotUsed,nQH.i64,pFH->nNextBit);
        }
        pFH++;
      }
    }
    pP++;
  }
}
//**********************************************************************************************************************

inline int compareI64__(const void *arg1,const void *arg2)
{
  const __int64 &l=*(__int64 *)arg1,&r=*(__int64 *)arg2;

  if((l&-l)<(r&-r)) return -1;
  else
    if((l&-l)>(r&-r)) return 1;
    else
      if(l<r) return -1;
      else
        if(l>r) return 1;
        else    return 0;

}

inline int compareI64__2(const void *arg1,const void *arg2)
{
  __int64 l=*(__int64 *)arg1,r=*(__int64 *)arg2;

  while(l || r)
  {
    if((l&-l)<(r&-r)) return -1;
    else
      if((l&-l)>(r&-r)) return 1;

    if(!l && !r)
      return 0;

    l &= l - 1;
    r &= r - 1;
  }
  return 0;
}

inline int compareI64__3(const void *arg1,const void *arg2)
{ return -compareI64__2(arg1,arg2);}

inline int FindPartWithMinTrans()
{
  int i,nMinI=0;
  for(i=1;i<g_nNumParts;i++)
    if(g_arParts[i].nNumTrans<g_arParts[nMinI].nNumTrans)
      nMinI=i;
  return nMinI;
}

// Liste der vorgefllten Quader
__int64         *g_pQ;
// Liste der durch den vorgefllten Quader nicht benutzten Teile
DEFPartNotUsed_ *g_pUnusedParts;

inline __int64 *NextQuader() 
{
#ifdef MULTI_THREAD
  EnterCriticalSection(&CriticalSection); 
  __int64 *pQ = (*g_pQ)?g_pQ++:g_pQ;
  LeaveCriticalSection(&CriticalSection);
  return pQ;
#else
  return (*g_pQ)?g_pQ++:g_pQ;
#endif
}

void Compute(DEFPartNotUsed_ *pUnusedParts)
{
  __int64 *pT;

  while(*(pT=NextQuader()))
  {
    EXCL_AT_FR(__int64 nTime=clock()-g_nStartTime;)

    //if((*pT & -*pT) <((__int64)1<<28)) 
    if(MinBit(*pT)+(MaxBit(*pT)-MinBit(*pT))/2 <= 37)
      Compute4_63(pUnusedParts,*pT<<4,4);
    else                                
    {
      EXCL_AT_FR(printf("reverse!!:\n");)
      Compute59_0_rev(pUnusedParts,*pT,59);
    }
    EXCL_AT_FR
    (
      __int64 nT=clock()-nTime;
      printf("");print_bits(*pT);printf(" %2d %02d.%03d\n",pT-g_arParts[10].parTrans,(int)(nT/1000)%60,(int)nT%1000);
    )
  }
}

// secondary Thread
void Compute2(DEFPartNotUsed_ *pUnusedParts)
{
  __int64 *pT;
  while(*(pT=NextQuader()))
  {
    EXCL_AT_FR(__int64 nTime=clock()-g_nStartTime;)

    //if((*pT & -*pT) <((__int64)1<<28)) 
    if(MinBit(*pT)+(MaxBit(*pT)-MinBit(*pT))/2 <= 37)
      Compute2_4_63(pUnusedParts,*pT<<4,4);
    else                                
    {
      EXCL_AT_FR(printf("reverse!!:\n");)
      Compute2_59_0_rev(pUnusedParts,*pT,59);
    }
    EXCL_AT_FR
    (
      __int64 nT=clock()-nTime;
      printf("");print_bits(*pT);printf(" %2d %02d.%03d (sec)\n",pT-g_arParts[10].parTrans,(int)(nT/1000)%60,(int)nT%1000);
    )
  }
}

void ComputeThread (void *pUnusedParts) {Compute((DEFPartNotUsed_*)pUnusedParts);}
void ComputeThread2(void *pUnusedParts) {Compute2((DEFPartNotUsed_*)pUnusedParts);}

void Compute()
{
  unsigned int nMinTransIndex = FindPartWithMinTrans();
 
  g_pUnusedParts=g_pExtParts;
  while(g_pUnusedParts->pPart != &g_arParts[nMinTransIndex])
    g_pUnusedParts++;
  g_pUnusedParts=g_pUnusedParts->pNotUsed;

  qsort(g_arParts[nMinTransIndex].parTrans,g_arParts[nMinTransIndex].nNumTrans,sizeof(__int64),compareI64__2);

  g_pQ = g_arParts[nMinTransIndex].parTrans;

#ifdef MULTI_THREAD
  InitializeCriticalSection(&CriticalSection);

  HANDLE nHdlThread1 = (HANDLE)_beginthread(ComputeThread ,0,g_pUnusedParts),
         nHdlThread2 = (HANDLE)_beginthread(ComputeThread2,0,g_pUnusedParts);

  WaitForSingleObject(nHdlThread1,INFINITE);
  WaitForSingleObject(nHdlThread2,INFINITE);

  DeleteCriticalSection(&CriticalSection);

  g_nSolutions+=g_nSolutions2;
  g_nCalls    +=g_nCalls2;
#else
  Compute(g_pUnusedParts);
#endif
}


int main(int argc, char* argv[])
{
  printf("noelte@web.de\n\n");

  g_nStartTime = clock();

  Init();
  
  Compute();

  clock_t nTime=clock()-g_nStartTime;

  printf("%lu Solutions found. Elapsed time %02d:%02d:%02d.%03d.  %lf L/s\n",g_nSolutions,(int)(nTime/3600000)%24,(int)(nTime/60000)%60,(int)(nTime/1000)%60,(int)nTime%1000,(double)g_nSolutions/(double)(nTime/1000.0));

  CleanUp();
  //getchar();
	return 0;
}
