/*=========================================================
Loesen von ct-Puzzle: liefert Anzahl der Loesungen
==========================================================*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

const unsigned int CHECK_YN3_1 = 14683648;  
const unsigned int CHECK_YN3_2 = 234938382;

const unsigned int CHECK_ZN3 = 65520; 
const unsigned int CHECK_ZN4 = 268369920;
const unsigned int CHECK_ZN34 = 268435440;

const unsigned int CHECK_NORMX_1 = 1227133513;
const unsigned int CHECK_NORMX_2 = 38347922; 

const unsigned int CHECK_NORMY_1 = 117469191;
const unsigned int CHECK_NORMY_2 = 458864;

const unsigned int CHECK_NORMZ = 4095;

const unsigned int CHECK_TRANSX_1 = 613566756;
const unsigned int CHECK_TRANSX_2 = 153391689;

const unsigned int CHECK_TRANSY_1 = 14683648;
const unsigned int CHECK_TRANSY_2 = 234938382;

const unsigned int CHECK_TRANSZ = 268369920;

const unsigned int CHECK_FIRST = 2147483648; 

const unsigned int CHECK_ALL = 4294967295;

/**
  Sowohl ein Wurfel als auch ..
  Kodierung      x+3*y+12*z 
*/

class Subcube 
{ 
  private:
    unsigned int w1,w2; // 64-Bits
    int number;

  public:
    Subcube() { w1=w2=0; }

    int getNumber() { return number; }
    void setNumber(int n) { number = n; }

    void reset() { w1 = w2 = 0; }

    void set(unsigned int bit) // 0..63
    { if(bit > 31) 
      { bit -= 32;
        w2 += 1<<bit;
      } else
          w1 += 1<<bit;        
    } // set


    void set(Subcube &cube) 
    { w1 = cube.w1;
      w2 = cube.w2;
    } // set

    int compareL2(Subcube &cube)
    { return (w1 & cube.w1 || w2 & cube.w2);
    } // compare2

    int compare2(Subcube &cube)
    { return (w2 & cube.w2 || w1 & cube.w1);
    } // compare2


    int addL(Subcube &cube) 
    { if((w2 & cube.w2) || (w1 & cube.w1)) return 0;
      w1 += cube.w1;
      w2 += cube.w2; 
      return 1;
    } // add
 
    int add(Subcube &cube) 
    { if((w1 & cube.w1) || (w2 & cube.w2)) return 0;
      w1 += cube.w1;
      w2 += cube.w2; 
      return 1;
    } // add

    int compare(Subcube &cube)
    { return (w1 == cube.w1 && w2 == cube.w2);
    } // compare 

    
    int order(Subcube &cube)
    { unsigned int help = 1;
      
      while((help != 0) && ((w1 & help) == (cube.w1 & help))) { help <<=1; }
      if(help == 0)
      { help = 1;
        while((help != 0) && ((w2 & help) == (cube.w2 & help))) { help <<=1; }

        if(help == 0) return 0;
          else { if(w2 & help) return 1; else return -1; }
      } else if(w1 & help) return 1; else return -1; 
    } // order

    int order2(Subcube &cube)
    { unsigned int help = 1<<27;

      while((help != 0) && ((w2 & help) == (cube.w2 & help))) { help >>=1; }
      if(help == 0)
      { help = 1<<31;
        while((help != 0) && ((w1 & help) == (cube.w1 & help))) { help >>=1; }
        if(help == 0) return 0;
          else { if(w1 & help) return 1; else return -1; }
      } else if(w2 & help) return 1; else return -1;
    } // order2

    int getFirst()
    { unsigned int help = 16,i=4;

      while(help != 0 && !(help & w1)) { help<<=1; i++;}
      if(help!= 0) return i;
      help=1;
      while(help != 0 && !(help & w2)) { help<<=1; i++;}
      if(help!=0) return i;
      return -1; 
    } // getFirst 

    int getLast()
    { unsigned int help = 1<<27,i=59;

      while(help != 0 && !(help & w2)) { help>>=1; i--;}
      if(help!= 0) return i;
      help=1<<31;
      while(help != 0 && !(help & w1)) { help>>=1; i--;}
      if(help!=0) return i;
      return -1;
    } // getLast

    int getFirstNull()
    { unsigned int help = 32;        
      for(int i=5; i<=31; i++)
      { if(!(help & w1)) return i;
        help <<= 1;
      } 
      return -1;   
    }  // getFirstNull

    int getLastNull()
    { // return 59-i berechnet
      unsigned int help = 1<<27,i;

      for(i=0; i<28; i++)
      { if(!(help & w2)) return i;
        help >>= 1;
      }
      
      help=1<<31;
      for(i=28; i<=59; i++)
      { if(!(help & w1)) return i;
        help >>= 1;
      }

      return -1;
    }  // getLastNull

    int getLastNull2(int k)
    { unsigned int help,i;
      
      k=58-k;
      if(k>31)
      { help = 1<<(k-32);
        for(i=k; i>31; i--)
        { if(!(help & w2)) return 59-i;
          help >>= 1;
        }
        //if(!(help & w1)) return i;
        help=1<<31;
        for(i=31; i>=0; i--)
        { if(!(help & w1)) return 59-i;
          help >>= 1;
        }
      } else
        { help = 1<<k;
          for(i=k; i>=0; i--)
          { if(!(help & w1)) return 59-i;
            help >>= 1;
          }
        }
       return -1;
    }  // getLastNull


    int getFirstNull2(int k)
    { unsigned int help;

      k++;  
      if(k<32)
      { help = 1<<k; 
        for(; k<=31; k++)
        { if(!(help & w1)) return k;
          help <<= 1;
        }
        
        help = w2;
        //k=32;
        while(1 & help) { help >>=1; k++; }
        return k; 
      } else 
        { help = w2;
          help >>= (k-32);         
          while(1 & help) { help >>=1; k++; }
          return k; 
        } 
    }  // getFirstNull2

    void swap(Subcube &cube)
    { unsigned int help=w1;
      int len = number;

      w1 = cube.w1;
      cube.w1 = help;

      help = w2;
      w2 = cube.w2;
      cube.w2 = help;

      number = cube.number;
      cube.number = len;
    } // swap

    void transL(int k)
    { for(int i=0; i<k; i++)
      { w2 <<= 1;
        if(w1 & CHECK_FIRST) w2 += 1; 
        w1 <<=1;
      } 
    } // transL

    void normX()
    { for(int i=0; i<3; i++)
      { if(w1 & CHECK_NORMX_1 || w2 & CHECK_NORMX_2) return; 
        else
        { w1 >>= 1; 
          if(w2 & 1) w1 += CHECK_FIRST; 
          w2 >>= 1; 
        } 
      } // for
    } // normX

    void normY()
    { for(int i=0; i<3; i++)
      { if(w1 & CHECK_NORMY_1 || w2 & CHECK_NORMY_2) return; 
        else
        { for(int j=0; j<3; j++)
          { w1 >>= 1; 
            if(w2 & 1) w1 += CHECK_FIRST; 
            w2 >>= 1; 
          }
        } 
      } // for
    } // normY

    void normZ()
    { for(int i=0; i<4; i++)
      { if(w1 & CHECK_NORMZ) return; 
        else
        { for(int j=0; j<12; j++)
          { w1 >>= 1; 
            if(w2 & 1) w1 += CHECK_FIRST; 
            w2 >>= 1; 
          }
        } 
      } // for
    } // normZ

    void normAll() { normZ(); normY(); normX(); }
    
    int translateX(Subcube *cube)
    { if(w1 & CHECK_TRANSX_1 || w2 & CHECK_TRANSX_2) return 0;
      unsigned int ww1 = w1,ww2 = w2;
      ww2 <<= 1;
      if(ww1 & CHECK_FIRST) ww2 += 1; 
      ww1 <<=1;
      (*cube).w1=ww1; (*cube).w2 = ww2;
      return 1;
    } // tarnslateX

    int translateY(Subcube *cube)
    { if(w1 & CHECK_TRANSY_1 || w2 & CHECK_TRANSY_2) return 0;
      unsigned int ww1 = w1,ww2 = w2;
      
      for(int i=0; i<3; i++)
      { ww2 <<= 1;
        if(ww1 & CHECK_FIRST) ww2 += 1; 
        ww1 <<=1;
      }
      (*cube).w1 = ww1;
      (*cube).w2 = ww2;  
      return 1;
    } // tarnslateY

    int translateZ(Subcube *cube)
    { if(w2 & CHECK_TRANSZ) return 0;
      unsigned int ww1 = w1,ww2 = w2;

      for(int i=0; i<12; i++)
      { ww2 <<= 1;
        if(ww1 & CHECK_FIRST) ww2 += 1; 
        ww1 <<=1;
      }
      (*cube).w1 = ww1;
      (*cube).w2 = ww2;  
      return 1;
    } // tarnslateZ

//================== rotateZ ============================

  int rotateZ1(Subcube *figNew)
  { if(w1 & CHECK_YN3_1 || w2 & CHECK_YN3_2) return 0;

    unsigned int help = w1;
    int i;   
    (*figNew).reset();
    i=0;
    while(help != 0) 
    { if(help & 1) 
        (*figNew).set(2-(i%12)/3+(((i/12)<<2) +(i%3))*3); 
      help >>= 1;
      i++;
    }
    i=32;
    help = w2;
    while(help != 0) 
    { if(help & 1) 
        (*figNew).set(2-(i%12)/3+(((i/12)<<2) +(i%3))*3); 
      help >>= 1;
      i++;
    }
    (*figNew).normAll();
    return 1;
  } // rotateZ1

  int rotateZ2(Subcube *figNew)
  { unsigned int help = w1;

    (*figNew).reset();
    int i=0;
    while(help != 0) 
    { if(help & 1) 
        (*figNew).set(2-(i%3)+3*(3-(i%12)/3+((i/12)<<2))); 
      help >>= 1;
      i++;
    }
    i=32;
    help = w2;
    while(help != 0) 
    { if(help & 1) 
        (*figNew).set(2-(i%3)+3*(3-(i%12)/3+((i/12)<<2))); 
      help >>= 1;
      i++;
    }
   (*figNew).normAll();
   return 1;
  } // rotateZ2

  int rotateZ3(Subcube *figNew)
  { if(w1 & CHECK_YN3_1 || w2 & CHECK_YN3_2) return 0;

    unsigned int help = w1;
    (*figNew).reset();
    int i=0;
    while(help != 0) 
    { if(help & 1) 
        (*figNew).set((i%12)/3+3*(2-(i%3)+((i/12)<<2))); 
      help >>= 1;
      i++;
    }
    i=32;
    help = w2;
    while(help != 0) 
    { if(help & 1) 
        (*figNew).set((i%12)/3+3*(2-(i%3)+((i/12)<<2))); 
      help >>= 1;
      i++;
    }
    (*figNew).normAll();
    return 1;
  } // rotateZ3

//=================== rotateY ==========================
  int rotateY1(Subcube *figNew)
  { if(w2 & CHECK_ZN34) return 0;

    unsigned int help = w1;
    (*figNew).reset();
    int i=0;
    while(help != 0) 
    { if(help & 1) 
        (*figNew).set(i/12+3*((i%12)/3+((2-(i%3))<<2))); 
      help >>= 1;
      i++;
    }
    i=32;
    help = w2;
    while(help != 0) 
    { if(help & 1) 
        (*figNew).set(i/12+3*((i%12)/3+((2-(i%3))<<2))); 
      help >>= 1;
      i++;
    }
    (*figNew).normAll();
    return 1;
  } // rotateY1

  int rotateY2(Subcube *figNew)
  { unsigned int help = w1;
   
    (*figNew).reset();
    int i=0;
    while(help != 0) 
    { if(help & 1) 
        (*figNew).set((2-(i%3))+3*((i%12)/3+((3-(i/12))<<2))); 
      help >>= 1;
      i++;
    }
    i=32;
    help = w2;
    while(help != 0) 
    { if(help & 1) 
        (*figNew).set((2-(i%3))+3*((i%12)/3+((3-(i/12))<<2))); 
      help >>= 1;
      i++;
    }
    (*figNew).normAll();
    return 1;
  } // rotateY2

  int rotateY3(Subcube *figNew)
  { if(w2 & CHECK_ZN34) return 0;
    unsigned int help = w1;
   
    (*figNew).reset();
    int i=0;
    while(help != 0) 
    { if(help & 1) 
        (*figNew).set(2-i/12+3*((i%12)/3+((i%3)<<2))); 
      help >>= 1;
      i++;
    }
    i=32;
    help = w2;
    while(help != 0) 
    { if(help & 1) 
        (*figNew).set(2-i/12+3*((i%12)/3+((i%3)<<2))); 
      help >>= 1;
      i++;
    }
    (*figNew).normAll();
    return 1;
  } // rotateY3

// ======================rotateX ===========================

  int rotateX1(Subcube *figNew)
  { if(w2 & CHECK_ZN4) return 0;
    unsigned int help = w1;
   
    (*figNew).reset();
    int i=0;
    while(help != 0) 
    { if(help & 1) 
        (*figNew).set((i%3)+3*(3-(i/12)+(((i%12)/3)<<2))); 
      help >>= 1;
      i++;
    }
    i=32;
    help = w2;
    while(help != 0) 
    { if(help & 1) 
        (*figNew).set((i%3)+3*(3-(i/12)+(((i%12)/3)<<2))); 
      help >>= 1;
      i++;
    }
    (*figNew).normAll();
    return 1;
  } // rotateX1

  int rotateX2(Subcube *figNew)
  { unsigned int help = w1;
    (*figNew).reset();
    int i=0;
    while(help != 0) 
    { if(help & 1) 
        (*figNew).set((i%3)+3*(3-((i%12)/3)+((3-(i/12))<<2))); 
      help >>= 1;
      i++;
    }
    i=32;
    help = w2;
    while(help != 0) 
    { if(help & 1) 
        (*figNew).set((i%3)+3*(3-((i%12)/3)+((3-(i/12))<<2))); 
      help >>= 1;
      i++;
    }
    (*figNew).normAll();
    return 1;
  } // rotateX2

  int rotateX3(Subcube *figNew)
  { if(w2 & CHECK_ZN4) return 0;
    unsigned int help = w1;
    (*figNew).reset();
    int i=0;
    while(help != 0) 
    { if(help & 1) 
        (*figNew).set((i%3)+3*((i/12)+((3-(i%12)/3)<<2))); 
      help >>= 1;
      i++;
    }
    i=32;
    help = w2;
    while(help != 0) 
    { if(help & 1) 
        (*figNew).set((i%3)+3*((i/12)+((3-(i%12)/3)<<2))); 
      help >>= 1;
      i++;
    }
    (*figNew).normAll();
    return 1;
  } // rotateX3

}; // end of class Subcube 

//============================ end of clas Subcube ===========================


//========================================================
//  globale Variable
//========================================================


Subcube *subcubes, *subcubesL;
int subcubesCount,subcubesBis,subcubesBisL;
int bound[61][12], boundL[60][12];


void initSubcubes()
{ int i,j,k;
  Subcube figure[12][600];
  int index[12];

  figure[0][0].set(1);
  figure[0][0].set(2);
  
  figure[0][0].set(3); 
  figure[0][0].set(4);
  figure[0][0].set(5);

  figure[1][0].set(0);
  figure[1][0].set(1);
  
  figure[1][0].set(4);
  figure[1][0].set(5);

  figure[1][0].set(7);
  

  figure[2][0].set(0);
  figure[2][0].set(1);
  
  figure[2][0].set(4);
  figure[2][0].set(5);

  figure[2][0].set(8);
  

  figure[3][0].set(0);
  figure[3][0].set(1);

  figure[3][0].set(4);

  figure[3][0].set(7);

  figure[3][0].set(10);
  

  figure[4][0].set(3);
  figure[4][0].set(4);

  figure[4][0].set(13);

  figure[4][0].set(15);  
  figure[4][0].set(16);
  

  figure[5][0].set(0);
  figure[5][0].set(1);

  figure[5][0].set(3);

  figure[5][0].set(15);


  figure[6][0].set(0);
  figure[6][0].set(1);

  figure[6][0].set(4);

  figure[6][0].set(6);
  figure[6][0].set(7);

  figure[6][0].set(10);
  
  
  figure[7][0].set(0);
  figure[7][0].set(1);
  figure[7][0].set(2);

  figure[7][0].set(3);
  figure[7][0].set(5);
  

  figure[8][0].set(0);
  figure[8][0].set(1);
  figure[8][0].set(2);

  figure[8][0].set(4);

  figure[8][0].set(7);


  figure[9][0].set(0);

  figure[9][0].set(3);
  figure[9][0].set(4);
  figure[9][0].set(5);
  
  figure[9][0].set(8);


  figure[10][0].set(1);

  figure[10][0].set(3);
  figure[10][0].set(4);
  figure[10][0].set(5);
  
  figure[10][0].set(7);
  

  figure[11][0].set(0);

  figure[11][0].set(3);
  figure[11][0].set(4);

  figure[11][0].set(6);

  
  figure[11][0].set(9);

// rotiere

  for(i=1;i<12; i++)
  { j=1;
    if(figure[i][0].rotateX1(&figure[i][j]))
    { for(int l=0; l<j; l++) if(figure[i][l].compare(figure[i][j])) break;
      if(l==j) j++; 
    }
    if(figure[i][0].rotateX2(&figure[i][j]))
    { for(int l=0; l<j; l++) if(figure[i][l].compare(figure[i][j])) break;
      if(l==j) j++; 
    }
    if(figure[i][0].rotateX3(&figure[i][j]))
    { for(int l=0; l<j; l++) if(figure[i][l].compare(figure[i][j])) break;
      if(l==j) j++; 
    }
    if(figure[i][0].rotateY1(&figure[i][j]))
    { for(int l=0; l<j; l++) if(figure[i][l].compare(figure[i][j])) break;
      if(l==j) j++; 
    }
    if(figure[i][0].rotateY2(&figure[i][j]))
    { for(int l=0; l<j; l++) if(figure[i][l].compare(figure[i][j])) break;
      if(l==j) j++; 
    }
    if(figure[i][0].rotateY3(&figure[i][j]))
    { for(int l=0; l<j; l++) if(figure[i][l].compare(figure[i][j])) break;
      if(l==j) j++; 
    }
    index[i] = j;

    for(k=0; k<index[i]; k++)   
    { if(figure[i][k].rotateZ1(&figure[i][j])) 
      { for(int l=0; l<j; l++) if(figure[i][l].compare(figure[i][j])) break;
        if(l==j) j++; 
      } 
      if(figure[i][k].rotateZ2(&figure[i][j]))
      { for(int l=0; l<j; l++) if(figure[i][l].compare(figure[i][j])) break;
        if(l==j) j++; 
      } 
      if(figure[i][k].rotateZ3(&figure[i][j]))
      { for(int l=0; l<j; l++) if(figure[i][l].compare(figure[i][j])) break;
        if(l==j) j++; 
      }
    }
    index[i] = j;
  } // for i

// fuer figure0 original
  figure[0][0].rotateZ1(&figure[0][1]);
  figure[0][1].rotateY2(&figure[0][2]);
  figure[0][1].set(figure[0][2]);

  figure[0][0].rotateY3(&figure[0][2]);
  figure[0][2].rotateX1(&figure[0][3]);
  figure[0][3].rotateZ2(&figure[0][4]);
  figure[0][3].set(figure[0][4]);


  figure[0][0].rotateX1(&figure[0][4]);
  figure[0][4].rotateY3(&figure[0][5]);
  figure[0][5].rotateZ2(&figure[0][6]);
  figure[0][5].set(figure[0][6]);
  index[0] = 6;

// translate
// X
  for(i=0; i<12; i++)
  { j=index[i];
    for(k=0; k<index[i]; k++)
    { if(figure[i][k].translateX(&figure[i][j]))
      { j++;
        if(figure[i][j-1].translateX(&figure[i][j])) j++;
      }
    }
    index[i] = j;
  } // for i
//Y
  for(i=0; i<12; i++)
  { j=index[i];
    for(k=0; k<index[i]; k++)
    { if(figure[i][k].translateY(&figure[i][j])) 
      { j++;
        for(int l=0; l<2; l++)
          if(figure[i][j-1].translateY(&figure[i][j])) j++;
            else break;
      } 
    }
    index[i] = j;
  } // for i
// Z
  for(i=0; i<12; i++)
  { j=index[i];
    for(k=0; k<index[i]; k++)
    { if(figure[i][k].translateZ(&figure[i][j])) 
      { j++;
        for(int l=0; l<3; l++)
          if(figure[i][j-1].translateZ(&figure[i][j])) j++;
            else break;
      } 
    }
    index[i] = j;
  } // for i


// init Subcubes

  subcubesCount = 0;
  for(i=0; i<12; i++) subcubesCount += index[i];
  subcubes =  new Subcube[subcubesCount];
  k=0;
  for(i=0; i<10; i++)
    for(j=0; j<index[i]; j++)  
    { subcubes[k].set(figure[i][j]);
      subcubes[k].setNumber(i); 
      k++; 
    } 
  i=11;
  for(j=0; j<index[i]; j++)  
  { subcubes[k].set(figure[i][j]);
    subcubes[k].setNumber(i); 
    k++; 
  }
  subcubesBis = k;
  i=10;
  for(j=0; j<index[i]; j++)  
  { subcubes[k].set(figure[i][j]);
    subcubes[k].setNumber(i); 
    k++; 
  } 

// sort Subcubes
   
  for(i=0; i<subcubesBis; i++)
  { k=1;
    for(int j=0; j<subcubesBis-1; j++)
    { if(subcubes[j].order(subcubes[j+1]) == -1)
      { subcubes[j].swap(subcubes[j+1]); 
        k = 0;
      }
    } // for j
    if(k) break;    
  } // for i

  for(i=subcubesBis; i<subcubesCount; i++)
  { k=1;
    for(int j=subcubesBis; j<subcubesCount-1; j++)
    { if(subcubes[j].order(subcubes[j+1]) == -1)
      { subcubes[j].swap(subcubes[j+1]); 
        k = 0;
      }
    } // for j
    if(k) break;    
  } // for i


//------------------ init & sort subcubesL

  subcubesBisL = subcubesBis;
  subcubesL = new Subcube[subcubesBisL];
 
  for(i=0,k=subcubesBisL-1; i<subcubesBisL; i++,k--)
  { subcubesL[i].set(subcubes[k]);
    subcubesL[i].setNumber(subcubes[k].getNumber());
  }

  for(i=0; i<subcubesBisL; i++)
  { k=1;
    for(int j=0; j<subcubesBisL-1; j++)
    { if(subcubesL[j].order2(subcubesL[j+1]) == -1)
      { subcubesL[j].swap(subcubesL[j+1]); 
        k = 0;
      }
    } // for j
    if(k) break;    
  } // for i


// init strukturen

  j = (subcubesBis+subcubesCount)>>1;
  for(i=0; i<j; i++) subcubes[i].transL(4); // w1-teil verkleine

  j = subcubes[0].getFirst();
  for(i=0; i<=j; i++) bound[i][0] = 0;
  
  for(i=1;i<subcubesBis;i++)
  { k=subcubes[i].getFirst(); 
    if(k!=j)
    { for(int l=j+1; l<=k; l++) bound[l][0] = i;    
      j = k;
    }
  }
  for(i=j+1; i<61; i++) bound[i][0] = subcubesBis; 


  for(k=0; k<60; k++)
  { while(1)
    { j=1;
      for(i=bound[k][0]; i<bound[k+1][0]-1; i++)
      { if(subcubes[i].getNumber() > subcubes[i+1].getNumber())
        { subcubes[i].swap(subcubes[i+1]); 
          j = 0;
        }
       } // for i
      if(j) break;    
    }
  } // for k

  for(k=0; k<60; k++)
  { j=0;
    for(i=bound[k][0]; i<bound[k+1][0]; i++)
    { int l=subcubes[i].getNumber();
      if(l!=j)
      { if(l==j+1) { bound[k][l] = i; }
        else
        { for(int k0=j+1;k0<=l;k0++) bound[k][k0] = i;
        } 
        j=l;
        if(l==11) break;
      }
    } // for i
    for(int k0=j+1;k0<12;k0++) bound[k][k0] = i;
  } // for k


// init strukturen L

  j = 59-subcubesL[0].getLast();
  for(i=0; i<=j; i++) boundL[i][0] = 0;
  
  for(i=1;i<subcubesBisL;i++)
  { k=59-subcubesL[i].getLast(); 
    if(k!=j)
    { for(int l=j+1; l<=k; l++) boundL[l][0] = i;    
      j = k;
    }
  }
  for(i=j+1; i<59; i++) boundL[i][0] = subcubesBisL;

  for(k=0; k<59; k++)
  { while(1)
    { j=1;
      for(i=boundL[k][0]; i<boundL[k+1][0]-1; i++)
      { if(subcubesL[i].getNumber() > subcubesL[i+1].getNumber())
        { subcubesL[i].swap(subcubesL[i+1]); 
          j = 0;
        }
       } // for i
      if(j) break;    
    }
  } // for k

  for(k=0; k<59; k++)
  { j=0;
    for(i=boundL[k][0]; i<boundL[k+1][0]; i++)
    { int l=subcubesL[i].getNumber();
      if(l!=j)
      { if(l==j+1) { boundL[k][l] = i; }
        else
        { for(int k0=j+1;k0<=l;k0++) boundL[k][k0] = i;
        } 
        j=l;
        if(l==11) break;
      }
    } // for i
    for(int k0=j+1;k0<12;k0++) boundL[k][k0] = i;
  } // for k


} // initSubcubes

///////////////////// Hilfsmethoden -----------------


int helpCalcSubcubes(Subcube &cube,int k7, int j3,int j2,int j1,int j0,int count)
{ Subcube cubeHelp0,cubeHelp1,cubeHelp2;
  int k8,k9,k10,bis1,bis2,bis3;

                  cubeHelp0.set(cube);
                  bis1 = bound[k7][j3+1];
                  for(int i7=bound[k7][j3]; i7<bis1; i7++)
                  { if(cube.addL(subcubes[i7])) k8 = cube.getFirstNull2(k7); 
                      else continue;
// 8 j2
                    cubeHelp1.set(cube);
                    bis2 = bound[k8][j2+1];
                    for(int i8=bound[k8][j2]; i8<bis2; i8++)
                    { if(cube.addL(subcubes[i8])) k9 = cube.getFirstNull2(k8); 
                        else continue;
         
                      cubeHelp2.set(cube);
                      bis3 = bound[k9][j0+1];     
                      for(int i9=bound[k9][j0]; i9<bis3; i9++)
                      { if(cube.addL(subcubes[i9])) k10 = cube.getFirstNull2(k9); 
                          else continue;

                        for(int i10=bound[k10][j1]; i10<bound[k10][j1+1]; i10++)
                        { if(!cube.compare2(subcubes[i10]))
                          { count++;
                            break;  
                          } 
                        }

                        cube.set(cubeHelp2);
                      } // for i9

                      bis3 = bound[k9][j1+1];
                      for(i9=bound[k9][j1]; i9<bis3; i9++)
                      { if(cube.addL(subcubes[i9])) k10 = cube.getFirstNull2(k9); 
                          else continue;

                        for(int i10=bound[k10][j0]; i10<bound[k10][j0+1]; i10++)
                        { if(!cube.compare2(subcubes[i10]))
                          { count++;
                            break;  
                          }
                        }

                        cube.set(cubeHelp2);
                      } // for i9

                      cube.set(cubeHelp1);
                    } // for i8
// 8 j1
                    bis2 = bound[k8][j1+1];
                    for(i8=bound[k8][j1]; i8<bis2; i8++)
                    { if(cube.addL(subcubes[i8])) k9 = cube.getFirstNull2(k8); 
                        else continue;
         
                      cubeHelp2.set(cube);
                      bis3 = bound[k9][j0+1]; 
                      for(int i9=bound[k9][j0]; i9<bis3; i9++)
                      { if(cube.addL(subcubes[i9])) k10 = cube.getFirstNull2(k9); 
                          else continue;

                        for(int i10=bound[k10][j2]; i10<bound[k10][j2+1]; i10++)
                        { if(!cube.compare2(subcubes[i10]))
                          { count++;
                            break;  
                          }
                        }

                        cube.set(cubeHelp2);
                      } // for i9

                      bis3 = bound[k9][j2+1];
                      for(i9=bound[k9][j2]; i9<bis3; i9++)
                      { if(cube.addL(subcubes[i9])) k10 = cube.getFirstNull2(k9); 
                          else continue;

                        for(int i10=bound[k10][j0]; i10<bound[k10][j0+1]; i10++)
                        { if(!cube.compare2(subcubes[i10]))
                          { count++;
                            break;  
                          }
                        }

                        cube.set(cubeHelp2);
                      } // for i9

                      cube.set(cubeHelp1);
                    } // for i8
// 8 j0
                    bis2 = bound[k8][j0+1];
                    for(i8=bound[k8][j0]; i8<bis2; i8++)
                    { if(cube.addL(subcubes[i8])) k9 = cube.getFirstNull2(k8); 
                        else continue;
         
                      cubeHelp2.set(cube);
                      bis3 = bound[k9][j1+1];
                      for(int i9=bound[k9][j1]; i9<bis3; i9++)
                      { if(cube.addL(subcubes[i9])) k10 = cube.getFirstNull2(k9); 
                          else continue;

                        for(int i10=bound[k10][j2]; i10<bound[k10][j2+1]; i10++)
                        { if(!cube.compare2(subcubes[i10]))
                          { count++;
                            break;  
                          }
                        }

                        cube.set(cubeHelp2);
                      } // for i9

                      bis3 = bound[k9][j2+1];
                      for(i9=bound[k9][j2]; i9<bis3; i9++)
                      { if(cube.addL(subcubes[i9])) k10 = cube.getFirstNull2(k9); 
                          else continue;

                        for(int i10=bound[k10][j1]; i10<bound[k10][j1+1]; i10++)
                        { if(!cube.compare2(subcubes[i10]))
                          { count++;
                            break;  
                          }
                        }

                        cube.set(cubeHelp2);
                      } // for i9

                      cube.set(cubeHelp1);
                    } // for i8

                    cube.set(cubeHelp0);
                  } // for i7
   return count;
} // helpCalcSubcubes


int helpCalcSubcubes2(Subcube &cube,int k6,int j4,int j3,int j2,int j1,int j0,int count)
{ Subcube cubeHelp6;
  int k7,bis,*bh = bound[k6];
//j4
                cubeHelp6.set(cube); 
                bis = bh[j4+1];
                for(int i6=bh[j4]; i6 < bis; i6++)
                { if(cube.addL(subcubes[i6])) k7 = cube.getFirstNull2(k6); 
                    else continue;
                  count = helpCalcSubcubes(cube,k7,j3,j2,j0,j1,count);
                  count = helpCalcSubcubes(cube,k7,j2,j3,j0,j1,count);
                  count = helpCalcSubcubes(cube,k7,j1,j2,j0,j3,count);
                  count = helpCalcSubcubes(cube,k7,j0,j2,j3,j1,count);
                  cube.set(cubeHelp6);
                } // for i6
// j3
                bis = bh[j3+1];  
                for(i6=bh[j3]; i6 < bis; i6++)
                { if(cube.addL(subcubes[i6])) k7 = cube.getFirstNull2(k6); 
                    else continue;
                  count = helpCalcSubcubes(cube,k7,j4,j2,j0,j1,count);
                  count = helpCalcSubcubes(cube,k7,j2,j4,j0,j1,count);
                  count = helpCalcSubcubes(cube,k7,j1,j2,j0,j4,count);
                  count = helpCalcSubcubes(cube,k7,j0,j2,j4,j1,count);
                  cube.set(cubeHelp6);
                } // for i6
// j2
                bis = bh[j2+1];
                for(i6=bh[j2]; i6 < bis; i6++)
                { if(cube.addL(subcubes[i6])) k7 = cube.getFirstNull2(k6); 
                    else continue;
                  count = helpCalcSubcubes(cube,k7,j3,j4,j0,j1,count);
                  count = helpCalcSubcubes(cube,k7,j4,j3,j0,j1,count);
                  count = helpCalcSubcubes(cube,k7,j1,j4,j0,j3,count);
                  count = helpCalcSubcubes(cube,k7,j0,j4,j3,j1,count);
                  cube.set(cubeHelp6);
                } // for i6
// j1
                bis = bh[j1+1];
                for(i6=bh[j1]; i6 < bis; i6++)
                { if(cube.addL(subcubes[i6])) k7 = cube.getFirstNull2(k6); 
                    else continue;
                  count = helpCalcSubcubes(cube,k7,j3,j2,j0,j4,count);
                  count = helpCalcSubcubes(cube,k7,j2,j3,j0,j4,count);
                  count = helpCalcSubcubes(cube,k7,j4,j2,j0,j3,count);
                  count = helpCalcSubcubes(cube,k7,j0,j2,j3,j4,count);
                  cube.set(cubeHelp6);
                } // for i6
// j0
                bis = bh[j0+1];
                for(i6=bh[j0]; i6 < bis; i6++)
                { if(cube.addL(subcubes[i6])) k7 = cube.getFirstNull2(k6); 
                    else continue;
                  count = helpCalcSubcubes(cube,k7,j3,j2,j4,j1,count);
                  count = helpCalcSubcubes(cube,k7,j2,j3,j4,j1,count);
                  count = helpCalcSubcubes(cube,k7,j1,j2,j4,j3,count);
                  count = helpCalcSubcubes(cube,k7,j4,j2,j3,j1,count);
                  cube.set(cubeHelp6);
                } // for i6
  return count;
} // helpCalcSubcubes2


int helpCalcSubcubes3(Subcube &cube,int k5,int j5,int j4,int j3,int j2,int j1,int j0,int count)
{ Subcube cubeHelp5;
  int k6,bis;
// j5 
              cubeHelp5.set(cube);
              bis = bound[k5][j5+1]; 
              for(int i5=bound[k5][j5]; i5<bis; i5++)
              { if(cube.add(subcubes[i5])) k6 = cube.getFirstNull2(k5); 
                  else continue;
                count = helpCalcSubcubes2(cube,k6,j4,j3,j2,j0,j1,count);
                cube.set(cubeHelp5);
              } // for i5
// j4 
              bis = bound[k5][j4+1];
              for(i5=bound[k5][j4]; i5<bis; i5++)
              { if(cube.add(subcubes[i5])) k6 = cube.getFirstNull2(k5); 
                  else continue;
                count = helpCalcSubcubes2(cube,k6,j5,j3,j2,j0,j1,count);
                cube.set(cubeHelp5);
              } // for i5
// j3
              bis = bound[k5][j3+1];
              for(i5=bound[k5][j3]; i5<bis; i5++)
              { if(cube.add(subcubes[i5])) k6 = cube.getFirstNull2(k5); 
                  else continue;
                count = helpCalcSubcubes2(cube,k6,j4,j5,j2,j0,j1,count);
                cube.set(cubeHelp5);
              } // for i5
// j2
              bis = bound[k5][j2+1];
              for(i5=bound[k5][j2]; i5<bis; i5++)
              { if(cube.add(subcubes[i5])) k6 = cube.getFirstNull2(k5); 
                  else continue;
                count = helpCalcSubcubes2(cube,k6,j4,j3,j5,j0,j1,count);
                cube.set(cubeHelp5);
              } // for i5
// j1
              bis = bound[k5][j1+1];
              for(i5=bound[k5][j1]; i5<bis; i5++)
              { if(cube.add(subcubes[i5])) k6 = cube.getFirstNull2(k5); 
                  else continue;
                count = helpCalcSubcubes2(cube,k6,j4,j3,j2,j0,j5,count);
                cube.set(cubeHelp5);
              } // for i5
// j0
              bis = bound[k5][j0+1];
              for(i5=bound[k5][j0]; i5<bis; i5++)
              { if(cube.add(subcubes[i5])) k6 = cube.getFirstNull2(k5); 
                  else continue;
                count = helpCalcSubcubes2(cube,k6,j4,j3,j2,j5,j1,count);
                cube.set(cubeHelp5);
              } // for i5

  return count;
} // helpCalcSubcubes3


int helpCalcSubcubes4(Subcube &cube,int k4,int j6,int j5,int j4,int j3,int j2,int j1,int j0,int count)
{ Subcube cubeHelp4;
  int k5,bis;
//j6
            cubeHelp4.set(cube);
            bis = bound[k4][j6+1];
            for(int i4=bound[k4][j6]; i4<bis; i4++)
            { if(cube.add(subcubes[i4])) k5 = cube.getFirstNull2(k4); 
                else continue;
              count = helpCalcSubcubes3(cube,k5,j5,j4,j3,j2,j0,j1,count);
              cube.set(cubeHelp4);
            } // for i4
//j5
            bis = bound[k4][j5+1];
            for(i4=bound[k4][j5]; i4<bis; i4++)
            { if(cube.add(subcubes[i4])) k5 = cube.getFirstNull2(k4); 
                else continue;
              count = helpCalcSubcubes3(cube,k5,j6,j4,j3,j2,j0,j1,count);
              cube.set(cubeHelp4);
            } // for i4
//j4
            bis = bound[k4][j4+1];
            for(i4=bound[k4][j4]; i4<bis; i4++)
            { if(cube.add(subcubes[i4])) k5 = cube.getFirstNull2(k4); 
                else continue;
              count = helpCalcSubcubes3(cube,k5,j5,j6,j3,j2,j0,j1,count);
              cube.set(cubeHelp4);
            } // for i4
//j3
            bis = bound[k4][j3+1];
            for(i4=bound[k4][j3]; i4<bis; i4++)
            { if(cube.add(subcubes[i4])) k5 = cube.getFirstNull2(k4); 
                else continue;
              count = helpCalcSubcubes3(cube,k5,j5,j4,j6,j2,j0,j1,count);
              cube.set(cubeHelp4);
            } // for i4
//j2
            bis = bound[k4][j2+1];
            for(i4=bound[k4][j2]; i4<bis; i4++)
            { if(cube.add(subcubes[i4])) k5 = cube.getFirstNull2(k4); 
                else continue;
              count = helpCalcSubcubes3(cube,k5,j5,j4,j3,j6,j0,j1,count);
              cube.set(cubeHelp4);
            } // for i4
//j1
            bis = bound[k4][j1+1];
            for(i4=bound[k4][j1]; i4<bis; i4++)
            { if(cube.add(subcubes[i4])) k5 = cube.getFirstNull2(k4); 
                else continue;
              count = helpCalcSubcubes3(cube,k5,j5,j4,j3,j2,j0,j6,count);
              cube.set(cubeHelp4);
            } // for i4
//j0
            bis = bound[k4][j0+1];
            for(i4=bound[k4][j0]; i4<bis; i4++)
            { if(cube.add(subcubes[i4])) k5 = cube.getFirstNull2(k4); 
                else continue;
              count = helpCalcSubcubes3(cube,k5,j5,j4,j3,j2,j6,j1,count);
              cube.set(cubeHelp4);
            } // for i4

  return count;
} // helpCalcSubcubes4


int helpCalcSubcubes5(Subcube &cube,int k3,int j7,int j6,int j5,int j4,int j3,int j2,int j1,int j0,int count)
{ Subcube cubeHelp3;
  int k4;
// j7          
          cubeHelp3.set(cube);
          for(int i3=bound[k3][j7]; i3<bound[k3][j7+1]; i3++)
          { if(cube.add(subcubes[i3])) k4 = cube.getFirstNull2(k3); 
              else continue;
            count = helpCalcSubcubes4(cube,k4,j6,j5,j4,j3,j2,j0,j1,count);
            cube.set(cubeHelp3);
          } // for i3
// j6         
          for(i3=bound[k3][j6]; i3<bound[k3][j6+1]; i3++)
          { if(cube.add(subcubes[i3])) k4 = cube.getFirstNull2(k3); 
              else continue;
            count = helpCalcSubcubes4(cube,k4,j7,j5,j4,j3,j2,j0,j1,count);
            cube.set(cubeHelp3);
          } // for i3
// j5
          for(i3=bound[k3][j5]; i3<bound[k3][j5+1]; i3++)
          { if(cube.add(subcubes[i3])) k4 = cube.getFirstNull2(k3); 
              else continue;
            count = helpCalcSubcubes4(cube,k4,j6,j7,j4,j3,j2,j0,j1,count);
            cube.set(cubeHelp3);
          } // for i3
// j4         
          for(i3=bound[k3][j4]; i3<bound[k3][j4+1]; i3++)
          { if(cube.add(subcubes[i3])) k4 = cube.getFirstNull2(k3); 
              else continue;
            count = helpCalcSubcubes4(cube,k4,j6,j5,j7,j3,j2,j0,j1,count);
            cube.set(cubeHelp3);
          } // for i3
// j3         
          for(i3=bound[k3][j3]; i3<bound[k3][j3+1]; i3++)
          { if(cube.add(subcubes[i3])) k4 = cube.getFirstNull2(k3); 
              else continue;
            count = helpCalcSubcubes4(cube,k4,j6,j5,j4,j7,j2,j0,j1,count);
            cube.set(cubeHelp3);
          } // for i3
// j2         
          for(i3=bound[k3][j2]; i3<bound[k3][j2+1]; i3++)
          { if(cube.add(subcubes[i3])) k4 = cube.getFirstNull2(k3); 
              else continue;
            count = helpCalcSubcubes4(cube,k4,j6,j5,j4,j3,j7,j0,j1,count);
            cube.set(cubeHelp3);
          } // for i3
// j1
          for(i3=bound[k3][j1]; i3<bound[k3][j1+1]; i3++)
          { if(cube.add(subcubes[i3])) k4 = cube.getFirstNull2(k3); 
              else continue;
            count = helpCalcSubcubes4(cube,k4,j6,j5,j4,j3,j2,j0,j7,count);
            cube.set(cubeHelp3);
          } // for i3
// j0         
          for(i3=bound[k3][j0]; i3<bound[k3][j0+1]; i3++)
          { if(cube.add(subcubes[i3])) k4 = cube.getFirstNull2(k3); 
              else continue;
            count = helpCalcSubcubes4(cube,k4,j6,j5,j4,j3,j2,j7,j1,count);
            cube.set(cubeHelp3);
          } // for i3

  return count;
} // helpCalcSubcubes5



int helpCalcSubcubes6(Subcube &cube,int k2,int j8,int j7,int j6,int j5,int j4,int j3,int j2,int j1,int j0,int count)
{ Subcube cubeHelp2;
  int k3,*bh = bound[k2];
// j8
        cubeHelp2.set(cube);
        for(int i2=bh[j8]; i2<bh[j8+1]; i2++)
        { if(cube.add(subcubes[i2])) k3 = cube.getFirstNull2(k2); 
            else continue;
          count = helpCalcSubcubes5(cube,k3,j7,j6,j5,j4,j3,j2,j0,j1,count);
          cube.set(cubeHelp2);
        } // for i2
// j7
        for(i2=bh[j7]; i2<bh[j7+1]; i2++)
        { if(cube.add(subcubes[i2])) k3 = cube.getFirstNull2(k2); 
            else continue;
          count = helpCalcSubcubes5(cube,k3,j8,j6,j5,j4,j3,j2,j0,j1,count);
          cube.set(cubeHelp2);
        } // for i2
// j6
        for(i2=bh[j6]; i2<bh[j6+1]; i2++)
        { if(cube.add(subcubes[i2])) k3 = cube.getFirstNull2(k2); 
            else continue;
          count = helpCalcSubcubes5(cube,k3,j7,j8,j5,j4,j3,j2,j0,j1,count);
          cube.set(cubeHelp2);
        } // for i2
// j5
        for(i2=bh[j5]; i2<bh[j5+1]; i2++)
        { if(cube.add(subcubes[i2])) k3 = cube.getFirstNull2(k2); 
            else continue;
          count = helpCalcSubcubes5(cube,k3,j7,j6,j8,j4,j3,j2,j0,j1,count);
          cube.set(cubeHelp2);
        } // for i2
// j4
        for(i2=bh[j4]; i2<bh[j4+1]; i2++)
        { if(cube.add(subcubes[i2])) k3 = cube.getFirstNull2(k2); 
            else continue;
          count = helpCalcSubcubes5(cube,k3,j7,j6,j5,j8,j3,j2,j0,j1,count);
          cube.set(cubeHelp2);
        } // for i2
// j3
        for(i2=bh[j3]; i2<bh[j3+1]; i2++)
        { if(cube.add(subcubes[i2])) k3 = cube.getFirstNull2(k2); 
            else continue;
          count = helpCalcSubcubes5(cube,k3,j7,j6,j5,j4,j8,j2,j0,j1,count);
          cube.set(cubeHelp2);
        } // for i2
// j2
        for(i2=bh[j2]; i2<bh[j2+1]; i2++)
        { if(cube.add(subcubes[i2])) k3 = cube.getFirstNull2(k2); 
            else continue;
          count = helpCalcSubcubes5(cube,k3,j7,j6,j5,j4,j3,j8,j0,j1,count);
          cube.set(cubeHelp2);
        } // for i2
// j1
        for(i2=bh[j1]; i2<bh[j1+1]; i2++)
        { if(cube.add(subcubes[i2])) k3 = cube.getFirstNull2(k2); 
            else continue;
          count = helpCalcSubcubes5(cube,k3,j7,j6,j5,j4,j3,j2,j0,j8,count);
          cube.set(cubeHelp2);
        } // for i2
// j0
        for(i2=bh[j0]; i2<bh[j0+1]; i2++)
        { if(cube.add(subcubes[i2])) k3 = cube.getFirstNull2(k2); 
            else continue;
          count = helpCalcSubcubes5(cube,k3,j7,j6,j5,j4,j3,j2,j8,j1,count);
          cube.set(cubeHelp2);
        } // for i2

  return count;
} // helpCalcSubcubes6

int helpCalcSubcubes7(Subcube &cube,int k1,int j9,int j8,int j7,int j6,int j5,int j4,int j3,int j2,int j1,int j0,int count)
{ Subcube cubeHelp1;
  int k2,*bh = bound[k1];
// j9
      cubeHelp1.set(cube);
      for(int i1=bh[j9]; i1<bh[j9+1]; i1++)
      { if(cube.add(subcubes[i1])) k2 = cube.getFirstNull2(k1); 
          else continue;
        count = helpCalcSubcubes6(cube,k2,j8,j7,j6,j5,j4,j3,j2,j0,j1,count);
        cube.set(cubeHelp1);
      } // for i1
// j8
      for(i1=bh[j8]; i1<bh[j8+1]; i1++)
      { if(cube.add(subcubes[i1])) k2 = cube.getFirstNull2(k1); 
          else continue;
        count = helpCalcSubcubes6(cube,k2,j9,j7,j6,j5,j4,j3,j2,j0,j1,count);
        cube.set(cubeHelp1);
      } // for i1
// j7
      for(i1=bh[j7]; i1<bh[j7+1]; i1++)
      { if(cube.add(subcubes[i1])) k2 = cube.getFirstNull2(k1); 
          else continue;
        count = helpCalcSubcubes6(cube,k2,j8,j9,j6,j5,j4,j3,j2,j0,j1,count);
        cube.set(cubeHelp1);
      } // for i1
// j6
      for(i1=bh[j6]; i1<bh[j6+1]; i1++)
      { if(cube.add(subcubes[i1])) k2 = cube.getFirstNull2(k1); 
          else continue;
        count = helpCalcSubcubes6(cube,k2,j8,j7,j9,j5,j4,j3,j2,j0,j1,count);
        cube.set(cubeHelp1);
      } // for i1
// j5
      for(i1=bh[j5]; i1<bh[j5+1]; i1++)
      { if(cube.add(subcubes[i1])) k2 = cube.getFirstNull2(k1); 
          else continue;
        count = helpCalcSubcubes6(cube,k2,j8,j7,j6,j9,j4,j3,j2,j0,j1,count);
        cube.set(cubeHelp1);
      } // for i1
// j4
      for(i1=bh[j4]; i1<bh[j4+1]; i1++)
      { if(cube.add(subcubes[i1])) k2 = cube.getFirstNull2(k1); 
          else continue;
        count = helpCalcSubcubes6(cube,k2,j8,j7,j6,j5,j9,j3,j2,j0,j1,count);
        cube.set(cubeHelp1);
      } // for i1
// j3
      for(i1=bh[j3]; i1<bh[j3+1]; i1++)
      { if(cube.add(subcubes[i1])) k2 = cube.getFirstNull2(k1); 
          else continue;
        count = helpCalcSubcubes6(cube,k2,j8,j7,j6,j5,j4,j9,j2,j0,j1,count);
        cube.set(cubeHelp1);
      } // for i1
// j2
      for(i1=bh[j2]; i1<bh[j2+1]; i1++)
      { if(cube.add(subcubes[i1])) k2 = cube.getFirstNull2(k1); 
          else continue;
        count = helpCalcSubcubes6(cube,k2,j8,j7,j6,j5,j4,j3,j9,j0,j1,count);
        cube.set(cubeHelp1);
      } // for i1
// j1
      for(i1=bh[j1]; i1<bh[j1+1]; i1++)
      { if(cube.add(subcubes[i1])) k2 = cube.getFirstNull2(k1); 
          else continue;
        count = helpCalcSubcubes6(cube,k2,j8,j7,j6,j5,j4,j3,j2,j0,j9,count);
        cube.set(cubeHelp1);
      } // for i1
// j0
      for(i1=bh[j0]; i1<bh[j0+1]; i1++)
      { if(cube.add(subcubes[i1])) k2 = cube.getFirstNull2(k1); 
          else continue;
        count = helpCalcSubcubes6(cube,k2,j8,j7,j6,j5,j4,j3,j2,j9,j1,count);
        cube.set(cubeHelp1);
      } // for i1

  return count;
} // helpCalcSubcubes7


int helpCalcSubcubes8(Subcube &cube,int j10,int j9,int j8,int j7,int j6,int j5,int j4,int j3,int j2,int j1,int j0,int count)
{ Subcube cubeHelp0;
  int k1,*bh = bound[4];
// j10
    cubeHelp0.set(cube);
    for(int i0=bh[j10]; i0<bh[j10+1]; i0++)
    { if(cube.add(subcubes[i0])) k1 = cube.getFirstNull();
        else continue;
      count = helpCalcSubcubes7(cube,k1,j9,j8,j7,j6,j5,j4,j3,j2,j0,j1,count);
      cube.set(cubeHelp0);
    } // for i0
// j9
    for(i0=bh[j9]; i0<bh[j9+1]; i0++)
    { if(cube.add(subcubes[i0])) k1 = cube.getFirstNull();
        else continue;
      count = helpCalcSubcubes7(cube,k1,j10,j8,j7,j6,j5,j4,j3,j2,j0,j1,count);
      cube.set(cubeHelp0);
    } // for i0
// j8
    for(i0=bh[j8]; i0<bh[j8+1]; i0++)
    { if(cube.add(subcubes[i0])) k1 = cube.getFirstNull();
        else continue;
      count = helpCalcSubcubes7(cube,k1,j9,j10,j7,j6,j5,j4,j3,j2,j0,j1,count);
      cube.set(cubeHelp0);
    } // for i0
// j7
    for(i0=bh[j7]; i0<bh[j7+1]; i0++)
    { if(cube.add(subcubes[i0])) k1 = cube.getFirstNull();
        else continue;
      count = helpCalcSubcubes7(cube,k1,j9,j8,j10,j6,j5,j4,j3,j2,j0,j1,count);
      cube.set(cubeHelp0);
    } // for i0
// j6
    for(i0=bh[j6]; i0<bh[j6+1]; i0++)
    { if(cube.add(subcubes[i0])) k1 = cube.getFirstNull();
        else continue;
      count = helpCalcSubcubes7(cube,k1,j9,j8,j7,j10,j5,j4,j3,j2,j0,j1,count);
      cube.set(cubeHelp0);
    } // for i0
// j5
    for(i0=bh[j5]; i0<bh[j5+1]; i0++)
    { if(cube.add(subcubes[i0])) k1 = cube.getFirstNull();
        else continue;
      count = helpCalcSubcubes7(cube,k1,j9,j8,j7,j6,j10,j4,j3,j2,j0,j1,count);
      cube.set(cubeHelp0);
    } // for i0
// j4
    for(i0=bh[j4]; i0<bh[j4+1]; i0++)
    { if(cube.add(subcubes[i0])) k1 = cube.getFirstNull();
        else continue;
      count = helpCalcSubcubes7(cube,k1,j9,j8,j7,j6,j5,j10,j3,j2,j0,j1,count);
      cube.set(cubeHelp0);
    } // for i0
// j3
    for(i0=bh[j3]; i0<bh[j3+1]; i0++)
    { if(cube.add(subcubes[i0])) k1 = cube.getFirstNull();
        else continue;
      count = helpCalcSubcubes7(cube,k1,j9,j8,j7,j6,j5,j4,j10,j2,j0,j1,count);
      cube.set(cubeHelp0);
    } // for i0
// j2
    for(i0=bh[j2]; i0<bh[j2+1]; i0++)
    { if(cube.add(subcubes[i0])) k1 = cube.getFirstNull();
        else continue;
      count = helpCalcSubcubes7(cube,k1,j9,j8,j7,j6,j5,j4,j3,j10,j0,j1,count);
      cube.set(cubeHelp0);
    } // for i0
// j1
    for(i0=bh[j1]; i0<bh[j1+1]; i0++)
    { if(cube.add(subcubes[i0])) k1 = cube.getFirstNull();
        else continue;
      count = helpCalcSubcubes7(cube,k1,j9,j8,j7,j6,j5,j4,j3,j2,j0,j10,count);
      cube.set(cubeHelp0);
    } // for i0
// j0
    for(i0=bh[j0]; i0<bh[j0+1]; i0++)
    { if(cube.add(subcubes[i0])) k1 = cube.getFirstNull();
        else continue;
      count = helpCalcSubcubes7(cube,k1,j9,j8,j7,j6,j5,j4,j3,j2,j10,j1,count);
      cube.set(cubeHelp0);
    } // for i0
 return count;
} // helpCalcSubcubes8
//----------------------   Last - Vesrsion -----------------------


int helpCalcSubcubesL(Subcube &cube,int k7, int j3,int j2,int j1,int j0,int count)
{ Subcube cubeHelp0,cubeHelp1,cubeHelp2;
  int k8,k9,k10,bis1,bis2,bis3;

                  cubeHelp0.set(cube);
                  bis1 = boundL[k7][j3+1];
                  for(int i7=boundL[k7][j3]; i7<bis1; i7++)
                  { if(cube.add(subcubesL[i7])) k8 = cube.getLastNull2(k7); 
                      else continue;
// 8 j2
                    cubeHelp1.set(cube);
                    bis2 = boundL[k8][j2+1];
                    for(int i8=boundL[k8][j2]; i8<bis2; i8++)
                    { if(cube.add(subcubesL[i8])) k9 = cube.getLastNull2(k8); 
                        else continue;
         
                      cubeHelp2.set(cube);
                      bis3 = boundL[k9][j0+1];     
                      for(int i9=boundL[k9][j0]; i9<bis3; i9++)
                      { if(cube.add(subcubesL[i9])) k10 = cube.getLastNull2(k9); 
                          else continue;

                        for(int i10=boundL[k10][j1]; i10<boundL[k10][j1+1]; i10++)
                        { if(!cube.compare2(subcubesL[i10]))
                          { count++;
                            break;  
                          } 
                        }

                        cube.set(cubeHelp2);
                      } // for i9

                      bis3 = boundL[k9][j1+1];
                      for(i9=boundL[k9][j1]; i9<bis3; i9++)
                      { if(cube.add(subcubesL[i9])) k10 = cube.getLastNull2(k9); 
                          else continue;

                        for(int i10=boundL[k10][j0]; i10<boundL[k10][j0+1]; i10++)
                        { if(!cube.compare2(subcubesL[i10]))
                          { count++;
                            break;  
                          }
                        }

                        cube.set(cubeHelp2);
                      } // for i9

                      cube.set(cubeHelp1);
                    } // for i8
// 8 j1
                    bis2 = boundL[k8][j1+1];
                    for(i8=boundL[k8][j1]; i8<bis2; i8++)
                    { if(cube.add(subcubesL[i8])) k9 = cube.getLastNull2(k8); 
                        else continue;
         
                      cubeHelp2.set(cube);
                      bis3 = boundL[k9][j0+1]; 
                      for(int i9=boundL[k9][j0]; i9<bis3; i9++)
                      { if(cube.add(subcubesL[i9])) k10 = cube.getLastNull2(k9); 
                          else continue;

                        for(int i10=boundL[k10][j2]; i10<boundL[k10][j2+1]; i10++)
                        { if(!cube.compare2(subcubesL[i10]))
                          { count++;
                            break;  
                          }
                        }

                        cube.set(cubeHelp2);
                      } // for i9

                      bis3 = boundL[k9][j2+1];
                      for(i9=boundL[k9][j2]; i9<bis3; i9++)
                      { if(cube.add(subcubesL[i9])) k10 = cube.getLastNull2(k9); 
                          else continue;

                        for(int i10=boundL[k10][j0]; i10<boundL[k10][j0+1]; i10++)
                        { if(!cube.compare2(subcubesL[i10]))
                          { count++;
                            break;  
                          }
                        }

                        cube.set(cubeHelp2);
                      } // for i9

                      cube.set(cubeHelp1);
                    } // for i8
// 8 j0
                    bis2 = boundL[k8][j0+1];
                    for(i8=boundL[k8][j0]; i8<bis2; i8++)
                    { if(cube.add(subcubesL[i8])) k9 = cube.getLastNull2(k8); 
                        else continue;
         
                      cubeHelp2.set(cube);
                      bis3 = boundL[k9][j1+1];
                      for(int i9=boundL[k9][j1]; i9<bis3; i9++)
                      { if(cube.add(subcubesL[i9])) k10 = cube.getLastNull2(k9); 
                          else continue;

                        for(int i10=boundL[k10][j2]; i10<boundL[k10][j2+1]; i10++)
                        { if(!cube.compare2(subcubesL[i10]))
                          { count++;
                            break;  
                          }
                        }

                        cube.set(cubeHelp2);
                      } // for i9

                      bis3 = boundL[k9][j2+1];
                      for(i9=boundL[k9][j2]; i9<bis3; i9++)
                      { if(cube.add(subcubesL[i9])) k10 = cube.getLastNull2(k9); 
                          else continue;

                        for(int i10=boundL[k10][j1]; i10<boundL[k10][j1+1]; i10++)
                        { if(!cube.compare2(subcubesL[i10]))
                          { count++;
                            break;  
                          }
                        }

                        cube.set(cubeHelp2);
                      } // for i9

                      cube.set(cubeHelp1);
                    } // for i8

                    cube.set(cubeHelp0);
                  } // for i7
   return count;
} // helpCalcSubcubesL


int helpCalcSubcubesL2(Subcube &cube,int k6,int j4,int j3,int j2,int j1,int j0,int count)
{ Subcube cubeHelp6;
  int k7,bis;
//j4
                cubeHelp6.set(cube); 
                bis = boundL[k6][j4+1];
                for(int i6=boundL[k6][j4]; i6 < bis; i6++)
                { if(cube.add(subcubesL[i6])) k7 = cube.getLastNull2(k6); 
                    else continue;

                  count = helpCalcSubcubesL(cube,k7,j3,j2,j0,j1,count);
                  count = helpCalcSubcubesL(cube,k7,j2,j3,j0,j1,count);
                  count = helpCalcSubcubesL(cube,k7,j1,j2,j0,j3,count);
                  count = helpCalcSubcubesL(cube,k7,j0,j2,j3,j1,count);

                  cube.set(cubeHelp6);
                } // for i6

// j3
                bis = boundL[k6][j3+1];  
                for(i6=boundL[k6][j3]; i6 < bis; i6++)
                { if(cube.add(subcubesL[i6])) k7 = cube.getLastNull2(k6); 
                    else continue;

                  count = helpCalcSubcubesL(cube,k7,j4,j2,j0,j1,count);
                  count = helpCalcSubcubesL(cube,k7,j2,j4,j0,j1,count);
                  count = helpCalcSubcubesL(cube,k7,j1,j2,j0,j4,count);
                  count = helpCalcSubcubesL(cube,k7,j0,j2,j4,j1,count);

                  cube.set(cubeHelp6);
                } // for i6
// j2
                bis = boundL[k6][j2+1];
                for(i6=boundL[k6][j2]; i6 < bis; i6++)
                { if(cube.add(subcubesL[i6])) k7 = cube.getLastNull2(k6); 
                    else continue;

                  count = helpCalcSubcubesL(cube,k7,j3,j4,j0,j1,count);
                  count = helpCalcSubcubesL(cube,k7,j4,j3,j0,j1,count);
                  count = helpCalcSubcubesL(cube,k7,j1,j4,j0,j3,count);
                  count = helpCalcSubcubesL(cube,k7,j0,j4,j3,j1,count);

                  cube.set(cubeHelp6);
                } // for i6
// j1
                bis = boundL[k6][j1+1];
                for(i6=boundL[k6][j1]; i6 < bis; i6++)
                { if(cube.add(subcubesL[i6])) k7 = cube.getLastNull2(k6); 
                    else continue;

                  count = helpCalcSubcubesL(cube,k7,j3,j2,j0,j4,count);
                  count = helpCalcSubcubesL(cube,k7,j2,j3,j0,j4,count);
                  count = helpCalcSubcubesL(cube,k7,j4,j2,j0,j3,count);
                  count = helpCalcSubcubesL(cube,k7,j0,j2,j3,j4,count);

                  cube.set(cubeHelp6);
                } // for i6
// j0
                bis = boundL[k6][j0+1];
                for(i6=boundL[k6][j0]; i6 < bis; i6++)
                { if(cube.add(subcubesL[i6])) k7 = cube.getLastNull2(k6); 
                    else continue;

                  count = helpCalcSubcubesL(cube,k7,j3,j2,j4,j1,count);
                  count = helpCalcSubcubesL(cube,k7,j2,j3,j4,j1,count);
                  count = helpCalcSubcubesL(cube,k7,j1,j2,j4,j3,count);
                  count = helpCalcSubcubesL(cube,k7,j4,j2,j3,j1,count);

                  cube.set(cubeHelp6);
                } // for i6
  return count;
} // helpCalcSubcubesL2


int helpCalcSubcubesL3(Subcube &cube,int k5,int j5,int j4,int j3,int j2,int j1,int j0,int count)
{ Subcube cubeHelp5;
  int k6,bis;

// j5 
              cubeHelp5.set(cube);
              bis = boundL[k5][j5+1]; 
              for(int i5=boundL[k5][j5]; i5<bis; i5++)
              { if(cube.add(subcubesL[i5])) k6 = cube.getLastNull2(k5); 
                  else continue;
                count = helpCalcSubcubesL2(cube,k6,j4,j3,j2,j0,j1,count);
                cube.set(cubeHelp5);
              } // for i5
// j4 
              bis = boundL[k5][j4+1];
              for(i5=boundL[k5][j4]; i5<bis; i5++)
              { if(cube.add(subcubesL[i5])) k6 = cube.getLastNull2(k5); 
                  else continue;
                count = helpCalcSubcubesL2(cube,k6,j5,j3,j2,j0,j1,count);
                cube.set(cubeHelp5);
              } // for i5
// j3
              bis = boundL[k5][j3+1];
              for(i5=boundL[k5][j3]; i5<bis; i5++)
              { if(cube.add(subcubesL[i5])) k6 = cube.getLastNull2(k5); 
                  else continue;
                count = helpCalcSubcubesL2(cube,k6,j4,j5,j2,j0,j1,count);
                cube.set(cubeHelp5);
              } // for i5
// j2
              bis = boundL[k5][j2+1];
              for(i5=boundL[k5][j2]; i5<bis; i5++)
              { if(cube.add(subcubesL[i5])) k6 = cube.getLastNull2(k5); 
                  else continue;
                count = helpCalcSubcubesL2(cube,k6,j4,j3,j5,j0,j1,count);
                cube.set(cubeHelp5);
              } // for i5
// j1
              bis = boundL[k5][j1+1];
              for(i5=boundL[k5][j1]; i5<bis; i5++)
              { if(cube.add(subcubesL[i5])) k6 = cube.getLastNull2(k5); 
                  else continue;
                count = helpCalcSubcubesL2(cube,k6,j4,j3,j2,j0,j5,count);
                cube.set(cubeHelp5);
              } // for i5
// j0
              bis = boundL[k5][j0+1];
              for(i5=boundL[k5][j0]; i5<bis; i5++)
              { if(cube.add(subcubesL[i5])) k6 = cube.getLastNull2(k5); 
                  else continue;
                count = helpCalcSubcubesL2(cube,k6,j4,j3,j2,j5,j1,count);
                cube.set(cubeHelp5);
              } // for i5

  return count;
} // helpCalcSubcubesL3


int helpCalcSubcubesL4(Subcube &cube,int k4,int j6,int j5,int j4,int j3,int j2,int j1,int j0,int count)
{ Subcube cubeHelp4;
  int k5,bis;
//j6
            cubeHelp4.set(cube);
            bis = boundL[k4][j6+1];
            for(int i4=boundL[k4][j6]; i4<bis; i4++)
            { if(cube.add(subcubesL[i4])) k5 = cube.getLastNull2(k4); 
                else continue;
              count = helpCalcSubcubesL3(cube,k5,j5,j4,j3,j2,j0,j1,count);
              cube.set(cubeHelp4);
            } // for i4
//j5
            bis = boundL[k4][j5+1];
            for(i4=boundL[k4][j5]; i4<bis; i4++)
            { if(cube.add(subcubesL[i4])) k5 = cube.getLastNull2(k4); 
                else continue;
              count = helpCalcSubcubesL3(cube,k5,j6,j4,j3,j2,j0,j1,count);
              cube.set(cubeHelp4);
            } // for i4
//j4
            bis = boundL[k4][j4+1];
            for(i4=boundL[k4][j4]; i4<bis; i4++)
            { if(cube.add(subcubesL[i4])) k5 = cube.getLastNull2(k4); 
                else continue;
              count = helpCalcSubcubesL3(cube,k5,j5,j6,j3,j2,j0,j1,count);
              cube.set(cubeHelp4);
            } // for i4
//j3
            bis = boundL[k4][j3+1];
            for(i4=boundL[k4][j3]; i4<bis; i4++)
            { if(cube.add(subcubesL[i4])) k5 = cube.getLastNull2(k4); 
                else continue;
              count = helpCalcSubcubesL3(cube,k5,j5,j4,j6,j2,j0,j1,count);
              cube.set(cubeHelp4);
            } // for i4
//j2
            bis = boundL[k4][j2+1];
            for(i4=boundL[k4][j2]; i4<bis; i4++)
            { if(cube.add(subcubesL[i4])) k5 = cube.getLastNull2(k4); 
                else continue;
              count = helpCalcSubcubesL3(cube,k5,j5,j4,j3,j6,j0,j1,count);
              cube.set(cubeHelp4);
            } // for i4
//j1
            bis = boundL[k4][j1+1];
            for(i4=boundL[k4][j1]; i4<bis; i4++)
            { if(cube.add(subcubesL[i4])) k5 = cube.getLastNull2(k4); 
                else continue;
              count = helpCalcSubcubesL3(cube,k5,j5,j4,j3,j2,j0,j6,count);
              cube.set(cubeHelp4);
            } // for i4
//j0
            bis = boundL[k4][j0+1];
            for(i4=boundL[k4][j0]; i4<bis; i4++)
            { if(cube.add(subcubesL[i4])) k5 = cube.getLastNull2(k4); 
                else continue;
              count = helpCalcSubcubesL3(cube,k5,j5,j4,j3,j2,j6,j1,count);
              cube.set(cubeHelp4);
            } // for i4

  return count;
} // helpCalcSubcubesL4


int helpCalcSubcubesL5(Subcube &cube,int k3,int j7,int j6,int j5,int j4,int j3,int j2,int j1,int j0,int count)
{ Subcube cubeHelp3;
  int k4;
// j7          
          cubeHelp3.set(cube);
          for(int i3=boundL[k3][j7]; i3<boundL[k3][j7+1]; i3++)
          { if(cube.add(subcubesL[i3])) k4 = cube.getLastNull2(k3); 
              else continue;
            count = helpCalcSubcubesL4(cube,k4,j6,j5,j4,j3,j2,j0,j1,count);
            cube.set(cubeHelp3);
          } // for i3
// j6         
          for(i3=boundL[k3][j6]; i3<boundL[k3][j6+1]; i3++)
          { if(cube.add(subcubesL[i3])) k4 = cube.getLastNull2(k3); 
              else continue;
            count = helpCalcSubcubesL4(cube,k4,j7,j5,j4,j3,j2,j0,j1,count);
            cube.set(cubeHelp3);
          } // for i3
// j5
          for(i3=boundL[k3][j5]; i3<boundL[k3][j5+1]; i3++)
          { if(cube.add(subcubesL[i3])) k4 = cube.getLastNull2(k3); 
              else continue;
            count = helpCalcSubcubesL4(cube,k4,j6,j7,j4,j3,j2,j0,j1,count);
            cube.set(cubeHelp3);
          } // for i3
// j4         
          for(i3=boundL[k3][j4]; i3<boundL[k3][j4+1]; i3++)
          { if(cube.add(subcubesL[i3])) k4 = cube.getLastNull2(k3); 
              else continue;
            count = helpCalcSubcubesL4(cube,k4,j6,j5,j7,j3,j2,j0,j1,count);
            cube.set(cubeHelp3);
          } // for i3
// j3         
          for(i3=boundL[k3][j3]; i3<boundL[k3][j3+1]; i3++)
          { if(cube.add(subcubesL[i3])) k4 = cube.getLastNull2(k3); 
              else continue;
            count = helpCalcSubcubesL4(cube,k4,j6,j5,j4,j7,j2,j0,j1,count);
            cube.set(cubeHelp3);
          } // for i3
// j2         
          for(i3=boundL[k3][j2]; i3<boundL[k3][j2+1]; i3++)
          { if(cube.add(subcubesL[i3])) k4 = cube.getLastNull2(k3); 
              else continue;
            count = helpCalcSubcubesL4(cube,k4,j6,j5,j4,j3,j7,j0,j1,count);
            cube.set(cubeHelp3);
          } // for i3
// j1
          for(i3=boundL[k3][j1]; i3<boundL[k3][j1+1]; i3++)
          { if(cube.add(subcubesL[i3])) k4 = cube.getLastNull2(k3); 
              else continue;
            count = helpCalcSubcubesL4(cube,k4,j6,j5,j4,j3,j2,j0,j7,count);
            cube.set(cubeHelp3);
          } // for i3
// j0         
          for(i3=boundL[k3][j0]; i3<boundL[k3][j0+1]; i3++)
          { if(cube.add(subcubesL[i3])) k4 = cube.getLastNull2(k3); 
              else continue;
            count = helpCalcSubcubesL4(cube,k4,j6,j5,j4,j3,j2,j7,j1,count);
            cube.set(cubeHelp3);
          } // for i3

  return count;
} // helpCalcSubcubesL5


int helpCalcSubcubesL6(Subcube &cube,int k2,int j8,int j7,int j6,int j5,int j4,int j3,int j2,int j1,int j0,int count)
{ Subcube cubeHelp2;
  int k3;

// j8
        cubeHelp2.set(cube);
        for(int i2=boundL[k2][j8]; i2<boundL[k2][j8+1]; i2++)
        { if(cube.add(subcubesL[i2])) k3 = cube.getLastNull2(k2); 
            else continue;
          count = helpCalcSubcubesL5(cube,k3,j7,j6,j5,j4,j3,j2,j0,j1,count);
          cube.set(cubeHelp2);
        } // for i2
// j7
        for(i2=boundL[k2][j7]; i2<boundL[k2][j7+1]; i2++)
        { if(cube.add(subcubesL[i2])) k3 = cube.getLastNull2(k2); 
            else continue;
          count = helpCalcSubcubesL5(cube,k3,j8,j6,j5,j4,j3,j2,j0,j1,count);
          cube.set(cubeHelp2);
        } // for i2
// j6
        for(i2=boundL[k2][j6]; i2<boundL[k2][j6+1]; i2++)
        { if(cube.add(subcubesL[i2])) k3 = cube.getLastNull2(k2); 
            else continue;
          count = helpCalcSubcubesL5(cube,k3,j7,j8,j5,j4,j3,j2,j0,j1,count);
          cube.set(cubeHelp2);
        } // for i2
// j5
        for(i2=boundL[k2][j5]; i2<boundL[k2][j5+1]; i2++)
        { if(cube.add(subcubesL[i2])) k3 = cube.getLastNull2(k2); 
            else continue;
          count = helpCalcSubcubesL5(cube,k3,j7,j6,j8,j4,j3,j2,j0,j1,count);
          cube.set(cubeHelp2);
        } // for i2
// j4
        for(i2=boundL[k2][j4]; i2<boundL[k2][j4+1]; i2++)
        { if(cube.add(subcubesL[i2])) k3 = cube.getLastNull2(k2); 
            else continue;
          count = helpCalcSubcubesL5(cube,k3,j7,j6,j5,j8,j3,j2,j0,j1,count);
          cube.set(cubeHelp2);
        } // for i2
// j3
        for(i2=boundL[k2][j3]; i2<boundL[k2][j3+1]; i2++)
        { if(cube.add(subcubesL[i2])) k3 = cube.getLastNull2(k2); 
            else continue;
          count = helpCalcSubcubesL5(cube,k3,j7,j6,j5,j4,j8,j2,j0,j1,count);
          cube.set(cubeHelp2);
        } // for i2
// j2
        for(i2=boundL[k2][j2]; i2<boundL[k2][j2+1]; i2++)
        { if(cube.add(subcubesL[i2])) k3 = cube.getLastNull2(k2); 
            else continue;
          count = helpCalcSubcubesL5(cube,k3,j7,j6,j5,j4,j3,j8,j0,j1,count);
          cube.set(cubeHelp2);
        } // for i2
// j1
        for(i2=boundL[k2][j1]; i2<boundL[k2][j1+1]; i2++)
        { if(cube.add(subcubesL[i2])) k3 = cube.getLastNull2(k2); 
            else continue;
          count = helpCalcSubcubesL5(cube,k3,j7,j6,j5,j4,j3,j2,j0,j8,count);
          cube.set(cubeHelp2);
        } // for i2
// j0
        for(i2=boundL[k2][j0]; i2<boundL[k2][j0+1]; i2++)
        { if(cube.add(subcubesL[i2])) k3 = cube.getLastNull2(k2); 
            else continue;
          count = helpCalcSubcubesL5(cube,k3,j7,j6,j5,j4,j3,j2,j8,j1,count);
          cube.set(cubeHelp2);
        } // for i2

  return count;
} // helpCalcSubcubesL6


int helpCalcSubcubesL7(Subcube &cube,int k1,int j9,int j8,int j7,int j6,int j5,int j4,int j3,int j2,int j1,int j0,int count)
{ Subcube cubeHelp1;
  int k2;
// j9
      cubeHelp1.set(cube);
      for(int i1=boundL[k1][j9]; i1<boundL[k1][j9+1]; i1++)
      { if(cube.addL(subcubesL[i1])) k2 = cube.getLastNull2(k1); 
          else continue;
        count = helpCalcSubcubesL6(cube,k2,j8,j7,j6,j5,j4,j3,j2,j0,j1,count);
        cube.set(cubeHelp1);
      } // for i1
// j8
      for(i1=boundL[k1][j8]; i1<boundL[k1][j8+1]; i1++)
      { if(cube.addL(subcubesL[i1])) k2 = cube.getLastNull2(k1); 
          else continue;
        count = helpCalcSubcubesL6(cube,k2,j9,j7,j6,j5,j4,j3,j2,j0,j1,count);
        cube.set(cubeHelp1);
      } // for i1
// j7
      for(i1=boundL[k1][j7]; i1<boundL[k1][j7+1]; i1++)
      { if(cube.addL(subcubesL[i1])) k2 = cube.getLastNull2(k1); 
          else continue;
        count = helpCalcSubcubesL6(cube,k2,j8,j9,j6,j5,j4,j3,j2,j0,j1,count);
        cube.set(cubeHelp1);
      } // for i1
// j6
      for(i1=boundL[k1][j6]; i1<boundL[k1][j6+1]; i1++)
      { if(cube.addL(subcubesL[i1])) k2 = cube.getLastNull2(k1); 
          else continue;
        count = helpCalcSubcubesL6(cube,k2,j8,j7,j9,j5,j4,j3,j2,j0,j1,count);
        cube.set(cubeHelp1);
      } // for i1
// j5
      for(i1=boundL[k1][j5]; i1<boundL[k1][j5+1]; i1++)
      { if(cube.addL(subcubesL[i1])) k2 = cube.getLastNull2(k1); 
          else continue;
        count = helpCalcSubcubesL6(cube,k2,j8,j7,j6,j9,j4,j3,j2,j0,j1,count);
        cube.set(cubeHelp1);
      } // for i1
// j4
      for(i1=boundL[k1][j4]; i1<boundL[k1][j4+1]; i1++)
      { if(cube.addL(subcubesL[i1])) k2 = cube.getLastNull2(k1); 
          else continue;
        count = helpCalcSubcubesL6(cube,k2,j8,j7,j6,j5,j9,j3,j2,j0,j1,count);
        cube.set(cubeHelp1);
      } // for i1
// j3
      for(i1=boundL[k1][j3]; i1<boundL[k1][j3+1]; i1++)
      { if(cube.addL(subcubesL[i1])) k2 = cube.getLastNull2(k1); 
          else continue;
        count = helpCalcSubcubesL6(cube,k2,j8,j7,j6,j5,j4,j9,j2,j0,j1,count);
        cube.set(cubeHelp1);
      } // for i1
// j2
      for(i1=boundL[k1][j2]; i1<boundL[k1][j2+1]; i1++)
      { if(cube.addL(subcubesL[i1])) k2 = cube.getLastNull2(k1); 
          else continue;
        count = helpCalcSubcubesL6(cube,k2,j8,j7,j6,j5,j4,j3,j9,j0,j1,count);
        cube.set(cubeHelp1);
      } // for i1
// j1
      for(i1=boundL[k1][j1]; i1<boundL[k1][j1+1]; i1++)
      { if(cube.addL(subcubesL[i1])) k2 = cube.getLastNull2(k1); 
          else continue;
        count = helpCalcSubcubesL6(cube,k2,j8,j7,j6,j5,j4,j3,j2,j0,j9,count);
        cube.set(cubeHelp1);
      } // for i1
// j0
      for(i1=boundL[k1][j0]; i1<boundL[k1][j0+1]; i1++)
      { if(cube.addL(subcubesL[i1])) k2 = cube.getLastNull2(k1); 
          else continue;
        count = helpCalcSubcubesL6(cube,k2,j8,j7,j6,j5,j4,j3,j2,j9,j1,count);
        cube.set(cubeHelp1);
      } // for i1

  return count;
} // helpCalcSubcubesL7


int helpCalcSubcubesL8(Subcube &cube,int j10,int j9,int j8,int j7,int j6,int j5,int j4,int j3,int j2,int j1,int j0,int count)
{ Subcube cubeHelp0;
  int k1,*bh=boundL[0];
// j10
    cubeHelp0.set(cube);
    for(int i0=bh[j10]; i0<bh[j10+1]; i0++)
    { if(cube.addL(subcubesL[i0])) k1 = cube.getLastNull();
        else continue;
      count = helpCalcSubcubesL7(cube,k1,j9,j8,j7,j6,j5,j4,j3,j2,j0,j1,count);
      cube.set(cubeHelp0);
    } // for i0
// j9
    for(i0=bh[j9]; i0<bh[j9+1]; i0++)
    { if(cube.addL(subcubesL[i0])) k1 = cube.getLastNull();
        else continue;
      count = helpCalcSubcubesL7(cube,k1,j10,j8,j7,j6,j5,j4,j3,j2,j0,j1,count);
      cube.set(cubeHelp0);
    } // for i0
// j8
    for(i0=bh[j8]; i0<bh[j8+1]; i0++)
    { if(cube.addL(subcubesL[i0])) k1 = cube.getLastNull();
        else continue;
      count = helpCalcSubcubesL7(cube,k1,j9,j10,j7,j6,j5,j4,j3,j2,j0,j1,count);
      cube.set(cubeHelp0);
    } // for i0
// j7
    for(i0=bh[j7]; i0<bh[j7+1]; i0++)
    { if(cube.addL(subcubesL[i0])) k1 = cube.getLastNull();
        else continue;
      count = helpCalcSubcubesL7(cube,k1,j9,j8,j10,j6,j5,j4,j3,j2,j0,j1,count);
      cube.set(cubeHelp0);
    } // for i0
// j6
    for(i0=bh[j6]; i0<bh[j6+1]; i0++)
    { if(cube.addL(subcubesL[i0])) k1 = cube.getLastNull();
        else continue;
      count = helpCalcSubcubesL7(cube,k1,j9,j8,j7,j10,j5,j4,j3,j2,j0,j1,count);
      cube.set(cubeHelp0);
    } // for i0
// j5
    for(i0=bh[j5]; i0<bh[j5+1]; i0++)
    { if(cube.addL(subcubesL[i0])) k1 = cube.getLastNull();
        else continue;
      count = helpCalcSubcubesL7(cube,k1,j9,j8,j7,j6,j10,j4,j3,j2,j0,j1,count);
      cube.set(cubeHelp0);
    } // for i0
// j4
    for(i0=bh[j4]; i0<bh[j4+1]; i0++)
    { if(cube.addL(subcubesL[i0])) k1 = cube.getLastNull();
        else continue;
      count = helpCalcSubcubesL7(cube,k1,j9,j8,j7,j6,j5,j10,j3,j2,j0,j1,count);
      cube.set(cubeHelp0);
    } // for i0
// j3
    for(i0=bh[j3]; i0<bh[j3+1]; i0++)
    { if(cube.addL(subcubesL[i0])) k1 = cube.getLastNull();
        else continue;
      count = helpCalcSubcubesL7(cube,k1,j9,j8,j7,j6,j5,j4,j10,j2,j0,j1,count);
      cube.set(cubeHelp0);
    } // for i0
// j2
    for(i0=bh[j2]; i0<bh[j2+1]; i0++)
    { if(cube.addL(subcubesL[i0])) k1 = cube.getLastNull();
        else continue;
      count = helpCalcSubcubesL7(cube,k1,j9,j8,j7,j6,j5,j4,j3,j10,j0,j1,count);
      cube.set(cubeHelp0);
    } // for i0
// j1
    for(i0=bh[j1]; i0<bh[j1+1]; i0++)
    { if(cube.addL(subcubesL[i0])) k1 = cube.getLastNull();
        else continue;
      count = helpCalcSubcubesL7(cube,k1,j9,j8,j7,j6,j5,j4,j3,j2,j0,j10,count);
      cube.set(cubeHelp0);
    } // for i0
// j0
    for(i0=bh[j0]; i0<bh[j0+1]; i0++)
    { if(cube.addL(subcubesL[i0])) k1 = cube.getLastNull();
        else continue;
      count = helpCalcSubcubesL7(cube,k1,j9,j8,j7,j6,j5,j4,j3,j2,j10,j1,count);
      cube.set(cubeHelp0);
    } // for i0
 return count;
} // helpCalcSubcubesL8


//--------------------------- calcSubcubes --------------------------


int calcSubcubes()
{ //clock_t startTime = clock();
  //int count1; 
  int k,bis,count = 0;
  
// nach subcubes
  bis = (subcubesBis+subcubesCount)>>1;

  for(k=subcubesBis; k<bis;k++)
  { count = helpCalcSubcubes8(subcubes[k],11,9,8,7,6,5,4,3,2,1,0,count);

    //double zeit = ((double)clock()-(double)startTime)/CLOCKS_PER_SEC;
    //printf("\n%d %u %.3f %.3f Lps  %6d",k,count,zeit,count/zeit,count-count1);
    //count1=count;
   } // for k

  
  for(k=bis; k<subcubesCount;k++)
  { count = helpCalcSubcubesL8(subcubes[k],11,9,8,7,6,5,4,3,2,1,0,count);

    //double zeit = ((double)clock()-(double)startTime)/CLOCKS_PER_SEC;
    //printf("\n%d %u %.3f %.3f Lps  %6d",k,count,zeit,count/zeit,count-count1);
    //count1=count;
   } // for k,l

  return count;
} // calcSubcubes


//============================================================
//                          MAIN
//============================================================

int main(int argc,char* argv[])
{ //clock_t startTime = clock();
  int result;
  //double zeit;

  printf("\nctpuzzle 1.0 (C)2003 Sergej Timm");

  initSubcubes();  

  //printf("\nZeit der Initialisierung: %.3f",((double)clock()-(double)startTime)/CLOCKS_PER_SEC);

  result = calcSubcubes();

  //zeit = ((double)clock()-(double)startTime)/CLOCKS_PER_SEC;
  //printf("\nErgebnis: %d  Zeit: %.3f  Lps: %.3f\n",result,zeit,result / zeit);
  printf("\nErgebnis: %d\n",result);
  return 0;
} // main