// CTPuzzleDlg.cpp : implementation file
//

#include "stdafx.h"
#include "CTPuzzle.h"
#include "CTPuzzleDlg.h"
#include "UKPuzzleDef.h"

#include <math.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCTPuzzleDlg dialog

CCTPuzzleDlg::CCTPuzzleDlg(CWnd* pParent /*=NULL*/)
:CDialog(CCTPuzzleDlg::IDD, pParent),
 m_bAdminVectorIsInit(FALSE),
 m_nThreadCount(0),
 m_nActiveThreads(0),
 m_nMaxActiveThreads(0),
 m_nTimerID1(0),
 m_nTimerID2(0),
 m_pPuzzleAdminVector(0),
 m_strInCfgFileName("")
{
	//{{AFX_DATA_INIT(CCTPuzzleDlg)
	m_strPastTime = _T("");
	m_strSolutions = _T("");
	m_strSolutionsPerSecond = _T("");
	m_strSolutionsPerSecond2 = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	strcpy(m_szPrompt,"::> ");
}

void CCTPuzzleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCTPuzzleDlg)
	DDX_Text(pDX, IDC_PASTTIME, m_strPastTime);
	DDX_Text(pDX, IDC_SOLUTIONS, m_strSolutions);
	DDX_Text(pDX, IDC_SOLPERSEC, m_strSolutionsPerSecond);
	DDX_Text(pDX, IDC_SOLPERSEC2, m_strSolutionsPerSecond2);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCTPuzzleDlg, CDialog)
	//{{AFX_MSG_MAP(CCTPuzzleDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_Stop, OnStop)
	ON_BN_CLICKED(IDC_Start, OnStart)
	ON_BN_CLICKED(IDC_Pause, OnPause)
	ON_BN_CLICKED(IDC_Continue, OnContinue)
	ON_BN_CLICKED(IDC_CLOSEDIALOG, OnCloseDialog)
	ON_WM_CLOSE()
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_LOAD_CONFIG, OnLoadConfig)
	//}}AFX_MSG_MAP
	ON_MESSAGE( WM_UK_WRITE, OnUKWrite )
	ON_MESSAGE( WM_UK_NOTIFY, OnUKNotify )
	ON_UPDATE_COMMAND_UI(IDC_Stop,OnUpdateButtonStop)
	ON_UPDATE_COMMAND_UI(IDC_Start,OnUpdateButtonStart)
	ON_UPDATE_COMMAND_UI(IDC_Pause,OnUpdateButtonPause)
	ON_UPDATE_COMMAND_UI(IDC_Continue,OnUpdateButtonContinue)
	ON_UPDATE_COMMAND_UI(IDC_LOAD_CONFIG,OnUpdateLoadConfig)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCTPuzzleDlg message handlers

BOOL CCTPuzzleDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	m_nTimerID1 = SetTimer(1,1000,NULL);
	m_nTimerID2 = SetTimer(2,1000,NULL);

	//*
	#ifdef _DEBUG //*/
		SetPriorityClass(GetCurrentProcess(),NORMAL_PRIORITY_CLASS);
	//*
	#else
		SetPriorityClass(GetCurrentProcess(),HIGH_PRIORITY_CLASS);
	#endif
	//*/

	SetDlgItemText(IDC_OutputText,m_szPrompt);
	
	TCHAR szPATH[_MAX_PATH];
	TCHAR szDRIVE[_MAX_DRIVE];
	TCHAR szDIR[_MAX_DIR];
	TCHAR szFNAME[_MAX_FNAME];
	TCHAR szEXT[_MAX_EXT];

	//Windows has different behaviors, setting the current directory
	//therefor I set the application path as current directory

	//Application Name and Path
	GetModuleFileName(GetModuleHandle(NULL),szPATH,_MAX_PATH);

	_splitpath(szPATH,szDRIVE,szDIR,szFNAME,szEXT);
	_makepath(szPATH,szDRIVE,szDIR,NULL,NULL);
	SetCurrentDirectory(szPATH);

	CUKIniAccess theIniAccess(".\\MainConfig.ini");

	m_nMaxActiveThreads=theIniAccess.ReadValueDef("Global Parameter","MaxThreads",1);
	m_strOutputFileNameBase=theIniAccess.ReadValueDef("Global Parameter","OutputFileNameBase","");

	if (m_strInCfgFileName=="")
	{
		CString strConfigFileName=theIniAccess.ReadValueDef("Global Parameter","ConfigFileName","");
		_fullpath( szPATH, strConfigFileName, _MAX_PATH );
		m_strConfigFileName=szPATH;
	}
	else
		m_strConfigFileName=m_strInCfgFileName;

	WriteLn("Maximum number of active threads = %d",m_nMaxActiveThreads);
	WriteLn("Output file name base = %s",(LPCTSTR)m_strOutputFileNameBase);
	WriteLn("Active configuration file = %s",(LPCTSTR)m_strConfigFileName);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CCTPuzzleDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CCTPuzzleDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CCTPuzzleDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CCTPuzzleDlg::OnOK() 
{
	// TODO: Add extra validation here

	return;
}

void CCTPuzzleDlg::OnCancel() 
{
	// TODO: Add extra cleanup here

	CDialog::OnCancel();
}

BOOL CCTPuzzleDlg::InitThreads()
{
	//Cant init twice
	if (m_bAdminVectorIsInit)	
		return FALSE;

	CUKIniAccess theIniAccess(m_strConfigFileName);

	//m_nThreadCount=12;//From ini
	m_nThreadCount=theIniAccess.ReadValueDef("StoneInfo","StoneCount",12);
	//m_nMaxActiveThreads=2;
	m_nActiveThreads=0;


	long nXSize=theIniAccess.ReadValueDef("BlockInfo","XSize",0);
	long nYSize=theIniAccess.ReadValueDef("BlockInfo","YSize",0);
	long nZSize=theIniAccess.ReadValueDef("BlockInfo","ZSize",0);
	long nStones=theIniAccess.ReadValueDef("StoneInfo","StoneCount",0);

	//not implemented yet
    //BOOL bEnhSym=theIniAccess.ReadValue("SymetryInfo","EnhancedSymetryCheck",FALSE);

	long nSymetries=theIniAccess.ReadValueDef("SymetryInfo","SymetryPosCount",0);

	long bWriteEveryNSolution=theIniAccess.ReadValueDef("OutputInfo","WriteEveryNSolution",0);

	WriteLn("Number of Threads = %d",m_nThreadCount);
	WriteLn("Block Size X*Y*Z=%d*%d*%d",nXSize,nYSize,nZSize);
	WriteLn("Number of different stones = %d",nStones);
	WriteLn("Number of symetries = %d",nSymetries);
	WriteLn("Write one every %d solutions to the output file(s)",bWriteEveryNSolution);

	m_pPuzzleAdminVector=new SUKAdminThread*[m_nThreadCount];
	if (!m_pPuzzleAdminVector)
		return FALSE;

	//long nPos=m_nThreadCount-1;
	long nPos=0;
	
	for (int i=0;i<m_nThreadCount;i++)
	{
		CString strOutputFile;
		if (m_strOutputFileNameBase!="")
			strOutputFile.Format("%s_%02d.txt",m_strOutputFileNameBase,i);
		else
			strOutputFile="";

		m_pPuzzleAdminVector[i]=new SUKAdminThread(this,nPos,nPos,m_strConfigFileName,strOutputFile);
		nPos++;
		//nPos--;

		if (!m_pPuzzleAdminVector[i])
		{
			DeinitThreads();
			return FALSE;
		}
	}

	m_bAdminVectorIsInit=TRUE;
	return TRUE;
}

void CCTPuzzleDlg::DeinitThreads()
{
	m_bAdminVectorIsInit=FALSE;

	if (m_pPuzzleAdminVector)
	{
		for (int i=0;i<m_nThreadCount;i++)
			if (m_pPuzzleAdminVector[i])
			{
				delete m_pPuzzleAdminVector[i];
				m_pPuzzleAdminVector[i]=NULL;
			}
		delete[] m_pPuzzleAdminVector;
		m_pPuzzleAdminVector=0;
	}
}

void CCTPuzzleDlg::OnStart() 
{
	// TODO: Add your control notification handler code here

	long nStartTime=GetTickCount();

	m_nItemCount=0;
	m_nLastItem=0;
	m_nState=0;

	if (!InitThreads())
	{
		WriteLn("Error on init Threads");
		return;
	}

	m_nTimerStart=GetTickCount();
	m_nElapsedTime=m_nTimerStart-nStartTime;

	WriteLn("Timeto initialize %.1f sec",m_nElapsedTime/1000.0);

	m_nState=CUKPuzzleAdmin::enRunning;
	//SetThreadPriority(GetCurrentThread(),THREAD_PRIORITY_BELOW_NORMAL);
}

void CCTPuzzleDlg::OnPause() 
{
	// TODO: Add your control notification handler code here
	m_nItemCount=0;
	m_nLastItem=0;

	if (!m_bAdminVectorIsInit)	
		return;	
	
	//SetThreadPriority(GetCurrentThread(),THREAD_PRIORITY_HIGHEST);

	for (int i=0;i<m_nThreadCount;i++)
	{
		if (m_pPuzzleAdminVector[i] && m_pPuzzleAdminVector[i]->bWasStarted && !m_pPuzzleAdminVector[i]->bWasFinished)
			m_pPuzzleAdminVector[i]->theThread.PausePuzzle();
	}
	m_nElapsedTime+=(GetTickCount()-m_nTimerStart);

	m_nState=CUKPuzzleAdmin::enPaused;

	//SetThreadPriority(GetCurrentThread(),THREAD_PRIORITY_NORMAL);
}

void CCTPuzzleDlg::OnContinue() 
{
	// TODO: Add your control notification handler code here
	m_nItemCount=0;
	m_nLastItem=0;

	if (!m_bAdminVectorIsInit)	
		return;		

	//SetThreadPriority(GetCurrentThread(),THREAD_PRIORITY_HIGHEST);

	m_nTimerStart=GetTickCount();

	for (int i=0;i<m_nThreadCount;i++)
	{
		if (m_pPuzzleAdminVector[i] && m_pPuzzleAdminVector[i]->bWasStarted && !m_pPuzzleAdminVector[i]->bWasFinished)
			m_pPuzzleAdminVector[i]->theThread.ContinuePuzzle();
	}

	m_nState=CUKPuzzleAdmin::enRunning;
	//SetThreadPriority(GetCurrentThread(),THREAD_PRIORITY_BELOW_NORMAL);
}

void CCTPuzzleDlg::OnStop() 
{
	int i;
	// TODO: Add your control notification handler code here
	m_nItemCount=0;
	m_nLastItem=0;

	if (!m_bAdminVectorIsInit)	
		return;		

	//SetThreadPriority(GetCurrentThread(),THREAD_PRIORITY_HIGHEST);

	BOOL bWasRunning=FALSE;
	for (i=0;i<m_nThreadCount;i++)
		if (m_pPuzzleAdminVector[i] && m_pPuzzleAdminVector[i]->bWasStarted && !m_pPuzzleAdminVector[i]->bWasFinished) 
			if (m_pPuzzleAdminVector[i]->theThread.GetProgressState()==CUKPuzzleAdmin::enRunning)
			{
				//if is running then first stop command pause the process
				
				bWasRunning=TRUE;
				break;
			}

	if (bWasRunning)
	{
		OnPause();
		//SetThreadPriority(GetCurrentThread(),THREAD_PRIORITY_NORMAL);
		return;
	}

	//SetThreadPriority(GetCurrentThread(),THREAD_PRIORITY_NORMAL);

	BOOL bError=FALSE;
	for (i=0;i<m_nThreadCount;i++)
	{
		if (m_pPuzzleAdminVector[i] && m_pPuzzleAdminVector[i]->bWasStarted && !m_pPuzzleAdminVector[i]->bWasFinished)
			if (m_pPuzzleAdminVector[i]->theThread.StopPuzzle()!=UKPUZ_NOERROR)
				bError=TRUE;
	}

	if (bError)
		return;

	DeinitThreads();

	m_nState=0;
	m_nTimerStart=0;
	m_nElapsedTime=0;
}

void __cdecl CCTPuzzleDlg::Write(LPCTSTR strText,...)
{
	va_list args;
	va_start( args, strText);

	CString strTmp;
	CString strDlgText;
	GetDlgItemText(IDC_OutputText,strDlgText);
	strTmp.FormatV(strText,args);
	strDlgText+=strTmp;
	SetDlgItemText(IDC_OutputText,strDlgText);

	va_end( args);
}

void __cdecl CCTPuzzleDlg::WriteLn(LPCTSTR strText,...)
{
	va_list args;
	va_start( args, strText);

	CString strTmp;
	CString strDlgText;
	GetDlgItemText(IDC_OutputText,strDlgText);
	strTmp.FormatV(strText,args);
	strDlgText+=strTmp+"\r\n"+m_szPrompt;
	SetDlgItemText(IDC_OutputText,strDlgText);

	va_end( args);
}

LRESULT CCTPuzzleDlg::OnUKWrite(WPARAM wParam, LPARAM lParam) 
{
	BSTR bstrText=(BSTR)(LPVOID)lParam;
	ASSERT(bstrText);
	CString strText(bstrText);
	SysFreeString(bstrText);
	if (wParam==0)
		Write(strText);
	else
		WriteLn(strText);
	return 0;
}

LRESULT CCTPuzzleDlg::OnUKNotify(WPARAM wParam, LPARAM lParam)
{
	int i;
	switch (wParam)
	{
		case enUKPUZZLE_SOLUTIONFOUND:
			break;
		case enUKPUZZLE_FINISHED:
			for (i=0;i<m_nThreadCount;i++)
				if (m_pPuzzleAdminVector[i])
					if (!m_pPuzzleAdminVector[i]->bWasFinished && 
						m_pPuzzleAdminVector[i]->theThread.GetProgressState()!=CUKPuzzleAdmin::enFinished)
						return 0;

			Beep(2000,500);
			m_nState=CUKPuzzleAdmin::enFinished;
			m_nElapsedTime+=(GetTickCount()-m_nTimerStart);
			m_nTimerStart=GetTickCount();
			break;
	}

	return 0;
}

void CCTPuzzleDlg::OnCloseDialog() 
{
	// TODO: Add your control notification handler code here
	
	PostMessage(WM_CLOSE);
}

void CCTPuzzleDlg::OnClose() 
{
	// TODO: Add your message handler code here and/or call default
	//Call it twice, becaus if it is running it will only pause on first call
	OnStop();
	OnStop();

	if (m_bAdminVectorIsInit && (AfxMessageBox(IDS_ERROR_000,MB_YESNO)==IDNO))
		return;
	
	if (m_nTimerID1)
		KillTimer(m_nTimerID1);
	m_nTimerID1=0;

	if (m_nTimerID2)
		KillTimer(m_nTimerID2);
	m_nTimerID2=0;

	CDialog::OnClose();
}

void CCTPuzzleDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default

	static nCounter=0;

	switch (nIDEvent)
	{
		case 1:
			UpdateData(TRUE);
			if (!m_bAdminVectorIsInit)
			{
				m_strPastTime="0";
				m_strSolutions="0";
			}
			else
			{
				int i=0;
				long nSolutions=0;
	
				CString strTmp;

				for (i=0;i<m_nThreadCount;i++)
				{
					if (m_pPuzzleAdminVector[i])
					{
						//check if one thread is running and has finished
						if (m_pPuzzleAdminVector[i]->bWasStarted && !m_pPuzzleAdminVector[i]->bWasFinished)
						{
							m_pPuzzleAdminVector[i]->nResultCount=m_pPuzzleAdminVector[i]->theThread.GetSolutions();
							if (m_pPuzzleAdminVector[i]->theThread.GetProgressState()==CUKPuzzleAdmin::enFinished)
							{
								m_pPuzzleAdminVector[i]->theThread.StopPuzzle();
								m_pPuzzleAdminVector[i]->bWasFinished=TRUE;
								m_nActiveThreads--;
								WriteLn("==> Thread(%d) Stopped ==> %d Threads Running",i,m_nActiveThreads);
								WriteLn("ThreadStat: Elapsed Time=%dsec, Solutions Found=%d",(m_nElapsedTime+GetTickCount()-m_nTimerStart)/1000,m_pPuzzleAdminVector[i]->nResultCount);
							}
						}

						nSolutions+=m_pPuzzleAdminVector[i]->nResultCount;

						//start next thread
						if (m_nActiveThreads<m_nMaxActiveThreads && !m_pPuzzleAdminVector[i]->bWasStarted)
						{
							m_nActiveThreads++;
							if (m_pPuzzleAdminVector[i]->theThread.StartPuzzle()!=UKPUZ_NOERROR)
							{
								WriteLn("==> Error on starting Thread(%d)",i);
								OnStop();
								OnStop();
								return;
							}
							m_pPuzzleAdminVector[i]->bWasStarted=TRUE;
							WriteLn("==> Thread(%d) Started ==> %d Threads Running",i,m_nActiveThreads);
						}
					}
				}

				m_nItemCount=min(enSolutionAveraging,m_nItemCount+1);
				m_nLastItem=(m_nLastItem+1)%enSolutionAveraging;
				m_nLastResultCount[m_nLastItem]=nSolutions;
				m_nLastResultTime[m_nLastItem]=GetTickCount();

				m_strSolutions.Format("%d    ",nSolutions);
				DWORD nPastTime=0;
				CString strInfo;

				switch (m_nState)
				{
					case CUKPuzzleAdmin::enRunning:		strInfo.LoadString(IDS_RUNNING);nPastTime=m_nElapsedTime+GetTickCount()-m_nTimerStart; break;
					case CUKPuzzleAdmin::enPaused:		strInfo.LoadString(IDS_PAUSED);nPastTime=m_nElapsedTime; break;
					case CUKPuzzleAdmin::enFinished:	strInfo.LoadString(IDS_FINISHED);nPastTime=m_nElapsedTime; break;
					default:							strInfo="unkwown";nPastTime=0; break;
				}
				m_strPastTime.Format("%dh %dmin %4.0fsec (%s)    ",nPastTime/3600000,(nPastTime%3600000)/60000,(nPastTime%60000)/1000.0,(LPCTSTR)strInfo);

				if (nPastTime>0)
					m_strSolutionsPerSecond.Format("%.1f    ",nSolutions/(nPastTime/1000.0));
				else
					m_strSolutionsPerSecond="0    ";

				if (m_nItemCount > 1)
				{
					long nDCount=m_nLastResultCount[m_nLastItem]-m_nLastResultCount[(m_nLastItem-m_nItemCount+1+enSolutionAveraging)%enSolutionAveraging];
					long nDTime=m_nLastResultTime[m_nLastItem]-m_nLastResultTime[(m_nLastItem-m_nItemCount+1+enSolutionAveraging)%enSolutionAveraging];

					if (nDCount>0)
						m_strSolutionsPerSecond2.Format("%.1f    ",(nDCount*1000.0)/nDTime);
					else
						m_strSolutionsPerSecond2="0    ";
				}
			}
			UpdateData(FALSE);
			nCounter++;
			if (nCounter==3)
			{
				InvalidateRect(NULL);
				nCounter=0;
			}
			break;
		case 2:
			UpdateDialogControls(this,FALSE);
			break;
	}

	CDialog::OnTimer(nIDEvent);
}

void CCTPuzzleDlg::OnUpdateButtonStop(CCmdUI* pCmdUI)
{
	if (m_bAdminVectorIsInit)
		pCmdUI->Enable(TRUE);
	else
		pCmdUI->Enable(FALSE);
}

void CCTPuzzleDlg::OnUpdateButtonStart(CCmdUI* pCmdUI)
{
	if (m_bAdminVectorIsInit)
		pCmdUI->Enable(FALSE);
	else
		pCmdUI->Enable(TRUE);
}

void CCTPuzzleDlg::OnUpdateButtonPause(CCmdUI* pCmdUI)
{
	if (m_pPuzzleAdminVector)
		for (int i=0;i<m_nThreadCount;i++)
			if (m_pPuzzleAdminVector[i] && m_pPuzzleAdminVector[i]->bWasStarted && !m_pPuzzleAdminVector[i]->bWasFinished)
				if (m_pPuzzleAdminVector[i]->theThread.GetProgressState()==CUKPuzzleAdmin::enRunning)
				{
					pCmdUI->Enable(TRUE);
					return;
				}
	
	pCmdUI->Enable(FALSE);
}


void CCTPuzzleDlg::OnUpdateLoadConfig(CCmdUI* pCmdUI)
{
	//Can only load config if puzzle is not already startet
	if (m_bAdminVectorIsInit)
		pCmdUI->Enable(FALSE);
	else
		pCmdUI->Enable(TRUE);
}

void CCTPuzzleDlg::OnUpdateButtonContinue(CCmdUI* pCmdUI)
{
	if (m_pPuzzleAdminVector)
		for (int i=0;i<m_nThreadCount;i++)
			if (m_pPuzzleAdminVector[i] && m_pPuzzleAdminVector[i]->bWasStarted && !m_pPuzzleAdminVector[i]->bWasFinished)
				if (m_pPuzzleAdminVector[i]->theThread.GetProgressState()==CUKPuzzleAdmin::enPaused)
				{
					pCmdUI->Enable(TRUE);
					return;
				}

	pCmdUI->Enable(FALSE);
}



void CCTPuzzleDlg::OnLoadConfig() 
{
	// TODO: Add your control notification handler code here
	CFileDialog theDlg(TRUE,"ini",m_strConfigFileName,OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,"Ini Dateien (*.ini)|*.ini|Alle Dateien (*.*)|*.*||");

	if (theDlg.DoModal()==IDOK)
	{
		m_strConfigFileName=theDlg.GetPathName();
		WriteLn("Active configuration file = %s",(LPCTSTR)m_strConfigFileName);
	}
}
