// CTPuzzleDlg.h : header file
//

#if !defined(AFX_CTPUZZLEDLG_H__4309079D_C92E_4B33_AFED_393A7CF8836E__INCLUDED_)
#define AFX_CTPUZZLEDLG_H__4309079D_C92E_4B33_AFED_393A7CF8836E__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
		  
#include "UKPuzzleAdmin.h"
/////////////////////////////////////////////////////////////////////////////
// CCTPuzzleDlg dialog

class CCTPuzzleDlg : public CDialog
{
// Construction
public:
	CCTPuzzleDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CCTPuzzleDlg)
	enum { IDD = IDD_CTPUZZLE_DIALOG };
	CString	m_strPastTime;
	CString	m_strSolutions;
	CString	m_strSolutionsPerSecond;
	CString	m_strSolutionsPerSecond2;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CCTPuzzleDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

public:
	BOOL PrepareDialog(LPCTSTR szCfgFileName){m_strInCfgFileName=szCfgFileName;return TRUE;}

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CCTPuzzleDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	virtual void OnOK();
	virtual void OnCancel();
	afx_msg void OnStop();
	afx_msg void OnStart();
	afx_msg void OnPause();
	afx_msg void OnContinue();
	afx_msg void OnCloseDialog();
	afx_msg void OnClose();
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnLoadConfig();
	//}}AFX_MSG
	afx_msg LRESULT OnUKWrite(WPARAM, LPARAM); 
	afx_msg LRESULT OnUKNotify(WPARAM, LPARAM); 
	afx_msg void OnUpdateButtonStop(CCmdUI* pCmdUI);
	afx_msg void OnUpdateButtonStart(CCmdUI* pCmdUI);
	afx_msg void OnUpdateButtonPause(CCmdUI* pCmdUI);
	afx_msg void OnUpdateButtonContinue(CCmdUI* pCmdUI);
	afx_msg void OnUpdateLoadConfig(CCmdUI* pCmdUI);
	DECLARE_MESSAGE_MAP()

protected:
	void __cdecl Write(LPCTSTR strText,...);
	void __cdecl WriteLn(LPCTSTR strText,...);

	//enum{enMaxAdminThreads=CUKPuzzleCore::enLastStoneToProof-CUKPuzzleCore::enFirstStoneToProof+1};
	
	BOOL	InitThreads();
	void	DeinitThreads();
	BOOL	m_bAdminVectorIsInit;

	long	m_nThreadCount;
	long	m_nMaxActiveThreads;
	long	m_nActiveThreads;

	struct SUKAdminThread
	{
		SUKAdminThread(CWnd* pWnd,long nFirstStoneOnPos_0=-1,long nLastStoneOnPos_0=-1,LPCTSTR szIniFileName="",LPCTSTR szOutputFileName="")
			:theThread(pWnd,nFirstStoneOnPos_0,nLastStoneOnPos_0,szIniFileName,szOutputFileName),
			 bWasStarted(FALSE),
			 bWasFinished(FALSE),
			 nResultCount(0){}

		CUKPuzzleAdmin theThread;
			
		BOOL bWasStarted;
		BOOL bWasFinished;

		long nResultCount;
	};
	SUKAdminThread **m_pPuzzleAdminVector;//[enMaxAdminThreads];
	//CUKPuzzleAdmin* m_pPuzzleAdminVector[enMaxAdminThreads];

	UINT m_nTimerID1;
	UINT m_nTimerID2;

	long  m_nState;
	DWORD m_nTimerStart;
	DWORD m_nElapsedTime;//excluding the time since last start or continue

	//variables for displaying Time average over the last 100 
	enum {enSolutionAveraging=100};
	long m_nItemCount;
	long m_nLastItem;
	DWORD m_nLastResultCount[enSolutionAveraging];
	DWORD m_nLastResultTime[enSolutionAveraging];

	CString m_strConfigFileName;
	CString m_strOutputFileNameBase;

	//Input Attributes, given by prepare dialog
	CString m_strInCfgFileName;

	TCHAR m_szPrompt[16];//maxPromptSize
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_CTPUZZLEDLG_H__4309079D_C92E_4B33_AFED_393A7CF8836E__INCLUDED_)
