/////////////////////////////////////////////////////////////////////////////
//Projectname 	: 
//Filename		: UKPuzzleAdmin.cpp 
//Classname		: CIUKPuzzleAdmin
//				: CUKPuzzleAdmin
//Author		: Ulrich Kraemer [uk]
//Date			: 25.03.2003
//Changes		: 
//////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "UKPuzzleAdmin.h"

CIUKPuzzleAdmin::CIUKPuzzleAdmin(long nFirstStoneOnPos_0,long nLastStoneOnPos_0,LPCTSTR szIniFileName,LPCTSTR szOutputFileName)
:m_PuzzleCore(nFirstStoneOnPos_0,nLastStoneOnPos_0,szIniFileName,szOutputFileName),
 m_nCmd(0),
 m_nProgressState(0)
{}

CIUKPuzzleAdmin::~CIUKPuzzleAdmin()
{}

DWORD CIUKPuzzleAdmin::GetSolutions()
{
	return m_PuzzleCore.GetSolutions();
}
DWORD CIUKPuzzleAdmin::GetProgressState()
{
	return m_nProgressState;
}

//Commands
UKPUZ_STATE CIUKPuzzleAdmin::StartPuzzle(DWORD nTime2Wait) //Start Thread or Programm
{
	if (m_nProgressState==enFinished)
		return UKPUZ_UNKNOWNERROR;

	if (m_nProgressState!=enUndefined)
		return UKPUZ_UNKNOWNERROR;
	return CommandSetAndWait(enCmd_Start,nTime2Wait);
}
//Commands (for thread only)
UKPUZ_STATE CIUKPuzzleAdmin::PausePuzzle(DWORD nTime2Wait)
{
	if (m_nProgressState==enFinished)
		return UKPUZ_NOERROR;

	if (m_nProgressState!=enRunning)
		return UKPUZ_UNKNOWNERROR;

	return CommandSetAndWait(enCmd_Pause,nTime2Wait);
}

UKPUZ_STATE CIUKPuzzleAdmin::ContinuePuzzle(DWORD nTime2Wait)
{
	if (m_nProgressState==enFinished)
		return UKPUZ_NOERROR;

	if (m_nProgressState!=enPaused)
		return UKPUZ_UNKNOWNERROR;

	return CommandSetAndWait(enCmd_Continue,nTime2Wait);
}	

UKPUZ_STATE CIUKPuzzleAdmin::StopPuzzle(DWORD nTime2Wait)
{
	if (m_nProgressState!=enPaused && m_nProgressState!=enRunning && m_nProgressState!=enFinished)
		return UKPUZ_UNKNOWNERROR;

	return CommandSetAndWait(enCmd_Stop,nTime2Wait);
}

//No realy synchronization used at the moment
UKPUZ_STATE CIUKPuzzleAdmin::CommandSetAndWait(DWORD nCmd,DWORD nTime2Wait)
{
	DWORD nTimer=GetTickCount();
	ASSERT(m_nCmd==0);
	m_nCmd=nCmd;
	while (m_nCmd!=0 && m_nProgressState!=enError && GetTickCount()-nTimer < nTime2Wait)
		;//do nothing loop

	if (m_nProgressState==enError)
		return UKPUZ_UNKNOWNERROR;

	if (m_nCmd==0)
		return UKPUZ_NOERROR;

	m_nCmd=0;
	return UKPUZ_TIMEERROR;
}

void CIUKPuzzleAdmin::MainLoop()
{
	CString strMsg;

	if (!m_PuzzleCore.Init())
	{
		m_nProgressState=enError;
		m_nCmd=0;
		return;
	}

	while (m_nCmd!=enCmd_Stop && m_nProgressState!=enFinished)
	{
		//coul'd be changed
		switch (m_nCmd)
		{
			case enCmd_Start:
				m_nProgressState=enRunning;
				m_nCmd=0;
				PuzzleIsRunning();
				break;
			case enCmd_Pause:
				m_nProgressState=enPaused;
				m_nCmd=0;
				PuzzleHasPaused();
				while (m_nCmd!=enCmd_Continue && m_nCmd!=enCmd_Stop)
				{
					if (m_nCmd!=0 && m_nCmd!=enCmd_Continue && m_nCmd!=enCmd_Stop)
					{
						strMsg.Format("Command(%d) ignored",m_nCmd);
						WriteLn(strMsg);
						m_nCmd=0;
					}
					Sleep(100);
				}
				break;
			case enCmd_Continue:
				m_nProgressState=enRunning;
				m_nCmd=0;
				PuzzleIsRunning();
				break;
			case enCmd_Stop:
				//do not clear cmd
				break;
		}
		m_PuzzleCore.DoNextStep();

		if (m_nProgressState==enRunning && m_PuzzleCore.HasFinished())
			m_nProgressState=enFinished;

	}

	if (m_nProgressState==enFinished)
		PuzzleHasFinished();
	
	while (m_nCmd!=enCmd_Stop)
		Sleep(100);

	PuzzleHasStopped();

	m_PuzzleCore.Deinit();

	m_nProgressState=0;
	m_nCmd=0;
}

void CIUKPuzzleAdmin::PuzzleIsRunning()
{
	CString	strMsg;
	strMsg.Format("State info (%d)-> Puzzle is running",GetCurrentThreadId());
	WriteLn(strMsg);
}
void CIUKPuzzleAdmin::PuzzleHasPaused()
{
	CString	strMsg;
	strMsg.Format("State info (%d)-> Puzzle has paused",GetCurrentThreadId());
	WriteLn(strMsg);
}
void CIUKPuzzleAdmin::PuzzleHasFinished()
{
	CString	strMsg;
	strMsg.Format("State info (%d)-> Puzzle has finished",GetCurrentThreadId());
	WriteLn(strMsg);
}
void CIUKPuzzleAdmin::PuzzleHasStopped()
{
	CString	strMsg;
	strMsg.Format("State info (%d)-> Puzzle has stopped",GetCurrentThreadId());
	WriteLn(strMsg);
}


//////////////////////////////////////////////////////////////////////////////
CUKPuzzleAdmin::CUKPuzzleAdmin(CWnd* pWnd,long nFirstStoneOnPos_0,long nLastStoneOnPos_0,LPCTSTR szIniFileName,LPCTSTR szOutputFileName)
:CIUKPuzzleAdmin(nFirstStoneOnPos_0,nLastStoneOnPos_0,szIniFileName,szOutputFileName),
 m_pMessageReceiver(pWnd)
{
	ASSERT(m_pMessageReceiver);
}

CUKPuzzleAdmin::~CUKPuzzleAdmin()
{}

UKPUZ_STATE CUKPuzzleAdmin::StartPuzzle(DWORD nTime2Wait)
{
	if (AfxBeginThread(RunPuzzleAdmin,this))
		return CIUKPuzzleAdmin::StartPuzzle(nTime2Wait);
	else
		return UKPUZ_UNKNOWNERROR;
}

void CUKPuzzleAdmin::Write(LPCTSTR szOutText)
{
	CString strText=szOutText;
	ASSERT(m_pMessageReceiver);
	m_pMessageReceiver->PostMessage(WM_UK_WRITE,0,(LPARAM)(LPVOID)strText.AllocSysString());
}

void CUKPuzzleAdmin::WriteLn(LPCTSTR szOutText)
{
	CString strText=CString(szOutText);
	ASSERT(m_pMessageReceiver);
	m_pMessageReceiver->PostMessage(WM_UK_WRITE,1,(LPARAM)(LPVOID)strText.AllocSysString());
}

void CUKPuzzleAdmin::SolutionFound()
{
	ASSERT(m_pMessageReceiver);
	m_pMessageReceiver->PostMessage(WM_UK_NOTIFY,enUKPUZZLE_SOLUTIONFOUND);
}

UINT __cdecl CUKPuzzleAdmin::RunPuzzleAdmin(LPVOID pVoid)
{
	((CUKPuzzleAdmin*)pVoid)->MainLoop();
	return 0;
}

void CUKPuzzleAdmin::PuzzleIsRunning()
{
	/*
	#ifdef _DEBUG //*/
		SetThreadPriority(GetCurrentThread(),THREAD_PRIORITY_NORMAL);
	/*
	#else
		//The time bonus is minimal, about 5 Percent on my system
		SetThreadPriority(GetCurrentThread(),THREAD_PRIORITY_ABOVE_NORMAL);
	#endif
	//*/

	CIUKPuzzleAdmin::PuzzleIsRunning();
}
void CUKPuzzleAdmin::PuzzleHasPaused()
{
	SetThreadPriority(GetCurrentThread(),THREAD_PRIORITY_NORMAL);
	CIUKPuzzleAdmin::PuzzleHasPaused();
}
void CUKPuzzleAdmin::PuzzleHasFinished()
{
	ASSERT(m_pMessageReceiver);
	SetThreadPriority(GetCurrentThread(),THREAD_PRIORITY_BELOW_NORMAL);
	CIUKPuzzleAdmin::PuzzleHasFinished();

	m_pMessageReceiver->PostMessage(WM_UK_NOTIFY,enUKPUZZLE_FINISHED);
}
void CUKPuzzleAdmin::PuzzleHasStopped()
{
	SetThreadPriority(GetCurrentThread(),THREAD_PRIORITY_NORMAL);
	CIUKPuzzleAdmin::PuzzleHasStopped();
}

