/////////////////////////////////////////////////////////////////////////////
//Projectname 	: 
//Filename		: UKIniAccess.h 
//Classname		: CUKPuzzleCore
//Author		: Ulrich Kraemer [uk]
//Date			: 04.04.2003
//Changes		: 
//////////////////////////////////////////////////////////////////////////////

#ifndef UKINIACCESS_H
#define UKINIACCESS_H

#include "afxtempl.h"

typedef CArray<long,long> CLongArray;

class CUKIniAccess
{
	public:
		CUKIniAccess(LPCTSTR strFileName="");
		~CUKIniAccess();

		Init(LPCTSTR strFileName);
		//no deinit rquired

		//Common methodes
		//at the moment only read is needed
		BOOL	ReadValue(LPCTSTR szSection,LPCTSTR szKey,int* pValue);
		BOOL	ReadValue(LPCTSTR szSection,LPCTSTR szKey,long* pValue);
		BOOL	ReadValue(LPCTSTR szSection,LPCTSTR szKey,CString& rValue);

		BOOL	ReadValue(LPCTSTR szSection,LPCTSTR szKey,CLongArray& rLongArray);

		int		ReadValueDef(LPCTSTR szSection,LPCTSTR szKey,int nDefValue);
		long	ReadValueDef(LPCTSTR szSection,LPCTSTR szKey,long nDefValue);
		CString	ReadValueDef(LPCTSTR szSection,LPCTSTR szKey,LPCTSTR szDefValue);

	private:
		CString m_strFileName;
};

inline int CUKIniAccess::ReadValueDef(LPCTSTR szSection,LPCTSTR szKey,int nDefValue)
{
	int nVal;
	if (!ReadValue(szSection,szKey,&nVal))
		return nDefValue;
	return nVal;
}
inline long CUKIniAccess::ReadValueDef(LPCTSTR szSection,LPCTSTR szKey,long nDefValue)
{
	long nVal;
	if (!ReadValue(szSection,szKey,&nVal))
		return nDefValue;
	return nVal;
}
inline CString CUKIniAccess::ReadValueDef(LPCTSTR szSection,LPCTSTR szKey,LPCTSTR szDefValue)
{
	CString strValue;
	if (!ReadValue(szSection,szKey,strValue))
		strValue=szDefValue;
	return strValue;
}

#endif