// recursive mit 12 Teilen

#include <iostream>
#include <iomanip>
using namespace std;

//////////////////////////////////////////////////////////////
template<int x, int y, int z>
struct Valid{
	enum {
		yes = x>=0 && x<5 && y>=0 && y<3 && z>=0 && z<4
	};
};

//////////////////////////////////////////////////////////////
// return offset to shift to origin
template<int a1, int a2, int a3, int a4, int a5, int a6>
struct ShiftToOrigin{
	enum {
		z1 = a1 < a2 ? a1 : a2,
		z2 = z1 < a3 ? z1 : a3,
		z3 = z2 < a4 ? z2 : a4,
		z4 = z3 < a5 ? z3 : a5,
		z5 = z4 < a6 ? z4 : a6,
		get = z5 < 0 ? -z5 : z5
	};
};

//////////////////////////////////////////////////////////////
template<
	int Posx1, int Posy1, int Posz1,
	int Posx2, int Posy2, int Posz2,
	int Posx3, int Posy3, int Posz3,
	int Posx4, int Posy4, int Posz4,
	int Posx5, int Posy5, int Posz5,
	int Posx6, int Posy6, int Posz6,
	int sx,    int sz,    int sy
>
struct ShiftedPiece
{
	enum {
		x1 = Posx1 + sx,
		x2 = Posx2 + sx,
		x3 = Posx3 + sx,
		x4 = Posx4 + sx,
		x5 = Posx5 + sx,
		x6 = Posx6 + sx,
		y1 = Posy1 + sy,
		y2 = Posy2 + sy,
		y3 = Posy3 + sy,
		y4 = Posy4 + sy,
		y5 = Posy5 + sy,
		y6 = Posy6 + sy,
		z1 = Posz1 + sz,
		z2 = Posz2 + sz,
		z3 = Posz3 + sz,
		z4 = Posz4 + sz,
		z5 = Posz5 + sz,
		z6 = Posz6 + sz,
		isValid = (
			   Valid<x1, y1, z1>::yes 
			&& Valid<x2, y2, z2>::yes
			&& Valid<x3, y3, z3>::yes
			&& Valid<x4, y4, z4>::yes
			&& Valid<x5, y5, z5>::yes
			&& Valid<x6, y6, z6>::yes
		),
		id1 = (
			  ((unsigned long long)1)<< (x1 + z1*5 + y1*20)
			| ((unsigned long long)1)<< (x2 + z2*5 + y2*20)
			| ((unsigned long long)1)<< (x3 + z3*5 + y3*20)
			| ((unsigned long long)1)<< (x4 + z4*5 + y4*20)
			| ((unsigned long long)1)<< (x5 + z5*5 + y5*20)
			| ((unsigned long long)1)<< (x6 + z6*5 + y6*20)
		) & 0xFFFFFFFF,
		id2 = (
			  ((unsigned long long)1)<< (x1 + z1*5 + y1*20)
			| ((unsigned long long)1)<< (x2 + z2*5 + y2*20)
			| ((unsigned long long)1)<< (x3 + z3*5 + y3*20)
			| ((unsigned long long)1)<< (x4 + z4*5 + y4*20)
			| ((unsigned long long)1)<< (x5 + z5*5 + y5*20)
			| ((unsigned long long)1)<< (x6 + z6*5 + y6*20)
		) >> 32

	};
};

//////////////////////////////////////////////////////////////
template<int rx, int ry, int rz, int rotationNr> struct Rotation;
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz, 0>  { enum {x=  rx, y=  ry, z=  rz }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz, 1>  { enum {x=  rz, y=  ry, z= -rx }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz, 2>  { enum {x= -rx, y=  ry, z= -rz }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz, 3>  { enum {x= -rz, y=  ry, z=  rx }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz, 4>  { enum {x=  rz, y=  rx, z=  ry }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz, 5>  { enum {x= -rx, y=  rz, z=  ry }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz, 6>  { enum {x= -rz, y= -rx, z=  ry }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz, 7>  { enum {x=  rx, y= -rz, z=  ry }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz, 8>  { enum {x=  ry, y=  rz, z=  rx }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz, 9>  { enum {x=  ry, y= -rx, z=  rz }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz, 10> { enum {x=  ry, y= -rz, z= -rx }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz, 11> { enum {x=  ry, y=  rx, z= -rz }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz, 12> { enum {x= -ry, y=  rx, z=  rz }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz, 13> { enum {x= -ry, y=  rz, z= -rx }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz, 14> { enum {x= -ry, y= -rx, z= -rz }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz, 15> { enum {x= -ry, y= -rz, z=  rx }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz, 16> { enum {x=  rz, y= -ry, z=  rx }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz, 17> { enum {x= -rx, y= -ry, z=  rz }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz, 18> { enum {x= -rz, y= -ry, z= -rx }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz, 19> { enum {x=  rx, y= -ry, z= -rz }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz, 20> { enum {x=  rx, y=  rz, z= -ry }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz, 21> { enum {x=  rz, y= -rx, z= -ry }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz, 22> { enum {x= -rx, y= -rz, z= -ry }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz, 23> { enum {x= -rz, y=  rx, z= -ry }; };


//////////////////////////////////////////////////////////////
template<
	int Posx1, int Posy1, int Posz1,
	int Posx2, int Posy2, int Posz2,
	int Posx3, int Posy3, int Posz3,
	int Posx4, int Posy4, int Posz4,
	int Posx5, int Posy5, int Posz5,
	int Posx6, int Posy6, int Posz6,
	int rotationNr
>
struct Rotate
{
	enum
	{
		zx1 = Rotation<Posx1, Posy1, Posz1, rotationNr>::x,
		zy1 = Rotation<Posx1, Posy1, Posz1, rotationNr>::y,
		zz1 = Rotation<Posx1, Posy1, Posz1, rotationNr>::z,
		zx2 = Rotation<Posx2, Posy2, Posz2, rotationNr>::x,
		zy2 = Rotation<Posx2, Posy2, Posz2, rotationNr>::y,
		zz2 = Rotation<Posx2, Posy2, Posz2, rotationNr>::z,
		zx3 = Rotation<Posx3, Posy3, Posz3, rotationNr>::x,
		zy3 = Rotation<Posx3, Posy3, Posz3, rotationNr>::y,
		zz3 = Rotation<Posx3, Posy3, Posz3, rotationNr>::z,
		zx4 = Rotation<Posx4, Posy4, Posz4, rotationNr>::x,
		zy4 = Rotation<Posx4, Posy4, Posz4, rotationNr>::y,
		zz4 = Rotation<Posx4, Posy4, Posz4, rotationNr>::z,
		zx5 = Rotation<Posx5, Posy5, Posz5, rotationNr>::x,
		zy5 = Rotation<Posx5, Posy5, Posz5, rotationNr>::y,
		zz5 = Rotation<Posx5, Posy5, Posz5, rotationNr>::z,
		zx6 = Rotation<Posx6, Posy6, Posz6, rotationNr>::x,
		zy6 = Rotation<Posx6, Posy6, Posz6, rotationNr>::y,
		zz6 = Rotation<Posx6, Posy6, Posz6, rotationNr>::z,
		sx = ShiftToOrigin<zx1, zx2, zx3, zx4, zx5, zx6>::get,
		sy = ShiftToOrigin<zy1, zy2, zy3, zy4, zy5, zy6>::get,
		sz = ShiftToOrigin<zz1, zz2, zz3, zz4, zz5, zz6>::get,
		x1 = zx1 + sx,
		x2 = zx2 + sx,
		x3 = zx3 + sx,
		x4 = zx4 + sx,
		x5 = zx5 + sx,
		x6 = zx6 + sx,
		y1 = zy1 + sy,
		y2 = zy2 + sy,
		y3 = zy3 + sy,
		y4 = zy4 + sy,
		y5 = zy5 + sy,
		y6 = zy6 + sy,
		z1 = zz1 + sz,
		z2 = zz2 + sz,
		z3 = zz3 + sz,
		z4 = zz4 + sz,
		z5 = zz5 + sz,
		z6 = zz6 + sz,
		id1 = (
			  ((unsigned long long)1)<< (x1 + z1*5 + y1*20)
			| ((unsigned long long)1)<< (x2 + z2*5 + y2*20)
			| ((unsigned long long)1)<< (x3 + z3*5 + y3*20)
			| ((unsigned long long)1)<< (x4 + z4*5 + y4*20)
			| ((unsigned long long)1)<< (x5 + z5*5 + y5*20)
			| ((unsigned long long)1)<< (x6 + z6*5 + y6*20)
		) & 0xFFFFFFFF,
		id2 = (
			  ((unsigned long long)1)<< (x1 + z1*5 + y1*20)
			| ((unsigned long long)1)<< (x2 + z2*5 + y2*20)
			| ((unsigned long long)1)<< (x3 + z3*5 + y3*20)
			| ((unsigned long long)1)<< (x4 + z4*5 + y4*20)
			| ((unsigned long long)1)<< (x5 + z5*5 + y5*20)
			| ((unsigned long long)1)<< (x6 + z6*5 + y6*20)
		) >> 32
	};
};


//////////////////////////////////////////////////////////////
template<
	int x1, int y1, int z1,
	int x2, int y2, int z2,
	int x3, int y3, int z3,
	int x4, int y4, int z4,
	int x5, int y5, int z5,
	int x6, int y6, int z6,
	int rotationNr,
	int otherRotation
>
struct RedundantHelper
{
	//////////////////////////////////////////////////////////////
	template<
		int x1, int y1, int z1,
		int x2, int y2, int z2,
		int x3, int y3, int z3,
		int x4, int y4, int z4,
		int x5, int y5, int z5,
		int x6, int y6, int z6,
		int rotationNr,
		int otherRotation,
		bool yes
	>
	struct RedundantHelper2;

	//////////////////////////////////////////////////////////////
	template<
		int x1, int y1, int z1,
		int x2, int y2, int z2,
		int x3, int y3, int z3,
		int x4, int y4, int z4,
		int x5, int y5, int z5,
		int x6, int y6, int z6,
		int rotationNr,
		int otherRotation
	>
	struct RedundantHelper2<
		x1, y1, z1,
		x2, y2, z2,
		x3, y3, z3,
		x4, y4, z4,
		x5, y5, z5,
		x6, y6, z6,
		rotationNr,
		otherRotation,
		true
	>
	{
		enum
		{
			with = otherRotation
		};
	};

	//////////////////////////////////////////////////////////////
	template<
		int x1, int y1, int z1,
		int x2, int y2, int z2,
		int x3, int y3, int z3,
		int x4, int y4, int z4,
		int x5, int y5, int z5,
		int x6, int y6, int z6,
		int rotationNr,
		int otherRotation
	>
	struct RedundantHelper2<
		x1, y1, z1,
		x2, y2, z2,
		x3, y3, z3,
		x4, y4, z4,
		x5, y5, z5,
		x6, y6, z6,
		rotationNr,
		otherRotation,
		false
	>
	{
		enum
		{
			with = RedundantHelper<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, rotationNr, otherRotation-1>::with,
		};
	};
	enum
	{
		with = RedundantHelper2
		<
			x1, y1, z1,
			x2, y2, z2,
			x3, y3, z3,
			x4, y4, z4,
			x5, y5, z5,
			x6, y6, z6,
			rotationNr,
			otherRotation,
			(	(Rotate<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, rotationNr>::id1 ==
				Rotate<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, otherRotation>::id1 )
			&&	(Rotate<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, rotationNr>::id2 ==
				Rotate<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, otherRotation>::id2 )
			)
		>::with
	};
};

//////////////////////////////////////////////////////////////
template<
	int x1, int y1, int z1,
	int x2, int y2, int z2,
	int x3, int y3, int z3,
	int x4, int y4, int z4,
	int x5, int y5, int z5,
	int x6, int y6, int z6,
	int rotationNr
>
struct RedundantHelper<
	x1, y1, z1,
	x2, y2, z2,
	x3, y3, z3,
	x4, y4, z4,
	x5, y5, z5,
	x6, y6, z6,
	rotationNr,
	-1
>
{
	enum
	{
		with = -1
	};
};

//////////////////////////////////////////////////////////////
template<
	int x1, int y1, int z1,
	int x2, int y2, int z2,
	int x3, int y3, int z3,
	int x4, int y4, int z4,
	int x5, int y5, int z5,
	int x6, int y6, int z6,
	int rotationNr
>
struct Redundant
{
	enum
	{
		//==-1 if not redundant
		with = RedundantHelper<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, rotationNr, rotationNr-1>::with,
	};
};

//////////////////////////////////////////////////////////////
template<
	int x1, int y1, int z1,
	int x2, int y2, int z2,
	int x3, int y3, int z3,
	int x4, int y4, int z4,
	int x5, int y5, int z5,
	int x6, int y6, int z6
>
struct Redundant<
	x1, y1, z1,
	x2, y2, z2,
	x3, y3, z3,
	x4, y4, z4,
	x5, y5, z5,
	x6, y6, z6,
	0
>
{
	enum
	{
		with = -1
	};
};

//////////////////////////////////////////////////////////////
template<
	int Posx1, int Posy1, int Posz1,
	int Posx2, int Posy2, int Posz2,
	int Posx3, int Posy3, int Posz3,
	int Posx4, int Posy4, int Posz4,
	int Posx5, int Posy5, int Posz5,
	int Posx6, int Posy6, int Posz6,
	int rotationNr
>
struct RotatedPiece
{
	enum
	{
		x1 = Rotate<Posx1, Posy1, Posz1, Posx2, Posy2, Posz2, Posx3, Posy3, Posz3, Posx4, Posy4, Posz4, Posx5, Posy5, Posz5, Posx6, Posy6, Posz6, rotationNr>::x1,
		x2 = Rotate<Posx1, Posy1, Posz1, Posx2, Posy2, Posz2, Posx3, Posy3, Posz3, Posx4, Posy4, Posz4, Posx5, Posy5, Posz5, Posx6, Posy6, Posz6, rotationNr>::x2,
		x3 = Rotate<Posx1, Posy1, Posz1, Posx2, Posy2, Posz2, Posx3, Posy3, Posz3, Posx4, Posy4, Posz4, Posx5, Posy5, Posz5, Posx6, Posy6, Posz6, rotationNr>::x3,
		x4 = Rotate<Posx1, Posy1, Posz1, Posx2, Posy2, Posz2, Posx3, Posy3, Posz3, Posx4, Posy4, Posz4, Posx5, Posy5, Posz5, Posx6, Posy6, Posz6, rotationNr>::x4,
		x5 = Rotate<Posx1, Posy1, Posz1, Posx2, Posy2, Posz2, Posx3, Posy3, Posz3, Posx4, Posy4, Posz4, Posx5, Posy5, Posz5, Posx6, Posy6, Posz6, rotationNr>::x5,
		x6 = Rotate<Posx1, Posy1, Posz1, Posx2, Posy2, Posz2, Posx3, Posy3, Posz3, Posx4, Posy4, Posz4, Posx5, Posy5, Posz5, Posx6, Posy6, Posz6, rotationNr>::x6,
		y1 = Rotate<Posx1, Posy1, Posz1, Posx2, Posy2, Posz2, Posx3, Posy3, Posz3, Posx4, Posy4, Posz4, Posx5, Posy5, Posz5, Posx6, Posy6, Posz6, rotationNr>::y1,
		y2 = Rotate<Posx1, Posy1, Posz1, Posx2, Posy2, Posz2, Posx3, Posy3, Posz3, Posx4, Posy4, Posz4, Posx5, Posy5, Posz5, Posx6, Posy6, Posz6, rotationNr>::y2,
		y3 = Rotate<Posx1, Posy1, Posz1, Posx2, Posy2, Posz2, Posx3, Posy3, Posz3, Posx4, Posy4, Posz4, Posx5, Posy5, Posz5, Posx6, Posy6, Posz6, rotationNr>::y3,
		y4 = Rotate<Posx1, Posy1, Posz1, Posx2, Posy2, Posz2, Posx3, Posy3, Posz3, Posx4, Posy4, Posz4, Posx5, Posy5, Posz5, Posx6, Posy6, Posz6, rotationNr>::y4,
		y5 = Rotate<Posx1, Posy1, Posz1, Posx2, Posy2, Posz2, Posx3, Posy3, Posz3, Posx4, Posy4, Posz4, Posx5, Posy5, Posz5, Posx6, Posy6, Posz6, rotationNr>::y5,
		y6 = Rotate<Posx1, Posy1, Posz1, Posx2, Posy2, Posz2, Posx3, Posy3, Posz3, Posx4, Posy4, Posz4, Posx5, Posy5, Posz5, Posx6, Posy6, Posz6, rotationNr>::y6,
		z1 = Rotate<Posx1, Posy1, Posz1, Posx2, Posy2, Posz2, Posx3, Posy3, Posz3, Posx4, Posy4, Posz4, Posx5, Posy5, Posz5, Posx6, Posy6, Posz6, rotationNr>::z1,
		z2 = Rotate<Posx1, Posy1, Posz1, Posx2, Posy2, Posz2, Posx3, Posy3, Posz3, Posx4, Posy4, Posz4, Posx5, Posy5, Posz5, Posx6, Posy6, Posz6, rotationNr>::z2,
		z3 = Rotate<Posx1, Posy1, Posz1, Posx2, Posy2, Posz2, Posx3, Posy3, Posz3, Posx4, Posy4, Posz4, Posx5, Posy5, Posz5, Posx6, Posy6, Posz6, rotationNr>::z3,
		z4 = Rotate<Posx1, Posy1, Posz1, Posx2, Posy2, Posz2, Posx3, Posy3, Posz3, Posx4, Posy4, Posz4, Posx5, Posy5, Posz5, Posx6, Posy6, Posz6, rotationNr>::z4,
		z5 = Rotate<Posx1, Posy1, Posz1, Posx2, Posy2, Posz2, Posx3, Posy3, Posz3, Posx4, Posy4, Posz4, Posx5, Posy5, Posz5, Posx6, Posy6, Posz6, rotationNr>::z5,
		z6 = Rotate<Posx1, Posy1, Posz1, Posx2, Posy2, Posz2, Posx3, Posy3, Posz3, Posx4, Posy4, Posz4, Posx5, Posy5, Posz5, Posx6, Posy6, Posz6, rotationNr>::z6,
		redundantWith = Redundant<Posx1, Posy1, Posz1, Posx2, Posy2, Posz2, Posx3, Posy3, Posz3, Posx4, Posy4, Posz4, Posx5, Posy5, Posz5, Posx6, Posy6, Posz6, rotationNr>::with

	};

	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 0, 0, 0> s00;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 1, 0, 0> s01;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 2, 0, 0> s02;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 3, 0, 0> s03;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 4, 0, 0> s04;

	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 0, 1, 0> s05;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 1, 1, 0> s06;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 2, 1, 0> s07;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 3, 1, 0> s08;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 4, 1, 0> s09;

	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 0, 2, 0> s10;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 1, 2, 0> s11;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 2, 2, 0> s12;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 3, 2, 0> s13;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 4, 2, 0> s14;

	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 0, 3, 0> s15;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 1, 3, 0> s16;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 2, 3, 0> s17;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 3, 3, 0> s18;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 4, 3, 0> s19;

	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 0, 0, 1> s20;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 1, 0, 1> s21;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 2, 0, 1> s22;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 3, 0, 1> s23;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 4, 0, 1> s24;

	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 0, 1, 1> s25;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 1, 1, 1> s26;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 2, 1, 1> s27;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 3, 1, 1> s28;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 4, 1, 1> s29;

	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 0, 2, 1> s30;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 1, 2, 1> s31;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 2, 2, 1> s32;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 3, 2, 1> s33;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 4, 2, 1> s34;

	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 0, 3, 1> s35;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 1, 3, 1> s36;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 2, 3, 1> s37;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 3, 3, 1> s38;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 4, 3, 1> s39;

	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 0, 0, 2> s40;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 1, 0, 2> s41;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 2, 0, 2> s42;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 3, 0, 2> s43;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 4, 0, 2> s44;

	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 0, 1, 2> s45;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 1, 1, 2> s46;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 2, 1, 2> s47;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 3, 1, 2> s48;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 4, 1, 2> s49;

	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 0, 2, 2> s50;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 1, 2, 2> s51;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 2, 2, 2> s52;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 3, 2, 2> s53;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 4, 2, 2> s54;

	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 0, 3, 2> s55;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 1, 3, 2> s56;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 2, 3, 2> s57;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 3, 3, 2> s58;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 4, 3, 2> s59;
};



//////////////////////////////////////////////////////////////
template<
	int x1, int y1, int z1,
	int x2, int y2, int z2,
	int x3, int y3, int z3,
	int x4, int y4, int z4,
	int x5, int y5, int z5,
	int x6, int y6, int z6
>
struct Piece
{
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6,  0> r00;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6,  1> r01;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6,  2> r02;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6,  3> r03;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6,  4> r04;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6,  5> r05;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6,  6> r06;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6,  7> r07;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6,  8> r08;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6,  9> r09;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 10> r10;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 11> r11;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 12> r12;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 13> r13;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 14> r14;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 15> r15;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 16> r16;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 17> r17;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 18> r18;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 19> r19;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 20> r20;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 21> r21;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 22> r22;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 23> r23;
};

//////////////////////////////////////////////////////////////
template<
	class P,
	int cube1,
	int cube2
>
struct Solution
{
	enum {
		isValid = (P::isValid && ((P::id1 & cube1) == 0) && ((P::id2 & cube2) == 0) )
	};
};

//////////////////////////////////////////////////////////////
template<
	class P1,
	class P2,
	class P3,
	class P4,
	class P5,
	class P6,
	class P7,
	class P8,
	class P9,
	class P10,
	class P11,
	class P12,
	unsigned int cube1=0,
	unsigned int cube2=0,
	bool valid=true
>
struct Puzzle;

//////////////////////////////////////////////////////////////
template<
	class P1,
	class P2,
	class P3,
	class P4,
	class P5,
	class P6,
	class P7,
	class P8,
	class P9,
	class P10,
	class P11,
	class P12,
	unsigned int cube1,
	unsigned int cube2
>
struct Puzzle<P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,cube1,cube2,false>
{
	enum
	{
		solutions = 0
	};
};

//////////////////////////////////////////////////////////////
template<
	int x1, int y1, int z1,
	int x2, int y2, int z2,
	int x3, int y3, int z3,
	int x4, int y4, int z4,
	int x5, int y5, int z5,
	int x6, int y6, int z6,
	int sx, int sy, int sz,
	class SP2,
	class SP3,
	class SP4,
	class SP5,
	class SP6,
	class SP7,
	class SP8,
	class SP9,
	class SP10,
	class SP11,
	class SP12,
	unsigned int cube1,
	unsigned int cube2
>
struct Puzzle<ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, sx, sy, sz>,SP2,SP3,SP4,SP5,SP6,SP7,SP8,SP9,SP10,SP11,SP12,cube1,cube2,true>
{
	enum
	{
		solutions = 1
	};
};

//////////////////////////////////////////////////////////////
template<
	int x1, int y1, int z1,
	int x2, int y2, int z2,
	int x3, int y3, int z3,
	int x4, int y4, int z4,
	int x5, int y5, int z5,
	int x6, int y6, int z6,
	class P2,
	class P3,
	class P4,
	class P5,
	class P6,
	class P7,
	class P8,
	class P9,
	class P10,
	class P11,
	class P12,
	unsigned int cube1,
	unsigned int cube2
>
struct Puzzle<Piece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6>,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,cube1,cube2,true>
{
		//////////////////////////////////////////////////////////////
		template<
			class P1,
			class P2,
			class P3,
			class P4,
			class P5,
			class P6,
			class P7,
			class P8,
			class P9,
			class P10,
			class P11,
			class P12,
			unsigned int cube1,
			unsigned int cube2,
			bool valid
		>
		struct PuzzleR;

		//////////////////////////////////////////////////////////////
		template<
			class P1,
			class P2,
			class P3,
			class P4,
			class P5,
			class P6,
			class P7,
			class P8,
			class P9,
			class P10,
			class P11,
			class P12,
			unsigned int cube1,
			unsigned int cube2
		>
		struct PuzzleR<P1,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,cube1,cube2,false>
		{
			enum
			{
				solutions = 0
			};
		};

		//////////////////////////////////////////////////////////////
		template<
			int x1, int y1, int z1,
			int x2, int y2, int z2,
			int x3, int y3, int z3,
			int x4, int y4, int z4,
			int x5, int y5, int z5,
			int x6, int y6, int z6,
			int rotationNr,
			class P2,
			class P3,
			class P4,
			class P5,
			class P6,
			class P7,
			class P8,
			class P9,
			class P10,
			class P11,
			class P12,
			unsigned int cube1,
			unsigned int cube2
		>
		struct PuzzleR<RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, rotationNr>,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,cube1,cube2,true>
		{
			typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, rotationNr> P;
			enum
			{
				solutions = 
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s00,(cube1|P::s00::id1),(cube2|P::s00::id2),Solution<P::s00,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s01,(cube1|P::s01::id1),(cube2|P::s01::id2),Solution<P::s01,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s02,(cube1|P::s02::id1),(cube2|P::s02::id2),Solution<P::s02,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s03,(cube1|P::s03::id1),(cube2|P::s03::id2),Solution<P::s03,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s04,(cube1|P::s04::id1),(cube2|P::s04::id2),Solution<P::s04,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s05,(cube1|P::s05::id1),(cube2|P::s05::id2),Solution<P::s05,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s06,(cube1|P::s06::id1),(cube2|P::s06::id2),Solution<P::s06,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s07,(cube1|P::s07::id1),(cube2|P::s07::id2),Solution<P::s07,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s08,(cube1|P::s08::id1),(cube2|P::s08::id2),Solution<P::s08,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s09,(cube1|P::s09::id1),(cube2|P::s09::id2),Solution<P::s09,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s10,(cube1|P::s10::id1),(cube2|P::s10::id2),Solution<P::s10,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s11,(cube1|P::s11::id1),(cube2|P::s11::id2),Solution<P::s11,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s12,(cube1|P::s12::id1),(cube2|P::s12::id2),Solution<P::s12,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s13,(cube1|P::s13::id1),(cube2|P::s13::id2),Solution<P::s13,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s14,(cube1|P::s14::id1),(cube2|P::s14::id2),Solution<P::s14,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s15,(cube1|P::s15::id1),(cube2|P::s15::id2),Solution<P::s15,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s16,(cube1|P::s16::id1),(cube2|P::s16::id2),Solution<P::s16,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s17,(cube1|P::s17::id1),(cube2|P::s17::id2),Solution<P::s17,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s18,(cube1|P::s18::id1),(cube2|P::s18::id2),Solution<P::s18,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s19,(cube1|P::s19::id1),(cube2|P::s19::id2),Solution<P::s19,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s20,(cube1|P::s20::id1),(cube2|P::s20::id2),Solution<P::s20,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s21,(cube1|P::s21::id1),(cube2|P::s21::id2),Solution<P::s21,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s22,(cube1|P::s22::id1),(cube2|P::s22::id2),Solution<P::s22,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s23,(cube1|P::s23::id1),(cube2|P::s23::id2),Solution<P::s23,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s24,(cube1|P::s24::id1),(cube2|P::s24::id2),Solution<P::s24,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s25,(cube1|P::s25::id1),(cube2|P::s25::id2),Solution<P::s25,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s26,(cube1|P::s26::id1),(cube2|P::s26::id2),Solution<P::s26,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s27,(cube1|P::s27::id1),(cube2|P::s27::id2),Solution<P::s27,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s28,(cube1|P::s28::id1),(cube2|P::s28::id2),Solution<P::s28,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s29,(cube1|P::s29::id1),(cube2|P::s29::id2),Solution<P::s29,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s30,(cube1|P::s30::id1),(cube2|P::s30::id2),Solution<P::s30,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s31,(cube1|P::s31::id1),(cube2|P::s31::id2),Solution<P::s31,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s32,(cube1|P::s32::id1),(cube2|P::s32::id2),Solution<P::s32,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s33,(cube1|P::s33::id1),(cube2|P::s33::id2),Solution<P::s33,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s34,(cube1|P::s34::id1),(cube2|P::s34::id2),Solution<P::s34,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s35,(cube1|P::s35::id1),(cube2|P::s35::id2),Solution<P::s35,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s36,(cube1|P::s36::id1),(cube2|P::s36::id2),Solution<P::s36,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s37,(cube1|P::s37::id1),(cube2|P::s37::id2),Solution<P::s37,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s38,(cube1|P::s38::id1),(cube2|P::s38::id2),Solution<P::s38,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s39,(cube1|P::s39::id1),(cube2|P::s39::id2),Solution<P::s39,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s40,(cube1|P::s40::id1),(cube2|P::s40::id2),Solution<P::s40,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s41,(cube1|P::s41::id1),(cube2|P::s41::id2),Solution<P::s41,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s42,(cube1|P::s42::id1),(cube2|P::s42::id2),Solution<P::s42,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s43,(cube1|P::s43::id1),(cube2|P::s43::id2),Solution<P::s43,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s44,(cube1|P::s44::id1),(cube2|P::s44::id2),Solution<P::s44,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s45,(cube1|P::s45::id1),(cube2|P::s45::id2),Solution<P::s45,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s46,(cube1|P::s46::id1),(cube2|P::s46::id2),Solution<P::s46,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s47,(cube1|P::s47::id1),(cube2|P::s47::id2),Solution<P::s47,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s48,(cube1|P::s48::id1),(cube2|P::s48::id2),Solution<P::s48,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s49,(cube1|P::s49::id1),(cube2|P::s49::id2),Solution<P::s49,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s50,(cube1|P::s50::id1),(cube2|P::s50::id2),Solution<P::s50,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s51,(cube1|P::s51::id1),(cube2|P::s51::id2),Solution<P::s51,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s52,(cube1|P::s52::id1),(cube2|P::s52::id2),Solution<P::s52,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s53,(cube1|P::s53::id1),(cube2|P::s53::id2),Solution<P::s53,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s54,(cube1|P::s54::id1),(cube2|P::s54::id2),Solution<P::s54,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s55,(cube1|P::s55::id1),(cube2|P::s55::id2),Solution<P::s55,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s56,(cube1|P::s56::id1),(cube2|P::s56::id2),Solution<P::s56,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s57,(cube1|P::s57::id1),(cube2|P::s57::id2),Solution<P::s57,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s58,(cube1|P::s58::id1),(cube2|P::s58::id2),Solution<P::s58,cube1,cube2>::isValid>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,P::s59,(cube1|P::s59::id1),(cube2|P::s59::id2),Solution<P::s59,cube1,cube2>::isValid>::solutions
			};
		};


	typedef Piece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6> P;
	enum
	{
		solutions = 
		PuzzleR<P::r00,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,cube1,cube2,P::r00::redundantWith==-1>::solutions +
		PuzzleR<P::r01,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,cube1,cube2,P::r01::redundantWith==-1>::solutions +
		PuzzleR<P::r02,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,cube1,cube2,P::r02::redundantWith==-1>::solutions +
		PuzzleR<P::r03,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,cube1,cube2,P::r03::redundantWith==-1>::solutions +
		PuzzleR<P::r04,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,cube1,cube2,P::r04::redundantWith==-1>::solutions +
		PuzzleR<P::r05,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,cube1,cube2,P::r05::redundantWith==-1>::solutions +
		PuzzleR<P::r06,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,cube1,cube2,P::r06::redundantWith==-1>::solutions +
		PuzzleR<P::r07,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,cube1,cube2,P::r07::redundantWith==-1>::solutions +
		PuzzleR<P::r08,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,cube1,cube2,P::r08::redundantWith==-1>::solutions +
		PuzzleR<P::r09,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,cube1,cube2,P::r09::redundantWith==-1>::solutions +
		PuzzleR<P::r10,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,cube1,cube2,P::r10::redundantWith==-1>::solutions +
		PuzzleR<P::r11,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,cube1,cube2,P::r11::redundantWith==-1>::solutions +
		PuzzleR<P::r12,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,cube1,cube2,P::r12::redundantWith==-1>::solutions +
		PuzzleR<P::r13,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,cube1,cube2,P::r13::redundantWith==-1>::solutions +
		PuzzleR<P::r14,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,cube1,cube2,P::r14::redundantWith==-1>::solutions +
		PuzzleR<P::r15,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,cube1,cube2,P::r15::redundantWith==-1>::solutions +
		PuzzleR<P::r16,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,cube1,cube2,P::r16::redundantWith==-1>::solutions +
		PuzzleR<P::r17,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,cube1,cube2,P::r17::redundantWith==-1>::solutions +
		PuzzleR<P::r18,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,cube1,cube2,P::r18::redundantWith==-1>::solutions +
		PuzzleR<P::r19,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,cube1,cube2,P::r19::redundantWith==-1>::solutions +
		PuzzleR<P::r20,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,cube1,cube2,P::r20::redundantWith==-1>::solutions +
		PuzzleR<P::r21,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,cube1,cube2,P::r21::redundantWith==-1>::solutions +
		PuzzleR<P::r22,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,cube1,cube2,P::r22::redundantWith==-1>::solutions +
		PuzzleR<P::r23,P2,P3,P4,P5,P6,P7,P8,P9,P10,P11,P12,cube1,cube2,P::r23::redundantWith==-1>::solutions
	};
};


void Show(unsigned long long c)
{
	const char space = '.';
	const char set = 'X';
	cerr << "   " << ((c&((unsigned long long)1 <<  0))?set:space)
	              << ((c&((unsigned long long)1 <<  1))?set:space)
	              << ((c&((unsigned long long)1 <<  2))?set:space)
	              << ((c&((unsigned long long)1 <<  3))?set:space)
	              << ((c&((unsigned long long)1 <<  4))?set:space)
				  << endl;

	cerr <<  "  " << ((c&((unsigned long long)1 <<  5))?set:space)
	              << ((c&((unsigned long long)1 <<  6))?set:space)
	              << ((c&((unsigned long long)1 <<  7))?set:space)
	              << ((c&((unsigned long long)1 <<  8))?set:space)
	              << ((c&((unsigned long long)1 <<  9))?set:space)
				  << endl;

	cerr <<   " " << ((c&((unsigned long long)1 << 10))?set:space)
	              << ((c&((unsigned long long)1 << 11))?set:space)
	              << ((c&((unsigned long long)1 << 12))?set:space)
	              << ((c&((unsigned long long)1 << 13))?set:space)
	              << ((c&((unsigned long long)1 << 14))?set:space)
				  << endl;

	cerr          << ((c&((unsigned long long)1 << 15))?set:space)
	              << ((c&((unsigned long long)1 << 16))?set:space)
	              << ((c&((unsigned long long)1 << 17))?set:space)
	              << ((c&((unsigned long long)1 << 18))?set:space)
				  << ((c&((unsigned long long)1 << 19))?set:space)
				  << endl;

	cerr << endl;

	cerr << "   " << ((c&((unsigned long long)1 << 20))?set:space)
	              << ((c&((unsigned long long)1 << 21))?set:space)
	              << ((c&((unsigned long long)1 << 22))?set:space)
	              << ((c&((unsigned long long)1 << 23))?set:space)
	              << ((c&((unsigned long long)1 << 24))?set:space)
				  << endl;

	cerr <<  "  " << ((c&((unsigned long long)1 << 25))?set:space)
	              << ((c&((unsigned long long)1 << 26))?set:space)
	              << ((c&((unsigned long long)1 << 27))?set:space)
	              << ((c&((unsigned long long)1 << 28))?set:space)
	              << ((c&((unsigned long long)1 << 29))?set:space)
				  << endl;

	cerr <<   " " << ((c&((unsigned long long)1 << 30))?set:space)
	              << ((c&((unsigned long long)1 << 31))?set:space)
	              << ((c&((unsigned long long)1 << 32))?set:space)
	              << ((c&((unsigned long long)1 << 33))?set:space)
	              << ((c&((unsigned long long)1 << 34))?set:space)
				  << endl;

	cerr          << ((c&((unsigned long long)1 << 35))?set:space)
	              << ((c&((unsigned long long)1 << 36))?set:space)
	              << ((c&((unsigned long long)1 << 37))?set:space)
	              << ((c&((unsigned long long)1 << 38))?set:space)
				  << ((c&((unsigned long long)1 << 39))?set:space)
				  << endl;

	cerr << endl;

	cerr << "   " << ((c&((unsigned long long)1 << 40))?set:space)
	              << ((c&((unsigned long long)1 << 41))?set:space)
	              << ((c&((unsigned long long)1 << 42))?set:space)
	              << ((c&((unsigned long long)1 << 43))?set:space)
	              << ((c&((unsigned long long)1 << 44))?set:space)
				  << endl;

	cerr <<  "  " << ((c&((unsigned long long)1 << 45))?set:space)
	              << ((c&((unsigned long long)1 << 46))?set:space)
	              << ((c&((unsigned long long)1 << 47))?set:space)
	              << ((c&((unsigned long long)1 << 48))?set:space)
	              << ((c&((unsigned long long)1 << 49))?set:space)
				  << endl;

	cerr <<   " " << ((c&((unsigned long long)1 << 50))?set:space)
	              << ((c&((unsigned long long)1 << 51))?set:space)
	              << ((c&((unsigned long long)1 << 52))?set:space)
	              << ((c&((unsigned long long)1 << 53))?set:space)
	              << ((c&((unsigned long long)1 << 54))?set:space)
				  << endl;

	cerr          << ((c&((unsigned long long)1 << 55))?set:space)
	              << ((c&((unsigned long long)1 << 56))?set:space)
	              << ((c&((unsigned long long)1 << 57))?set:space)
	              << ((c&((unsigned long long)1 << 58))?set:space)
				  << ((c&((unsigned long long)1 << 59))?set:space)
				  << endl;

	cerr << endl;
};

//////////////////////////////////////////////////////////////
int main(int argc, const char** argv)
{
	typedef Piece<
		1, 0, 0,
		0, 0, 0,
		0, 0, 1,
		0, 0, 2,
		1, 0, 2,
		1, 0, 2
	> p1;

	typedef Piece<
		2, 0, 0,
		1, 0, 0,
		1, 0, 1,
		1, 0, 2,
		0, 0, 2,
		0, 0, 2
	> p2;

	typedef Piece<
		1, 0, 0,
		1, 0, 1,
		1, 0, 2,
		1, 0, 3,
		0, 0, 3,
		0, 0, 3
	> p3;

	typedef Piece<
		0, 0, 0,
		0, 0, 1,
		0, 0, 2,
		0, 0, 3,
		1, 0, 1,
		1, 0, 1
	> p4;

	typedef Piece<
		0, 1, 0,
		0, 0, 0,
		0, 0, 1,
		0, 1, 1,
		1, 1, 1,
		1, 1, 1
	> p5;

	typedef Piece<
		0, 0, 0,
		1, 0, 0,
		2, 0, 0,
		1, 0, 1,
		1, 0, 2,
		1, 0, 2
	> p6;

	typedef Piece<
		0, 0, 1,
		0, 0, 2,
		1, 0, 2,
		1, 0, 1,
		1, 0, 0,
		1, 0, 0
	> p7;

	typedef Piece<
		0, 0, 0,
		0, 0, 1,
		1, 0, 1,
		1, 0, 2,
		2, 0, 2,
		2, 0, 2
	> p8;

	typedef Piece<
		0, 0, 1,
		0, 0, 0,
		0, 1, 0,
		1, 1, 0,
		1, 1, 0,
		1, 1, 0
	> p9;

	typedef Piece<
		0, 0, 0,
		0, 0, 1,
		1, 0, 1,
		1, 0, 2,
		2, 0, 1,
		2, 0, 1
	> p10;

	typedef Piece<
		1, 0, 1,
		1, 0, 0,
		0, 0, 1,
		1, 0, 2,
		2, 0, 1,
		2, 0, 1
	> p11;

	typedef Piece<
		0, 0, 0,
		0, 0, 1,
		1, 0, 1,
		0, 0, 2,
		0, 0, 3,
		1, 0, 3
	> p12;


	// uncomment this to calculate the number of solutions. 
//	cerr << Puzzle<p1,p2,p3,p4,p5,p6,p7,p8,p9,p10,p11,p12>::solutions << endl;

	// t-piece is not valid if placed vertical
//	cerr <<  5 << ": " << endl; Show(((unsigned long long)p12::r05::s00::id1) | (((unsigned long long)p12::r05::s00::id2)<<32)); cerr << "valid: " << p12::r05::s00::isValid << endl; cerr << "redundant: " << p12::r05::redundantWith << endl;
/*
	// there are 24 different orientations
	// piece 7 has no redundant orientations
	cerr <<  0 << ": " << endl; Show(((unsigned long long)p7::r00::s00::id1) | (((unsigned long long)p7::r00::s00::id2)<<32)); cerr << "redundant: " << p7::r00::redundantWith << endl;
	cerr <<  1 << ": " << endl; Show(((unsigned long long)p7::r01::s00::id1) | (((unsigned long long)p7::r01::s00::id2)<<32)); cerr << "redundant: " << p7::r01::redundantWith << endl;
	cerr <<  2 << ": " << endl; Show(((unsigned long long)p7::r02::s00::id1) | (((unsigned long long)p7::r02::s00::id2)<<32)); cerr << "redundant: " << p7::r02::redundantWith << endl;
	cerr <<  3 << ": " << endl; Show(((unsigned long long)p7::r03::s00::id1) | (((unsigned long long)p7::r03::s00::id2)<<32)); cerr << "redundant: " << p7::r03::redundantWith << endl;
	cerr <<  4 << ": " << endl; Show(((unsigned long long)p7::r04::s00::id1) | (((unsigned long long)p7::r04::s00::id2)<<32)); cerr << "redundant: " << p7::r04::redundantWith << endl;
	cerr <<  5 << ": " << endl; Show(((unsigned long long)p7::r05::s00::id1) | (((unsigned long long)p7::r05::s00::id2)<<32)); cerr << "redundant: " << p7::r05::redundantWith << endl;
	cerr <<  6 << ": " << endl; Show(((unsigned long long)p7::r06::s00::id1) | (((unsigned long long)p7::r06::s00::id2)<<32)); cerr << "redundant: " << p7::r06::redundantWith << endl;
	cerr <<  7 << ": " << endl; Show(((unsigned long long)p7::r07::s00::id1) | (((unsigned long long)p7::r07::s00::id2)<<32)); cerr << "redundant: " << p7::r07::redundantWith << endl;
	cerr <<  8 << ": " << endl; Show(((unsigned long long)p7::r08::s00::id1) | (((unsigned long long)p7::r08::s00::id2)<<32)); cerr << "redundant: " << p7::r08::redundantWith << endl;
	cerr <<  9 << ": " << endl; Show(((unsigned long long)p7::r09::s00::id1) | (((unsigned long long)p7::r09::s00::id2)<<32)); cerr << "redundant: " << p7::r09::redundantWith << endl;
	cerr << 10 << ": " << endl; Show(((unsigned long long)p7::r10::s00::id1) | (((unsigned long long)p7::r10::s00::id2)<<32)); cerr << "redundant: " << p7::r10::redundantWith << endl;
	cerr << 11 << ": " << endl; Show(((unsigned long long)p7::r11::s00::id1) | (((unsigned long long)p7::r11::s00::id2)<<32)); cerr << "redundant: " << p7::r11::redundantWith << endl;
	cerr << 12 << ": " << endl; Show(((unsigned long long)p7::r12::s00::id1) | (((unsigned long long)p7::r12::s00::id2)<<32)); cerr << "redundant: " << p7::r12::redundantWith << endl;
	cerr << 13 << ": " << endl; Show(((unsigned long long)p7::r13::s00::id1) | (((unsigned long long)p7::r13::s00::id2)<<32)); cerr << "redundant: " << p7::r13::redundantWith << endl;
	cerr << 14 << ": " << endl; Show(((unsigned long long)p7::r14::s00::id1) | (((unsigned long long)p7::r14::s00::id2)<<32)); cerr << "redundant: " << p7::r14::redundantWith << endl;
	cerr << 15 << ": " << endl; Show(((unsigned long long)p7::r15::s00::id1) | (((unsigned long long)p7::r15::s00::id2)<<32)); cerr << "redundant: " << p7::r15::redundantWith << endl;
	cerr << 16 << ": " << endl; Show(((unsigned long long)p7::r16::s00::id1) | (((unsigned long long)p7::r16::s00::id2)<<32)); cerr << "redundant: " << p7::r16::redundantWith << endl;
	cerr << 17 << ": " << endl; Show(((unsigned long long)p7::r17::s00::id1) | (((unsigned long long)p7::r17::s00::id2)<<32)); cerr << "redundant: " << p7::r17::redundantWith << endl;
	cerr << 18 << ": " << endl; Show(((unsigned long long)p7::r18::s00::id1) | (((unsigned long long)p7::r18::s00::id2)<<32)); cerr << "redundant: " << p7::r18::redundantWith << endl;
	cerr << 19 << ": " << endl; Show(((unsigned long long)p7::r19::s00::id1) | (((unsigned long long)p7::r19::s00::id2)<<32)); cerr << "redundant: " << p7::r19::redundantWith << endl;
	cerr << 20 << ": " << endl; Show(((unsigned long long)p7::r20::s00::id1) | (((unsigned long long)p7::r20::s00::id2)<<32)); cerr << "redundant: " << p7::r20::redundantWith << endl;
	cerr << 21 << ": " << endl; Show(((unsigned long long)p7::r21::s00::id1) | (((unsigned long long)p7::r21::s00::id2)<<32)); cerr << "redundant: " << p7::r21::redundantWith << endl;
	cerr << 22 << ": " << endl; Show(((unsigned long long)p7::r22::s00::id1) | (((unsigned long long)p7::r22::s00::id2)<<32)); cerr << "redundant: " << p7::r22::redundantWith << endl;
	cerr << 23 << ": " << endl; Show(((unsigned long long)p7::r23::s00::id1) | (((unsigned long long)p7::r23::s00::id2)<<32)); cerr << "redundant: " << p7::r23::redundantWith << endl;
*/
/*
	// piece 11 has a lot of redundant orientations
	cerr <<  0 << ": " << endl; Show(((unsigned long long)p11::r00::s00::id1) | (((unsigned long long)p11::r00::s00::id2)<<32)); cerr << "redundant mit: " << p11::r00::redundantWith << endl;
	cerr <<  1 << ": " << endl; Show(((unsigned long long)p11::r01::s00::id1) | (((unsigned long long)p11::r01::s00::id2)<<32)); cerr << "redundant mit: " << p11::r01::redundantWith << endl;
	cerr <<  2 << ": " << endl; Show(((unsigned long long)p11::r02::s00::id1) | (((unsigned long long)p11::r02::s00::id2)<<32)); cerr << "redundant mit: " << p11::r02::redundantWith << endl;
*/
	return 0;
}
