// runtime mit 12 Teilen

#include <iostream>
#include <iomanip>
#include <assert.h>

using namespace std;

//////////////////////////////////////////////////////////////
inline bool Valid(int x, int y, int z)
{
	return (x>=0 && x<5 && y>=0 && y<3 && z>=0 && z<4);
};

//////////////////////////////////////////////////////////////
// return offset to shift to origin
inline int ShiftToOrigin(int a1, int a2, int a3, int a4, int a5, int a6)
{
	int z1 = a1 < a2 ? a1 : a2;
	int z2 = z1 < a3 ? z1 : a3;
	int z3 = z2 < a4 ? z2 : a4;
	int z4 = z3 < a5 ? z3 : a5;
	int z5 = z4 < a6 ? z4 : a6;
	return z5 < 0 ? -z5 : z5;
};

//////////////////////////////////////////////////////////////
class ShiftedPiece
{
public:
	ShiftedPiece() 
		:isValid(0)
		,id(0)
	{};

	void Set(
		int Posx1, int Posy1, int Posz1,
		int Posx2, int Posy2, int Posz2,
		int Posx3, int Posy3, int Posz3,
		int Posx4, int Posy4, int Posz4,
		int Posx5, int Posy5, int Posz5,
		int Posx6, int Posy6, int Posz6,
		int sx,    int sz,    int sy
		)
	{
		int x1 = Posx1 + sx;
		int x2 = Posx2 + sx;
		int x3 = Posx3 + sx;
		int x4 = Posx4 + sx;
		int x5 = Posx5 + sx;
		int x6 = Posx6 + sx;
		int y1 = Posy1 + sy;
		int y2 = Posy2 + sy;
		int y3 = Posy3 + sy;
		int y4 = Posy4 + sy;
		int y5 = Posy5 + sy;
		int y6 = Posy6 + sy;
		int z1 = Posz1 + sz;
		int z2 = Posz2 + sz;
		int z3 = Posz3 + sz;
		int z4 = Posz4 + sz;
		int z5 = Posz5 + sz;
		int z6 = Posz6 + sz;
		isValid = (
			   Valid(x1, y1, z1)
			&& Valid(x2, y2, z2)
			&& Valid(x3, y3, z3)
			&& Valid(x4, y4, z4)
			&& Valid(x5, y5, z5)
			&& Valid(x6, y6, z6)
		);
		if (isValid)
		{
			id = (
				((unsigned long long)1)<< (x1 + z1*5 + y1*20)
				| ((unsigned long long)1)<< (x2 + z2*5 + y2*20)
				| ((unsigned long long)1)<< (x3 + z3*5 + y3*20)
				| ((unsigned long long)1)<< (x4 + z4*5 + y4*20)
				| ((unsigned long long)1)<< (x5 + z5*5 + y5*20)
				| ((unsigned long long)1)<< (x6 + z6*5 + y6*20)
			);
		}
	};

	int isValid;
	unsigned long long id;

	void Print(ostream& OS)
	{

		const char space = '.';
		const char set = 'X';
		OS << "   " << ((id&((unsigned long long)1 <<  0))?set:space)
					<< ((id&((unsigned long long)1 <<  1))?set:space)
					<< ((id&((unsigned long long)1 <<  2))?set:space)
					<< ((id&((unsigned long long)1 <<  3))?set:space)
					<< ((id&((unsigned long long)1 <<  4))?set:space)
					<< endl;

		OS <<  "  " << ((id&((unsigned long long)1 <<  5))?set:space)
					<< ((id&((unsigned long long)1 <<  6))?set:space)
					<< ((id&((unsigned long long)1 <<  7))?set:space)
					<< ((id&((unsigned long long)1 <<  8))?set:space)
					<< ((id&((unsigned long long)1 <<  9))?set:space)
					<< endl;

		OS <<   " " << ((id&((unsigned long long)1 << 10))?set:space)
					<< ((id&((unsigned long long)1 << 11))?set:space)
					<< ((id&((unsigned long long)1 << 12))?set:space)
					<< ((id&((unsigned long long)1 << 13))?set:space)
					<< ((id&((unsigned long long)1 << 14))?set:space)
					<< endl;

		OS          << ((id&((unsigned long long)1 << 15))?set:space)
					<< ((id&((unsigned long long)1 << 16))?set:space)
					<< ((id&((unsigned long long)1 << 17))?set:space)
					<< ((id&((unsigned long long)1 << 18))?set:space)
					<< ((id&((unsigned long long)1 << 19))?set:space)
					<< endl;

		OS << endl;

		OS << "   " << ((id&((unsigned long long)1 << 20))?set:space)
					<< ((id&((unsigned long long)1 << 21))?set:space)
					<< ((id&((unsigned long long)1 << 22))?set:space)
					<< ((id&((unsigned long long)1 << 23))?set:space)
					<< ((id&((unsigned long long)1 << 24))?set:space)
					<< endl;

		OS <<  "  " << ((id&((unsigned long long)1 << 25))?set:space)
					<< ((id&((unsigned long long)1 << 26))?set:space)
					<< ((id&((unsigned long long)1 << 27))?set:space)
					<< ((id&((unsigned long long)1 << 28))?set:space)
					<< ((id&((unsigned long long)1 << 29))?set:space)
					<< endl;

		OS <<   " " << ((id&((unsigned long long)1 << 30))?set:space)
					<< ((id&((unsigned long long)1 << 31))?set:space)
					<< ((id&((unsigned long long)1 << 32))?set:space)
					<< ((id&((unsigned long long)1 << 33))?set:space)
					<< ((id&((unsigned long long)1 << 34))?set:space)
					<< endl;

		OS          << ((id&((unsigned long long)1 << 35))?set:space)
					<< ((id&((unsigned long long)1 << 36))?set:space)
					<< ((id&((unsigned long long)1 << 37))?set:space)
					<< ((id&((unsigned long long)1 << 38))?set:space)
					<< ((id&((unsigned long long)1 << 39))?set:space)
					<< endl;

		OS << endl;

		OS << "   " << ((id&((unsigned long long)1 << 40))?set:space)
					<< ((id&((unsigned long long)1 << 41))?set:space)
					<< ((id&((unsigned long long)1 << 42))?set:space)
					<< ((id&((unsigned long long)1 << 43))?set:space)
					<< ((id&((unsigned long long)1 << 44))?set:space)
					<< endl;

		OS <<  "  " << ((id&((unsigned long long)1 << 45))?set:space)
					<< ((id&((unsigned long long)1 << 46))?set:space)
					<< ((id&((unsigned long long)1 << 47))?set:space)
					<< ((id&((unsigned long long)1 << 48))?set:space)
					<< ((id&((unsigned long long)1 << 49))?set:space)
					<< endl;

		OS <<   " " << ((id&((unsigned long long)1 << 50))?set:space)
					<< ((id&((unsigned long long)1 << 51))?set:space)
					<< ((id&((unsigned long long)1 << 52))?set:space)
					<< ((id&((unsigned long long)1 << 53))?set:space)
					<< ((id&((unsigned long long)1 << 54))?set:space)
					<< endl;

		OS          << ((id&((unsigned long long)1 << 55))?set:space)
					<< ((id&((unsigned long long)1 << 56))?set:space)
					<< ((id&((unsigned long long)1 << 57))?set:space)
					<< ((id&((unsigned long long)1 << 58))?set:space)
					<< ((id&((unsigned long long)1 << 59))?set:space)
					<< endl;

		OS << endl;
	};

};

//////////////////////////////////////////////////////////////
void Rotate(int rx, int ry, int rz, int rotationNr, int &x, int &y, int &z)
{
	switch(rotationNr)
	{
	case 0:
		x = rx;
		y = ry;
		z = rz;
		break;
	case 1:
		x = rz;
		y = ry;
		z = -rx;
		break;
	case 2:
		x = -rx;
		y = ry;
		z = -rz;
		break;
	case 3:
		x = -rz;
		y = ry;
		z = rx;
		break;
	case 4:
		x = rz;
		y = rx;
		z = ry;
		break;
	case 5:
		x = -rx;
		y = rz;
		z = ry;
		break;
	case 6:
		x = -rz;
		y = -rx;
		z = ry;
		break;
	case 7:
		x = rx;
		y = -rz;
		z = ry;
		break;
	case 8:
		x = ry;
		y = rz;
		z = rx;
		break;
	case 9:
		x = ry;
		y = -rx;
		z = rz;
		break;
	case 10:
		x = ry;
		y = -rz;
		z = -rx;
		break;
	case 11:
		x = ry;
		y = rx;
		z = -rz;
		break;
	case 12:
		x = -ry;
		y = rx;
		z = rz;
		break;
	case 13:
		x = -ry;
		y = rz;
		z = -rx;
		break;
	case 14:
		x = -ry;
		y = -rx;
		z = -rz;
		break;
	case 15:
		x = -ry;
		y = -rz;
		z = rx;
		break;
	case 16:
		x = rz;
		y = -ry;
		z = rx;
		break;
	case 17:
		x = -rx;
		y = -ry;
		z = rz;
		break;
	case 18:
		x = -rz;
		y = -ry;
		z = -rx;
		break;
	case 19:
		x = rx;
		y = -ry;
		z = -rz;
		break;
	case 20:
		x = rx;
		y = rz;
		z = -ry;
		break;
	case 21:
		x = rz;
		y = -rx;
		z = -ry;
		break;
	case 22:
		x = -rx;
		y = -rz;
		z = -ry;
		break;
	case 23:
		x = -rz;
		y = rx;
		z = -ry;
		break;
	};
}

void Rotation(
		int Posx1, int Posy1, int Posz1,
		int Posx2, int Posy2, int Posz2,
		int Posx3, int Posy3, int Posz3,
		int Posx4, int Posy4, int Posz4,
		int Posx5, int Posy5, int Posz5,
		int Posx6, int Posy6, int Posz6,
		int rotationNr,
		unsigned long long &id1,
		unsigned long long &id2
	)
{
	int zx1, zy1, zz1;
	int zx2, zy2, zz2;
	int zx3, zy3, zz3;
	int zx4, zy4, zz4;
	int zx5, zy5, zz5;
	int zx6, zy6, zz6;

	Rotate(Posx1, Posy1, Posz1, rotationNr, zx1, zy1, zz1);
	Rotate(Posx2, Posy2, Posz2, rotationNr, zx2, zy2, zz2);
	Rotate(Posx3, Posy3, Posz3, rotationNr, zx3, zy3, zz3);
	Rotate(Posx4, Posy4, Posz4, rotationNr, zx4, zy4, zz4);
	Rotate(Posx5, Posy5, Posz5, rotationNr, zx5, zy5, zz5);
	Rotate(Posx6, Posy6, Posz6, rotationNr, zx6, zy6, zz6);

	int sx = ShiftToOrigin(zx1, zx2, zx3, zx4, zx5, zx6);
	int sy = ShiftToOrigin(zy1, zy2, zy3, zy4, zy5, zy6);
	int sz = ShiftToOrigin(zz1, zz2, zz3, zz4, zz5, zz6);

	int x1 = zx1 + sx;
	int x2 = zx2 + sx;
	int x3 = zx3 + sx;
	int x4 = zx4 + sx;
	int x5 = zx5 + sx;
	int x6 = zx6 + sx;
	int y1 = zy1 + sy;
	int y2 = zy2 + sy;
	int y3 = zy3 + sy;
	int y4 = zy4 + sy;
	int y5 = zy5 + sy;
	int y6 = zy6 + sy;
	int z1 = zz1 + sz;
	int z2 = zz2 + sz;
	int z3 = zz3 + sz;
	int z4 = zz4 + sz;
	int z5 = zz5 + sz;
	int z6 = zz6 + sz;

	id1 = (
		((unsigned long long)1)<< (x1 + z1*5 + y1*20)
		| ((unsigned long long)1)<< (x2 + z2*5 + y2*20)
		| ((unsigned long long)1)<< (x3 + z3*5 + y3*20)
		| ((unsigned long long)1)<< (x4 + z4*5 + y4*20)
		| ((unsigned long long)1)<< (x5 + z5*5 + y5*20)
		| ((unsigned long long)1)<< (x6 + z6*5 + y6*20)
	) & 0xFFFFFFFF;
	id2 = (
		((unsigned long long)1)<< (x1 + z1*5 + y1*20)
		| ((unsigned long long)1)<< (x2 + z2*5 + y2*20)
		| ((unsigned long long)1)<< (x3 + z3*5 + y3*20)
		| ((unsigned long long)1)<< (x4 + z4*5 + y4*20)
		| ((unsigned long long)1)<< (x5 + z5*5 + y5*20)
		| ((unsigned long long)1)<< (x6 + z6*5 + y6*20)
	) >> 32;
};

//////////////////////////////////////////////////////////////
int Redundant(
	int x1, int y1, int z1,
	int x2, int y2, int z2,
	int x3, int y3, int z3,
	int x4, int y4, int z4,
	int x5, int y5, int z5,
	int x6, int y6, int z6,
	int rotationNr
	)
{
	int with = -1;
	unsigned long long r1id1;
	unsigned long long r1id2;
	Rotation(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, rotationNr, r1id1, r1id2);
	unsigned long long r2id1;
	unsigned long long r2id2;
	int otherRotation = rotationNr-1;
	while(otherRotation>=0)
	{
		Rotation(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, otherRotation, r2id1, r2id2);
		if ( (r1id1 == r2id1 ) && (r1id2 == r2id2 ) )
		{
			with = otherRotation;
			otherRotation=-1;
		} else {
			--otherRotation;
		}
	}
	return with;
};

//////////////////////////////////////////////////////////////
class RotatedPiece
{
public:
	RotatedPiece()
		:shift(NULL)
	{};

	void Set(
		int Posx1, int Posy1, int Posz1,
		int Posx2, int Posy2, int Posz2,
		int Posx3, int Posy3, int Posz3,
		int Posx4, int Posy4, int Posz4,
		int Posx5, int Posy5, int Posz5,
		int Posx6, int Posy6, int Posz6,
		int rotationNr
		)
	{
		redundantWith = Redundant(Posx1, Posy1, Posz1, Posx2, Posy2, Posz2, Posx3, Posy3, Posz3, Posx4, Posy4, Posz4, Posx5, Posy5, Posz5, Posx6, Posy6, Posz6, rotationNr);
		if (redundantWith==-1)
		{
			int zx1, zy1, zz1;
			int zx2, zy2, zz2;
			int zx3, zy3, zz3;
			int zx4, zy4, zz4;
			int zx5, zy5, zz5;
			int zx6, zy6, zz6;

			Rotate(Posx1, Posy1, Posz1, rotationNr, zx1, zy1, zz1);
			Rotate(Posx2, Posy2, Posz2, rotationNr, zx2, zy2, zz2);
			Rotate(Posx3, Posy3, Posz3, rotationNr, zx3, zy3, zz3);
			Rotate(Posx4, Posy4, Posz4, rotationNr, zx4, zy4, zz4);
			Rotate(Posx5, Posy5, Posz5, rotationNr, zx5, zy5, zz5);
			Rotate(Posx6, Posy6, Posz6, rotationNr, zx6, zy6, zz6);

			int sx = ShiftToOrigin(zx1, zx2, zx3, zx4, zx5, zx6);
			int sy = ShiftToOrigin(zy1, zy2, zy3, zy4, zy5, zy6);
			int sz = ShiftToOrigin(zz1, zz2, zz3, zz4, zz5, zz6);

			int x1 = zx1 + sx;
			int x2 = zx2 + sx;
			int x3 = zx3 + sx;
			int x4 = zx4 + sx;
			int x5 = zx5 + sx;
			int x6 = zx6 + sx;
			int y1 = zy1 + sy;
			int y2 = zy2 + sy;
			int y3 = zy3 + sy;
			int y4 = zy4 + sy;
			int y5 = zy5 + sy;
			int y6 = zy6 + sy;
			int z1 = zz1 + sz;
			int z2 = zz2 + sz;
			int z3 = zz3 + sz;
			int z4 = zz4 + sz;
			int z5 = zz5 + sz;
			int z6 = zz6 + sz;

			shift = new ShiftedPiece[60];
			assert(shift!=NULL);

			shift[ 0].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 0, 0, 0);
			shift[ 1].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 1, 0, 0);
			shift[ 2].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 2, 0, 0);
			shift[ 3].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 3, 0, 0);
			shift[ 4].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 4, 0, 0);
			shift[ 5].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 0, 1, 0);
			shift[ 6].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 1, 1, 0);
			shift[ 7].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 2, 1, 0);
			shift[ 8].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 3, 1, 0);
			shift[ 9].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 4, 1, 0);
			shift[10].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 0, 2, 0);
			shift[11].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 1, 2, 0);
			shift[12].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 2, 2, 0);
			shift[13].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 3, 2, 0);
			shift[14].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 4, 2, 0);
			shift[15].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 0, 3, 0);
			shift[16].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 1, 3, 0);
			shift[17].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 2, 3, 0);
			shift[18].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 3, 3, 0);
			shift[19].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 4, 3, 0);
			shift[20].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 0, 0, 1);
			shift[21].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 1, 0, 1);
			shift[22].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 2, 0, 1);
			shift[23].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 3, 0, 1);
			shift[24].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 4, 0, 1);
			shift[25].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 0, 1, 1);
			shift[26].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 1, 1, 1);
			shift[27].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 2, 1, 1);
			shift[28].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 3, 1, 1);
			shift[29].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 4, 1, 1);
			shift[30].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 0, 2, 1);
			shift[31].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 1, 2, 1);
			shift[32].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 2, 2, 1);
			shift[33].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 3, 2, 1);
			shift[34].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 4, 2, 1);
			shift[35].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 0, 3, 1);
			shift[36].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 1, 3, 1);
			shift[37].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 2, 3, 1);
			shift[38].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 3, 3, 1);
			shift[39].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 4, 3, 1);
			shift[40].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 0, 0, 2);
			shift[41].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 1, 0, 2);
			shift[42].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 2, 0, 2);
			shift[43].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 3, 0, 2);
			shift[44].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 4, 0, 2);
			shift[45].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 0, 1, 2);
			shift[46].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 1, 1, 2);
			shift[47].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 2, 1, 2);
			shift[48].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 3, 1, 2);
			shift[49].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 4, 1, 2);
			shift[50].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 0, 2, 2);
			shift[51].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 1, 2, 2);
			shift[52].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 2, 2, 2);
			shift[53].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 3, 2, 2);
			shift[54].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 4, 2, 2);
			shift[55].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 0, 3, 2);
			shift[56].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 1, 3, 2);
			shift[57].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 2, 3, 2);
			shift[58].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 3, 3, 2);
			shift[59].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 4, 3, 2);
		}

	};

	~RotatedPiece()
	{
		delete[] shift;
	}

	int redundantWith;

	ShiftedPiece* shift;
};



//////////////////////////////////////////////////////////////
class Piece
{
public:
	Piece()
		:rotate(new RotatedPiece[24])
	{};

	void Set (
		int x1, int y1, int z1,
		int x2, int y2, int z2,
		int x3, int y3, int z3,
		int x4, int y4, int z4,
		int x5, int y5, int z5,
		int x6, int y6, int z6
		)
	{
		assert(rotate!=NULL);

		rotate[ 0].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6,  0);
		rotate[ 1].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6,  1);
		rotate[ 2].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6,  2);
		rotate[ 3].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6,  3);
		rotate[ 4].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6,  4);
		rotate[ 5].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6,  5);
		rotate[ 6].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6,  6);
		rotate[ 7].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6,  7);
		rotate[ 8].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6,  8);
		rotate[ 9].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6,  9);
		rotate[10].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 10);
		rotate[11].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 11);
		rotate[12].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 12);
		rotate[13].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 13);
		rotate[14].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 14);
		rotate[15].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 15);
		rotate[16].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 16);
		rotate[17].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 17);
		rotate[18].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 18);
		rotate[19].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 19);
		rotate[20].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 20);
		rotate[21].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 21);
		rotate[22].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 22);
		rotate[23].Set(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, x5, y5, z5, x6, y6, z6, 23);
	};

	~Piece()
	{
		delete[] rotate;
	}

	RotatedPiece* rotate;
};

class Puzzle
{
public:
	Puzzle(Piece p[])
		:piece(p)
		,solutions(0)
	{
	};

	void Solve()
	{
		solutions=0;

		for(int r0=0; r0<24; ++r0)
		{
//cerr << "r0=" << r0 << endl;
			if(piece[0].rotate[r0].redundantWith==-1)
			{
				for(int s0=0; s0<60; ++s0)
				{
//cerr << "r0=" << r0 << '\t' << "s0=" << s0 << endl;
					if(piece[0].rotate[r0].shift[s0].isValid)
					{

		unsigned long long cube1 = piece[0].rotate[r0].shift[s0].id;
		for(int r1=0; r1<24; ++r1)
		{
//cerr << "r0=" << r0 << '\t' << "s0=" << s0 << '\t' << "r1=" << r1 << endl;
			if(piece[1].rotate[r1].redundantWith==-1)
			{
				for(int s1=0; s1<60; ++s1)
				{
//cerr << "r0=" << r0 << '\t' << "s0=" << s0 << '\t' << "r1=" << r1 << '\t' << "s1=" << s1 << endl;
					if(piece[1].rotate[r1].shift[s1].isValid &&
						((cube1 & piece[1].rotate[r1].shift[s1].id) == 0)
					)
					{

		unsigned long long cube2 = cube1 | piece[1].rotate[r1].shift[s1].id;
		for(int r2=0; r2<24; ++r2)
		{
//cerr << "r0=" << r0 << '\t' << "s0=" << s0 << '\t' << "r1=" << r1 << '\t' << "s1=" << s1 << '\t' << "r2=" << r2 << endl;
			if(piece[2].rotate[r2].redundantWith==-1)
			{
				for(int s2=0; s2<60; ++s2)
				{
//cerr << "r0=" << r0 << '\t' << "s0=" << s0 << '\t' << "r1=" << r1 << '\t' << "s1=" << s1 << '\t' << "r2=" << r2 << '\t' << "s2=" << s2 << endl;
					if(piece[2].rotate[r2].shift[s2].isValid &&
						((cube2 & piece[2].rotate[r2].shift[s2].id) == 0)
					)
					{

		unsigned long long cube3 = cube2 | piece[2].rotate[r2].shift[s2].id;
		for(int r3=0; r3<24; ++r3)
		{
//cerr << "r0=" << r0 << '\t' << "s0=" << s0 << '\t' << "r1=" << r1 << '\t' << "s1=" << s1 << '\t' << "r2=" << r2 << '\t' << "s2=" << s2 << '\t' << "r3=" << r3 << endl;
			if(piece[3].rotate[r3].redundantWith==-1)
			{
				for(int s3=0; s3<60; ++s3)
				{
//cerr << "r0=" << r0 << '\t' << "s0=" << s0 << '\t' << "r1=" << r1 << '\t' << "s1=" << s1 << '\t' << "r2=" << r2 << '\t' << "s2=" << s2 << '\t' << "r3=" << r3 << '\t' << "s3=" << s3 << endl;
					if(piece[3].rotate[r3].shift[s3].isValid &&
					((cube3 & piece[3].rotate[r3].shift[s3].id) == 0)
					)
					{

		unsigned long long cube4 = cube3 | piece[3].rotate[r3].shift[s3].id;
		for(int r4=0; r4<24; ++r4)
		{
//cerr << "r0=" << r0 << '\t' << "s0=" << s0 << '\t' << "r1=" << r1 << '\t' << "s1=" << s1 << '\t' << "r2=" << r2 << '\t' << "s2=" << s2 << '\t' << "r3=" << r3 << '\t' << "s3=" << s3 << '\t' << "r4=" << r4 << endl;
			if(piece[4].rotate[r4].redundantWith==-1)
			{
				for(int s4=0; s4<60; ++s4)
				{
					if(piece[4].rotate[r4].shift[s4].isValid &&
					((cube4 & piece[4].rotate[r4].shift[s4].id) == 0))
					{

		unsigned long long cube5 = cube4 | piece[4].rotate[r4].shift[s4].id;
		for(int r5=0; r5<24; ++r5)
		{
			if(piece[5].rotate[r5].redundantWith==-1)
			{
				for(int s5=0; s5<60; ++s5)
				{
					if(piece[5].rotate[r5].shift[s5].isValid &&
					((cube5 & piece[5].rotate[r5].shift[s5].id) == 0))
					{

		unsigned long long cube6 = cube5 | piece[5].rotate[r5].shift[s5].id;
		for(int r6=0; r6<24; ++r6)
		{
			if(piece[6].rotate[r6].redundantWith==-1)
			{
				for(int s6=0; s6<60; ++s6)
				{
					if(piece[6].rotate[r6].shift[s6].isValid &&
					((cube6 & piece[6].rotate[r6].shift[s6].id) == 0))
					{

		unsigned long long cube7 = cube6 | piece[6].rotate[r6].shift[s6].id;
		for(int r7=0; r7<24; ++r7)
		{
			if(piece[7].rotate[r7].redundantWith==-1)
			{
				for(int s7=0; s7<60; ++s7)
				{
					if(piece[7].rotate[r7].shift[s7].isValid &&
					((cube7 & piece[7].rotate[r7].shift[s7].id) == 0))
					{

		unsigned long long cube8 = cube7 | piece[7].rotate[r7].shift[s7].id;
		for(int r8=0; r8<24; ++r8)
		{
			if(piece[8].rotate[r8].redundantWith==-1)
			{
				for(int s8=0; s8<60; ++s8)
				{
					if(piece[8].rotate[r8].shift[s8].isValid &&
					((cube8 & piece[8].rotate[r8].shift[s8].id) == 0))
					{

		unsigned long long cube9 = cube8 | piece[8].rotate[r8].shift[s8].id;
		for(int r9=0; r9<24; ++r9)
		{
			if(piece[9].rotate[r9].redundantWith==-1)
			{
				for(int s9=0; s9<60; ++s9)
				{
					if(piece[9].rotate[r9].shift[s9].isValid &&
					((cube9 & piece[9].rotate[r9].shift[s9].id) == 0))
					{

		unsigned long long cube10 = cube9 | piece[9].rotate[r9].shift[s9].id;
		for(int r10=0; r10<24; ++r10)
		{
			if(piece[10].rotate[r10].redundantWith==-1)
			{
				for(int s10=0; s10<60; ++s10)
				{
					if(piece[10].rotate[r10].shift[s10].isValid &&
					((cube10 & piece[10].rotate[r10].shift[s10].id) == 0))
					{

		unsigned long long cube11 = cube10 | piece[10].rotate[r10].shift[s10].id;
		for(int r11=0; r11<24; ++r11)
		{
			if(piece[11].rotate[r11].redundantWith==-1)
			{
				for(int s11=0; s11<60; ++s11)
				{
					if(piece[11].rotate[r11].shift[s11].isValid &&
					((cube11 & piece[11].rotate[r11].shift[s11].id) == 0))
					{

		unsigned long long cube12 = cube11 | piece[11].rotate[r11].shift[s11].id;
		for(int r12=0; r12<24; ++r12)
		{
			if(piece[12].rotate[r12].redundantWith==-1)
			{
				for(int s12=0; s12<60; ++s12)
				{
					if(piece[12].rotate[r12].shift[s12].isValid &&
					((cube12 & piece[12].rotate[r12].shift[s12].id) == 0))
					{
cerr << endl << "solution";
						if ((cube12 | piece[12].rotate[r12].shift[s12].id) != 0x7FFFFFFF) cerr << "?" << endl;
						else cerr << "!" << endl;
cerr << r1 << '\t' << r2 << '\t' << r3 << '\t' << r4 << '\t' << r5 << '\t' << r6 << '\t' << r7 << '\t' << r8 << '\t' << r9 << '\t' << r10 << '\t' << r11 << '\t' << r12 << endl;
cerr << s1 << '\t' << s2 << '\t' << s3 << '\t' << s4 << '\t' << s5 << '\t' << s6 << '\t' << s7 << '\t' << s8 << '\t' << s9 << '\t' << s10 << '\t' << s11 << '\t' << s12 << endl;
cerr << (cube12 | piece[12].rotate[r12].shift[s12].id) << endl;
						++solutions;
					}
				}
			}
		}
					}
				}
			}
		}
					}
				}
			}
		}
					}
				}
			}
		}
					}
				}
			}
		}
					}
				}
			}
		}
					}
				}
			}
		}
					}
				}
			}// else cerr << "Teil 5, rotation " << r5 << " ist redundant mit " << piece[5].rotate[r5].redundantWith << endl;
		}
					}
				}
			} else cerr << "Teil 4, rotation " << r4 << " ist redundant mit " << piece[4].rotate[r4].redundantWith << endl;
		}
					}
				}
			} else cerr << "Teil 3, rotation " << r3 << " ist redundant mit " << piece[3].rotate[r3].redundantWith << endl;
		}
					}
				}
			} else cerr << "Teil 2, rotation " << r2 << " ist redundant mit " << piece[2].rotate[r2].redundantWith << endl;
		}
					}
				}
			} else cerr << "Teil 1, rotation " << r1 << " ist redundant mit " << piece[1].rotate[r1].redundantWith << endl;
		}
					}
				}
			} else cerr << "Teil 0, rotation " << r0 << " ist redundant mit " << piece[0].rotate[r0].redundantWith << endl;
		}
	};

	Piece* piece;
	int solutions;
};

//////////////////////////////////////////////////////////////
int main(int argc, const char** argv)
{

	Piece piece[12];
	
	piece[0].Set(
			1, 0, 0,
			0, 0, 0,
			0, 0, 1,
			0, 0, 2,
			1, 0, 2,
			1, 0, 2
		);
	piece[1].Set(
			2, 0, 0,
			1, 0, 0,
			1, 0, 1,
			1, 0, 2,
			0, 0, 2,
			0, 0, 2
		);
	piece[2].Set(
			1, 0, 0,
			1, 0, 1,
			1, 0, 2,
			1, 0, 3,
			0, 0, 3,
			0, 0, 3
		);
	piece[3].Set(
			0, 0, 0,
			0, 0, 1,
			0, 0, 2,
			0, 0, 3,
			1, 0, 1,
			1, 0, 1
		);
	piece[4].Set(
			0, 1, 0,
			0, 0, 0,
			0, 0, 1,
			0, 1, 1,
			1, 1, 1,
			1, 1, 1
		);
	piece[5].Set(
			0, 0, 0,
			1, 0, 0,
			2, 0, 0,
			1, 0, 1,
			1, 0, 2,
			1, 0, 2
		);
	piece[6].Set(
			0, 0, 1,
			0, 0, 2,
			1, 0, 2,
			1, 0, 1,
			1, 0, 0,
			1, 0, 0
		);
	piece[7].Set(
			0, 0, 0,
			0, 0, 1,
			1, 0, 1,
			1, 0, 2,
			2, 0, 2,
			2, 0, 2
		);
	piece[8].Set(
			0, 0, 1,
			0, 0, 0,
			0, 1, 0,
			1, 1, 0,
			1, 1, 0,
			1, 1, 0
		);
	piece[9].Set(
			0, 0, 0,
			0, 0, 1,
			1, 0, 1,
			1, 0, 2,
			2, 0, 1,
			2, 0, 1
		);
	piece[10].Set(
			1, 0, 1,
			1, 0, 0,
			0, 0, 1,
			1, 0, 2,
			2, 0, 1,
			2, 0, 1
		);
	piece[11].Set(
			0, 0, 0,
			0, 0, 1,
			1, 0, 1,
			0, 0, 2,
			0, 0, 3,
			1, 0, 3
		);

	Puzzle puzzle(piece);
	puzzle.Solve();
	cerr << puzzle.solutions << endl;

	return 0;
}

