/*
 * modul.cpp
 *
 * zu ctpuzzle
 *
 * Autor: Wolfgang Ruelfing
 *        Pfarrer-Strerath-Strasse 7
 *        41470 Neuss
 *        <wolfgang@ruelfing.de>
 *
 *
 *
 *
 */


#include "modul.h"

BYTE Cube2BitNo(const SCube* pCube)
{
	if (!pCube)
		return 0;

	// !!! keine negativen komponenten !!!
	BYTE bitno = pCube->comp[0] + PUZZLELENGTH_0 * pCube->comp[1];
	if (DIM > 2)
		bitno += PUZZLELENGTH_0 * PUZZLELENGTH_1 * pCube->comp[2];
	return bitno;
}

BYTE TranslatedCube2BitNo(const SCube* pCube, char* pVector)
{
	if (!pVector || !pCube)
		return 0;

	// !!! keine negativen komponenten !!!
	SCube cubeTranslated;
	for (int nComp=0 ; nComp<DIM ; nComp++)
		cubeTranslated.comp[nComp] = pCube->comp[nComp] + pVector[nComp];

	return Cube2BitNo(&cubeTranslated);
}

QWORD Modul2BitVector(const SCube* pCubes, int nCubeCount)
{
	QWORD bitvector = 0;
	for (int nCube=0 ; nCube < nCubeCount ; nCube++)
		bitvector |= ((QWORD)1 << Cube2BitNo(&pCubes[nCube]));		
	return bitvector;
}

QWORD TranslatedModul2BitVector(const SCube* pCubes, int nCubeCount, char* pVector)
{
	QWORD bitvector = 0;
	for (int nCube=0 ; nCube < nCubeCount ; nCube++)
		bitvector |= ((QWORD)1 << TranslatedCube2BitNo(&pCubes[nCube], pVector));		
	return bitvector;
}

// im math. pos. sinn um nAxis (0,1,2)
void RotateCube90(const SCube* pCubeIn, SCube* pCubeOut, BYTE nAxis)
{
	if (!pCubeIn || !pCubeOut || nAxis >= DIM)
		return;

	if (DIM==2)
		nAxis = 2;
	else
		pCubeOut->comp[nAxis] = pCubeIn->comp[nAxis];

	char n1 = (nAxis + 1) % DIM;
	char n2 = (nAxis + 2) % DIM;

	pCubeOut->comp[n1] = - pCubeIn->comp[n2];
	pCubeOut->comp[n2] = pCubeIn->comp[n1];
}


// im math. pos. sinn um nAxis (0,1,2), nCount * 90 Grad
// dim=2 -> axis=2
void RotateCube(const SCube* pCubeIn, SCube* pCubeOut, BYTE nAxis, BYTE nCount)
{
	if (!pCubeIn || !pCubeOut)
		return;

	if (nCount == 0)
	{
		for (int i=0 ; i < DIM ; ++i)
			pCubeOut->comp[i] = pCubeIn->comp[i];
	}
	else
	{
		for (int i=0 ; i < nCount ; ++i)
			RotateCube90(pCubeIn, pCubeOut, nAxis);
	}
}


// im math. pos. sinn um nAxis (0,1,2), nCount * 90 Grad
void Modul::GenerateTempRotation(BYTE nTempRotIn, BYTE nTempRotOut, BYTE nAxis, BYTE nCount)
{
	if (nTempRotIn >= ALL_ROTATION_COUNT || nTempRotOut >= ALL_ROTATION_COUNT)
		return;

	for (int nCube=0 ; nCube < m_nCubeCount ; ++nCube)
	{
		if (nTempRotOut == 0)	// erste erzeugen
		{
			for (int nComp=0 ; nComp<DIM ; ++nComp)
				m_TempRotations[nTempRotOut][nCube].comp[nComp] = m_pCubes[nCube].comp[nComp];
		}
		else
			::RotateCube(&m_TempRotations[nTempRotIn][nCube], &m_TempRotations[nTempRotOut][nCube], nAxis, nCount);

	}
}

void Modul::GenerateSymFreeTempRotations() // pro koordinatenebene nur 2 lagen wg. quadersymmetrie des puzzles
{
	GenerateTempRotation(0, 0, 0, 0);	// ausgangsstellung
	GenerateTempRotation(0, 1, 2, 1);	// 0 um z
	GenerateTempRotation(1, 2, 1, 1);	// 1 um y
	GenerateTempRotation(2, 3, 0, 1);	// 2 um x
	GenerateTempRotation(3, 4, 2, 1);	// 3 um z
	GenerateTempRotation(4, 5, 1, 1);	// 4 um y

	m_nTempRotationCount = 6;
}

void Modul::GenerateAllTempRotations()
{
	// alle wuerfelseiten mal oben und jeweils 4 drehungen um z (hochachse)
	GenerateTempRotation( 0, 0, 0, 0);	// ausgangsstellung 1 oben, 2 vorn
	// 3mal um z
	GenerateTempRotation( 0, 1, 2, 1);
	GenerateTempRotation( 1, 2, 2, 1);
	GenerateTempRotation( 2, 3, 2, 1);

	GenerateTempRotation( 0, 4, 1, 1);	// 0 um y -> 3 ist oben
	// 3mal um z
	GenerateTempRotation( 4, 5, 2, 1);	 
	GenerateTempRotation( 5, 6, 2, 1);	 
	GenerateTempRotation( 6, 7, 2, 1);	 

	GenerateTempRotation( 4, 8, 0, 1);	// 4 um x -> 2 oben
	// 3mal um z
	GenerateTempRotation( 8, 9, 2, 1);	 
	GenerateTempRotation( 9,10, 2, 1);	 
	GenerateTempRotation(10,11, 2, 1);	 

	GenerateTempRotation( 8,12, 1, 1);	// 8 um y -> 6 oben
	// 3mal um z
	GenerateTempRotation(12,13, 2, 1);	
	GenerateTempRotation(13,14, 2, 1);	 
	GenerateTempRotation(14,15, 2, 1);	 

	GenerateTempRotation(12,16, 0, 1);	// 12 um x -> 4 oben
	// 3mal um z
	GenerateTempRotation(16,17, 2, 1);	 
	GenerateTempRotation(17,18, 2, 1);	 
	GenerateTempRotation(18,19, 2, 1);	 

	GenerateTempRotation(16,20, 1, 1);	// 16 um y -> 5 oben
	// 3mal um z
	GenerateTempRotation(20,21, 2, 1);	 
	GenerateTempRotation(21,22, 2, 1);	 
	GenerateTempRotation(22,23, 2, 1);	 

	m_nTempRotationCount = 24;
}



void Modul::GenerateAllRotations()		// nur die die passen, und die nicht identisch
{
	char nMin[DIM], nMax[DIM];	// grenzen fuer jede koordinatenrichtung

	QWORD RotationsInNullPosition[ALL_ROTATION_COUNT];

	// alle temp rotations durchlaufen, auf groesse und uebereinstimmung prufen
	for (int nTempRot=0 ; nTempRot < m_nTempRotationCount ; nTempRot++)
	{

		for (int nComp=0 ; nComp<DIM ; ++nComp)
		{
			nMin[nComp] = 127;
			nMax[nComp] = -128;
		}

		// abmessungen merken
		for (int nCube=0 ; nCube < m_nCubeCount ; ++nCube)
		{
			for (int nComp=0 ; nComp<DIM ; ++nComp)
			{
				char nValue = m_TempRotations[nTempRot][nCube].comp[nComp];
				if (nValue < nMin[nComp])
					nMin[nComp] = nValue;
				if (nValue > nMax[nComp])
					nMax[nComp] = nValue;
			}
		}


		// passt es so in das puzzle?
		// ausdehnung = max - min + 1
		if 
		(
			nMax[0] - nMin[0] >= PUZZLELENGTH_0 ||
			nMax[1] - nMin[1] >= PUZZLELENGTH_1 ||
			(DIM > 2 && nMax[2] - nMin[2] >= PUZZLELENGTH_2)
		)
		{
			// teil passt so nicht in puzzle
			continue;	// naechste rotation
		}


		// in grundstellung schieben

		for (int nCube=0 ; nCube < m_nCubeCount ; ++nCube)
		{
			for (int nComp=0 ; nComp<DIM ; ++nComp)
				m_Rotations[m_nRotationCount][nCube].comp[nComp] = m_TempRotations[nTempRot][nCube].comp[nComp] - nMin[nComp];
		}


		RotationsInNullPosition[m_nRotationCount] = ::Modul2BitVector(m_Rotations[m_nRotationCount], m_nCubeCount);	// erstmal ablegen

		// auf uebereinstimmung mit bisherigen rotationen pruefen
		bool bSchonDa = false;
		for (int nRot=0 ; nRot < m_nRotationCount ; nRot++)
		{
			if (RotationsInNullPosition[nRot] == RotationsInNullPosition[m_nRotationCount])
			{
				bSchonDa = true;
				break;
			}
		}

		if (!bSchonDa)
			m_nRotationCount++;
		
	}
}

void Modul::GenerateAllPositionsInPuzzle()
{
	char nMax[DIM];	// max fuer jede koordinatenrichtung, min=0 wg. grundstellung
	char vector[DIM];

	for (int nRot=0 ; nRot < m_nRotationCount ; nRot++)
	{
		for (int nComp=0 ; nComp<DIM ; ++nComp)
			nMax[nComp] = 0;

		for (int nCube=0 ; nCube < m_nCubeCount ; ++nCube)
		{
			for (int nComp=0 ; nComp<DIM ; ++nComp)
			{
				char nValue = m_Rotations[nRot][nCube].comp[nComp];
				if (nValue > nMax[nComp])
					nMax[nComp] = nValue;
			}
		}

		for (vector[0] = 0 ; vector[0] < PUZZLELENGTH_0 - nMax[0] ; vector[0]++)
		{
			for (vector[1] = 0 ; vector[1] < PUZZLELENGTH_1 - nMax[1] ; vector[1]++)
			{
				if (DIM > 2)
				{
					for (vector[2] = 0 ; vector[2] < PUZZLELENGTH_2 - nMax[2] ; vector[2]++)
					{
						m_PossiblePositionsInPuzzle[m_nPossiblePositionsCount++] = ::TranslatedModul2BitVector(m_Rotations[nRot], m_nCubeCount, vector);
					}
				}
				else
				{
					m_PossiblePositionsInPuzzle[m_nPossiblePositionsCount++] = ::TranslatedModul2BitVector(m_Rotations[nRot], m_nCubeCount, vector);
				}
			}
		}
	}
}
