
//
// ----------------------------
// --    c't-Puzzle lsen    --
// ----------------------------
//
// Autor: Tobias Glasmachers
//
// Dies ist mein Beitrag zum c't-Puzzle Programmierwettbewerb,
// Das Programm habe ich mit dem Intel-Compiler (icc) und den
// Compiler-Optionen O3, Qip, QxW/QaxW bersetzt.
//
//
// Ich habe nichts dagegen, wenn der Sourcecode von Anderen weiterverwendet wird.
// Vielleicht kann ja irgendjemand etwas wirklich sinnvolles damit anfangen.
// Wenn allerdings eine vernderte Version des Codes weitergegeben oder
// verffentlicht wird, so muss die Datei entsprechend gekennzeichnet sein.
//


#include <io.h>
#include <stdio.h>
#include <time.h>


#define UINT64			unsigned _int64
#define UINT			unsigned int
#define WORD			unsigned short
#define BYTE			unsigned char


#define DREI_D_TEST			0x0600
#define INVALID_NF			0xff


// #define AUFRUFE


// Datenstrukturen
/////////////////////////////////////////////////////////////////////


// Interpretation:
// Es werden 4 12er-Ebenen reprsentiert. Die 5. Ebene wird sowieso nicht benutzt.
union tBelegung
{
	UINT64 int64;
	struct
	{
		UINT bits0;
		UINT bits1;
	};
	WORD word_bits[4];
};

struct tBauform
{
	int m_Drehungen;		// aktuelle Anzahl Drehungen
	int m_DrehungenSymmY;	// Drehungen ohne y-Symmetrie
	int m_DrehungenGesamtY;	// Anzahl echt verschiedener Drehungen

	struct tGedreht
	{
		int m_MaxX;			// maximale Verschiebung in dieser Drehung
		int m_MaxY;
		int m_MaxZ;
		tBelegung m_Bits;	// Bit-Reprsentation
	};

	tGedreht m_Gedreht[24];
};

struct tPassendeForm
{
	WORD form;
	tBelegung belegung;
};

struct tPassendeForm4
{
	WORD form;
	UINT belegung;
};

struct tZustand
{
	BYTE m_FreiesFeld_Nachbarn;			// 0..191, siehe Abbildung NachbarFeld
	WORD m_VerbauteFormen;				// 11 Bit
	tBelegung m_Belegung;
};


// globale Daten
/////////////////////////////////////////////////////////////////////


int rot[24][3][3] = {						// Alle orientierungserhaltenden rechtwinkligen 3x3-Drehmatrizen
	{{1, 0, 0}, {0, 1, 0}, {0, 0, 1}},
	{{0, 1, 0}, {-1, 0, 0}, {0, 0, 1}},
	{{-1, 0, 0}, {0, -1, 0}, {0, 0, 1}},
	{{0, -1, 0}, {1, 0, 0}, {0, 0, 1}},

	{{1, 0, 0}, {0, 0, -1}, {0, 1, 0}},
	{{0, 0, 1}, {1, 0, 0}, {0, 1, 0}},
	{{-1, 0, 0}, {0, 0, 1}, {0, 1, 0}},
	{{0, 0, -1}, {-1, 0, 0}, {0, 1, 0}},

	{{0, 1, 0}, {0, 0, 1}, {1, 0, 0}},
	{{0, 0, 1}, {0, -1, 0}, {1, 0, 0}},
	{{0, -1, 0}, {0, 0, -1}, {1, 0, 0}},
	{{0, 0, -1}, {0, 1, 0}, {1, 0, 0}},


	{{-1, 0, 0}, {0, 1, 0}, {0, 0, -1}},
	{{0, -1, 0}, {-1, 0, 0}, {0, 0, -1}},
	{{1, 0, 0}, {0, -1, 0}, {0, 0, -1}},
	{{0, 1, 0}, {1, 0, 0}, {0, 0, -1}},

	{{-1, 0, 0}, {0, 0, -1}, {0, -1, 0}},
	{{0, 0, -1}, {1, 0, 0}, {0, -1, 0}},
	{{1, 0, 0}, {0, 0, 1}, {0, -1, 0}},
	{{0, 0, 1}, {-1, 0, 0}, {0, -1, 0}},

	{{0, -1, 0}, {0, 0, 1}, {-1, 0, 0}},
	{{0, 0, -1}, {0, -1, 0}, {-1, 0, 0}},
	{{0, 1, 0}, {0, 0, -1}, {-1, 0, 0}},
	{{0, 0, 1}, {0, 1, 0}, {-1, 0, 0}},
};


// 30 hoffentlich sinnvoll ausgewhlte Bitkombinationen mit wenigen gesetzten Bit
// Es ist leider berhaupt nicht klar, wie Optimal oder auch nicht diese Auswahl und Reihenfolge ist.
WORD Komprimierung_Invers[30] = {
		0x003, 0x006, 0x600, 0xc00,
		0x009, 0x240, 0x024, 0x900,
		0x018, 0x030, 0x0c0, 0x180,
		0x048, 0x090, 0x120,

		0x001, 0x002, 0x004,
		0x008, 0x010, 0x020,
		0x040, 0x080, 0x100,
		0x200, 0x400, 0x800,

		0x000,
};


WORD bit16[16];
UINT bit32[32];
UINT64 bit64[64];


tBauform Bauform[11];
BYTE NachbarFeld[384];


UINT Loesungen;
UINT Aufrufe;


tPassendeForm* PassendIndex1[192];
UINT PassendCount1[192];
tPassendeForm* PassendIndex3[192];
UINT PassendCount3[192];
tPassendeForm4* PassendIndex4[192];
UINT PassendCount4[192];
tPassendeForm4* PassendIndex5[192];
UINT PassendCount5[192];

int Komprimierung[4096];				// Bit-Komprimierung von 12 auf 6 Bit
BYTE BestesFeld[0x1e000];

tPassendeForm PassendeFormen1[12772];
tPassendeForm PassendeFormen3[10644];
tPassendeForm4 PassendeFormen4[7504];
tPassendeForm4 PassendeFormen5[3204];



// Programm
/////////////////////////////////////////////////////////////////////


#define CALC_INDEX_B \
{ \
	int top6 = Komprimierung[(4095-zustand.m_Belegung.word_bits[0]) & (zustand.m_Belegung.word_bits[1])]; \
	b = BestesFeld[zustand.m_Belegung.word_bits[0] | top6]; \
}

#define CALC_INDEX_B5 \
	b = BestesFeld[zustand.m_Belegung.word_bits[1] + 29*4096];




// Parameter:
// index 0..10
// pos1 .. pos6 sind Koordinaten der Form 111..345
void InitBauform(int index, int pos1, int pos2, int pos3, int pos4, int pos5, int pos6)
{
	tBauform* pB = &Bauform[index];

	int i, j, k;
	int x, y, z;
	int xmax, ymax, zmax, xp, yp, zp;
	int count;
	int pos[6], posX[6], posY[6], posZ[6];
	tBauform::tGedreht* pG;

	count = 4;
	pos[0] = pos1;
	pos[1] = pos2;
	pos[2] = pos3;
	pos[3] = pos4;
	if (pos5 != 0)
	{
		pos[4] = pos5;
		count++;
	}
	if (pos6 != 0)
	{
		pos[5] = pos6;
		count++;
	}
	for (i=0; i<count; i++)
	{
		posX[i] = pos[i] / 100 % 10 - 1;
		posY[i] = pos[i] / 10 % 10 - 1;
		posZ[i] = pos[i] % 10 - 1;
	}

	// Alle Drehungen durchgehen
	pB->m_DrehungenGesamtY = 0;
	pB->m_DrehungenSymmY = 0;
	for (j=0; j<24; j++)
	{
		pG = &pB->m_Gedreht[pB->m_DrehungenGesamtY];

		xmax = 0; ymax = 0; zmax = 0;
		xp = 0; yp = 0; zp = 0;

		// Lage im Raum berechnen
		pG->m_Bits.int64 = 0;

		// minimale Translation berechnen
		for (i=0; i<count; i++)
		{
			// lineare Transformation
			x = rot[j][0][0]*posX[i] + rot[j][0][1]*posY[i] + rot[j][0][2]*posZ[i];
			y = rot[j][1][0]*posX[i] + rot[j][1][1]*posY[i] + rot[j][1][2]*posZ[i];
			z = rot[j][2][0]*posX[i] + rot[j][2][1]*posY[i] + rot[j][2][2]*posZ[i];
			if (-x > xp) xp = -x;
			if (-y > yp) yp = -y;
			if (-z > zp) zp = -z;
		}

		for (i=0; i<count; i++)
		{
			// Affine Transformation
			x = rot[j][0][0]*posX[i] + rot[j][0][1]*posY[i] + rot[j][0][2]*posZ[i] + xp;
			y = rot[j][1][0]*posX[i] + rot[j][1][1]*posY[i] + rot[j][1][2]*posZ[i] + yp;
			z = rot[j][2][0]*posX[i] + rot[j][2][1]*posY[i] + rot[j][2][2]*posZ[i] + zp;

			if (x > xmax) xmax = x;
			if (y > ymax) ymax = y;
			if (z > zmax) zmax = z;

			pG->m_Bits.word_bits[z] |= bit16[x + 3*y];
		}

		// maximale Translation merken
		pG->m_MaxX = 2 - xmax;
		pG->m_MaxY = 3 - ymax;
		pG->m_MaxZ = 4 - zmax;

		if (pG->m_MaxX < 0)
		{
			// Die gedrehte Bauform passt nicht in den Quader
			continue;
		}

		// Bitmuster suchen (Symmterien nutzen)
		for (k=0; k<pB->m_DrehungenGesamtY; k++)
		{
			if (pB->m_Gedreht[k].m_Bits.int64 == pG->m_Bits.int64)
			{
				k = -1;
				break;
			}
		}
		if (k == -1) continue;

		// echt neue Lage gefunden
		pB->m_DrehungenGesamtY++;
		if (j < 12) pB->m_DrehungenSymmY++;
	}
	pB->m_Drehungen = pB->m_DrehungenGesamtY;
}

void InitPassendeFormen()
{
	// PassendIndex*
	// PassendCount*
	// PassendeFormen*

	tPassendeForm* pF1;
	tPassendeForm* pF3;
	tPassendeForm4* pF4;
	tPassendeForm4* pF5;
	int r, b, f, d;
	int dcount, xcount, ycount;
	int x, y, xs, ys;
	int index;
	BYTE byte;
	tBelegung belegung;
	tBauform* pB;
	tBauform::tGedreht* pG;
	UINT belegt32;

	int f2, d2, dcount2;
	tBauform* pB2;
	tBauform::tGedreht* pG2;
	UINT64 belegtefelder;
	UINT64 feldbit;
	WORD belegt16, belegt16_2;

	pF1 = &PassendeFormen1[0];
	pF3 = &PassendeFormen3[0];
	pF4 = &PassendeFormen4[0];
	pF5 = &PassendeFormen5[0];
	for (r=0; r<12; r++)
	{
		feldbit = bit64[r];
		x = r % 3;
		y = r / 3;

		for (b=0; b<32; b++)
		{
			byte = NachbarFeld[(r << 5) + b];
			if (byte == INVALID_NF) continue;

			PassendIndex1[byte] = pF1;
			PassendIndex3[byte] = pF3;
			PassendIndex4[byte] = pF4;
			PassendIndex5[byte] = pF5;
			PassendCount1[byte] = 0;
			PassendCount3[byte] = 0;
			PassendCount4[byte] = 0;
			PassendCount5[byte] = 0;

			if (b == 31) continue;

			belegt32 = 0;

			if (b & 1 && x != 0) belegt32 |= bit32[r-1];
			if (b & 2 && x != 2) belegt32 |= bit32[r+1];
			if (b & 4 && y != 0) belegt32 |= bit32[r-3];
			if (b & 8 && y != 3) belegt32 |= bit32[r+3];
			if (b & 16) belegt32 |= bit32[r+16];

			for (f=0; f<11; f++)
			{
				pB = &Bauform[f];
				dcount = pB->m_Drehungen;
				for (d=0; d<dcount; d++)
				{
					pG = &pB->m_Gedreht[d];
					xcount = pG->m_MaxX;
					ycount = pG->m_MaxY;
					for (ys=0; ys<=ycount; ys++)
					{
						for (xs=0; xs<=xcount; xs++)
						{
							index = xs + 3*ys;
							belegung.int64 = pG->m_Bits.int64 << index;
							if (belegung.int64 & feldbit)
							{
								if ((belegung.bits0 & belegt32) == 0)
								{
									// Stein passt - hinzufgen
									pF1->belegung.int64 = belegung.int64;
									pF1->form = bit16[f];
									PassendCount1[byte]++;
									pF1++;

									if (belegung.bits1 < 65536)
									{
										// Passt fr Rec3
										pF3->belegung.int64 = belegung.int64;
										pF3->form = bit16[f];
										PassendCount3[byte]++;
										pF3++;

										if (belegung.bits1 == 0)
										{
											// Passt fr Rec4
											pF4->belegung = belegung.bits0;
											pF4->form = bit16[f];
											PassendCount4[byte]++;
											pF4++;

											if (belegung.bits0 < 65536)
											{
												// Passt fr Rec5
												pF5->belegung = belegung.bits0 << 16;
												pF5->form = bit16[f];
												PassendCount5[byte]++;
												pF5++;
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}

void InitData()
{
	UINT i;
	int r, r2, f, d, b;
	int count, dcount, xcount, ycount, zcount;
	int x, y;
	int xs, ys, zs;
	int index;
	int val, best;
	int feld;
	UINT64 i64;
	tBauform* pB;
	tBauform::tGedreht* pG;
	UINT nb;
	UINT belegt32;
	UINT64 belegt64;

	// bit
	i = 1;
	for (r=0; r<16; r++)
	{
		bit16[r] = i;
		i *= 2;
	}

	i = 1;
	for (r=0; r<32; r++)
	{
		bit32[r] = i;
		i *= 2;
	}

	i64 = 1;
	for (r=0; r<64; r++)
	{
		bit64[r] = i64;
		i64 *= 2;
	}

	printf("\n- Bauformen...");

	// Bauform
	InitBauform(0, 111, 211, 112, 113, 213, 0);			// c
	InitBauform(1, 311, 112, 212, 312, 313, 0);			// T
	InitBauform(2, 111, 211, 221, 231, 331, 0);			// s
	InitBauform(3, 311, 312, 212, 213, 113, 0);			// w
	InitBauform(4, 211, 112, 212, 213, 313, 0);			// y
	InitBauform(5, 111, 112, 212, 113, 213, 0);			// b
	InitBauform(6, 111, 211, 112, 113, 213, 114);		// 4er t
	InitBauform(7, 111, 112, 113, 114, 213, 0);			// 4er Y
	InitBauform(8, 111, 112, 113, 114, 214, 0);			// 4er L
	InitBauform(9, 111, 112, 212, 122, 222, 0);			// 3D-5er
	InitBauform(10, 211, 212, 222, 122, 0, 0);			// 3D-4er

	printf(" ok\n- passende Formen...");

	// Abbildung Nachbarn/Feld -> 0..191
	index = 0;
	count = 0;
	for (r=0; r<12; r++)
	{
		x = r % 3;
		y = r / 3;
		for (b=0; b<32; b++)
		{
			if (((b & 1) == 0 && (x == 0))
					|| ((b & 2) == 0 && (x == 2))
					|| ((b & 4) == 0 && (y == 0))
					|| ((b & 8) == 0 && (y == 3)))
			{
				NachbarFeld[index] = 255;		// ungltig
			}
			else
			{
				NachbarFeld[index] = count;
				count++;
			}
			index++;
		}
	}

	// Passende Bauformen fr gegebene Feld/Nachbar-Kombination
	InitPassendeFormen();

	printf(" ok\n- bestes Feld...");

	// Komprimierung
	// Diese Schleife initialisiert Komprimierung aufgrund von Komprimierung_Invers.
	int t;
	for (r=0; r<4096; r++)
	{
		for (t=0; t<30; t++)
		{
			if ((r & Komprimierung_Invers[t]) == Komprimierung_Invers[t])
			{
				Komprimierung[r] = (t << 12);
				break;
			}
		}
	}

	UINT feldbit32;
	tPassendeForm* pF;

	// BestesFeld
	for (r=0; r<4096; r++)
	{
		for (t=0; t<30; t++)
		{
			r2 = Komprimierung_Invers[t];
			best = 0;
			for (index=0; index<12; index++)
			{
				feldbit32 = bit32[index];
				if (feldbit32 & r) continue;

				val = 1000;

				nb = 0;
				x = index % 3;
				y = index / 3;
				if (x == 0 || r & bit32[index-1]) nb |= 1;
				if (x == 2 || r & bit32[index+1]) nb |= 2;
				if (y == 0 || r & bit32[index-3]) nb |= 4;
				if (y == 3 || r & bit32[index+3]) nb |= 8;
				if (r2 & bit32[index]) nb |= 16;
				b = NachbarFeld[(index << 5) | nb];
				pF = PassendIndex1[b];
				count = PassendCount1[b];
				for (f=0; f<count; f++)
				{
					if (pF->belegung.bits0 & feldbit32)
					{
						if ((pF->belegung.bits0 & ((r2 << 16) | r)) == 0)
						{
							val--;
						}
					}
					pF++;
				}

				if (val > best)
				{
					best = val;
					feld = b;
				}
			}
			if (best == 1000)
			{
				BestesFeld[(t << 12) | r] = INVALID_NF;
			}
			else
			{
				BestesFeld[(t << 12) | r] = feld;
			}
		}
	}

	printf(" ok\n\n");
}


// Diese Routine fllt die fnfte 12er-Ebene.
void Rec5(tZustand* pZ)
{
#ifdef AUFRUFE
	Aufrufe++;
#endif

	int t, count;
	tZustand zustand;
	tPassendeForm4* pF;
	BYTE b;

	pF = PassendIndex5[pZ->m_FreiesFeld_Nachbarn];
	count = PassendCount5[pZ->m_FreiesFeld_Nachbarn];

	for (t=0; t<count; t++)
	{
		if ((pF->form & pZ->m_VerbauteFormen) == 0)
		{
			// Bauform passt! Einsetzen
			zustand.m_VerbauteFormen = pZ->m_VerbauteFormen + pF->form;
			zustand.m_Belegung.bits0 = pZ->m_Belegung.bits0 | pF->belegung;

			// bestes nchstes Feld suchen
			if (zustand.m_Belegung.word_bits[1] == 0x0fff)
			{
				// Diese Ebene ist voll - Dies ist eine Lsung!
				Loesungen++;
			}
			else
			{
				CALC_INDEX_B5
				if (b != INVALID_NF)
				{
					zustand.m_FreiesFeld_Nachbarn = b;

					// Rekursion
					Rec5(&zustand);
				}
			}
		}

		pF++;
	}
}


// Diese Routine fllt die vierte 12er-Ebene.
// Sie kommt mit 32 Bit zur Darstellung der Felder aus.
void Rec4(tZustand* pZ)
{
#ifdef AUFRUFE
	Aufrufe++;
#endif

	int t, count;
	tZustand zustand;
	tPassendeForm4* pF;
	BYTE b;

	pF = PassendIndex4[pZ->m_FreiesFeld_Nachbarn];
	count = PassendCount4[pZ->m_FreiesFeld_Nachbarn];

	for (t=0; t<count; t++)
	{
		if ((pF->form & pZ->m_VerbauteFormen) == 0)
		{
			if ((pZ->m_Belegung.bits0 & pF->belegung) == 0)
			{
				// Bauform passt! Einsetzen
				zustand.m_VerbauteFormen = pZ->m_VerbauteFormen + pF->form;
				zustand.m_Belegung.bits0 = (pZ->m_Belegung.bits0 | pF->belegung);

				// bestes nchstes Feld suchen
				if (zustand.m_Belegung.word_bits[0] == 0x0fff)
				{
					// Diese Ebene ist voll
					if (zustand.m_Belegung.word_bits[1] == 0x0fff)
					{
						// Diese Ebene ist auch voll
						// Dies ist eine Lsung
						Loesungen++;
					}
					else
					{
						// Ebene 5 beginnen
						if (zustand.m_VerbauteFormen >= DREI_D_TEST)
						{
							CALC_INDEX_B5
							if (b != INVALID_NF)
							{
								zustand.m_FreiesFeld_Nachbarn = b;
								Rec5(&zustand);
							}
						}
					}
				}
				else
				{
					CALC_INDEX_B
					if (b != INVALID_NF)
					{
						zustand.m_FreiesFeld_Nachbarn = b;

						// Rekursion
						Rec4(&zustand);
					}
				}
			}
		}

		pF++;
	}
}


// Diese Routine fllt die dritte 12er-Ebene.
void Rec3(tZustand* pZ)
{
#ifdef AUFRUFE
	Aufrufe++;
#endif

	int t, count;
	tZustand zustand;
	tPassendeForm* pF;
	BYTE b;

	pF = PassendIndex3[pZ->m_FreiesFeld_Nachbarn];
	count = PassendCount3[pZ->m_FreiesFeld_Nachbarn];

	for (t=0; t<count; t++)
	{
		if ((pF->form & pZ->m_VerbauteFormen) == 0)
		{
			if ((pZ->m_Belegung.int64 & pF->belegung.int64) == 0)
			{
				// Bauform passt! Einsetzen
				zustand.m_VerbauteFormen = pZ->m_VerbauteFormen + pF->form;
				zustand.m_Belegung.int64 = (pZ->m_Belegung.int64 | pF->belegung.int64);

				// bestes nchstes Feld suchen
				if (zustand.m_Belegung.word_bits[0] == 0x0fff)
				{
					// Diese Ebene ist voll
					if (zustand.m_Belegung.word_bits[1] == 0x0fff)
					{
						// Diese Ebene ist auch voll
						if (zustand.m_Belegung.word_bits[2] == 0x0fff)
						{
							// Dies ist eine Lsung
							Loesungen++;
						}
						else
						{
							// Ebene 5 beginnen
							if (zustand.m_VerbauteFormen >= DREI_D_TEST)
							{
								zustand.m_Belegung.bits0 = (zustand.m_Belegung.bits1 << 16) | 0x0fff;
								CALC_INDEX_B5
								if (b != INVALID_NF)
								{
									zustand.m_FreiesFeld_Nachbarn = b;

									Rec5(&zustand);
								}
							}
						}
					}
					else
					{
						// Ebene 4 beginnen
						zustand.m_Belegung.bits0 = (UINT)(zustand.m_Belegung.int64 >> 16);
						CALC_INDEX_B
						if (b != INVALID_NF)
						{
							zustand.m_FreiesFeld_Nachbarn = b;

							Rec4(&zustand);
						}
					}
				}
				else
				{
					CALC_INDEX_B
					if (b != INVALID_NF)
					{
						zustand.m_FreiesFeld_Nachbarn = b;

						// Rekursion
						Rec3(&zustand);
					}
				}
			}
		}

		pF++;
	}
}


// Diese Routine fllt die zweite 12er-Ebene.
void Rec2(tZustand* pZ)
{
#ifdef AUFRUFE
	Aufrufe++;
#endif

	int t, count;
	tZustand zustand;
	tPassendeForm* pF;
	BYTE b;

	pF = PassendIndex1[pZ->m_FreiesFeld_Nachbarn];
	count = PassendCount1[pZ->m_FreiesFeld_Nachbarn];

	for (t=0; t<count; t++)
	{
		if ((pF->form & pZ->m_VerbauteFormen) == 0)
		{
			if ((pZ->m_Belegung.int64 & pF->belegung.int64) == 0)
			{
				// Bauform passt! Einsetzen
				zustand.m_VerbauteFormen = pZ->m_VerbauteFormen + pF->form;
				zustand.m_Belegung.int64 = (pZ->m_Belegung.int64 | pF->belegung.int64);

				// bestes nchstes Feld suchen
				if (zustand.m_Belegung.word_bits[0] == 0x0fff)
				{
					// Ebene 2 ist voll
					if (zustand.m_Belegung.word_bits[1] == 0x0fff)
					{
						// Diese Ebene ist auch voll
						if (zustand.m_Belegung.word_bits[2] == 0x0fff)
						{
							if (zustand.m_Belegung.word_bits[3] == 0x0fff)
							{
								// Dies ist eine Lsung
								Loesungen++;
							}
							else
							{
								// Ebene 5 beginnen
								if (zustand.m_VerbauteFormen >= DREI_D_TEST)
								{
									zustand.m_Belegung.bits0 = zustand.m_Belegung.bits1;
									CALC_INDEX_B5
									if (b != INVALID_NF)
									{
										zustand.m_FreiesFeld_Nachbarn = b;

										Rec5(&zustand);
									}
								}
							}
						}
						else
						{
							// Ebene 4 beginnen
							zustand.m_Belegung.bits0 = zustand.m_Belegung.bits1;

							CALC_INDEX_B
							if (b != INVALID_NF)
							{
								zustand.m_FreiesFeld_Nachbarn = b;

								Rec4(&zustand);
							}
						}
					}
					else
					{
						// Ebene 3 beginnen
						zustand.m_Belegung.int64 >>= 16;
						CALC_INDEX_B
						if (b != INVALID_NF)
						{
							zustand.m_FreiesFeld_Nachbarn = b;

							Rec3(&zustand);
						}
					}
				}
				else
				{
					CALC_INDEX_B
					if (b != INVALID_NF)
					{
						zustand.m_FreiesFeld_Nachbarn = b;

						// Rekursion
						Rec2(&zustand);
					}
				}
			}
		}

		pF++;
	}
}


// Diese Routine fllt die erste 12er-Ebene.
void Rec1(tZustand* pZ)
{
#ifdef AUFRUFE
	Aufrufe++;
#endif

	int t, count;
	tZustand zustand;
	tPassendeForm* pF;
	BYTE b;

	pF = PassendIndex1[pZ->m_FreiesFeld_Nachbarn];
	count = PassendCount1[pZ->m_FreiesFeld_Nachbarn];

	for (t=0; t<count; t++)
	{
		if ((pF->form & pZ->m_VerbauteFormen) == 0)
		{
			if ((pZ->m_Belegung.int64 & pF->belegung.int64) == 0)
			{
				// Bauform passt! Einsetzen
				zustand.m_VerbauteFormen = pZ->m_VerbauteFormen + pF->form;
				zustand.m_Belegung.int64 = (pZ->m_Belegung.int64 | pF->belegung.int64);

				// bestes nchstes Feld suchen
				if (zustand.m_Belegung.word_bits[0] == 0x0fff)
				{
					// Ebene 1 ist voll

					if (zustand.m_Belegung.word_bits[1] == 0x0fff)
					{
						// Ebene 2 ist auch voll
						if (zustand.m_Belegung.word_bits[2] == 0x0fff)
						{
							if (zustand.m_Belegung.word_bits[3] == 0x0fff)
							{
								// Ebene 5 beginnen
								if (zustand.m_VerbauteFormen >= DREI_D_TEST)
								{
									zustand.m_Belegung.bits0 = 0x00000fff;
									zustand.m_FreiesFeld_Nachbarn = NachbarFeld[21];
									// toter Code, aber egal

									Rec5(&zustand);
								}
							}
							else
							{
								// Ebene 4 beginnen
								zustand.m_Belegung.bits0 = zustand.m_Belegung.word_bits[3];
								CALC_INDEX_B
								if (b != INVALID_NF)
								{
									zustand.m_FreiesFeld_Nachbarn = b;

									Rec4(&zustand);
								}
							}
						}
						else
						{
							// Ebene 3 beginnen
							zustand.m_Belegung.int64 >>= 32;
							CALC_INDEX_B
							if (b != INVALID_NF)
							{
								zustand.m_FreiesFeld_Nachbarn = b;

								Rec3(&zustand);
							}
						}
					}
					else
					{
						// Ebene 2 beginnen
						zustand.m_Belegung.int64 >>= 16;
						CALC_INDEX_B
						if (b != INVALID_NF)
						{
							zustand.m_FreiesFeld_Nachbarn = b;

							Rec2(&zustand);
						}
					}
				}
				else
				{
					CALC_INDEX_B
					if (b != INVALID_NF)
					{
						zustand.m_FreiesFeld_Nachbarn = b;

						// Rekursion
						Rec1(&zustand);
					}
				}
			}
		}

		pF++;
	}
}


// Diese Routine platziert den X-Bauklotz in seine 12 Positionen.
void solve()
{
	tZustand zustand;
	zustand.m_VerbauteFormen = 0;

	printf("x");
	zustand.m_Belegung.word_bits[0] = 0x00ba;
	zustand.m_Belegung.word_bits[1] = 0;
	zustand.m_Belegung.word_bits[2] = 0;
	zustand.m_Belegung.word_bits[3] = 0;
	zustand.m_FreiesFeld_Nachbarn = NachbarFeld[0*32 + 15];
	Rec1(&zustand);

	printf("x");
	zustand.m_Belegung.word_bits[0] = 0;
	zustand.m_Belegung.word_bits[1] = 0x00ba;
	zustand.m_Belegung.word_bits[2] = 0;
	zustand.m_Belegung.word_bits[3] = 0;
	zustand.m_FreiesFeld_Nachbarn = NachbarFeld[4*32 + 16];
	Rec1(&zustand);

	printf("x");
	zustand.m_Belegung.word_bits[0] = 0x0002;
	zustand.m_Belegung.word_bits[1] = 0x0007;
	zustand.m_Belegung.word_bits[2] = 0x0002;
	zustand.m_Belegung.word_bits[3] = 0;
	zustand.m_FreiesFeld_Nachbarn = NachbarFeld[0*32 + 23];
	Rec1(&zustand);

	printf("x");
	zustand.m_Belegung.word_bits[0] = 0x0010;
	zustand.m_Belegung.word_bits[1] = 0x0038;
	zustand.m_Belegung.word_bits[2] = 0x0010;
	zustand.m_Belegung.word_bits[3] = 0;
	zustand.m_FreiesFeld_Nachbarn = NachbarFeld[3*32 + 19];
	Rec1(&zustand);

	printf("x");
	zustand.m_Belegung.word_bits[0] = 0x0008;
	zustand.m_Belegung.word_bits[1] = 0x0049;
	zustand.m_Belegung.word_bits[2] = 0x0008;
	zustand.m_Belegung.word_bits[3] = 0;
	zustand.m_FreiesFeld_Nachbarn = NachbarFeld[0*32 + 29];
	Rec1(&zustand);

	printf("x");
	zustand.m_Belegung.word_bits[0] = 0x0040;
	zustand.m_Belegung.word_bits[1] = 0x0248;
	zustand.m_Belegung.word_bits[2] = 0x0040;
	zustand.m_Belegung.word_bits[3] = 0;
	zustand.m_FreiesFeld_Nachbarn = NachbarFeld[9*32 + 29];
	Rec1(&zustand);

	printf("x");
	zustand.m_Belegung.word_bits[0] = 0;
	zustand.m_Belegung.word_bits[1] = 0x0008;
	zustand.m_Belegung.word_bits[2] = 0x0049;
	zustand.m_Belegung.word_bits[3] = 0x0008;
	zustand.m_FreiesFeld_Nachbarn = NachbarFeld[0*32 + 5];
	Rec1(&zustand);

	printf("x");
	zustand.m_Belegung.word_bits[0] = 0x0010;
	zustand.m_Belegung.word_bits[1] = 0x0092;
	zustand.m_Belegung.word_bits[2] = 0x0010;
	zustand.m_Belegung.word_bits[3] = 0;
	zustand.m_FreiesFeld_Nachbarn = NachbarFeld[1*32 + 28];
	Rec1(&zustand);


	// bezglich Y-Drehung symmetrische Positionen:
	// zustzliche Symmetrie bercksichtigen!
	printf("\nNeuinitialisierung einiger Tabellen...");
	Bauform[9].m_Drehungen = Bauform[9].m_DrehungenSymmY;
	InitPassendeFormen();
	printf(" ok\n");

	printf("x");
	zustand.m_Belegung.word_bits[0] = 0;
	zustand.m_Belegung.word_bits[1] = 0;
	zustand.m_Belegung.word_bits[2] = 0x00ba;
	zustand.m_Belegung.word_bits[3] = 0;
	zustand.m_FreiesFeld_Nachbarn = NachbarFeld[0*32 + 5];
	Rec1(&zustand);

	printf("x");
	zustand.m_Belegung.word_bits[0] = 0;
	zustand.m_Belegung.word_bits[1] = 0x0002;
	zustand.m_Belegung.word_bits[2] = 0x0007;
	zustand.m_Belegung.word_bits[3] = 0x0002;
	zustand.m_FreiesFeld_Nachbarn = NachbarFeld[0*32 + 5];
	Rec1(&zustand);

	printf("x");
	zustand.m_Belegung.word_bits[0] = 0;
	zustand.m_Belegung.word_bits[1] = 0x0010;
	zustand.m_Belegung.word_bits[2] = 0x0038;
	zustand.m_Belegung.word_bits[3] = 0x0010;
	zustand.m_FreiesFeld_Nachbarn = NachbarFeld[3*32 + 1];
	Rec1(&zustand);

	printf("x");
	zustand.m_Belegung.word_bits[0] = 0;
	zustand.m_Belegung.word_bits[1] = 0x0010;
	zustand.m_Belegung.word_bits[2] = 0x0092;
	zustand.m_Belegung.word_bits[3] = 0x0010;
	zustand.m_FreiesFeld_Nachbarn = NachbarFeld[4*32 + 16];
	Rec1(&zustand);
}


int main(int argc, char* argv[])
{
	printf("c't-Puzzle loesen\n\n");

	time_t zeit_anfang;
	time_t zeit_ende;
	time(&zeit_anfang);

	printf("Initialisierung");
	InitData();

	Aufrufe = 0;
	Loesungen = 0;

	printf("Berechnung\n");
	solve();
	time(&zeit_ende);

	int time_used = (int)difftime(zeit_ende, zeit_anfang);
	int sekunden = time_used % 60;
	int minuten = time_used / 60;

	printf("\n\nZeit:      %02d:%02d\nLoesungen: %d\n", minuten, sekunden, Loesungen);
#ifdef AUFRUFE
	printf("Aufrufe:   %d\n", Aufrufe);
#endif

	return 0;
}
