program EPROM_Simulator_Treiber;

(* 110691 Tilmann Reh. Genderte Write-Routine von C.Meyer     *)

(* Programm zum Ansteuern des EPROM-Simulators REH-ESIM 08/16. *)
(* Geschrieben fr Turbo-Pascal 5.5 (prinzipiell ab V4.0).     *)

(* Binrdateien und Intel-HEX knnen bearbeitet werden.        *)
(* Unterscheidung anhand des Dateityps (.HEX); ist kein Typ    *)
(* angegeben, so wird .HEX angenommen.                         *)

(* Der Datenpuffer von 64k kann leider nicht sauber deklariert *)
(* werden, da Turbo-Pascal Variablengren intern als Word-    *)
(* Variablen handhabt. Deswegen wird ein um genau 1 Byte zu    *)
(* kleines Array deklariert und spter 'berfahren'. Dies ist  *)
(* mglich, da es a) die letzte bzw. einzige Variable auf dem  *)
(* Heap ist und b) der Heap segmentweise verwaltet wird.       *)

{$R-} (* Array-Bereichs-Check ausschalten! *)

uses  dos;

const signon = ^m^j'ESIM 08/16 Driver V1.1 on LPT1'^m^j;

      OutPort = $378;
      InPort  = $379;
      StPort  = $37A;

type  simbuftyp     = array[0..65534] of byte;

var   filnam,filext : string;
      simbuf        : ^simbuftyp;
      laenge        : longint;


(* Untersuchen eines Dateinamens auf Angabe einer Extension,   *)
(* gefundene Extension wird (Upcase) in FILEXT gespeichert.    *)

function extension(s:string):boolean;
var i,j : integer;
begin
  extension:=false;
  filext:='';
  for i:=length(s) downto 2 do begin
    if s[i]='\' then exit;
    if s[i]='.' then begin
      extension:=true;
      filext:=copy(s,succ(i),255);
      for j:=1 to length(filext) do
        filext[j]:=upcase(filext[j]);
      exit;
      end;
    end;
  end;


(* Binrdatei ffnen und in Puffer SIMBUF lesen.               *)
(* Lesen in zwei Abschnitten, da sonst nur max. 65535 Byte     *)
(* gelesen werden knnen (Lngenangabe durch WORD).            *)

procedure getbinfile;
var binfil : file;
    n      : word;
begin
  assign(binfil,filnam);
  {$I-} reset(binfil,1); {$I+}
  if ioresult<>0 then begin
    writeln('Fehler beim ffnen von ',filnam);
    halt;
    end;
  blockread(binfil,simbuf^[0],32768,n);
  laenge:=n;
  if n=32768 then begin
    blockread(binfil,simbuf^[32768],32768,n);
    inc(laenge,n);
    end;
  close(binfil);
  end;


(* HEX-Datei ffnen und in Puffer SIMBUF lesen. Untersttzt    *)
(* werden nur unsegmentierte Dateien.                          *)

procedure gethexfile;
var hexfil          : text;
    s               : string;
    anz,typ,chk,i,n : byte;
    zeile,adr       : word;
    ende            : boolean;

  function gethex(ziffern:byte):word;
  var st  : string;
      x,y : word;
  begin
    st:='$'+copy(s,n,ziffern);
    val(st,x,y);
    if y<>0 then writeln(zeile,': Fehler in HEX-Daten!');
    inc(n,ziffern);
    chk:=chk+lo(x)+hi(x);
    gethex:=x;
    end;

begin
  assign(hexfil,filnam);
  {$I-} reset(hexfil); {$I+}
  if ioresult<>0 then begin
    writeln('Fehler beim ffnen von ',filnam);
    halt;
    end;
  ende:=false;
  zeile:=0;
  laenge:=0;
  while not ende do begin
    if eof(hexfil) then begin
      writeln('Fehler: kein EOF-Record!');
      close(hexfil);
      exit;
      end;
    readln(hexfil,s);
    inc(zeile);
    if s[1]=':' then begin
      n:=2; chk:=0;
      anz:=gethex(2);
      adr:=gethex(4);
      typ:=gethex(2);
      case typ of
        0   : begin
                for i:=1 to anz do begin
                  simbuf^[adr]:=gethex(2);
                  inc(adr);
                  end;
                if adr>laenge then laenge:=adr;
                end;
        1   : ende:=true;
        2,3 : writeln(zeile,': Fehler - Segmentierte Datei!');
        else  writeln(zeile,': Fehler - unbekannter Datentyp!');
        end;
      i:=gethex(2);
      if chk<>0 then writeln(zeile,': Fehler - Checksumme!');
      end;
    end;
  close(hexfil);
  end;


(* Puffer SIMBUF zum Simulator senden. - C.Meyer 9/93          *)
(* Aus Geschwindigkeitsgrnden keine Fehlerberprfung bei     *)
(* bertragung. Wer will, kann leicht weitere Abfrage einfgen.*)

procedure write_esim;
var  n,m,i : word;
begin

  m:=port[StPort];
  for n:=0 to pred(laenge) do
  begin
    port[OutPort]:=simbuf^[n];
    port[StPort]:=m+1;
    port[StPort]:=m;
    end;
end;


(*---------------------------- MAIN ---------------------------*)

begin
  writeln(signon);
  new(simbuf);
  simbuf^[0]:=$FF;
  fillchar(simbuf^[1],65535,$FF);

  if paramcount>0 then filnam:=paramstr(1) else begin
    write('Dateiname: ');
    readln(filnam);
    if filnam='' then halt;
    end;

  if extension(filnam) then
    if filext='HEX' then gethexfile
    else getbinfile
  else begin filnam:=filnam+'.HEX'; gethexfile; end;

  write_esim;
  writeln(filnam,' zum Simulator bertragen.');
  writeln('Lnge ',laenge,' Bytes.');
  end.
