echo off
echo The following demonstration will compare the abilities of 24- bit
echo data over 16-bit data.  Even if the input data to a system is limited
echo by a 16-bit data converter, the system can still benefit greatly from
echo a 24-bit architecture.  The demo takes an input from the "in" connector,
echo digitizes that input signal, and adds a 60 Hz tone that simulates
echo a noise that originates from a 60 Hz AC power line.  The signal
echo then goes through a filter with one of three sets of coefficients.  
pause 
echo -
echo The first set of coefficients performs no filtering at all, simply 
echo allowing the corrupted signal to pass.  This first set of coefficients 
echo is used by the filter when the demo first begins or following the
echo Non-Maskable Interrupt (NMI).  To trigger this interrupt, connect
echo ground to connector J17 pin 1 (the pin closest to the J17 silkscreen
echo label on the board.)
echo -
echo The second set of coefficients are 24-bit coefficients that make 
echo up a 60 Hz notch filter which removes the 60 Hz portion of the 
echo corrupted signal.  This second set of coefficients is used 
echo following the external interrupt A (IRQA).  To trigger this interrupt,
echo connect ground to connector J17 pin 3 (the pin furthest from the J17
echo label.)  
echo -
echo The final set of coefficients (located at y:coeff_16) consists of 
echo the same coefficients as those for the 24-bit filter, only rounded to 
echo 16 bits.  These 16-bit coefficients are used by the filter following 
echo the external interrupt B (IRQB).  To trigger this interrupt, connect
echo ground to connector J17 pin 2 (the middle pin of the connector.)
echo -
pause 
asm56000 -a -b -l 60hzdemo.asm
evm56k 60hzdemo.cmd



