	page    132,60
;****************************************************************************
;	ECHO.ASM    Rev.1.2
;	Example program to move audio through CS4215
;               This program uses 4k samples of delay
;               to add a noticeable echo to the audio.
;
;	Copyright (c) MOTOROLA 1995
;		      Semiconductor Products Sector 
;		      Digital Signal Processing Division
; 
;******************************************************************************
START   equ     $40

	org     p:0                     ;RESET Vector
	jmp     START
 
	org     p:$000C
	jsr     ssi_rx_isr              ;SSI RX
	jsr     ssi_rx_isr              ;SSI RX w/Exception
	jsr     ssi_tx_isr              ;SSI TX
	jsr     ssi_tx_isr              ;SSI TX w/Exception
;******************************************************************************

;---------------------------------------------------------------------------
;
;      DSP/codec initialization
;
;---------------------------------------------------------------------------
	org     p:START

	movep   #$261009,x:PLL          ;set PLL for MPY of 10x
	movep   #$0000,x:BCR            ;zero wait states in all ext. memory
	ori     #3,mr                   ;disable interrupts
	movec   #0,sp                   ;clear hardware stack pointer
	move    #0,omr                  ;mode 0: enable int. P:RAM, rst=0000
	move    #$40,r6                 ; initialize stack pointer
	move    #-1,m6                  ; linear addressing

	include 'ada_init.asm'


;******************************************************************************
; the following two EQUates will define the operatonal parameters
;   of the codec.  Please refer to the ADA_INIT.ASM source file
;   for a description of the parameters selections available.  The
;   variables defined by the EQUates are sent to the  codec via 
;   the transmit buffer, TX_BUFF.
;
;   Since the parameters are defined in ADA_INIT.ASM, these line must
;   follow the include statement.
;******************************************************************************

TONE_OUTPUT     EQU     HEADPHONE_EN+LINEOUT_EN+(4*LEFT_ATTN)+(4*RIGHT_ATTN)   
TONE_INPUT      EQU     MIC_IN_SELECT+(15*MONITOR_ATTN)


        move    #$4000,r4
        move    #$3FFF,m4
loop_1
	jset    #2,x:SSISR,*            ; Wait for frame sync to pass.
	jclr    #2,x:SSISR,*            ; Wait for frame sync.
	        
        move    x:RX_BUFF_BASE,a        ;get new samples
        move    x:RX_BUFF_BASE+1,b
        asr     a       x:(r4),x0       ;divide them by 2 and get oldest
        asr     b       y:(r4),y0       ;   samples from buffer
        add     x0,a                    ;add the new samples and the old
        add     y0,b
        asr     a                       ;reduce magnitude of new data
        asr     b
        move    a,x:(r4)                ;save the altered samples
        move    b,y:(r4)+               ;   and bump the pointer

	move    a,x:TX_BUFF_BASE        ; Put value in left channel tx.
	move    b,x:TX_BUFF_BASE+1      ; Put value in right channel tx.  
	move    #TONE_OUTPUT,y0         ; headphones, line out, mute spkr, no attn.
	move            y0,x:TX_BUFF_BASE+2
	move    #TONE_INPUT,y0          ; no input gain, monitor mute
	move            y0,x:TX_BUFF_BASE+3
	jmp     loop_1                  ; Loop back.

;----- the following line adds the interrupt service routines to the program
        include 'txrx_isr.asm'

    end
