.equ    P_INT   =PortB
.equ    P_BUSY  =PortB

.equ    P_I2CC  =PortD
.equ    P_I2CD  =PortD
.equ    P_CLR   =PortD
.equ    P_BUS   =PortC

.equ    PIN_DREH=PINB
.equ    PIN_DEM =PIND
.equ    PIN_STR =PIND
.equ    PIN_CTRL=PIND
.equ    PIN_I2CD=PIND
.equ    PIN_BUS =PINC

.equ    DDR_I2CC=DDRD
.equ    DDR_I2CD=DDRD
.equ    DDR_BUS =DDRC



.equ    LCD_RW  =PD6                    ;Bit 6 in Port D
.equ    LCD_ADR =PD7                    ;Bit 6 in Port D
.equ    KONTR   =PD5                    ;Bit 5 in Port D
.equ    I2CC    =PD4                    ;Bit 4 in Port D
.equ    STROBE  =PD3                    ;Bit 3 in Port D
.equ    DEMAND  =PD2                    ;Bit 2 in Port D
.equ    I2CD    =PD1                    ;Bit 1 in Port D
.equ    CLR     =PD0                    ;Bit 0 in Port D

.equ    SCLK    =PB7                    ;Bit 7 in Port B
.equ    SREAD   =PB6                    ;Bit 6 in Port B
.equ    SDATA   =PB5                    ;Bit 5 in Port B
.equ    CTRL2   =PD5                    ;Bit 3 in Port B
.equ    CTRL1   =PD7                    ;Bit 1 in Port B
.equ    CTRL0   =PD6                    ;Bit 0 in Port B

.equ    LCD_SEL =PB3                    ;Bit 7 in Port A
.equ    BUSY    =PB4                    ;Bit 4 in Port A
.equ    INT     =PB2                    ;Bit 2 in Port A
.equ    DREH0   =PB0                    ;Bit 1 in Port A
.equ    DREH1   =PB1                    ;Bit 0 in Port A


.equ    VERSION =$10



;*********************************************************************
;  Interruptroutine  Get Data and Control
;*********************************************************************
Get_INT_Param:  in      PData,PINC               ; Daten sichern
                in      PCtrl,PIND               ; Ctrl-Informationen sichern
                clt
                sbic    PINB,SREAD
                set
                bld     PCtrl,CTRL2
                andi    PCtrl,(1<<CTRL0)+(1<<CTRL1)+(1<<CTRL2)
                ret


Set_Data:       out     PortC,PData              ; Daten ausgeben
                ret

Output:         ret

Input:          ret



;*********************************************************************
;  Display-Routinen
;*********************************************************************

WriteLCDinit:   cbi     PortD,LCD_ADR
                rjmp    WriteLCD
WriteLCD0:      rcall   BusyCheck
                cbi     PortD,LCD_ADR
                rjmp    WriteLCD
WriteLCD1:      rcall   BusyCheck
                sbi     PortD,LCD_ADR
                rjmp    WriteLCD
WriteLCD:       sbi     DDRD,LCD_ADR
                sbi     DDRD,LCD_RW
                cbi     PortD,LCD_RW
                out     PortC,Temp
                ldi     Temp,$0ff
                out     DDRC,Temp
                sbi     PortB,LCD_SEL
                nop
                nop
                nop
                nop
                cbi     PortB,LCD_SEL
                ldi     Temp,$000
                out     PortC,Temp
                out     DDRC,Temp
                cbi     PortD,LCD_ADR
                cbi     DDRD,LCD_ADR
                cbi     DDRD,LCD_RW
                ret


ReadLCD0:       cbi     PortD,LCD_ADR
                rjmp    ReadLCD
ReadLCD1:       sbi     PortD,LCD_ADR
                rjmp    ReadLCD
ReadLCD:        sbi     DDRD,LCD_ADR
                sbi     DDRD,LCD_RW
                sbi     PortD,LCD_RW
                sbi     PortB,LCD_SEL            ; Display Strobe high
                nop
                nop
                nop
                nop
                in      Temp,PINC
                cbi     PortB,LCD_SEL            ; Display Strobe high
                cbi     DDRD,LCD_ADR
                cbi     DDRD,LCD_RW
                ret


BusyCheck:      sbi     DDRD,LCD_ADR
                sbi     DDRD,LCD_RW
                cbi     PortD,LCD_ADR
                sbi     PortD,LCD_RW
                push    Temp
                ldi     Temp,144           ; 5 ms Timeout
                neg     Temp
                out     TCNT0,Temp
                ldi     Temp,(1<<TOV0)
                out     TIFR,Temp
WaitCheck:      in      Temp,TIFR
                sbrc    Temp,TOV0
                rjmp    GoCheck
                cbi     PortB,LCD_SEL
                sbi     PortB,LCD_SEL
                nop
                nop
                nop
                nop
                sbic    PINC,7
                rjmp    WaitCheck
GoCheck:        cbi     PortB,LCD_SEL
                cbi     PortD,LCD_RW
                cbi     PortD,LCD_ADR
                cbi     DDRD,LCD_ADR
                cbi     DDRD,LCD_RW
                pop     Temp
                ret



;*********************************************************************
;  TastenPort lesen
;*********************************************************************
Tasten_Input:   in      TOVTemp,PINA
                com     TOVTemp
                ret
Dreh_Input:     in      TOVTemp,PIN_DREH
                swap    TOVTemp
                bst     TOVTemp,DREH0+4
                bld     TOVTemp,SDREH1
                bst     TOVTemp,DREH1+4
                bld     TOVTemp,SDREH0
                andi    TOVTemp,(1<<SDREH0) + (1<<SDREH1)
                ret



;*********************************************************************
;  Port-Initialisierung
;*********************************************************************
Port_Setting:
; Port D Setting
                ldi     Temp,(1<<DEMAND)+(1<<I2CC)+(1<<I2CD)   ; /CLR low ( MAS-Reset )
                out     PortD,Temp
                ldi     Temp,(1<<CLR)+(1<<I2CC)+(1<<KONTR); /CLR , I2CC , KONTR sind Ausgnge
                out     DDRD,Temp
                cbi     PortD,INT                ; INT loeschen

; Port C Setting
                ldi     Temp,$000                ; Pull-Up's aus
                out     PortC,Temp
                ldi     Temp,$000                ; Port C ist Eingang
                out     DDRC,Temp

; Port B Setting
                ldi     Temp,(1<<DREH0)+(1<<DREH1)                   +(1<<SCLK)
                out     PortB,Temp
                ldi     Temp,                      (1<<INT)+(1<<BUSY)+(1<<SCLK)+(1<<SDATA)+(1<<LCD_SEL)
                out     DDRB,Temp                ; Light und Busy sind Ausgang

; Port A Setting
                ldi     Temp,$0FF                ; Pull-Up's an
                out     PortA,Temp
                ldi     Temp,$000                ; alles Eingnge (Tasten/Drehknopf)
                out     DDRA,Temp


                ldi     Temp,(1<<COM1A1)+(1<<COM1B1)+(1<<PWM11)
                out     TCCR1A,Temp









