/* Main Routines for the CT-Player-Project,version 1.0.

	Copyright (C) 1999 Marcus Schwatke, Andreas Kemper

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2, or (at your option)
	any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <time.h>
#include <malloc.h>
#include <math.h>
#include <dirent.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <time.h>

#include "regio.h"
#include "events.h"
#include "masisr.h"
#include "mpfio.h"
#include "parms.h"
#include "fileio.h"
#include "display.h"
#include "atmelini.h"

/* Default-Optionen */
int lcdemu     = FALSE; 			/* IO via Keyboard/Screen */
int lcdLineCnt = 4; 					/* Default 4 Zeilen */
int lcdColCnt  = 16; 				/* Default 16 Spalten */
int lptMode    = PMODE_UNIDIR;	/* LPT default-mode (Unidirektional) */
int lptBase    = 0x378; 			/* LPT1 default-adresse */
int lptIrq     = 0x7;				/* LPT1 default-irq */
int BufferLimit	= 4096;			/* Minimaler Pufferfuellstand in Bytes */
int BurstLength	= 2048;        /* Gelesene Bytes waehrend eines Bursts */
char*mapfname  = "mapper.txt"; 	/* Default Mapper-Filename */

/* Dateinamenliste */
extern FileEntry *fileList;
extern int fileListSize;
extern int fileListCur;

/* LPT-Einstellungen */
extern MASLPTPARAMS lptP;

/* MP3-Dateieinstellungen */
extern MP3FILEPARAMS mpfP;

/* aktueller Dateiname */
static char *curFileName;

/* Aktuelle LCD-Zeile */
static char lcdLine[20];

/* Ausgabe der Startoptionen	*/
void PrintArgs(void)
{
	printf("------LPT-MP3-Demo-Player------\n");
	printf("Copyright 1999, MP3-Team\n");
	printf("-------------------------------\n");
	printf("Optionen:\n");
	printf("-h     : Hilfe anzeigen\n");
	printf("-pNNN  : LPT-Adresse (default=378)\n");
	printf("-iNN   : LPT-Adresse (default=7)\n");
	printf("-b     : LPT ist Bidirektional (default=Unidirektional)\n");
	printf("-zZ    : Anzahl der LCD-Zeilen {2|4} (default=4)\n");
	printf("-e     : Zusaetzliche Bildschirmausgabe und Eingabe ");
				printf("ueber Tasten (default=aus)\n");
	printf("-fName : Dateiname fuer Mapper-Datei (default=mapper.txt)\n");
	printf("-lNNNN : Fuellstandslimit fuer internen MP3-Datenpuffer ");
				printf("(default=4096 Bytes)\n");
	printf("-rNNNN : Burstlaenge beim Nachladen (default=2048 Bytes)\n");
	printf("-kNN   : EEPROM Initialisierung mit LCD-Kontrastwert (default=20)\n");
}

/* Initialisierung der parallelen Schnittstelle */
void LptInit(void)
{
	/* Initialisierung der Schnittstellenadresse */
	lptP.lptAdr   = lptBase;
	lptP.lptStat  = lptBase+1;
	lptP.lptCtrl  = lptBase+2;
	lptP.lptIrq   = lptIrq;
	lptP.lptUnidir = PMODE_UNIDIR;

	/* Grundinitialisierung Parallelport */
	outp(lptP.lptCtrl, 0x1a);
}

/* Initialisierung aller IO */
void Init(void)
{
	/* Initialisierung der parallelen Schnittstelle */
	LptInit();

	/* Initialisierung der Pufferparameter */
	mpfP.buffer_limit = BufferLimit;
	mpfP.burst_length = BurstLength;

	Evnt_Init();             	/* Initialisierung der Ereigniskarte */
	Evnt_Load(mapfname);     	/* Lade der Ereigniskarte */
	MPFile_Init();           	/* Initialisierung der MP3-Datei IO */

	Reg_Write(ATMEL_CMD, 0x04);	/* Atmel initialisieren */
	Reg_Write(ATMEL_CMD, 0x09);	/* Licht an */

	Displ_Init(); 					/* Display initialisieren*/
}

/* Anzeige des Mens "Laufwerksauswahl" und Verarbeitung von Benutzereingaben */
int DriveSelector(void)
{
	char sPath[] = "C:\\";

	DumpDrives(0, lcdLineCnt); /* Ausgabe der Laufwerke */

	do /* Pruefe Verzeichnisse des jew. LWs bis Gueltiges gefunden ist */
	{
		while(Displ_Dequeue()!= FAIL); 	/* Displayqueue leeren */

		switch(Evnt_Check()) 				/* Warten auf Ereignis */
		{
			case EVNTID_CURSORUP:
				DumpDrives(-1, lcdLineCnt);  /* Ausgabe der Laufwerke */
			break;
			case EVNTID_CURSORDWN:
				DumpDrives( 1, lcdLineCnt);  /* Ausgabe der Laufwerke */
			break;
			case EVNTID_OK:
				/* Playlist von aktuellem Laufwerk aufbauen */
				ClearFileList(); /* Dateiliste freigeben */

				sPath[0] = GetCurLetter();
				if(GetFileList(sPath) > 0)
				{
					/* Dateinamen in Liste ordnen */
					GenerateDirEntries();
					/* "MP3" Laufwerkskennung ausgeben */
					SetCurDriveType(FILETYPE_MP3DISK);
					return TRUE;
				}
				else
				{
					/* Falls keine Dateien gefunden werden "NOMP3" ausgeben */
					SetCurDriveType(FILETYPE_NOMP3DISK);
					/* Ausgabe der Laufwerke */
					DumpDrives(0, lcdLineCnt);
				}
			break;
			case EVNTID_TOGGLE:				/* Datei markieren und Liste neu ausg. */
				ToggleTagFlag();
				DumpDrives(0, lcdLineCnt);
			break;
		}
	} while(1);
}

/* Anzeige des Mens "Dateien" und Verarbeitung von Benutzereingaben */
int FileSelector(void)
{
	DumpFiles(0, lcdLineCnt); /* Ausgabe der MP3-Files */

	do /* Pruefe/Markiere die einzelnen Dateien */
	{
		while(Displ_Dequeue()!= FAIL); 	/* Displayqueue leeren */
		switch(Evnt_Check()) 				/* Warten auf Ereignis */
		{
			case EVNTID_CURSORUP:
				DumpFiles(-1, lcdLineCnt);	/* Ausgabe der MP3-Files */
			break;
			case EVNTID_CURSORDWN:
				DumpFiles(1, lcdLineCnt);	/* Ausgabe der MP3-Files */
			break;
			case EVNTID_OK:					/* TRUE zurueckgeben -> Wdg. starten */
				return TRUE;
			case EVNTID_CANCEL:				/* LCD reinitialisieren und LWs ausg. */
				Displ_Init();
				return FALSE;
			case EVNTID_TOGGLE:				/* Datei markieren und Liste neu ausg. */
				ToggleFile();
				DumpFiles(0,lcdLineCnt);
				break;
		}
	} while(1);
}

/* Menu fuer MP3-Player */
int DoMp3(void)
{
	int min,sec;
	byte paused=FALSE;
	time_t	curTm, oldTm, baseTm, pauseTm;
	clock_t starttime, endtime;

	Displ_Init(); /* Clear Display */
	Display_String(0,"***MP3-Player***");

	/* Initialisierung der Zeitanzeige */
	pauseTm = oldTm = 0;
	baseTm = time(NULL);
	sprintf(lcdLine, "*%03d/%03d--%02d:%02d*", fileListCur + 1,
				fileListSize, 0, 0);
	Display_String(1, lcdLine);

	/* Ersten Dateinamen holen, Zeit ausgeben und Wdg. starten  */
	curFileName=GetFirstMp3();

	/* Startzeit zur Ermittlung der verschiedenen Periodendauern lesen */
	starttime=clock();

	while(Displ_Dequeue()!= FAIL); 	/* Displayqueue leeren */

	do
	{
		/* Schleifenzeit fuer spaetere Periodendauerberechnung */
		endtime=clock();

		if(paused == FALSE)
		{
			/* Aktuelle Zeit in Displayqueue schreiben sofern wieder eine s um */
			curTm = time(NULL) - baseTm;
			if(curTm != oldTm)
			{
				min = (int)((curTm) / 60);
				sec = (int)((curTm) % 60);
				sprintf(lcdLine, "*%03d/%03d--%02d:%02d*", fileListCur + 1,
							fileListSize, min, sec);
				Display_String(1, lcdLine);
				oldTm = curTm;
				if(lcdLineCnt == 4)
					Display_String(2, GetLCDName());
			}
		}
		/* Wiedergabeschleife aufrufen */
		if(MPFile_Play(curFileName)==FILEEND)
		{
			oldTm = 0;
			baseTm = time(NULL);
			sprintf(lcdLine, "*%03d/%03d--%02d:%02d*", fileListCur + 1,
						fileListSize, 0, 0);
			Display_String(1, lcdLine);
			curFileName=GetNextMp3();
		}

		Displ_Dequeue(); 		/* Zeichen aus Queue auf Display schreiben */

		/* Alle 50ms Eingaben pollen */
		if((endtime-starttime)>50)
		{
			starttime=endtime;	/* Zeitzaehler auf neue Startzeit setzen um */
										/* erneut 20ms zu warten */

			switch(Evnt_Check()) /* Abrage von Tastatur oder IR-Ereignissen */
			{
				case EVNTID_CURSORUP:	/* Naechste Datei spielen */
					MPFile_Stop();
					MPFile_Play(curFileName = GetNextMp3());
					baseTm = time(NULL);
					paused = FALSE;
				break;
				case EVNTID_CURSORDWN:	/* Vorhergehende Datei spielen */
					MPFile_Stop();
					MPFile_Play(curFileName = GetPrevMp3());
					baseTm = time(NULL);
					paused=FALSE;
				break;
				case EVNTID_NEXTDIR:		/* Erste Datei im naechsten Verz. spielen */
					MPFile_Stop();
					MPFile_Play(curFileName=GetNextMp3Dir());
					baseTm = time(NULL);
					paused = FALSE;
				break;
				case EVNTID_PREVDIR:
					MPFile_Stop();			/* Erste Datei im vorh. Verz. spielen */
					MPFile_Play(curFileName=GetPrevMp3Dir());
					baseTm = time(NULL);
					paused = FALSE;
				break;
				case EVNTID_TOGGLE:		/* Pausenfunktion aktivieren/deaktivieren */
					MPFile_Pause();
					if(paused==TRUE)
					{
						paused = FALSE;
						baseTm = time(NULL) - pauseTm;
					}
					else
					{
						paused = TRUE;
						pauseTm = time(NULL) - baseTm;
					}
				break;
				case EVNTID_CANCEL:		/* Abbruch der Wiedergabe */
					MPFile_Stop();
					Displ_Init();
					return TRUE;
			}
		}
	} while(1);
}

/* Beginn Hauptschleife	*/
void main(int argc, char *argv[])
{
	int i;

	/* Argumente parsen */
	for (i = 1; i < argc; i++)
	 {
		if(*argv[i] == '-')
			argv[i]++;

		if((*argv[i] == 'h') || (*argv[i] == '?'))
		{
			PrintArgs();
			return;
		}

		if(*argv[i] == 'b')		/* Bidirektionalen Modus aktivieren */
		  lptMode = PMODE_BIDIR;
		if(*argv[i] == 'p')		/* Default Portadresse aendern */
		  sscanf(argv[i] + 1, "%x", &lptBase);
		if(*argv[i] == 'i')		/* Default Interrupt aendern */
		  lptIrq = atoi(argv[i] + 1);
		if(*argv[i] == 'z')		/* Default Zeilenzahl aendern */
			if((lcdLineCnt= atoi(argv[i] + 1)) != 4)
				lcdLineCnt = 2;
		if(*argv[i] == 'e')		/* Emulationsmodus aktivieren */
		  lcdemu = TRUE;
		if(*argv[i] == 'f')		/* Andere Mapperdatei waehlen */
			strcpy(mapfname, argv[i] + 1);
		if(*argv[i] == 'l')		/* Unteres Pufferfuellstandslimit aendern */
			BufferLimit=atoi(argv[i] + 1);
		if(*argv[i] == 'r')		/* Burstgroesse aendern */
			BurstLength=atoi(argv[i] + 1);
		if(*argv[i] == 'k')		/* Kontrast einstellen und EEPROM flashen */
		{
			if(atoi(argv[i] + 1)>0)
			{
				LptInit();
				AtmelInit(atoi(argv[i] + 1));
			}
			else
			{
				LptInit();
				AtmelInit(20);
			}
			return;	/* Nach EEPROM Initialisierung Programm immer beenden */
		}
	}

	/* Alles Wichtige initialisieren */
	Init();

	/* Im Emulationsmodus alle Aufrufparameter nach dem Start mit ausgeben */
	if(lcdemu == TRUE)
	{
		gotoxy(1, 6);
		if( lptMode == PMODE_UNIDIR)
			printf("irq = %d, port = %x, lines = %d, mode = uni, emu = 1",
						lptP.lptIrq, lptP.lptAdr, lcdLineCnt);
		else
			printf("irq = %d, port = %x, lines = %d, mode = bi",
						lptP.lptIrq, lptP.lptAdr, lcdLineCnt);
	}

	/* Verfuegbare Laufwerke identifizieren */
	if(CheckDrives() == 0)
	{
		Display_String(1, "Keine Laufwerke!");
		return;
	}

	do /* Hauptschleife - luft bis zum bitteren Ende */
	{
		/* Systemlaufwerke ermitteln */
		DriveSelector();

		/* Loeschen des Displays */
		Displ_Init();

		/* Start der Wiedergabe falls im Dateimenu OK gedrueckt wird */
		if(FileSelector() == TRUE)
			DoMp3();
	}
	while(1);
}

