#ifndef _EVENTS
#define _EVENTS

/* Klassifizierung der Eventart beim ersten Lesezugriff */
#define EVNTMASK_UNKNOWN	0x00
#define EVNTMASK_RC5			0x10
#define EVNTMASK_DREH		0x08
#define EVNTMASK_TASTE		0x20

/* Interne Eventklassennummern vor dem Mapping */
#define EVNT_RC5		1
#define EVNT_DREH		2
#define EVNT_TASTE	3

/* Struktur eines Eintrags in der Eventtabelle */
typedef struct tagEMapEntry
{
	int rc5;			/* RC5-Code in int-Variaben ablegen */
	char dreh;		/* Vorzeichen der Drehknopfvariable entspr. Richtung */
	byte taste;		/* Acht Eingabetasten binaer in einem Byte codiert */
} EMapEntry;

/* Besondere Eventart fuer nicht klassifizierbare Eingabe */
#define EVNT_UNKNOWN	255

/* Interne Eventnummern nach dem Mapping */
#define EVNTID_CURSORUP		0
#define EVNTID_CURSORDWN	1
#define EVNTID_OK				2
#define EVNTID_CANCEL		3
#define EVNTID_TOGGLE		4
#define EVNTID_NEXTDIR 		5
#define EVNTID_PREVDIR 		6
#define EVNTID_COUNT 		7

int Evnt_Check(void);		/* Prueft, ob ein RC, IR, oder Tastencode anliegt*/
void Evnt_Assign(void);		/* Belegt die Map mit default-Werten */
void Evnt_Init(void);		/* Init der EventMap */
int Evnt_Map(byte,int);		/* Ordnet einem externen Event (rc5,dreh,taste) */
									/* einen internen Befehl zu (play,skip, usw.) */
int Evnt_Load(char *);		/* Laed die Map aus Datei */

#endif