/* Interrupt-Handler Routines for the CT-Player-Project,version 1.0.

	Copyright (C) 1999 Andreas Kemper, Marcus Schwatke

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2, or (at your option)
	any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <dos.h>
#include "parms.h"
#include "masisr.h"
#include "mpfio.h"
#include "regio.h"

extern MP3FILEPARAMS mpfP;
extern int lptDelay;
MASLPTPARAMS lptP;

void interrupt (*oldlptisr)();	/* Alter INT-Handler zur Wiederherstellung */
											/* bei Programmende */

/* ISR gibt byteweise MP3-Datenstrom an parallele Schnittstelle aus */
void interrupt LPTISR()
{
	int i;

	asm cli;		/* Waehrend Abarbeitung alle INTs sperren */

	if(mpfP.stat == MP3_STAT_PLAY)	/* Wiedergabe nur im entsprechenden Modus */
	{
		/* Nach Aufruf des INT-Handlers werden immer mind. ein 32 Byte Block */
		/* akzeptiert. Daher kann hier ohne gesonderte vorherige Pruefung *7
		/* immer mindestens ein Block gesendet werden */
		do
		{
			/* VOLL-Flag des Puffers immer zuruecksetzen */
			mpfP.rb_full = FALSE;

			/* 32 Bytes-Bursts koennen immer gepuffert werden */
			for(i=0; i<32; i++)
			{
				/* Weiteres Byte rausschreiben */
				Reg_Write(WR_MP3,mpfP.buf[mpfP.rb_start]);

				/* Anzahl der gesendeten Bytes inkrementieren */
				mpfP.curPos++;

				/* Pufferzeiger weitersetzen */
				mpfP.rb_start = ++mpfP.rb_start % BUFLEN;

				if (mpfP.rb_start == mpfP.rb_end)
				{
					mpfP.stat = MP3_STAT_END;
					break;
				}
			}
		} /* Bytes senden solange "ACK" und Puffer nicht leer */
		while((inp(lptP.lptStat)&ACK)&&(mpfP.stat != MP3_STAT_END));
	}

	/* Dem MASTER immer EOI signalisieren, da nur INT des Master-Interrupt- */
	/* Controllers [2..7] fuer die parallele Schnittstelle in Frage kommen */
	outp(INT_MASTER_CTRL, EOI);

	/* INTs global wieder freigeben */
	asm sti;
}

/* Initialisierung des INT-Controllers und LPT-Portbausteins */
void InitLPTISR()
{
	/* Interrupt Vektor, Adresse und Maskierung berechnen */
	if (lptP.lptIrq >= 2 && lptP.lptIrq <= 7)
	{
		lptP.intNo		= lptP.lptIrq + 0x08;
		lptP.picAdr		= INT_MASTER_CTRL;
		/* Vorbereitung fuer die Freigabe des ausgewaehlten Interrupts */
		lptP.picMask	= 1;
		lptP.picMask	= lptP.picMask << lptP.lptIrq;
	}
	else
	{
		printf("Ungueltiger Interrupt!\n");
		exit(0);
	}

	/* Alten INT-Handler fuer Wiederherstellung speichern */
	oldlptisr = getvect(lptP.intNo);

	/* Neuen INT-Handler zuweisen */
	setvect(lptP.intNo, LPTISR);

	/* Neuen Interrupt freigeben */
	outp(lptP.picAdr+MASK_REG_OFFSET,inp(lptP.picAdr+MASK_REG_OFFSET)
			& (0xFF - lptP.picMask));

	/* Neuen Interrupt auch am Parallelport aktivieren */
	outp(lptP.lptCtrl,(inp(lptP.lptCtrl)|EACK));
}

/* INT wieder freigeben und entsprechenden Zeiger "zurueckbiegen" */
void FreeLPTISR()
{
	/* Zuerst INT von paralleler Schnittstelle wieder deaktivieren */
	outp(lptP.lptCtrl,(inp(lptP.lptCtrl)^EACK));

	/* Maskierung rueckgaengig machen */
	outp(lptP.picAdr+1,inp(lptP.picAdr+1)|lptP.picMask);

	/* Alten Handler wieder herstellen */
	setvect(lptP.intNo, oldlptisr);
}

