#ifndef _MASISR
#define _MASISR

/* Modusflags fuer Datenempfangsroutine */
#define PMODE_BIDIR		0
#define PMODE_UNIDIR		1

/* Struktur mit den Parametern fuer parallele Schnittstelle und INT-Controller */
typedef struct tagMASLPTParams
{
	int	lptAdr;		/* Datenregister Parallelport */
	int	lptCtrl;		/* Steuerregister Parallelport */
	int	lptStat;		/* Statusregister Parallelport */
	int	lptIrq;		/* Interrupt der parallelen Schnittstelle */
	int	lptUnidir;	/* Betriebsart je nach Porteigenschaften festlegen */
	int	lptHdShake;	/* Graduelle Einstellung des verwendeten Handshaking */
	int	picAdr;		/* Aktuelle Adresse des INT-Controllers (Master o. Slave) */
	int	picMask;		/* Bitfeld zur Interruptmaskierung */
	int	intNo;    	/* Interrupt Vector Nummer */
} MASLPTPARAMS;

void InitLPTISR(void);	/* LPT-Interrupt initialisieren */
void FreeLPTISR(void);	/* LPT-Interrupt freigeben */

#endif