/* MP3-File Routines for the CT-Player-Project,version 1.0.

	Copyright (C) 1999 Andreas Kemper, Marcus Schwatke

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2, or (at your option)
	any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <dos.h>
#include <sys\stat.h>
#include "parms.h"
#include "masisr.h"
#include "mpfio.h"
#include "regio.h"

MP3FILEPARAMS mpfP;
extern MASLPTPARAMS lptP;
extern lcdemu;

/* Initialisierung der Variablen */
void MPFile_Init()
{
	mpfP.fh       = NULL;
	mpfP.fn       = NULL;
	mpfP.stat     = MP3_STAT_STOP;
	mpfP.curPos   = 0;
	mpfP.rb_start = 0;
	mpfP.rb_end   = 0;
	mpfP.rb_full  = FALSE;
}

/* Routine liefert MP3-Daten an MAS und wird im Hauptprogramm zykl. gepollt */
int MPFile_Play(char *fn)
{
	int cnt,i,bufEntries;
	struct stat fileStat;

	switch(mpfP.stat)
	{
		case MP3_STAT_STOP:

		/**** Vorbereitung zur INT-gesteuerten Wiedergabe eine neuen Datei ****/

		/* Die Datei wird geoeffnet, der Ringpuffer erstmalig gefuellt und */
		/* korrekt initialisiert. Anschliessend wird aus dem Ringpuffer der */
		/* Atmel-interne Puffer vollstaendig gefuellt, so dass die Wiedergabe */
		/* startet. Durch das abschliessende Initialisieren des Interrupthandl. */
		/* werden im Folgenden weitere Bytes per Interrupt zum Atmel uebertr. */

			mpfP.fh		= NULL;		/* Handler der aktuellen Datei */
			mpfP.fn		= NULL;		/* Name der aktuellen Datei */
			mpfP.curPos = 0;			/* Anzahl der bereits wiedergegebenen Bytes */

			/* Versuche Datei zu oeffnen, andernfalls Abbruch */
			if( (mpfP.fh =fopen((mpfP.fn=fn), "rb"))==NULL)
				return FALSE;

			/* Variable mit Dateigroesse initialisieren, damit Erkennung des */
			/* Dateiendes moeglich wird */
			fstat(fileno(mpfP.fh), &fileStat);
			mpfP.fSize=fileStat.st_size;

			/* Den internen Puffer erstmalig fuellen */
			if(fread(mpfP.buf,1,BUFLEN,mpfP.fh)==0)
				return FALSE;

			/* Betriebsart fuer Wiedergabe wechseln */
			mpfP.stat = MP3_STAT_PLAY;

			/* Puffervariablen neu setzen */
			mpfP.rb_full = FALSE;	/* Sobald mind. ein Byte gesendet wurde */
			mpfP.rb_refill = FALSE;	/* Noch kein Grund den Puffer nachzuladen */
			mpfP.rb_start = 0;		/* Ausgabezeiger zunaechst 0 */
			mpfP.rb_end = BUFLEN-1;	/* Puffer urspruenglich ganz gefuellt */

			/* Byteweises Senden an Atmel bis sein Puffer erstmalig gefuellt */
			/* Achtung: Da Pufferfuellstand hier nicht bekannt ist, sollte vorab */
			/* geprueft werden, ob noch 32 Bytes gesendet werden drfen */
			while((mpfP.rb_start<BUFLEN) && (inp(lptP.lptStat) & ACK))
			{
				/* 32 Bytes-Bursts koennen immer gepuffert werden */
				for(i=0; i<32; i++)
				{
					/* Weiteres Byte rausschreiben */
					Reg_Write(WR_MP3,mpfP.buf[mpfP.rb_start]);

					/* Anzahl der gesendeten Bytes inkrementieren */
					mpfP.curPos++;

					/* Pufferzeiger weitersetzen */
					mpfP.rb_start = ++mpfP.rb_start % BUFLEN;
				}
			} /* Bytes senden solange "ACK" gesetzt */

			/* Handler installieren damit im Folgenden interruptgesteuertes */
			/* Nachladen moeglich wird */
			InitLPTISR();

			return TRUE;

		case MP3_STAT_PLAY:

		/**** Pufferfuellschleife fuer aktuell wiedergegebene Datei ****/

		/* Ueberprueft waehrend der Wiedergabe fortlaufend den Pufferfuellstand */
		/* und liest bei Bedarf neue Bytes aus der Datei. Falls beim Lesen EOF */
		/* auftritt, wird "rb_end" nicht weiter inkrementiert, damit in */
		/* Interruptroutine durch Vergleich von Pufferanfangs- mit */
		/* Pufferendzeiger ein Pufferunterlauf erkannt wird */

			/* Pruefe ob minimaler Fuellstand unterschritten wurde */
			if(mpfP.rb_end>mpfP.rb_start)
				bufEntries=mpfP.rb_end-mpfP.rb_start;
			else
				bufEntries=BUFLEN-(mpfP.rb_start-mpfP.rb_end);

			if((bufEntries % BUFLEN) > mpfP.buffer_limit)
				mpfP.rb_refill=TRUE;

			/* Falls Nachfuellflag geloescht beende Routine */
			if(mpfP.rb_refill==FALSE)
				return TRUE;

			/* Puffer fuellen sobald untere Fuellgrenze erreicht. Abbruch des */
			/* aktuellen Lesevorgangs falls entweder oberes Fuellstandslimit, */
			/* max. zu lesende Burstgroesse oder Dateiende erreicht */
			cnt=0;
			while((mpfP.rb_full==FALSE) && (cnt++<mpfP.burst_length)
					&& !feof(mpfP.fh))
			{
				mpfP.rb_end = ++mpfP.rb_end % BUFLEN;
				mpfP.buf[mpfP.rb_end]=fgetc(mpfP.fh);

				/* VOLL-Flag bei vollem Puffer setzen und Abbruch der Schleife */
				if(mpfP.rb_end>mpfP.rb_start)
					bufEntries=mpfP.rb_end-mpfP.rb_start;
				else
					bufEntries=BUFLEN-(mpfP.rb_start-mpfP.rb_end);

				if(bufEntries % BUFLEN == (BUFLEN-1))
				{
					mpfP.rb_full = TRUE;
					mpfP.rb_refill = FALSE;
				}
			}

			return TRUE;

		case MP3_STAT_END:

		/**** Behandlung eines Pufferunterlaufs ****/

		/* Bei einem Pufferunterlauf wird diese Routine aus dem Interrupt- */
		/* handler heraus aktiviert. Da die Verzweigung aufgrund gleicher */
		/* Schreib- und Lesezeiger erfolgt, muss zwischen einem gerade komplett */
		/* gefuellten Puffer und einem tatsaechlich leeren (Dateiende!) Puffer */
		/* unterschieden werden */

			/* Echter Pufferunterlauf, also Neustart an Zwischenposition */
			if(mpfP.fSize>mpfP.curPos)
				mpfP.stat = MP3_STAT_RESTRT;
			/* Andernfalls naechste Datei spielen */
			else
			{
				MPFile_Stop();
				return FILEEND;
			}

			return TRUE;

		case MP3_STAT_RESTRT:

		/**** Wiederaufnahme der Wiedergabe nach Pufferunterlauf/Pause ****/

		/* Das Vorgehen hier ist fast identisch zu dem beim Oeffnen einer Datei */
		/* Weitere Details siehe oben */

			/* Den internen Puffer erneut fuellen */
			while(mpfP.rb_start != mpfP.rb_end)
			{
				mpfP.buf[mpfP.rb_end]=fgetc(mpfP.fh);
				mpfP.rb_end=++mpfP.rb_end%BUFLEN;
			}

			/* Puffervariablen neu setzen */
			mpfP.rb_full = FALSE;	/* Sobald mind. ein Byte gesendet wurde */
			mpfP.rb_refill = FALSE;	/* Noch kein Grund den Puffer nachzuladen */

			/* Byteweises Senden an Atmel bis sein Puffer erstmalig gefuellt */
			do
			{
				/* 32 Bytes-Bursts koennen immer gepuffert werden */
				for(i=0; i<32; i++)
				{
					/* Weiteres Byte rausschreiben */
					Reg_Write(WR_MP3,mpfP.buf[mpfP.rb_start]);

					/* Anzahl der gesendeten Bytes inkrementieren */
					mpfP.curPos++;

					/* Pufferzeiger weitersetzen */
					mpfP.rb_start = ++mpfP.rb_start % BUFLEN;
				}
			} /* Bytes senden solange "ACK" gesetzt */
			while((mpfP.rb_start<BUFLEN) && (inp(lptP.lptStat) & ACK));

			/* Betriebsart fuer Wiedergabe wechseln */
			mpfP.stat = MP3_STAT_PLAY;

			return TRUE;
	}
	return TRUE;
}

/* Anhalten der Wiedergabe durch Deaktivierung des Interrupthandlers und */
/* Wechsel in Betriebsart MP3_STAT_STOP. Ferner wird vor der Auswahl einer */
/* evtl. folgenden Datei die Aktuelle geschlossen */
void MPFile_Stop()
{
	mpfP.stat = MP3_STAT_STOP;
	FreeLPTISR();
	fclose(mpfP.fh);
	delay(10);
	mpfP.curPos = 0;
}

/* Pausenfunktion bei der MP3-Wiedergabe */
/* Hardwaremaessig wird die Pausenfunktion durch vorruebergehendes */
/* Deaktivieren des Interrupts realisiert, wobei gleichzeitig durch den */
/* Modus MP3_STAT_PAUSE der aktivierte Pausenstatus bis zum erneuten Druecken */
/* der Pause-Taste gemerkt wird */
void MPFile_Pause()
{
	if(mpfP.stat == MP3_STAT_PAUSE)
	{
		mpfP.stat = MP3_STAT_RESTRT;
		InitLPTISR();
	}
	else if(mpfP.stat == MP3_STAT_PLAY)
	{
		mpfP.stat = MP3_STAT_PAUSE;
		FreeLPTISR();
	}
}

