'   Stand: 24.03.1999
'   ----------------------------------------------------------------------
'
'   NoAd: Keine Werbung auf dem Viorekorder: PC Steuerung
'   Copyright (C) 1999 Peter Richert (Richert@FH-Muenster.DE)
'
'   Telefon +49 2551 9-62125, Fax -62391
'
'   Fachhochschule Mnster, Fachbereich Elektrotechnik
'   eLKaTe - Labor Kommunikationstechnik
'   Stegerwaldstrasse 39, 48565 Steinfurt, GERMANY
'
'   ----------------------------------------------------------------------
'   This program is free software; you can redistribute it and/or modify
'   it under the terms of the GNU General Public License as published by
'   the Free Software Foundation; either version 2 of the License, or
'   (at your option) any later version.
'
'   This program is distributed in the hope that it will be useful,
'   but WITHOUT ANY WARRANTY; without even the implied warranty of
'   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'   GNU General Public License for more details.
'
'   You should have received a copy of the GNU General Public License
'   along with this program; if not, write to the Free Software
'   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
'
'   ----------------------------------------------------------------------
'

Attribute VB_Name = "Modul1"
'Allgemeine Konstanten
Public Const Shift8 As Long = 256
Public Const Shift16 As Long = 65536
Public Const Verkleinerungsfaktor = 10

'Konstanten der Fernsteuerungen
Public Const Video$ = "00101"
Public Const Fernseher$ = "00000"
Global Taste_gedrckt$

'Die Koordinaten der oberen-linken Ecke der Fernsehbildes
'in der Hauppauge-Applikation
Public Const TV_X As Byte = 135
Public Const TV_Y As Byte = 115
'Hinw.: Gilt nur fr die maximierte Hauppauge-Applikation

Global Logo_X, Logo_Y As Long 'die oberen-linken X/Y Koordinaten des Logo im Fernsehbild
Global Logobreite, Logohhe As Byte 'Breite und Hhe des Logos

Global Handlewintv As Long  'enthlt die HandleNr. der Hauppauge-Applikation
Global DC As Long           'enthlt den Device Contest von Hauppauge

Global Freigabe_Austastzeilen As Boolean 'Freigabe, ob schw. Austastzeilen erkannt werden sollen
Global Freigabe_Logo_identifizieren As Boolean 'Ist die Freigabe, ob nach das Logo identifiziert werden soll
Global Freigabe_Logo_finden As Boolean
Global Freigabe_Eigenschaften_ermitteln As Boolean
Global Freigabe_Mepunkte_ermitteln As Boolean
Global Werbung As Boolean ' Vom Wert dieser Variable ist abhngig, ob der Video aufnimmt oder stoppt

' Die Pixelbreite/-hhe, auf die das Fernsehbild komprimiert wird
Public Const Suchbreite As Byte = 75
Public Const Suchhhe As Byte = 55

'Enthalten das farbige Bild
Global Rot2(100, 100) As Byte
Global Grn2(100, 100) As Byte
Global Blau2(100, 100) As Byte

'geben die mittleren Farbanteile von RGB an
Global mhr As Byte
Global mhg As Byte
Global mhb As Byte

Global Mepunkt_Rot_X(3000) As Byte
Global Mepunkt_Grn_X(3000) As Byte
Global Mepunkt_Blau_X(3000) As Byte

Global Mepunkt_Rot_Y(3000) As Byte
Global Mepunkt_Grn_Y(3000) As Byte
Global Mepunkt_Blau_Y(3000) As Byte

Global Referenzpunkt_X(3000) As Byte
Global Referenzpunkt_Y(3000) As Byte

Global Lauf_M As Long 'Gibt die Anzahl der Me- und Referenzpunkte an
Global Helligkeitstoleranz As Byte  'in %; gibt an, um wieviel sich der
                                    'Me- vom Referenzpunkt unterscheiden mu
Global Farbtoleranz As Byte         'in %
Global Helles_Logo As Byte  'ist 1 wenn das Logo heller als der Hintergrund,
                            'und 0 wenn es dunkler ist

Global SB_unten As Byte 'SB_xxx geben an, an welcher Y-Koordinate die sw-Austastzeilen enden
Global SB_oben As Byte

Global Aufnahmestart_Uhrzeit As Long    '
Global Aufnahmestop_Uhrzeit As Long
Global Sender As String
Global Aufnahmestart_Datum As Long
Global Aufnahmestop_Datum As Long

Public Sub Initialisierung()

AppActivate "Hauppauge Win/TV"
Handlewintv = GetForegroundWindow()
DC = GetWindowDC(Handlewintv)

Form1.Show
'Form3.Show

Freigabe_Logo_identifizieren = False
Freigabe_Austastzeilen = False
Taste_gedrckt$ = "01"
Aufnahmestart_Uhrzeit = 999999
Aufnahmestop_Uhrzeit = 999999

'CommPort2 wird geffnet und initialisiert
Form1.MSComm1.CommPort = 1
Form1.MSComm1.DTREnable = False 'Recording-Taste; Default auf false
Form1.MSComm1.RTSEnable = True 'Default auf true; Stop-Taste
Form1.MSComm1.Settings = "9600,n,8,1"
Form1.MSComm1.PortOpen = True

'Komando-Modus im Infrarotsender einschalten
Call Kommando_Mode_an_IC(True)

'Die Register im Infrarotsender werden initialisiert
Call Kommando_an_IC_senden("11010000")  'Shadow-Bit rcksetzen im Control Register #3
                                            'Register 0-15 werden angesprochen
    
'ControlRegister #1
Call Kommando_an_IC_senden("00001001") 'Transmitter enabled, Echo enabled
    
'Transmit Mode Register #1
Call Kommando_an_IC_senden("00100101")  'TV remote mode enabled,Amplitude modulated carrier modulation
    
'Transmit Mode Register #2
Call Kommando_an_IC_senden("00110110")  'Bits are trandmitted based on TxD, 8 Bits
    
'Output Power Register
Call Kommando_an_IC_senden("01000011")  'Both LED1C and LED2C enabled
    
'Modulator Divider Register #1 & #2
Call Kommando_an_IC_senden("10100101")  'LSB
Call Kommando_an_IC_senden("10110110")  'MSB ;auf 36 kHz einstellen
    
Call Kommando_an_IC_senden("11010001")  'Shadow bit setzen im Control Register #3
                                            'Register 16-31 werden angesprochen
    
'TV Remote Transmit Bit Rate Divider Register #1 & #2
Call Kommando_an_IC_senden("00111101") '
Call Kommando_an_IC_senden("01001100") '1120 bps
    
'Control Register #4
'Call Kommando_an_IC_senden("01010010")  'If crystal ist used, disable clock output driver (Hi-Z)
                                               'Nur Sicherheitshalber, um berschwinger zu vermeiden
    
Call Kommando_an_IC_senden("11010000")  'Shadow-Bit rcksetzen im Control Register #3
                                                'Register 0-15 werden angesprochen
'Programmierung des IC's beendet
'Komando-Modus im Infrarotsender ausschalten

Call Kommando_Mode_an_IC(False)

End Sub

Public Function Long_Helligkeit(ByVal Longwert As Long) As Byte
'Diese Funktion gibt die Helligkeit eines Pixels[0..255] zurueck

Dim r, g, b As Byte

r = (Longwert And &HFF&)
g = (Longwert And &HFF00&) / Shift8
b = (Longwert And &HFF0000) / Shift16

Long_Helligkeit = CByte((r + g + b) / 3)

End Function

Public Function Helligkeit_Long(ByVal Bytewert As Byte) As Long
'Diese Funftion wandelt aus einer 8-Bit Helligkeit ein 24-Bit Farbwert

r = CByte(Bytewert)
g = CByte(Bytewert)
b = CByte(Bytewert)

Helligkeit_Long = CLng(r + Shift8 * g + Shift16 * b)

End Function

Public Sub Logo_finden()

'Die Logo_finden-Routine ermittelt die Koordinaten des Senderlogos innerhalb des Fernsehbildes
'dazu ermittelt sie ueber mehrere Bilder den Mittelwert jedes einzelnen Bildpunktes
'Um die Anzahl dieser Punkte gering zu halten, wurde das Bild um den Verkleinerungsfaktor verringert
'-> nicht 750x550(=412500), sondern nur 75x55(=4125) Bildpunkte

'Initialisierung
Dim Fensterrand, n, m, Max_Differenz, Max_Differenz_X_Koordinate, Max_Differenz_Y_Koordinate As Byte
Dim Helligkeit As Long
Dim mh, Zhler1 As Long
Dim Punkt(100, 100) As Long
Dim Punkt2(100, 100) As Byte

Fensterrand = 15    'Gibt an, wie weit das Logo von linken bzw. rechten Rand entfern sein darf

With Form1.Picture3
    .Width = Suchbreite
    .Height = Suchhhe
    .Visible = True
    .Left = 22
    .Top = 290
End With

'Der oberste-linke Punkt eines Picture-Objects in VB hat die Koordinaten (0,0)
'Daher wird nur bis Suchbreite,-hhe -1 der Mittelwert gebildet
'(=die Gesamtzahl ist dann wieder Suchbreite * Suchhhe !)

While (n < 80 And Freigabe_Logo_finden = True)

    DoEvents 'Die Kontrolle wird whrend der Schleife an das Betriebssystem gegeben
    
        n = n + 1 '
        
        Call Verkleinertes_Fernsehbild_anzeigen(Suchbreite, Suchhhe)
        
        'vom aktuellen Fernsehbild wird der SW-Wert ermittelt
        'und mit dem errechneten Mittelwert aktualisiert
    
        For X = 0 To Suchbreite - 1
            DoEvents
        
            For Y = 0 To Suchhhe - 1
                DoEvents
                'Routine zur Ermittlung des sw-Wertes
                Helligkeit = Long_Helligkeit(Form1.Picture3.Point(X, Y))
                Punkt(X, Y) = Punkt(X, Y) + Helligkeit
                'der neue Mittelwert des aktuellen XY-Punktes wird in die Punkt2 Matrix
                Punkt2(X, Y) = CByte(Punkt(X, Y) / n)
                
                'Die mittlere Helligkeit des gesamten Bildes wird ermittelt
                mh = mh + Helligkeit
                Zhler1 = Zhler1 + 1
                m = CByte(mh / Zhler1) 'm beinhaltet die durchschnittliche Helligkeit
                
                ' Die Koordinaten des aufflligsten Punktes werden nach der Mittelwertbildung ermittelt
                
                If ((X > Fensterrand) And (X < (Suchbreite - Fensterrand))) Then
                    ' Es werden keine Helligkeitswerte im "inneren Fenster" ermittelt
                Else
                
                    'Wenn der aktuelle Mepunkt "aufflliger" ist als der Bisherige werden seine
                    'Helligkeit und seine Koordinaten gespeichert
                    If (Abs(Punkt2(X, Y) - m) > Max_Differenz) Then
                        
                        Max_Differenz = Abs(Punkt2(X, Y) - m)
                        Max_Differenz_X_Koordinate = X
                        Max_Differenz_Y_Koordinate = Y
                        If (Punkt2(X, Y) > m) Then
                            Helles_Logo = 1
                        Else
                            Helles_Logo = 0
                        End If
                        
                    End If
                    
                End If 'vom hellsten Punkt suchen
            
            Next Y
        
        Next X
        
        If Helles_Logo = 1 Then
            Form1.Picture3.Line (0, Max_Differenz_Y_Koordinate)-(Suchbreite - 1, Max_Differenz_Y_Koordinate), &HFFFFFF
            Form1.Picture3.Line (Max_Differenz_X_Koordinate, 0)-(Max_Differenz_X_Koordinate, Suchhhe - 1), &HFFFFFF
        Else
            Form1.Picture3.Line (0, Max_Differenz_Y_Koordinate)-(Suchbreite - 1, Max_Differenz_Y_Koordinate), &H0&
            Form1.Picture3.Line (Max_Differenz_X_Koordinate, 0)-(Max_Differenz_X_Koordinate, Suchhhe - 1), &H0&
        End If
        
        Max_Differenz = 1
    
        'Die Start/Stop-Koordinaten werden wieder um den Faktor 10 gestreckt
        'Lag der aufflligste Punkt zu nah am Rand wird LogoX/Y gleich Null gesetzt
        Logo_X = (Max_Differenz_X_Koordinate * 10) - 30
        If Logo_X < 0 Then Logo_X = 0
        Logo_Y = (Max_Differenz_Y_Koordinate * 10) - 50
        If Logo_Y < 0 Then Logo_Y = 0
        
Wend ' von Freigabe_Logo_finden

' An dieser Stelle ist die Mittelwertbildung der Fernsehbilder abgeschloen
Form1.Command1.Visible = False
Form1.Picture3.Visible = False
Form1.Eigenschaften.Enabled = True

End Sub

Public Sub Austastzeilen_messen()

'Dies Funktion gibt die Position der Austastzeilen an
Dim X, Y As Long
Dim Gesamte_Helligkeit, Helligkeit As Long
Dim Hilfspunkt(100, 100) As Long
Const m = 5 'Gibt an, wie viele Fernsehbilder zu Mittelwertbildung herangezogen werden

With Form1.Picture3
    .Visible = True
    .Width = Suchbreite
    .Height = Suchhhe
    .Top = 290
    .Left = 22
End With

For n = 1 To m

    DoEvents
    
    Call Verkleinertes_Fernsehbild_anzeigen(Suchbreite, Suchhhe)
    
    For X = 0 To Suchbreite - 1
        DoEvents
        For Y = 0 To Suchhhe - 1
        DoEvents
        Hilfspunkt(X, Y) = Hilfspunkt(X, Y) + Long_Helligkeit(Form1.Picture3.Point(X, Y))
        Next Y
    Next X
Next n

For X = 0 To Suchbreite - 1
    For Y = 0 To Suchhhe - 1
    Hilfspunkt(X, Y) = CByte(Hilfspunkt(X, Y) / m)
    Form1.Picture3.PSet (X, Y), Helligkeit_Long(Hilfspunkt(X, Y))
    Next Y
Next X

SB_oben = 0
'von oben kommend wird das Fernsehbild so lange abgetastet bis die gesamte
'Helligkeit einer Bildzeile grer als der eingestellte Grenzwert wird

For Y = 0 To Int(Suchhhe / 2)
    Gesamte_Helligkeit = 0
    For X = 0 To Suchbreite
        Gesamte_Helligkeit = Gesamte_Helligkeit + Long_Helligkeit(Form1.Picture3.Point(X, Y))
    Next X
    If ((Gesamte_Helligkeit < 2000) And (Y > SB_oben)) Then
        SB_oben = Y
    End If
Next Y

SB_unten = Suchhhe
'von unten kommend wird das Fernsehbild so lange abgetastet bis die gesamte
'Helligkeit einer Bildzeile grer als der eingestellte Grenzwert wird

For Y = Suchhhe To Int(Suchhhe / 2) Step -1
    Gesamte_Helligkeit = 0
    For X = 0 To Suchbreite
        Gesamte_Helligkeit = Gesamte_Helligkeit + Long_Helligkeit(Form1.Picture3.Point(X, Y))
    Next X
    If ((Gesamte_Helligkeit < 2000) And (Y < SB_unten)) Then
        SB_unten = Y
    End If
Next Y

Form1.Picture3.Visible = False

If ((SB_oben <> 0) And (SB_unten <> Suchhhe)) Then
    Freigabe_Austastzeilen = True
    Call Austastzeilen__identifizieren
Else
'Es sind keine Austastzeilen vorhanden, daher wird die Aufnahmesteuerung durch das Vorhandensein
    'des Senderlogos bestimmt
Call Logo_identifizieren

End If

End Sub

Public Sub Austastzeilen__identifizieren()
'Diese Funktion stellt fest, ob die Austastzeilen vorhanden sind

Dim X As Byte
Dim a, b, c, d As Long
Dim ab$

With Form1
    .Command2.Visible = True
    .Picture3.Visible = True
    .Picture3.Width = Suchbreite
    .Picture3.Height = Suchhhe
End With
    
While (Freigabe_Austastzeilen = True)
    DoEvents
    a = 0
    b = 0
    c = 0
    d = 0
    
    Call Verkleinertes_Fernsehbild_anzeigen(Suchbreite, Suchhhe)
    
    For X = 0 To Suchbreite Step 2
        DoEvents
        a = a + Long_Helligkeit(Form1.Picture3.Point(X, SB_oben - 1))
        b = b + Long_Helligkeit(Form1.Picture3.Point(X, SB_oben + 1))
        c = c + Long_Helligkeit(Form1.Picture3.Point(X, SB_unten + 1))
        d = d + Long_Helligkeit(Form1.Picture3.Point(X, SB_unten - 1))
    Next X

    If ((b > 1000) And (d > 1000)) Then
        'Die Zeilen unter- und oberhalb der Austastzeilen sind hell genug
        If ((a < 1000) And (c < 1000)) Then
            'Austastzeilen vorhanden
            'Aussage "A-Zeilen vorhanden" muss zweimal hintereinander erfolgen
            If Form1.Frame2.BackColor = &H0& Then Werbung = False
            'Der Rahmen wird schwarz, die Schrift wei
            Form1.Frame2.BackColor = &H0&
            Form1.Frame2.ForeColor = &HFFFFFF
        Else
            'keine Austastzeilen vorhanden
            'Aussage "A-Zeilen nicht vorhanden" muss zweimal hintereinander erfolgen
            If Form1.Frame2.BackColor = &HC0C0C0 Then Werbung = True
            'Der Rahmen wird grau, die Schrift schwarz
            Form1.Frame2.BackColor = &HC0C0C0
            Form1.Frame2.ForeColor = &H0&
        End If
    Else
        'Keine Aussage mglich
        'Der Rahmen wird rot, die Schrift schwarz
        Form1.Frame2.BackColor = &HFF&
        Form1.Frame2.ForeColor = &H0&
    End If
    
    Call Aufnahmesteuerung
    
Wend

Form1.Picture3.Visible = False
Form1.Command2.Visible = False

End Sub

Public Sub Eigenschaften_ermitteln()

'Initialisierung
Dim r, g, b As Byte
Dim rot(100, 100), grn(100, 100), blau(100, 100) As Single
Dim PixelFarbe As Long
Dim mh_r, mh_g, mh_b, Zhler2 As Single

'Ein Rechteck wird um den hellsten Punkt aufgespannt
'Die Breite/Hhe wird mit 100 angenommen
Logobreite = 100
Logohhe = 100

With Form1.Picture3
    .Width = Logobreite
    .Height = Logohhe
    .Visible = True
    .Top = 272
    .Left = 8
End With

   
While (n < 50 And Freigabe_Eigenschaften_ermitteln = True)

    DoEvents
        
        n = n + 1
    
        'Das ungefhre Logo wird in Picture3 geschrieben
        Form1.Picture3 = CaptureWindow(Handlewintv, False, _
        TV_X + Logo_X, TV_Y + Logo_Y, Logobreite, Logohhe)
        
        'vom Logo wird von jedem Punkt der Farbwert ermittelt
        'und mit dem bereits errecheneten Mittelwert aktualisiert
        
        For Y = 0 To Logohhe - 1
        
            For X = 0 To Logobreite - 1
                
                'Funktion zu Ermittlung des Farbwertes
                PixelFarbe = Form1.Picture3.Point(X, Y)
                
                'ermitteln die Grundfarbenanteile
                r = (PixelFarbe And &HFF&)
                g = (PixelFarbe And &HFF00&) / Shift8
                b = (PixelFarbe And &HFF0000) / Shift16
                
                'Die Grundfarbenanteile des Logobildes werden aufsummiert
                mh_r = mh_r + r
                mh_g = mh_g + g
                mh_b = mh_b + b
                Zhler2 = Zhler2 + 1
                
                'Die Grundfarbenanteile der einzelnen Pixel werden aufsummiert
                rot(X, Y) = rot(X, Y) + r
                grn(X, Y) = grn(X, Y) + g
                blau(X, Y) = blau(X, Y) + b
                
                'Die Grundfarbenanteile des Mittelwertbildes werden ermittelt
                Rot2(X, Y) = CByte(rot(X, Y) / n)
                Grn2(X, Y) = CByte(grn(X, Y) / n)
                Blau2(X, Y) = CByte(blau(X, Y) / n)
                'Form1.Picture4.PSet (X, Y), Rot2(X, Y) + Shift8 * Grn2(X, Y) + Shift16 * Blau2(X, Y)
                
            Next X
                           
        Next Y
        
        mhr = CByte(mh_r / Zhler2)
        mhg = CByte(mh_g / Zhler2)
        mhb = CByte(mh_b / Zhler2)
    
        r = mhr
        g = mhg
        b = mhb

        mhh = CByte((r + g + b) / 3)
    
Wend 'Freigabe_Eigenschaften_ermitteln
' An dieser Stelle ist die Mittelwertbildung des Logos abgeschloen


Form1.Command1.Visible = False
Form1.Picture3.Visible = False
Form1.Mepunkte_ermitteln.Enabled = True

End Sub

Public Sub Logo_identifizieren()

Dim r, g, b, ref_r, ref_g, ref_b As Byte
Dim Logo_vorhanden, Logo_nichtvorhanden, Anzahl_Messpunkte As Integer
Dim ft As Single

With Form1.Picture3
    .Width = Logobreite
    .Height = Logohhe
    .Visible = True
    .Top = 272
    .Left = 8
End With

With Form1
    .Frame1.Caption = "Logo identifizieren"
    .Command1.Visible = True
    .Label1.Visible = True
End With
    
Freigabe_Logo_identifizieren = True

While (Freigabe_Logo_identifizieren = True)
    
    Logo_vorhanden = 0
    Logo_nichtvorhanden = 0
    Anzahl_Messpunkte = 0
    
    'Das Logo in Picture 3 schreiben
    Form1.Picture3 = CaptureWindow(Handlewintv, False, _
        TV_X + Logo_X, TV_Y + Logo_Y, Logobreite, Logohhe)
    
    'Die Farbtolernaz wird beim Identifizieren nur halb so gro gewhlt wie beim Mepunkt ermitteln
    'Grund: Die Mepunkte sind unter "idealeren" Bedingungen ermittelt worden
    ft = (Farbtoleranz / 200)
    
    For n = 1 To Lauf_M
        
        DoEvents
        
        'Die RGB-Komponenten werden von den jeweiligen Mepunkten ermittelt
        r = ((Form1.Picture3.Point(Mepunkt_Rot_X(n), Mepunkt_Rot_Y(n))) And &HFF&)
        g = (((Form1.Picture3.Point(Mepunkt_Grn_X(n), Mepunkt_Grn_Y(n))) And &HFF00&) / Shift8)
        b = (((Form1.Picture3.Point(Mepunkt_Blau_X(n), Mepunkt_Blau_Y(n))) And &HFF0000) / Shift16)
         
        'Die zur Messung herangezogenen Punkte werden eingezeichnet
        
        'Die Referenz RGB-Werte werden ermittelt und angezeigt
        ref_r = ((Form1.Picture3.Point(Referenzpunkt_X(n), Referenzpunkt_Y(n))) And &HFF&)
        ref_g = (((Form1.Picture3.Point(Referenzpunkt_X(n), Referenzpunkt_Y(n))) And &HFF00&) / Shift8)
        ref_b = (((Form1.Picture3.Point(Referenzpunkt_X(n), Referenzpunkt_Y(n))) And &HFF0000) / Shift16)
        
        
        If (Helles_Logo = 1) Then

            If (((ref_r + ref_g + ref_b) > 480)) Then
                'Bei einem hellen Logo ist der Referenzpunkt zu hell(>3x180)
            Else
                Anzahl_Messpunkte = Anzahl_Messpunkte + 1
                Form1.Picture3.PSet (Referenzpunkt_X(n), Referenzpunkt_Y(n)), &H808080
                
                'Ist der Mepunkt ein gltiger ?
                If ((Mepunkt_Rot_X(n) <> 0) And (Mepunkt_Rot_Y(n) <> 0)) Then
                    'berschreitet seine Helligkeit die erforderliche Grenze
                    If (r > (ref_r * (1 + ft))) Then
                            'Falls ja ist er wahrscheinlich ein Punkt des Logos
                            Logo_vorhanden = Logo_vorhanden + 1
                            Form1.Picture3.PSet (Mepunkt_Rot_X(n), Mepunkt_Rot_Y(n)), &HFF&
                        Else
                            'Ist der Me- dem referenzpunkt zu hnlich
                            Logo_nichtvorhanden = Logo_nichtvorhanden + 1
                    End If
                        
                End If
                    
                If ((Mepunkt_Grn_X(n) <> 0) And (Mepunkt_Grn_Y(n) <> 0)) Then
                    If (g > (ref_g * (1 + ft))) Then
                        Logo_vorhanden = Logo_vorhanden + 1
                        Form1.Picture3.PSet (Mepunkt_Grn_X(n), Mepunkt_Grn_Y(n)), (&HFF00& Or (Form1.Picture3.Point(Mepunkt_Grn_X(n), Mepunkt_Grn_Y(n))))
                    Else
                        Logo_nichtvorhanden = Logo_nichtvorhanden + 1
                    End If
                
                End If
                    
                If ((Mepunkt_Blau_X(n) <> 0) And (Mepunkt_Blau_Y(n) <> 0)) Then
                    If (b > (ref_b * (1 + ft))) Then
                        Logo_vorhanden = Logo_vorhanden + 1
                        Form1.Picture3.PSet (Mepunkt_Blau_X(n), Mepunkt_Blau_Y(n)), (&HFF0000 Or (Form1.Picture3.Point(Mepunkt_Blau_X(n), Mepunkt_Blau_Y(n))))
                    Else
                        Logo_nichtvorhanden = Logo_nichtvorhanden + 1
                    End If
                End If
            
            End If
                
        Else 'Helles/dunkles Logo

            If (((ref_r + ref_g + ref_b) < 300)) Then
                'bei einem dunkelen Logo ist der Referenzpunkt zu dunkel (< 3x100)
            Else
                Form1.Picture3.PSet (Referenzpunkt_X(n), Referenzpunkt_Y(n)), &H808080
                Anzahl_Messpunkte = Anzahl_Messpunkte + 1
                
                If ((Mepunkt_Rot_X(n) <> 0) And (Mepunkt_Rot_Y(n) <> 0)) Then
                    If (r < (ref_r * (1 - ft))) Then
                        Logo_vorhanden = Logo_vorhanden + 1
                        Form1.Picture3.PSet (Mepunkt_Rot_X(n), Mepunkt_Rot_Y(n)), &HFF&
                    Else
                        Logo_nichtvorhanden = Logo_nichtvorhanden + 1
                    End If
                End If
                        
                If ((Mepunkt_Grn_X(n) <> 0) And (Mepunkt_Grn_Y(n) <> 0)) Then
                    If (g < (ref_g * (1 - ft))) Then
                        Logo_vorhanden = Logo_vorhanden + 1
                        Form1.Picture3.PSet (Mepunkt_Grn_X(n), Mepunkt_Grn_Y(n)), (&HFF00& Or (Form1.Picture3.Point(Mepunkt_Grn_X(n), Mepunkt_Grn_Y(n))))
                    Else
                        Logo_nichtvorhanden = Logo_nichtvorhanden + 1
                    End If
                End If
                        
                If ((Mepunkt_Blau_X(n) <> 0) And (Mepunkt_Blau_Y(n) <> 0)) Then
                    If (b < (ref_b * (1 - ft))) Then
                        Logo_vorhanden = Logo_vorhanden + 1
                        Form1.Picture3.PSet (Mepunkt_Blau_X(n), Mepunkt_Blau_Y(n)), (&HFF0000 Or (Form1.Picture3.Point(Mepunkt_Blau_X(n), Mepunkt_Blau_Y(n))))
                    Else
                        Logo_nichtvorhanden = Logo_nichtvorhanden + 1
                    End If
                End If
            End If
        End If
        
    Next n
    
    If (Anzahl_Messpunkte < (Lauf_M / 3)) Then
        'nicht gengend Messpunkte zur Verfgung
        'Keine Aussage mglich
        Form1.Label1.Caption = "?"
        
    Else
        If (Logo_vorhanden > (3 * Logo_nichtvorhanden)) Then
            'Sollten die gemessenen Farbwerte deutlich(Faktor 3) sich von den Referenzpunkten
            'unterscheiden wird es sich um das Senderlogo handeln
            'Entscheidung "Logo vorhanden" muss zweimal hintereinander erfolgen
            If (Form1.Label1.Caption = "L") Then Werbung = False
            Form1.Label1.Caption = "L"
            
        End If
        
        If (Logo_nichtvorhanden > Logo_vorhanden) Then
            'Statistisch haben Me und Referenzpunkte bei nicht vorhandenem Logo
            'die gleichen Farbwerte, daher reicht
            'fr die Aussage "kein Logo vorhanden" die obere Bedingung
            'Entscheidung "Keine Logo vorhanden muss zweimal hintereinander folgen
            If (Form1.Label1.Caption = " ") Then Werbung = True
            Form1.Label1.Caption = " "
            
        End If
        
    End If
    
    Call Aufnahmesteuerung ' Ist der Videorekorder programmiert wird jetzt festgestellt,
    'ob die Aufnahme aungehalten werden mu oder nicht

Wend 'Logo_identifizieren


Form1.Command1.Visible = False
Form1.Picture3.Visible = False
Form1.Label1.Visible = False

End Sub

Public Function Schon_benutzt(ByVal Farbe As Long) As Boolean
'Mepunkte knnen sich sowohl in einer als uch in mehreren Farben
'von Ihrer umgebung unterscheiden.
'Damit zur einer XY-Koordinate auch nur ein Referenzpunkt bentigt wird, kann mit Hilfe
'dieser Funktion festgestellt werden, ob der Punkt bereits benutzt wird
If ( _
    (Farbe = &HFF&) Or _
    (Farbe = &HFF00&) Or _
    (Farbe = &HFF0000) Or _
    (Farbe = &HFFFF&) Or _
    (Farbe = &HFF00FF) Or _
    (Farbe = &HFFFF00) Or _
    (Farbe = &HFFFFFF) Or _
    (Farbe = &H808080) _
) Then
    Schon_benutzt = True
Else
    Schon_benutzt = False
End If

End Function

Public Sub Messpunkte_ermitteln()

'Nach Ablauf dieser Routine sind die Variabelen der Me- und Referenzpunkte
'festgestellt worden

Dim r, g, b, n, SummeMittelwertFarben, HelligkeitPixel As Byte
Dim oben, unten, links, rechts As Byte
Dim m, PixelFarbe As Long
Dim ht, ft As Single

For m = 0 To 3000
    Mepunkt_Rot_X(m) = 0
    Mepunkt_Rot_Y(m) = 0
    Mepunkt_Grn_X(m) = 0
    Mepunkt_Grn_Y(m) = 0
    Mepunkt_Blau_X(m) = 0
    Mepunkt_Blau_Y(m) = 0
Next m

Form1.Picture3.Visible = True

'Die Mae des Logos werden ersteinmal in die Mitte des Bildes gelegt.
oben = Logohhe / 2
unten = Logohhe / 2
links = Logobreite / 2
rechts = Logobreite / 2

r = mhr
g = mhg
b = mhb
m = 1

Helligkeitstoleranz = 51 'Gibt an, um wieviel sich der Farbwert einen Punktes
'von seinem Referenzpunkt unterscheiden mu, in %

SummeMittelwertFarben = CByte((r + g + b) / 3)
ht = (Helligkeitstoleranz / 100)

While ((m < 2000) And (ht > 0.2) And (Freigabe_Mepunkte_ermitteln = True))
    
    ht = ht - 0.01
    
    ft = ht
    
    DoEvents

    For X = 0 To Logobreite - 1

        For Y = 0 To Logohhe - 1
            
            'Anzeige des Mittelwertbildes
            r = Rot2(X, Y)
            g = Grn2(X, Y)
            b = Blau2(X, Y)
            HelligkeitPixel = CByte((r + g + b) / 3)
            PixelFarbe = Rot2(X, Y) + Shift8 * Grn2(X, Y) + Shift16 * Blau2(X, Y)
            Form1.Picture3.PSet (X, Y), PixelFarbe
            
            If ( _
                    (HelligkeitPixel < 40) _
                ) Then
                'zu dunkel, evtl. Austastzeilen
            Else
                
                If Helles_Logo = 1 Then
                    'Bei einem hellen Logo mssen seine Werte hher als die seiner Nachbarn liegen
                    If ( _
                        (HelligkeitPixel > ((1 + ht) * SummeMittelwertFarben)) _
                    ) Then
                        m = m + 1 'mehr als 1000 Mepunkte werden nicht bentigt
                        'Liegen Mepunkte auerhalb der Bildmitte werden Ihre Mae (re, li, ob, un) durch Neue ersetzt
                        If X > rechts Then rechts = X
                        If X < links Then links = X
                        If Y < oben Then oben = Y
                        If Y > unten Then unten = Y
                            
                        'Ein Punkt hat eine hellere Farbe als der Durchschnitt
                        If ( _
                            (Rot2(X, Y) > ((1 + ft) * mhr)) _
                        ) Then
                            Form1.Picture3.PSet (X, Y), &HFF&
                        End If
                        
                        If ( _
                            (Grn2(X, Y) > ((1 + ft) * mhg)) _
                        ) Then
                            Form1.Picture3.PSet (X, Y), &HFF00&
                        End If
                        
                        If ( _
                            (Blau2(X, Y) > ((1 + ft) * mhb)) _
                        ) Then
                            Form1.Picture3.PSet (X, Y), &HFF0000
                        End If
                        
                        'Ein Punkt unterscheidet sich in zwei Farben vom Normalbild
                        If ( _
                            (Rot2(X, Y) > ((1 + ft) * mhr)) And _
                            (Grn2(X, Y) > ((1 + ft) * mhg)) _
                        ) Then
                            Form1.Picture3.PSet (X, Y), &HFFFF&
                        End If
                        
                        If ( _
                            (Rot2(X, Y) > ((1 + ft) * mhr)) And _
                            (Blau2(X, Y) > ((1 + ft) * mhb)) _
                        ) Then
                            Form1.Picture3.PSet (X, Y), &HFF00FF
                        End If
                        
                        If ( _
                            (Grn2(X, Y) > ((1 + ft) * mhg)) And _
                            (Blau2(X, Y) > ((1 + ft) * mhb)) _
                        ) Then
                            Form1.Picture3.PSet (X, Y), &HFFFF00
                        End If
                        
                        'Ein Punkt unterscheidet sich in allen Farben vom Normalbild(wei bzw. wei-transparent)
                        If ( _
                            (Rot2(X, Y) > ((1 + ft) * mhr)) And _
                            (Grn2(X, Y) > ((1 + ft) * mhg)) And _
                            (Blau2(X, Y) > ((1 + ft) * mhb)) _
                        ) Then
                            Form1.Picture3.PSet (X, Y), &HFFFFFF
                        End If
                        
                    End If
                    
                Else 'Wenn es ich um ein dunkles Logo handelt
                    
                    'seine Helligkeit und seine Farbwerte men dunkler
                    'als der Bilddurchschnitt sein
                    If ( _
                        (HelligkeitPixel < ((1 - ht) * SummeMittelwertFarben)) _
                    ) Then
                        m = m + 1 'mehr als 1000 Mepunkte werden nicht bentigt
                        If X > rechts Then rechts = X
                        If X < links Then links = X
                        If Y < oben Then oben = Y
                        If Y > unten Then unten = Y
                            
                        If ( _
                            (Rot2(X, Y) < ((1 - ft) * mhr)) _
                        ) Then
                            Form1.Picture3.PSet (X, Y), &HFF&
                        End If
                        
                        If ( _
                            (Grn2(X, Y) < ((1 - ft) * mhg)) _
                        ) Then
                            Form1.Picture3.PSet (X, Y), &HFF00&
                        End If
                        
                        If ( _
                            (Blau2(X, Y) < ((1 - ft) * mhb)) _
                        ) Then
                            Form1.Picture3.PSet (X, Y), &HFF0000
                        End If
                        
                        If ( _
                            (Rot2(X, Y) < ((1 - ft) * mhr)) And _
                            (Grn2(X, Y) < ((1 - ft) * mhg)) _
                        ) Then
                            Form1.Picture3.PSet (X, Y), &HFFFF&
                        End If
                        
                        'zwei dunkle Mepunkte
                        If ( _
                            (Rot2(X, Y) < ((1 - ft) * mhr)) And _
                            (Blau2(X, Y) < ((1 - ft) * mhb)) _
                        ) Then
                            Form1.Picture3.PSet (X, Y), &HFF00FF
                        End If
                        
                        If ( _
                            (Grn2(X, Y) < ((1 - ft) * mhg)) And _
                            (Blau2(X, Y) < ((1 - ft) * mhb)) _
                        ) Then
                            Form1.Picture3.PSet (X, Y), &HFFFF00
                        End If
                        
                        'Alle Farben sind dunkler als der Durchschnitt, schwarzer Punkt
                        If ( _
                            (Rot2(X, Y) < ((1 - ft) * mhr)) And _
                            (Grn2(X, Y) < ((1 - ft) * mhg)) And _
                            (Blau2(X, Y) < ((1 - ft) * mhb)) _
                        ) Then
                            Form1.Picture3.PSet (X, Y), &HFFFFFF
                        End If
                    End If
                End If
            End If
        Next Y
    Next X
Wend 'Freigabe_Mepunkte_ermitteln

'Die Mepunkte wurden oben eingezeichnet, hier werden ihre Koordinaten in die
'Variablen geschrieben

For X = 0 To Logobreite - 1
    For Y = 0 To Logohhe - 1
        Farbe = Form1.Picture3.Point(X, Y)
        DoEvents
        If (Schon_benutzt(Farbe) = True) Then
            n = n + 1
            If ((Farbe And &HFF&) = &HFF&) Then
                Mepunkt_Rot_X(n) = X
                Mepunkt_Rot_Y(n) = Y
            End If
            If ((Farbe And &HFF00&) = &HFF00&) Then
                Mepunkt_Grn_X(n) = X
                Mepunkt_Grn_Y(n) = Y
            End If
            If ((Farbe And &HFF0000) = &HFF0000) Then
                Mepunkt_Blau_X(n) = X
                Mepunkt_Blau_Y(n) = Y
            End If
        End If
    Next Y
Next X

m = 0
While m < n     'Solange die Anzahl der Referenzpunkte kleiner ist als die Zahl der
                'Mepunkte wird die Schleife durchlaufen
    X = links + (rechts - links) / 2
    Y = oben + (unten - oben) / 2
    
    'Es werden nur Referenzpunkte zugelassen, die sich auerhalb des Logo befinden
    While _
    (X > links And _
    X < rechts And _
    Y > oben And _
    Y < unten)
    
        DoEvents
        X = (links / 2) + Int((2 * (rechts - links)) * Rnd)
        Y = (oben / 2) + Int((3 * (unten - oben)) * Rnd)
    Wend
    
    DoEvents
    If (Schon_benutzt(Form1.Picture3.Point(X, Y))) Then
        'der zufllige Punkt wird schon als Me/Referenzpunkt benutzt
    Else
        m = m + 1
        Referenzpunkt_X(m) = X
        Referenzpunkt_Y(m) = Y
        Form1.Picture3.PSet (X, Y), &H808080
    End If
Wend

Lauf_M = m 'Beinhaltet nun die Anzahl der Me/Referenzpunkte
Helligkeitstoleranz = CByte(100 * ht) 'Wird wieder umgewandelt in %
Farbtoleranz = CByte(100 * ft) 'Wird wieder umgewandelt in %

Form1.Command1.Visible = False
Form1.Picture3.Visible = False
Form1.speichern.Enabled = True
Form1.identifizieren.Enabled = True

End Sub

Public Function Time_Long(ByVal Zeit$) As Long

'Um die Start/Stopzeit zu erkennen werden zwei Long-Zahlen
Time_Long = Val(Mid$(Zeit$, 1, 1)) * 100000 + Val(Mid$(Zeit$, 2, 1)) * 10000 + Val(Mid$(Zeit$, 4, 1)) * 1000 + Val(Mid$(Zeit$, 5, 1)) * 100 + Val(Mid$(Zeit$, 7, 1)) * 10 + Val(Mid$(Zeit$, 8, 1)) * 1

End Function

Public Function Long_Time(ByVal Zeit As Long) As String

Long_Time = Mid$(Zeit, 1, 2) & ":" & Mid$(Zeit, 3, 2) & ":" & Mid$(Zeit, 5, 2)

End Function

Public Sub Aufnahmesteuerung()
'Diese Routine stellt aufrgund der Uhrzeit und der Variable "Werbung(Boolean) fest,
'ob die Aufnahme des Videorekorders angehalten werden mu, oder nicht

Dim Hilfsvariable$
Dim Zeit As Long

Hilfsvariable$ = Time
Zeit = Time_Long(Hilfsvariable$)
Form1.Text3.Text = Time 'Zeit 'Hilfsvariable$
       
If ((Zeit >= Aufnahmestart_Uhrzeit) And (Zeit < Aufnahmestop_Uhrzeit) And Werbung = False) Then
    Form1.Label2.Visible = True
    If Form1.Label2.Caption <> "REC" Then Call Recording
    Form1.Label2.Caption = "REC"
    
End If
    
If ((Zeit >= Aufnahmestart_Uhrzeit) And (Zeit < Aufnahmestop_Uhrzeit) And Werbung = True) Then
    If Form1.Label2.Caption <> "Pause" Then Call Stopp
    Form1.Label2.Caption = "Pause"
End If
    
If Zeit > Aufnahmestop_Uhrzeit Then
    With Form1
    .Label2.Caption = "Stop"
    .Command3.Caption = "programmieren"
    .Text3.Visible = False
    .Command1.Visible = False
    .Command2.Visible = False
    .Command3.Visible = True
    .Frame2.BackColor = &HC0C0C0
    .Frame2.ForeColor = &H0&
    .Label1.Caption = " "
    End With
    Freigabe_Logo_identifizieren = False
    Freigabe_Austastzeilen = False
    If Form1.Label2.Caption <> "Pause" Then Call Stopp
End If

End Sub

Public Sub Verkleinertes_Fernsehbild_anzeigen(Breite, Hhe)

'Das vollstndige Fernsehbild wird in Picture2 geschrieben, allerdings nicht
'angezeigt (picture2.visible=false)
Form1.Picture2 = CaptureWindow(Handlewintv, False, TV_X, TV_Y, Breite * Verkleinerungsfaktor, Hhe * Verkleinerungsfaktor)
Form1.Picture3.PaintPicture Form1.Picture2, 0, 0, Breite, Hhe

End Sub

Public Sub Kommando_an_Fernbedienung_senden(ByVal Steuerbit$, ByVal Video_Fernseh$, ByVal Kommando$)

'eine gesendete "1" schaltet die LED aus, whrend eine "0" die LED zum Leuchetn bringt
'Daher mu die Bitfolge noch invertiert werden

'Zur Unterscheidung, ob eine Taste zweimal gedrckt wurde oder die gleiche
'Taste nur lange gedrckt wurde, wechselt das dritte Bit nach dem Loslassen immer
'den Wert.
Dim Taste_Gedrckt_Bi$
Dim Steuerbit_Bi$

If Taste_gedrckt$ = "1" Then
    Taste_gedrckt$ = "0"
    Taste_Gedrckt_Bi$ = "01" '01 ist ok
    Steuerbit_Bi$ = "10"
Else
    Taste_gedrckt$ = "1"
    Taste_Gedrckt_Bi$ = "10"
    Steuerbit_Bi$ = "10"
End If

If Steuerbit$ = "1" Then
    Steuerbit_Bi$ = "10"
Else
    Steuerbit_Bi$ = "01"
End If

Dim Video_Fernseh_Bi$
If Video_Fernseh = "00101" Then
    Video_Fernseh_Bi$ = "0101100110" '=00101
Else
    Video_Fernseh_Bi$ = "0101010101" '=00000
End If

Dim Bit(5) As Byte
Dim Bit_Bi$(5)
Dim Kommando_Bi$

'Kommando_Bi$ = 1

For n = 0 To 5
    Bit(n) = Val(Mid$(Kommando$, 6 - n, 1))
    If Bit(n) = 1 Then
        'invertiert
        Bit_Bi$(n) = "10"
    Else
        Bit_Bi$(n) = "01"
    End If
    
    Kommando_Bi$ = Bit_Bi$(n) & Kommando_Bi$
Next n

'enthlt 28 Bit (Biphase codierte 14 Bit !)+ 4x"1111" zum Auffllen = 32 Zeichen
Befehl$ = "10" & Steuerbit_Bi$ & Taste_Gedrckt_Bi$ & Video_Fernseh_Bi$ & Kommando_Bi$ & "1111"
'Befehl$ = "1010" & Taste_Gedrckt_Bi$ & Video_Fernseh_Bi$ & Kommando_Bi$ & "1111"

Dim a(3)


    For m = 0 To 3

        a(m) = 0
        For n = 0 To 7
          a(m) = a(m) + (Val(Mid$(Befehl$, n + 1 + (8 * m), 1)) * (2 ^ n))
'          a = a + (Val(Mid$(Befehl$, n + 1 + (8 * m), 1)) * (2 ^ (7 - n)))
        Next n
    
    Next m
        
    For Anzahl_Sendungen = 1 To 2
        
        Form1.MSComm1.Output = Chr$(a(0)) + Chr$(a(1)) + Chr$(a(2)) + Chr$(a(3))
    
    Next Anzahl_Sendungen


End Sub

Public Sub Kommando_Mode_an_IC(ByVal Status As Boolean)

If (Status) Then
    Form1.MSComm1.RTSEnable = True ' Chip Reset setzen
    Form1.MSComm1.RTSEnable = False ' Chip Normal Operation setzen
    
    Form1.MSComm1.DTREnable = True ' Chip auf Steuerempfang (D/C_ auf low) setzen
Else
    ' Zeitschleife damit das Signal DTR nicht zu frh wechselt
    Y = 0
    For X = 0 To 1000
        Y = Y + 1
    Next X
    
    Form1.MSComm1.DTREnable = False  ' Chip auf Datenempfang (D/C_ auf high) setzen
End If

End Sub
Public Sub Kommando_an_IC_senden(ByVal Kommando$)

Dim Bit(7) As Byte
Dim Summe As Byte

For n = 0 To 7
    Bit(n) = ((Val(Mid$(Kommando$, (8 - n), 1))) * (2 ^ n))
    Summe = Summe + Bit(n)
Next n

'Form1.MSComm1.DTREnable = False ' Chip auf Steuerempfang (D/C_ auf low) setzen
Form1.MSComm1.Output = Chr$(Summe)
'Form1.MSComm1.DTREnable = True  ' Chip auf Datenempfang (D/C_ auf high) setzen

End Sub

Public Sub Recording()

    'REC
    Call Kommando_an_Fernbedienung_senden("1", Video, "110111")
    
    'Form1.MSComm1.DTREnable = True
    'For n = 1 To 10000
    '    DoEvents
    'Next n
    'Form1.MSComm1.DTREnable = False

End Sub

Public Sub Stopp()
    
    'Stop
    Call Kommando_an_Fernbedienung_senden("1", Video, "110110")

    'Form1.MSComm1.RTSEnable = False
    'For n = 1 To 10000
    '    DoEvents
    'Next n
    'Form1.MSComm1.RTSEnable = True

End Sub

Public Sub finde()
'Die Logo_finden-Routine ermittelt die Koordinaten des Senderlogos innerhalb des Fernsehbildes
'dazu ermittelt sie ueber mehrere Bilder den Mittelwert jedes einzelnen Bildpunktes
'Um die Anzahl dieser Punkte gering zu halten, wurde das Bild um den Verkleinerungsfaktor verringert
'-> nicht 750x550(=412500), sondern nur 75x55(=4125) Bildpunkte

'Initialisierung
Dim Fensterrand, n, m, Max_Differenz, Max_Differenz_X_Koordinate, Max_Differenz_Y_Koordinate As Byte
Dim Helligkeit As Long
Dim mh, Zhler1 As Long
Dim Punkt(100, 100) As Long
Dim Punkt2(100, 100) As Byte

Fensterrand = 15    'Gibt an, wie weit das Logo von linken bzw. rechten Rand entfern sein darf

With Form1.Picture3
    .Width = Suchbreite
    .Height = Suchhhe
    .Visible = True
    .Left = 22
    .Top = 290
End With

'Der oberste-linke Punkt eines Picture-Objects in VB hat die Koordinaten (0,0)
'Daher wird nur bis Suchbreite,-hhe -1 der Mittelwert gebildet
'(=die Gesamtzahl ist dann wieder Suchbreite * Suchhhe !)

While (n < 80 And Freigabe_Logo_finden = True)

    DoEvents 'Die Kontrolle wird whrend der Schleife an das Betriebssystem gegeben
    
        n = n + 1 '
        
        Call Verkleinertes_Fernsehbild_anzeigen(Suchbreite, Suchhhe)
        
        'vom aktuellen Fernsehbild wird der SW-Wert ermittelt
        'und mit dem errechneten Mittelwert aktualisiert
    
        For X = 0 To Suchbreite - 1
            DoEvents
        
            For Y = 0 To Suchhhe - 1
                DoEvents
                'Routine zur Ermittlung des sw-Wertes
                Helligkeit = Long_Helligkeit(Form1.Picture3.Point(X, Y))
                Punkt(X, Y) = Punkt(X, Y) + Helligkeit
                'der neue Mittelwert des aktuellen XY-Punktes wird in die Punkt2 Matrix
                Punkt2(X, Y) = CByte(Punkt(X, Y) / n)
                
                'Die mittlere Helligkeit des gesamten Bildes wird ermittelt
                mh = mh + Helligkeit
                Zhler1 = Zhler1 + 1
                m = CByte(mh / Zhler1) 'm beinhaltet die durchschnittliche Helligkeit
                
                ' Die Koordinaten des aufflligsten Punktes werden nach der Mittelwertbildung ermittelt
                
                If ((X > Fensterrand) And (X < (Suchbreite - Fensterrand))) Then
                    ' Es werden keine Helligkeitswerte im "inneren Fenster" ermittelt
                Else
                
                    'Wenn der aktuelle Mepunkt "aufflliger" ist als der Bisherige werden seine
                    'Helligkeit und seine Koordinaten gespeichert
                    If (Abs(Punkt2(X, Y) - m) > Max_Differenz) Then
                        
                        Max_Differenz = Abs(Punkt2(X, Y) - m)
                        Max_Differenz_X_Koordinate = X
                        Max_Differenz_Y_Koordinate = Y
                        If (Punkt2(X, Y) > m) Then
                            Helles_Logo = 1
                        Else
                            Helles_Logo = 0
                        End If
                        
                    End If
                    
                End If 'vom hellsten Punkt suchen
            
            Next Y
        
        Next X
        
        If Helles_Logo = 1 Then
            Form1.Picture3.Line (0, Max_Differenz_Y_Koordinate)-(Suchbreite - 1, Max_Differenz_Y_Koordinate), &HFFFFFF
            Form1.Picture3.Line (Max_Differenz_X_Koordinate, 0)-(Max_Differenz_X_Koordinate, Suchhhe - 1), &HFFFFFF
        Else
            Form1.Picture3.Line (0, Max_Differenz_Y_Koordinate)-(Suchbreite - 1, Max_Differenz_Y_Koordinate), &H0&
            Form1.Picture3.Line (Max_Differenz_X_Koordinate, 0)-(Max_Differenz_X_Koordinate, Suchhhe - 1), &H0&
        End If
        
        Max_Differenz = 1
    
        'Die Start/Stop-Koordinaten werden wieder um den Faktor 10 gestreckt
        'Lag der aufflligste Punkt zu nah am Rand wird LogoX/Y gleich Null gesetzt
        Logo_X = (Max_Differenz_X_Koordinate * 10) - 30
        If Logo_X < 0 Then Logo_X = 0
        Logo_Y = (Max_Differenz_Y_Koordinate * 10) - 50
        If Logo_Y < 0 Then Logo_Y = 0
        
Wend ' von Freigabe_Logo_finden

' An dieser Stelle ist die Mittelwertbildung der Fernsehbilder abgeschloen
Form1.Command1.Visible = False
Form1.Picture3.Visible = False
Form1.Eigenschaften.Enabled = True

End Sub
