program videox;  uses crt, dos;  const ID =

'VideoX, Videoschnitt mit Control-L, V1.1, E. Pofahl, ct-Nov-96';
{ 100566.3315@compuserve.com }
const { zur Anpassung an Aufnahmerecorder }
   Default_Record_Totzeit = '2.00'  ;
   Default_Pause_Totzeit  = '-0.13' ;
const { zur Anpassung an den PC }
   Max_Wartezeit         = 20000 ; { auf ein COMn Zeichen }
   Default_Schnittstelle = '1'   ;  { COM x }
   Default_Schnittliste  = 'schnitt.lst' ;
const { sonstiges }
   HFrames_sec   = 50   ;  { Anzahl Halbframes / Sekunde }
   Speichertiefe = 1500 ;
   CR = chr (13) ; { Carriage Return }
{ Moegliche Erweiterungen :
  - max. Pausezeit Aufnahmerecorder beruecksichtigen, ca. 5 Min.
  - weitere Plausibilitaetskontrollen
  - Control-L Steuerung per Tx und Software Sync.
  - Wiederholungsfaktor fuer Fernsteuerungsbefehle
}
{$I+}  { I/O Pruefung }     {$R+}  { Rangecheck ! }

type
   t_Zaehler = record
      dez : longint ; { Dezimalrepresentation }
      Vorzeichen : char ;
      Stunden, Minuten, Sekunden, HFrames, Old_Sekunden : longint;
   end ;

var
   CC_Zaehler, Start_Zeit, Stop_Zeit, Schnitt_Laenge,
   Record_Totzeit, Pause_Totzeit, Offset_Zeit,
   pre_start, pre_stop, Alte_Stop_Zeit : t_Zaehler ;
   schwelle : Integer;
   delays   : array [1 .. Speichertiefe ] of integer ;
   zeichen  : array [1 .. Speichertiefe ] of byte ;
   Zeile    : string ;
   laufindicator : longint ;
   CC_Status  : string ;
   port_basis : word ;
   Schnitt_eingelesen, Aufnahme, Scharf, Control_L, Old_Control_L,
   Ende, PLAY, FWD, REVERSE, infile_vorhanden :    Boolean ;
   infile : Text ;

procedure abort ( A_Diagnose : string ) ;
begin writeln ; writeln ( A_Diagnose ) ; writeln ; halt ; end;

procedure Help ;
begin
   writeln ;
   writeln ('C> VideoX  Schnittliste [', Default_Schnittliste,
            '] ', 'COMn [', Default_Schnittstelle, ']');
   writeln ('Moegliche Kommandos : ') ;
   writeln ('r=Aufnahme; p=Pause; w,CR=Weiter; ',
            '1=ein; 0=aus; x,Blank,ESC=Ende');
end ;

function   hexb (c : byte) : string ;  { BYTE zu Hex-Ziffern }
const  hexdig : string [16] = '0123456789ABCDEF';
begin  hexb := hexdig [(c DIV 16) + 1] + hexdig [(c MOD 16) + 1];
end;

const                  { Serial Chip Constants }
   RX_buffer = $F8 ;   { I/O Codes for Comm Adapter INS 8250 }
   Divisor_Latch_LSB = $F8 ;
   Divisor_Latch_MSB = $F9 ;
   Line_Control_Register  = $FB ;
   Modem_Control_Register = $FC ;
   Line_Status_Register   = $FD ;

function byte_da: boolean;
begin    byte_da :=
      (port[port_basis + Line_Status_Register] and $01) > 0 ;
end;

procedure read_byte (var wert: byte; var wartezeit: Integer );
begin
   Wartezeit := 0;
   while (not byte_da) and (Wartezeit <= Max_Wartezeit )
          do inc (Wartezeit);
   if byte_da then wert := NOT port [ port_basis + RX_buffer ]
              else wert := 0 ;
end;

procedure read_puffer ( ranz: Integer ) ;
var ri : integer ;
begin
   ri := 0 ;
   repeat begin
      inc ( ri ) ;
      read_byte (zeichen [ri], delays [ri] ) ;
   end until ((ri >= ranz) OR (delays [ri] >= Max_Wartezeit));
   zeichen [ri+1] :=  0 ;
   delays  [ri+1] := -1 ;
end ;

procedure ser_ini ( S_Schnittstelle : Integer ) ;
begin
   case S_Schnittstelle of
      1 : port_basis := $300 ;
      2 : port_basis := $200 ;
      else abort ( 'Falsche Schnittstelle ! ') ;
   end ; { case }
   port [port_basis + Line_control_register ] := $83; {DLAB = 1}
   port [port_basis + Divisor_latch_LSB     ] :=  12; {9600 Baud}
   port [port_basis + Divisor_latch_MSB     ] := $00 ;
   port [port_basis + Line_Control_Register ] := $03 ; { DLAB=0}
         {DTR = 0, RTS = 1 : }
   port [port_basis + Modem_Control_Register    ] := $02;
end;

function valid_telegramm_at ( var vi : Integer ) : Boolean ;
var lvi : integer ;
begin
   while ( ( delays [vi] < Schwelle ) AND
           ( delays [vi] <> -1      )      ) do inc (vi);
   valid_telegramm_at := ( delays [vi] <> -1 ) ;
   for lvi := (vi + 1) to (vi + 7) do
      if (delays [lvi] = -1)  OR ( delays [lvi] > schwelle )
         then valid_telegramm_at := false;
end ;

procedure  Bestimme_Schwelle ;
var  bi, x_min, x_max : Integer;
begin
   Schwelle := 10 ;
   read_puffer ( 20 ) ; { Puffer leerlesen }
   read_puffer ( 1 ) ;
   if delays [1] < Max_Wartezeit then
   begin
       read_puffer ( 80 ) ; { 10 Telegramme a 8 Bytes }
       x_min := delays [1] ; x_max := x_min ;
       bi := 1 ;
       while delays [bi] <> -1 do
       begin
          if delays [bi] < x_min then x_min := delays [bi] ;
          if delays [bi] > x_max then x_max := delays [bi] ;
          inc (bi) ;
       end ;
       schwelle := x_min + 5 + round ( 0.1 *  (x_max - x_min) );
   end ;
end ;

procedure hexa_to_dez ( var c_zeit : t_Zaehler ) ;
begin
   with c_zeit do begin
      dez  := HFrames + ( HFrames_sec * Sekunden          )
                      + ( HFrames_sec * 60 * Minuten      )
                      + ( HFrames_sec * 60 * 60 * Stunden ) ;
      if Vorzeichen = '-' then dez := -dez ;
   end;
end ;

procedure dez_to_hexa ( var c_zeit : t_Zaehler ) ;
var hd : longint ;
begin
   with c_zeit do begin
      if dez < 0 then Vorzeichen := '-' else Vorzeichen := ' ';
      hd       := abs (dez) ;
      Stunden  := hd div ( HFrames_sec * 60 * 60 ) ;
      hd       := hd mod ( HFrames_sec * 60 * 60 ) ;
      Minuten  := hd div ( HFrames_sec * 60 ) ;
      hd       := hd mod ( HFrames_sec * 60 ) ;
      Sekunden := hd div ( HFrames_sec ) ;
      HFrames  := hd mod ( HFrames_sec ) ;
   end;
end ;

procedure clear_Zeit ( var cl_zeit : t_Zaehler ) ;
begin
   with cl_zeit do
   begin
      dez        := 0   ;
      Vorzeichen := ' ' ; Stunden := 0 ; Minuten      := 0 ;
      Sekunden   := 0   ; HFrames := 0 ; Old_Sekunden := 0 ;
   end ;
end;

procedure print_Zeit ( p_zeit : t_Zaehler ) ;
begin
with p_zeit do write (Vorzeichen, Stunden:2,  ':',
        Minuten:2, ':', Sekunden:2, '.', (HFrames shr 1):2 );
end;

function strg2int ( var zt_string : String) : Integer ;
var vs : string ; E_i, i_err, sptr : Integer;
begin
   sptr := 1 ;
   while (( sptr <= length (zt_string) ) and
          ( NOT ( zt_string [sptr] in [ '0' .. '9' ] )))
                do inc (sptr) ;
   vs := '' ;
   while (( sptr <= length (zt_string) ) and
          ( zt_string [sptr] in [ '0' .. '9' ] )) do
      begin
         vs := vs + zt_string [sptr] ;
         zt_string [sptr] := ' ' ;
         inc (sptr) ;
      end ;
   if vs = '' then abort ('strg2int, Leerer String') ;
   val (vs, E_i, i_err ) ;
   if i_err <> 0 then abort ('strg2int >' + zt_string+ '-'+ vs);
   strg2int := E_i ;
end;

procedure Eintragen (var e_zeit : t_Zaehler ; E_string : string);
var E_Stunden, E_Minuten, E_HFrames : Boolean ;
    zeit_String : string ;
begin
   clear_Zeit (E_zeit);
   zeit_string := E_String ;
   if ( pos ('-', E_string ) <> 0 ) then E_zeit.Vorzeichen := '-' ;
   E_Minuten := false ;
   if pos (':', zeit_string) <> 0 then
      begin
         E_Minuten := true ;
         zeit_string [pos (':', zeit_string) ] := ' ' ;
      end ;
   E_Stunden := ( pos (':', zeit_string) <> 0 ) ;
   E_HFrames := ( pos ('.', zeit_string) <> 0 ) ;

   if E_Stunden then E_zeit.Stunden  := strg2int (zeit_string);
   if E_Minuten then E_zeit.Minuten  := strg2int (zeit_string);
                     E_zeit.Sekunden := strg2int (zeit_string);
   if E_HFrames then E_zeit.HFrames  := 2*strg2int (zeit_string);
   hexa_to_dez ( E_Zeit ) ; dez_to_hexa ( E_Zeit ) ;
end ;

function  Zeit_string ( instring : string ) : string ;
var z_strg : string ; z_i : integer ;
begin
   z_strg := '' ;  z_i := 1 ;
   while ( z_i <= length (instring) ) AND
         ( instring [z_i] in [' ',':','-','.', '0' .. '9'] ) do
        begin z_strg := z_strg + instring [z_i]; inc (z_i); end;
   Zeit_string := z_strg ;
end ;

procedure Zeile_Aufdroeseln ;
begin
   if pos (',', Zeile) = 0  then abort ('Kein "," in Liste');
   Eintragen (Start_Zeit, Zeit_string (zeile) ) ;
   Eintragen (Stop_Zeit,
         Zeit_string (copy (zeile,pos (',', Zeile ) + 1, 50 ) )) ;
   inc ( Schnitt_Laenge.dez, (Stop_Zeit.dez - Start_Zeit.dez));
   dez_to_hexa ( Schnitt_Laenge ) ;
   inc ( Start_Zeit.dez, Offset_Zeit.dez ) ;
   inc ( Stop_Zeit.dez,  Offset_Zeit.dez ) ;
   if Start_Zeit.dez <  Alte_Stop_Zeit.dez  then
      {if scharf then spule_nach ( Start_Zeit ) ; }
      writeln ('******* Achtung ! Startzeit zu klein !! ?????? ');
   Alte_Stop_Zeit := Stop_Zeit ;

   Start_Zeit.dez := Start_Zeit.dez - Record_Totzeit.dez ;
   Stop_Zeit.dez  := Stop_Zeit.dez  - Pause_Totzeit.dez  ;
   dez_to_hexa ( Start_Zeit ) ;
   dez_to_hexa ( Stop_Zeit  ) ;

   pre_start.dez := Start_Zeit.dez - 2 {sec} * HFrames_sec ;
   pre_stop.dez  := Stop_Zeit.dez  - 2 {sec} * HFrames_sec ;
   dez_to_hexa (pre_start);
   dez_to_hexa (pre_stop );

   write ('    '); print_zeit ( Start_Zeit );
   write (' ')   ; print_zeit ( Stop_Zeit  );
   write ('    Gesamtlaenge : ' ); print_zeit (Schnitt_Laenge);
   writeln ;
end ;

procedure  Print_Totzeiten ;
begin
   write ( 'Totzeit Aufnahme ') ; print_zeit (Record_Totzeit) ;
   write ( ', Pause ')          ; print_zeit (Pause_Totzeit ) ;
   write ( ', Offset ')         ; print_zeit (Offset_Zeit   ) ;
   writeln ;
end ;

function Nibbles_to_dez ( c_puf : byte ) : Integer ;
begin    Nibbles_to_dez :=   ( c_puf AND $0F ) +
                           ( ( c_puf AND $F0 ) shr 4 ) * 10 ;
end ;

procedure Telegramm_dekodieren ( Puffer_pos : Integer ) ;
var guide_code : Integer ;
begin
   guide_code := (zeichen [Puffer_pos + 5] shr 4) AND $000F;
   with CC_Zaehler do
   begin
      case guide_code of
      2: Sekunden := Nibbles_to_dez ( zeichen [Puffer_pos+6] )
                   +        ( 100 * ( zeichen [Puffer_pos+7] ) );
      3: begin
           Sekunden := Nibbles_to_dez ( zeichen [Puffer_pos+6] );
           Minuten  := Nibbles_to_dez ( zeichen [Puffer_pos+7] );
         end ;
      4: begin
           Stunden  := Nibbles_to_dez ( zeichen [Puffer_pos+6] );
           if (zeichen [Puffer_pos+7] AND $80 ) = 0
              then Vorzeichen := ' ' else Vorzeichen := '-';
         end ;
      end ; { case }
   end ;
end ;

procedure update_CC_Zaehler ;
var ii : Integer ;
begin
   read_puffer ( 41 ) ; { mehr als 4 Telegramme a 8 Bytes}
   ii := 1 ;
   while valid_telegramm_at (ii)  do
      begin Telegramm_dekodieren (ii) ; inc ( ii, 6 ) ; end ;
   CC_Zaehler.  HFrames      := 0 ;
   CC_Zaehler.  Old_Sekunden := CC_Zaehler. Sekunden ;
   hexa_to_dez ( CC_Zaehler ) ;
end ;

procedure   Neue_Schnitt_Zeiten_einlesen ;
var Kommando : Boolean ; BZeile : String ;
begin
   Schnitt_eingelesen := false ;
   repeat begin
      if eof(infile) then begin zeile := 'EOF'; Ende := true; end
                     else readln (infile, zeile) ;
      writeln (zeile, '<' ) ;
      Kommando := true ;
      if zeile <> '' then begin
         BZeile := copy (zeile, 2, length (Zeile) - 1 ) ;
         case upCase ( zeile [1] ) of
            'R': Eintragen (Record_Totzeit,Zeit_string (BZeile));
            'P': Eintragen (Pause_Totzeit, Zeit_string (BZeile));
            'O': Eintragen (Offset_Zeit,   Zeit_string (BZeile));
            '*', ';' :  { nop } ;
            else Kommando := false ;
         end ; {case }
         if upCase ( zeile [1] ) in ['R', 'P', 'O']
            then Print_Totzeiten;
      end;
   end until (NOT Kommando ) OR Ende ;
   if not Ende then
      begin
         Zeile_Aufdroeseln ; { in Start- und Stop_zeit }
            {hier Plausibilitaetsabfragen, erweiterbar ... }
         if ( Stop_zeit.dez < Start_zeit.dez ) then
            abort ('Schnitt nicht moeglich ! (Stop < Start)' );
         Schnitt_eingelesen := true ;
      end ;
   if Ende      then scharf := false ;
   if Control_L then update_CC_Zaehler ;
end ;

procedure FB_Status_out ( ST_Bits : byte ) ;
begin
   port [port_basis + modem_control_register ] := ST_Bits ;
   delay (20) ; { kuenstlich prellen, manche Fernbed. brauchts !?}
   port [port_basis + modem_control_register ] := $02 ;
   delay (20) ;
   port [port_basis + modem_control_register ] := ST_Bits ;
   delay ( 600 { ms, Tasten_druck_laenge } ) ;
   port [port_basis + modem_control_register ] := $02 ;
end ;

procedure Aufnahme_Senden ;  {RTS}
begin FB_Status_out ($00); { FB_Status_out ($00); } end;

procedure Pause_Senden    ; begin FB_Status_out ($03); end; {DTR}

procedure    Warte_exact ( Warte_Zeit : t_Zaehler ) ;
var  Warte_muster, t_byte : byte ;
     win1, win2, Warte_counter : integer;
begin
   Warte_muster  :=    ( Warte_Zeit.Sekunden mod 10 ) +
                     ( ( Warte_Zeit.Sekunden div 10 ) shl 4 ) ;
   Warte_counter := 0 ;
   repeat begin
      repeat read_byte ( t_byte, win1 ) until win1 > schwelle;
      read_puffer ( 6 {!} ) ;
      inc ( Warte_counter ) ;
   end until ( ( ( zeichen [5] AND $E0 ) = $20 {Guidecd 2,3} ) AND
               (   zeichen [6]           = Warte_muster    )  )

             OR  ( Warte_counter > 150 ) ; { max.  ca. 3 Sek. }

   for win2 := 0 to Warte_Zeit.HFrames do
      repeat read_byte ( t_byte, win1 ) until win1 > schwelle;
end ;

procedure trig_Record ;
begin
   write ( '+' ) ;
   Aufnahme := true ;
   Warte_exact (Start_Zeit) ;
   Aufnahme_Senden ;
   write   (CR, CC_Status)   ; print_zeit (Start_Zeit);
   writeln ( '   r', chr(7)) ;
   update_CC_Zaehler ;
end ;

procedure trig_Pause ;
begin
   write ( '-' ) ;
   Aufnahme := false ;
   Warte_exact (Stop_Zeit) ;
   Pause_senden ;
   Schnitt_eingelesen := false ;
   write   (CR, CC_Status)   ; print_zeit (Stop_Zeit);
   writeln ( '   p', chr(7)) ;
   update_CC_Zaehler ;
end ;

procedure read_and_decode ;
begin
   read_puffer ( 7 ) ;
   PLAY    := ( zeichen [4] = $06 ) ;
   FWD     := ( zeichen [4] = $03 ) ;
   REVERSE := ( zeichen [4] = $83 ) ;
   Telegramm_dekodieren ( 0 ) ;
   with CC_Zaehler do { HalbFrames zaehlen : }
      begin
         if ( Sekunden = Old_Sekunden ) then
            begin
               inc ( Laufindicator ) ;
               if  ( Laufindicator <= ( HFrames_sec + 6 ) )
                  then inc ( HFrames )
                  else HFrames := 0 ;
               HFrames := HFrames mod HFrames_sec ;
            end
         else
            begin
               Old_Sekunden  := Sekunden ;
               HFrames       := 0 ;
               Laufindicator := 0 ;
            end ;
      end ;
   hexa_to_dez ( CC_Zaehler ) ;
end ;

procedure print_Status ;
begin
   CC_Status := '    ' ;
   if not Control_L then CC_Status [1] := '?' ;
   if not scharf    then CC_Status [2] := '*' ;
   if PLAY          then CC_Status [3] := 'P' ;
   if REVERSE       then CC_Status [3] := '<' ;
   if FWD           then CC_Status [3] := '>' ;
   write (CR, CC_Status); print_Zeit (CC_Zaehler);
end ;

function Naehe ( N_Zaehler : t_Zaehler) : Boolean ;
var n_dif : longint ;
begin
   n_dif := CC_Zaehler.dez  -  N_Zaehler.dez ;
   Naehe := ( ( n_dif > 0 ) and ( n_dif < (8 * HFrames_Sec) ));
end ;

procedure Record_and_Pause ;
begin
   if Aufnahme
      then begin if Naehe (pre_stop)  then trig_pause  end
      else begin if Naehe (pre_start) then trig_record end;
end;

procedure bearbeite_Befehl ;
var taste : char ;
begin
   taste := readkey ;
   writeln ( '  >', taste, '<', chr (7) ) ;
   case UpCase (taste) of
      'R' : Aufnahme_Senden ;
      'P' : Pause_Senden ;
      'W', CR            : Schnitt_eingelesen := false ;
      'X', ' ', chr (27) : ende := true ;
      '0' : Scharf := false ;
      '1' : Scharf := true ;
      else  Help ;
   end ; { case }
end ;

procedure   Synchronisiere ;
var isync, S_i : Integer ; s_byte : Byte ;
begin
   S_i := 0 ;
   repeat begin read_byte ( s_byte, isync ) ; inc (S_i) ; end
      until ( isync > schwelle ) OR ( S_i > 20 ) ;

   Control_L := ( ( isync < Max_Wartezeit ) AND ( S_i < 17 ) ) ;

   if Control_L <> Old_Control_L then
      begin
         PLAY := false ;
         Bestimme_Schwelle ;
         update_CC_Zaehler ;
         Old_Control_L := Control_L ;
      end ;
end ;

procedure  Initialisiere_Daten ;
var i_ini : integer ;
begin
   for i_ini := 1 to Speichertiefe do delays [i_ini] := -1 ;
   Clear_Zeit ( CC_Zaehler     ) ;  Clear_Zeit ( Start_Zeit ) ;
   Clear_Zeit ( Alte_Stop_Zeit ) ;  Clear_Zeit ( Stop_Zeit  ) ;
   Clear_Zeit ( Pre_Start      ) ;  Clear_Zeit ( Pre_Stop   ) ;
   Clear_Zeit ( Offset_Zeit    ) ;  Clear_Zeit ( Schnitt_Laenge );
   Eintragen  ( Record_Totzeit, Default_Record_Totzeit ) ;
   Eintragen  ( Pause_Totzeit,  Default_Pause_Totzeit  ) ;
   Schnitt_eingelesen := false  ;   PLAY     := false ;
   Laufindicator := 0     ;         REVERSE  := false ;
   Control_L     := false ;         FWD      := false ;
   Old_Control_L := true  ;         ende     := false ;
   Scharf        := true  ;         Aufnahme := false ;
   CC_Status     := ''    ;
end;

function Parameter (Bezeichng, Vorgabe, Default: string): string;
var p_strg : string ;
begin
   p_strg := vorgabe ;
   if length ( vorgabe ) = 0 then
      begin
         write (Bezeichng, ' [', Default, '] : ') ;
         readln (p_strg) ;
         if length (p_strg) = 0 then p_strg := Default ;
      end ;
   writeln  ( Bezeichng, ' : ', p_strg ) ;
   Parameter := p_strg ;
end ;

{_______________________ Hauptprogramm : ____________________}
begin
   Initialisiere_Daten ; writeln ( id ) ; help ;
   { Dateinamen fuer Schnittliste : }
   zeile := Parameter ('Schnittliste',
                       ParamStr(1), Default_Schnittliste) ;
   assign ( infile, zeile ) ;
   {$I-} reset (infile); {$I+}
   infile_vorhanden := ( IOResult = 0 ) ;
   if NOT infile_vorhanden then
      begin
         scharf := false ;
         writeln ('Kann Schnittliste nicht oeffnen' ) ;
      end ;
   { COM 1 oder 2 }
   zeile := Parameter ('Nummer der Schnittstelle (COM) ',
                       ParamStr (2), Default_Schnittstelle ) ;
   case zeile [1] of
      '1' : ser_ini ( 1 ) ;
      '2' : ser_ini ( 2 ) ;
      else  abort ( 'Falsche Schnittstelle !' ) ;
   end ; { case }

   Print_Totzeiten     ;
   Bestimme_Schwelle   ;
   Synchronisiere      ;
   if Control_L then update_CC_Zaehler ;

   while not ende do
   begin
      if (NOT Schnitt_eingelesen ) AND infile_vorhanden
                           then Neue_Schnitt_Zeiten_einlesen ;
      Synchronisiere ;
      if Control_L then Read_and_decode ;
      Print_Status ;
      if Control_L AND scharf AND PLAY then Record_and_Pause ;
      if keypressed then bearbeite_Befehl ;
   end ;

end.
