  /* 
    LM75_address.c
    --------------
      1) set the i2c address of the LM75
	* R/W pulse at end of address byte not included in address 1-0-0-1-A2-A1-A0
	* example - all lines to 0V - 1001000 = decimal 72
      2) calculate the temperature
      3) print it
	usage :- type (without the < >)
		<LM75_address><space><address as decimal>
*/

#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <stdio.h>
#include <linux/i2c-dev.h>

int main(int argc, char** argv)
{
  int address, bla;      /* i2c bus address */
  float data_f, data_t ;

 if (argc != 2)   /* report error if we are not getting just 1 input after the program name */
 {
  printf("Error. usage: %s i2c_chip_address\n", argv[0]);           
 }
  address = atoi(argv[1]); /* address is the first number after the program name */


          int f = open("/dev/i2c-1",O_RDWR);
          unsigned char buf[2];
          if (f>0) {
              ioctl(f,I2C_SLAVE,address);
		usleep(100);
		buf[0]= 0xAC;
		buf[1]= 0x0C;
            	write(f,buf,2);
	      ioctl(f,I2C_SLAVE,address);
		buf[0] = 0x51;
		write(f,buf,1);
		sleep(1);
		usleep(100);
	      ioctl(f,I2C_SLAVE,address);	
		buf[0] = 0xaa;
		write(f,buf,1);
	      ioctl(f,I2C_RDWR,address); 	
		usleep(100);
 		bla=read(f,buf,2);
		data_t=(float)buf[0]+(float)((buf[1]>>4)*0.0625);
	        //printf("BYTE = %i %i %i  \n", buf[0], buf[1], bla); 
		printf("%f \n", data_t);         
		return close(f);
	}
  }  

                              
