// permut.cpp : Defines the entry point for the console application.
//

// Permut.cpp : Definiert den Einstiegspunkt fr die Konsolenanwendung.
//

#include "stdafx.h"
#include <Windows.h>
#define N 5

int Z[N]={1,2,3,4,5}; 
int X[N];
#define A Z[0]
#define B Z[1]
#define C Z[2] 
#define D Z[3] 
#define E Z[4]

int Alt[6]={6,7,8,9,10,11};

int comb[6]={0,1,2,3,4,5};

char Name[5][6]={"Anna","Berta","Clara","Dora","Erna"};

void swap (int i, int j) { 
	int temp; 
	temp=Z[i]; 
	Z[i]=Z[j]; 
	Z[j]=temp;
}


void show(int X[],int n) {
    int m=1;
    int count=0;
	 do {
		 for (int i=0;i<N;i++) if (X[i]==m) 
		  {printf ("%s (%d) ",Name[i],X[i]); count++;}
		 m++;
	 } while (count <N);

	printf ("\n");
}


bool visit1() {
	if (A > B) if (C <= D) return false; 
	if (A > C) if (D >= E) return false;
    if (E > A) if (D >= A) return false; 
	if (C < B) if (A >= D) return false;
	if (C > D) if (A >= D) return false;
	if (B > E) if (C >= A) return false;
	return true; 
}

bool visit2() {
	if (A > B) if (C <= D) return false; 
	if (A > C) if (D >= E) return false;
    if (E > A) if (D >= A) return false; 
	if (C < B) if (A >= D) return false;
	if (C > D) if (A >= D) return false;
	if ((A + E) != (B + C)) return false;
	return true; 
}





int checkPermLoop() { // mit festen Schleifen und sukkzessivem Ausschluss
	int count=0;
	for (A=1; A <= N; A++) {
		for (B=1; B <= N; B++) if (B!=A) {
			for (C=1; C<= N; C++) if (C!=A && C!=B)  {
				for (D=1; D<= N; D++) if (D!=A && D!=B && D!=C) {
					for (E=1; E<= N; E++) if (E!=A && E!=B && E!=C && E!=D) {

							if (visit1()) {
							count++;
							show(Z,N);
							}
					}
				}
			}
		}				

	}
	return count;
}


bool NextLexiPermut(int* Z) { // Knuth 7.2.1.2: Algorithmus L }
	int i=N-1; 
	while (Z[i-1] >= Z[i]) { 
		i--; if (i==0) { 
			// letzte Permutation erreicht
			// setzt Feld wieder auf Start, 
			for (int j=0; j< (N-1)/2; j++) swap (j,N-1-j); 			
			return false; 
		}
	} ;
	int j=N;
	while (Z[j-1] <= Z[i-1]) j--; 

	swap (i-1,j-1);
	i++;
	j=N; 
	while (i<j) {
		swap (i-1,j-1); 
		i++;j--;
	}
	return true;
}

int checkPermL() { //Check mit Permutation v. Knuth Algorithmus L 

int count=0; 
for (int i=0; i<N; i++) Z[i]=i+1;
	do if (visit1()) {
		count++;
		show(Z,N); 						
	} while (NextLexiPermut(Z));
return count; 
}

//Variation mit festen Schleifen
#define ab 6
#define bis 11
void checkVariLoop () {

	int count=0;
	for (A=ab; A <= bis; A++) {
		for (B=ab; B <= bis; B++) if (B!=A) {
			for (C=ab; C<= bis; C++) if (C!=A && C!=B) {  
				for (D=ab; D<= bis; D++) if (D!=A && D!=B && D!=C) {
					for (E=ab; E<= bis; E++) if (E!=A && E!=B && E!=C && E!=D){
						if (visit2()) {
						show(Z,N);
						count++; 
						}
					}
				}
			}
		}

	}
}

    	
bool NextComb(int comb[], int k, int n) { 
	// Lexikografische Kombinationen k aus n 
	// fr Arrays von {0,1,..n-1}
	int i = k - 1;
	++comb[i];
	while ((i > 0) && (comb[i] >= n - k + 1 + i)) ++comb[--i];
	if (comb[0] > n - k)  return false; // Letzte Kombination erreicht
	for (i = i + 1; i < k; ++i) comb[i] = comb[i - 1] + 1;
	return true ;
}

int checkComb() {

int count=0; 
 do{  
	 for (int i=0;i<5;i++) Z[i]=comb[i]+6; 
	 do {
	    if (visit2()){ 
		count++;
		show(Z,N); 
		}		
	} while (NextLexiPermut(Z));
 } while (NextComb(comb,5,6)); 
return count; 
}



int c[100];


void InitCombL (int c[],int t, int n) {
	for (int j=0; j<t;j++) c[j]=j; 
	c[t]=n; c[t+1]=0; //set Sentinels 
}


bool NextCombL (int c[],int t) { // Knuth Alg. L 0 basiert
	int j=0;
	while (c[j]+1==c[j+1]) 
	 {c[j]=j; j++;} 
	if (j>=t) return false; 
	c[j]++; 
	return true; 
}

int checkCombL() {
	int count=0;
	InitCombL(c,5,6);
	do {
		for (int i=0;i<5;i++) Z[i]=c[i]+6; 
		do {
			if (visit2()){ 
				count++;
				show(Z,5); 
			}		

		} while (NextLexiPermut(Z));
	} while (NextCombL(c,5));
	return count;
}


int j; 


void InitCombT (int c[],int t, int n) {
	for (int j1=0; j1<t;j1++) c[j1]=j1; 
	c[t]=n; c[t+1]=0; //set Sentinels 
	j=t-1; 

}


bool NextCombT (int c[],int t) { //Knuth Alg. T 0-basiert }
	int x;

	if (j>=0) {c[j--]=j+1; return true; }
	if (c[0]+1 < c[1]) {c[0]++; return true; } 

	j=1; 
	do {
		c[j-1]=j-1;
		x=c[j]+1; 
		if (x!=c[j+1]) break; 
		j++; 
	} while (true);

	if (j>=t) return false; 
	c[j--]=x;

	return true;
}

int checkCombT() {
	int count=0;
	InitCombT(c,5,6);
	do {
		for (int i=0;i<5;i++) Z[i]=c[i]+6; 
		do {
			if (visit2()){ 
				count++;
				show(Z,5); 
			}		
		} while (NextLexiPermut(Z));
	} while (NextCombT(c,5));

	return count;
}

int _tmain(int argc, _TCHAR* argv[]) {
	printf ("Permutationen\n------------------------"); 
	printf ("\nfeste Schleifen,  in der Reihenfolge (1=Juengste, 5=Aelteste) : \n"); checkPermLoop();
    printf ("\nAlgorithmus L, in der Reihenfolge (1=Juengste, 5=Aelteste) : \n"); checkPermL();
    printf ("\n\nVariation ohne Wiederholung\n---------------------------");
	printf ("\nfeste Schleifen, Alter in Klammern: \n"); checkVariLoop ();  
	printf ("\nVariation, Algorithmus C + Permutation L : \n"); checkComb();
	printf ("\nVariation, Algorithmus L + Perm L : \n"); checkCombL();
	printf ("\nVariation, Algorithmus T + Perm L : \n"); checkCombT();

	return 0;
}


