/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

#include "spice.h"
#include <stdio.h>
#include "cktdefs.h"
#include "acdefs.h"
#include "const.h"
#include "optdefs.h"
#include "devdefs.h"
#include "ifsim.h"
#include "iferrmsg.h"
#include "distodef.h"
#include "pzdefs.h"
#include "fteconst.h"
#include "tskdefs.h"
#include "trandefs.h"
#include "complex.h"
#include "jobdefs.h"
#include "spmatrix.h"
#include "tfdefs.h"
#include "noisedef.h"
#include "gendefs.h"
#include "opdefs.h"
#include "util.h"
#include "acdefs.h"
#include "misc.h"
#include "trcvdefs.h"
#include "strext.h"
#include "smpdefs.h"
#include "sensdefs.h"
#include "sensgen.h"
#include "sperror.h"
#include "suffix.h"
#pragma hdrstop
#ifdef HAS_FLAT_INCLUDES
#include "vsrcdefs.h"
#include "isrcdefs.h"
#else
#include "vsrc/vsrcdefs.h"
#include "isrc/isrcdefs.h"
#endif


int
CKTfndDev(Ckt,type,fast,name,modfast,modname)
    GENERIC *Ckt;
    int *type;
    GENERIC **fast;
    IFuid name;
    GENERIC *modfast;
    IFuid modname;
{
    register CKTcircuit *ckt=(CKTcircuit *)Ckt;
    register GENinstance *here;
    register GENmodel *mods;

    if((GENinstance **)fast != (GENinstance **)NULL && 
            *(GENinstance **)fast != (GENinstance *)NULL) {
        /* already have  fast, so nothing much to do */
        /* just get & set type */
        if(type) *type = (*((GENinstance**)fast))->GENmodPtr->GENmodType;
        return(OK);
    } 
    if(modfast) {
        /* have model, just need device */
        mods = (GENmodel*)modfast;
        for(here = mods->GENinstances ; here != NULL; 
                here = here->GENnextInstance) {
            if (here->GENname == name) {
                if(fast != NULL) *(GENinstance **)fast = here;
                if(type) *type = mods->GENmodType;
                return(OK);
            }
        }
        return(E_NODEV);
    }
    if(*type >=0 && *type < DEVmaxnum) {
        /* have device type, need to find model & device */
        /* look through all models */
        for(mods=(GENmodel *)ckt->CKThead[*type]; mods != NULL ; 
                mods = mods->GENnextModel) {
            /* and all instances */
            if(modname == (char *)NULL || mods->GENmodName == modname) {
                for(here = mods->GENinstances ; here != NULL; 
                        here = here->GENnextInstance) {
                    if (here->GENname == name) {
                        if(fast != 0) *(GENinstance **)fast = here;
                        return(OK);
                    }
                }
                if(mods->GENmodName == modname) {
                    return(E_NODEV);
                }
            }
        }
        return(E_NOMOD);
    } else if(*type == -1) {
        /* look through all types (UGH - worst case - take forever) */ 
        for(*type = 0;*type <DEVmaxnum;(*type)++) {
            /* need to find model & device */
            /* look through all models */
            for(mods=(GENmodel *)ckt->CKThead[*type];mods!=NULL;
                    mods = mods->GENnextModel) {
                /* and all instances */
                if(modname == (char *)NULL || mods->GENmodName == modname) {
                    for(here = mods->GENinstances ; here != NULL; 
                            here = here->GENnextInstance) {
                        if (here->GENname == name) {
                            if(fast != 0) *(GENinstance **)fast = here;
                            return(OK);
                        }
                    }
                    if(mods->GENmodName == modname) {
                        return(E_NODEV);
                    }
                }
            }
        }
        *type = -1;
        return(E_NODEV);
    } else return(E_BADPARM);
}
