/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/
/*
 */

    /* CKTground(ckt,node)
     *  specify the node to be the ground node of the given circuit
     */

#include "spice.h"
#include <stdio.h>
#include "cktdefs.h"
#include "acdefs.h"
#include "const.h"
#include "optdefs.h"
#include "devdefs.h"
#include "ifsim.h"
#include "iferrmsg.h"
#include "distodef.h"
#include "pzdefs.h"
#include "fteconst.h"
#include "tskdefs.h"
#include "trandefs.h"
#include "complex.h"
#include "jobdefs.h"
#include "spmatrix.h"
#include "tfdefs.h"
#include "noisedef.h"
#include "gendefs.h"
#include "opdefs.h"
#include "util.h"
#include "acdefs.h"
#include "misc.h"
#include "trcvdefs.h"
#include "strext.h"
#include "smpdefs.h"
#include "sensdefs.h"
#include "sensgen.h"
#include "sperror.h"
#include "suffix.h"
#pragma hdrstop
#ifdef HAS_FLAT_INCLUDES
#include "vsrcdefs.h"
#include "isrcdefs.h"
#else
#include "vsrc/vsrcdefs.h"
#include "isrc/isrcdefs.h"
#endif


int
CKTground(inCkt,node,name)
    GENERIC *inCkt;
    GENERIC **node;
    IFuid name;

{
    register CKTcircuit *ckt = (CKTcircuit *)inCkt;

    if(ckt->CKTnodes) {
        if(ckt->CKTnodes->name) {
            /*already exists - keep old name, but return it */
            if(node)*node = (char *)ckt->CKTnodes;
            return(E_EXISTS);
        }
        ckt->CKTnodes->name = name;
        ckt->CKTnodes->type = SP_VOLTAGE;
        ckt->CKTnodes->number = 0;
    } else {
        ckt->CKTnodes = (CKTnode *)MALLOC(sizeof(CKTnode));
        if(ckt->CKTnodes == NULL) return(E_NOMEM);
        ckt->CKTnodes->name = name;
        ckt->CKTnodes->type = SP_VOLTAGE;
        ckt->CKTnodes->number = 0;
        ckt->CKTnodes->next = (CKTnode *)NULL;
        ckt->CKTlastNode = ckt->CKTnodes;
    }
    if(node)*node = (char *)ckt->CKTnodes;
    return(OK);

}
