/**********
Copyright 1990 Regents of the University of California.  All rights reserved.
Author: 1985 Thomas L. Quarles
**********/

#include "spice.h"
#include <stdio.h>
#include "cktdefs.h"
#include "acdefs.h"
#include "const.h"
#include "optdefs.h"
#include "devdefs.h"
#include "ifsim.h"
#include "iferrmsg.h"
#include "distodef.h"
#include "pzdefs.h"
#include "fteconst.h"
#include "tskdefs.h"
#include "trandefs.h"
#include "complex.h"
#include "jobdefs.h"
#include "spmatrix.h"
#include "tfdefs.h"
#include "noisedef.h"
#include "gendefs.h"
#include "opdefs.h"
#include "util.h"
#include "acdefs.h"
#include "misc.h"
#include "trcvdefs.h"
#include "strext.h"
#include "smpdefs.h"
#include "sensdefs.h"
#include "sensgen.h"
#include "sperror.h"
#include "suffix.h"
#pragma hdrstop
#ifdef HAS_FLAT_INCLUDES
#include "vsrcdefs.h"
#include "isrcdefs.h"
#else
#include "vsrc/vsrcdefs.h"
#include "isrc/isrcdefs.h"
#endif


extern SPICEdev *DEVices[];

int
CKTic(ckt)
    CKTcircuit *ckt;
{
    int error;
    int size;
    int i;
    CKTnode *node;

    size = SMPmatSize(ckt->CKTmatrix);
    for (i=0;i<=size;i++) {
        *(ckt->CKTrhs+i)=0;
    }

    for(node = ckt->CKTnodes;node != NULL; node = node->next) {
        if(node->nsGiven) {
            node->ptr = SMPmakeElt(ckt->CKTmatrix,node->number,node->number);
            if(node->ptr == (double *)NULL) return(E_NOMEM);
            ckt->CKThadNodeset = 1;
            *(ckt->CKTrhs+node->number) = node->nodeset;
        }
        if(node->icGiven) {
            if(! ( node->ptr)) {
                node->ptr = SMPmakeElt(ckt->CKTmatrix,node->number,
                        node->number);
                if(node->ptr == (double *)NULL) return(E_NOMEM);
            }
            *(ckt->CKTrhs+node->number) = node->ic;
        }
    }

    if(ckt->CKTmode & MODEUIC) {
        for (i=0;i<DEVmaxnum;i++) {
            if( ((*DEVices[i]).DEVsetic != NULL) && (ckt->CKThead[i] != NULL) ){
                error = (*((*DEVices[i]).DEVsetic))(ckt->CKThead[i],ckt);
                if(error) return(error);
            }
        }
    }

    return(OK);
}
